/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.ClassLoaderDump;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AllowSymLinkAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ManagedAttributeListener;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.Graceful;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

@ManagedObject(value="URI Context")
public class ContextHandler
extends ScopedHandler
implements Attributes,
Graceful {
    public static final int SERVLET_MAJOR_VERSION = 3;
    public static final int SERVLET_MINOR_VERSION = 1;
    public static final Class<?>[] SERVLET_LISTENER_TYPES = new Class[]{ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class};
    public static final int DEFAULT_LISTENER_TYPE_INDEX = 1;
    public static final int EXTENDED_LISTENER_TYPE_INDEX = 0;
    private static final String __unimplmented = "Unimplemented - use org.eclipse.jetty.servlet.ServletContextHandler";
    private static final Logger LOG = Log.getLogger(ContextHandler.class);
    private static final ThreadLocal<Context> __context = new ThreadLocal();
    private static String __serverInfo = "jetty/" + Server.getVersion();
    public static final String MANAGED_ATTRIBUTES = "org.eclipse.jetty.server.context.ManagedAttributes";
    protected Context _scontext;
    private final AttributesMap _attributes;
    private final Map<String, String> _initParams;
    private ClassLoader _classLoader;
    private String _contextPath = "/";
    private String _displayName;
    private Resource _baseResource;
    private MimeTypes _mimeTypes;
    private Map<String, String> _localeEncodingMap;
    private String[] _welcomeFiles;
    private ErrorHandler _errorHandler;
    private String[] _vhosts;
    private Logger _logger;
    private boolean _allowNullPathInfo;
    private int _maxFormKeys = Integer.getInteger("org.eclipse.jetty.server.Request.maxFormKeys", -1);
    private int _maxFormContentSize = Integer.getInteger("org.eclipse.jetty.server.Request.maxFormContentSize", -1);
    private boolean _compactPath = false;
    private boolean _usingSecurityManager = System.getSecurityManager() != null;
    private final List<EventListener> _eventListeners = new CopyOnWriteArrayList<EventListener>();
    private final List<EventListener> _programmaticListeners = new CopyOnWriteArrayList<EventListener>();
    private final List<ServletContextListener> _servletContextListeners = new CopyOnWriteArrayList<ServletContextListener>();
    private final List<ServletContextAttributeListener> _servletContextAttributeListeners = new CopyOnWriteArrayList<ServletContextAttributeListener>();
    private final List<ServletRequestListener> _servletRequestListeners = new CopyOnWriteArrayList<ServletRequestListener>();
    private final List<ServletRequestAttributeListener> _servletRequestAttributeListeners = new CopyOnWriteArrayList<ServletRequestAttributeListener>();
    private final List<ContextScopeListener> _contextListeners = new CopyOnWriteArrayList<ContextScopeListener>();
    private final List<EventListener> _durableListeners = new CopyOnWriteArrayList<EventListener>();
    private Map<String, Object> _managedAttributes;
    private String[] _protectedTargets;
    private final CopyOnWriteArrayList<AliasCheck> _aliasChecks = new CopyOnWriteArrayList();
    private volatile Availability _availability;

    public static Context getCurrentContext() {
        return __context.get();
    }

    public static ContextHandler getContextHandler(ServletContext servletContext) {
        if (servletContext instanceof Context) {
            return ((Context)servletContext).getContextHandler();
        }
        Context context = ContextHandler.getCurrentContext();
        if (context != null) {
            return context.getContextHandler();
        }
        return null;
    }

    public static String getServerInfo() {
        return __serverInfo;
    }

    public static void setServerInfo(String string) {
        __serverInfo = string;
    }

    public ContextHandler() {
        this((Context)null);
    }

    protected ContextHandler(Context context) {
        this._scontext = context == null ? new Context() : context;
        this._attributes = new AttributesMap();
        this._initParams = new HashMap<String, String>();
        this.addAliasCheck(new ApproveNonExistentDirectoryAliases());
        if (File.separatorChar == '/') {
            this.addAliasCheck(new AllowSymLinkAliasChecker());
        }
    }

    public ContextHandler(String string) {
        this();
        this.setContextPath(string);
    }

    public ContextHandler(HandlerContainer handlerContainer, String string) {
        this();
        this.setContextPath(string);
        if (handlerContainer instanceof HandlerWrapper) {
            ((HandlerWrapper)handlerContainer).setHandler(this);
        } else if (handlerContainer instanceof HandlerCollection) {
            ((HandlerCollection)handlerContainer).addHandler(this);
        }
    }

    public void dump(Appendable appendable, String string) {
        this.dumpBeans(appendable, string, new Collection[]{Collections.singletonList(new ClassLoaderDump(this.getClassLoader())), Collections.singletonList(new DumpableCollection("Handler attributes " + this, (Collection)((AttributesMap)this.getAttributes()).getAttributeEntrySet())), Collections.singletonList(new DumpableCollection("Context attributes " + this, (Collection)this.getServletContext().getAttributeEntrySet())), Collections.singletonList(new DumpableCollection("Initparams " + this, this.getInitParams().entrySet()))});
    }

    public Context getServletContext() {
        return this._scontext;
    }

    @ManagedAttribute(value="Checks if the /context is not redirected to /context/")
    public boolean getAllowNullPathInfo() {
        return this._allowNullPathInfo;
    }

    public void setAllowNullPathInfo(boolean bl) {
        this._allowNullPathInfo = bl;
    }

    @Override
    public void setServer(Server server) {
        super.setServer(server);
        if (this._errorHandler != null) {
            this._errorHandler.setServer(server);
        }
    }

    public boolean isUsingSecurityManager() {
        return this._usingSecurityManager;
    }

    public void setUsingSecurityManager(boolean bl) {
        this._usingSecurityManager = bl;
    }

    public void setVirtualHosts(String[] stringArray) {
        if (stringArray == null) {
            this._vhosts = stringArray;
        } else {
            this._vhosts = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this._vhosts[i] = this.normalizeHostname(stringArray[i]);
            }
        }
    }

    public void addVirtualHosts(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        ArrayList<Object> arrayList = null;
        arrayList = this._vhosts != null ? new ArrayList<String>(Arrays.asList(this._vhosts)) : new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.normalizeHostname(stringArray[i]);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        this._vhosts = arrayList.toArray(new String[0]);
    }

    public void removeVirtualHosts(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        if (this._vhosts == null || this._vhosts.length == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this._vhosts));
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.normalizeHostname(stringArray[i]);
            if (!arrayList.contains(string)) continue;
            arrayList.remove(string);
        }
        this._vhosts = arrayList.isEmpty() ? null : arrayList.toArray(new String[0]);
    }

    @ManagedAttribute(value="Virtual hosts accepted by the context", readonly=true)
    public String[] getVirtualHosts() {
        return this._vhosts;
    }

    public Object getAttribute(String string) {
        return this._attributes.getAttribute(string);
    }

    public Enumeration<String> getAttributeNames() {
        return AttributesMap.getAttributeNamesCopy((Attributes)this._attributes);
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @ManagedAttribute(value="The file classpath")
    public String getClassPath() {
        if (this._classLoader == null || !(this._classLoader instanceof URLClassLoader)) {
            return null;
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)this._classLoader;
        URL[] uRLArray = uRLClassLoader.getURLs();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                Resource resource = this.newResource(uRLArray[i]);
                File file = resource.getFile();
                if (file == null || !file.exists()) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(File.pathSeparatorChar);
                }
                stringBuilder.append(file.getAbsolutePath());
                continue;
            }
            catch (IOException iOException) {
                LOG.debug((Throwable)iOException);
            }
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    @ManagedAttribute(value="True if URLs are compacted to replace the multiple '/'s with a single '/'")
    public String getContextPath() {
        return this._contextPath;
    }

    public String getInitParameter(String string) {
        return this._initParams.get(string);
    }

    public String setInitParameter(String string, String string2) {
        return this._initParams.put(string, string2);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    @ManagedAttribute(value="Initial Parameter map for the context")
    public Map<String, String> getInitParams() {
        return this._initParams;
    }

    @ManagedAttribute(value="Display name of the Context", readonly=true)
    public String getDisplayName() {
        return this._displayName;
    }

    public EventListener[] getEventListeners() {
        return this._eventListeners.toArray(new EventListener[this._eventListeners.size()]);
    }

    public void setEventListeners(EventListener[] eventListenerArray) {
        this._contextListeners.clear();
        this._servletContextListeners.clear();
        this._servletContextAttributeListeners.clear();
        this._servletRequestListeners.clear();
        this._servletRequestAttributeListeners.clear();
        this._eventListeners.clear();
        if (eventListenerArray != null) {
            for (EventListener eventListener : eventListenerArray) {
                this.addEventListener(eventListener);
            }
        }
    }

    public void addEventListener(EventListener eventListener) {
        this._eventListeners.add(eventListener);
        if (!this.isStarted() && !this.isStarting()) {
            this._durableListeners.add(eventListener);
        }
        if (eventListener instanceof ContextScopeListener) {
            this._contextListeners.add((ContextScopeListener)eventListener);
        }
        if (eventListener instanceof ServletContextListener) {
            this._servletContextListeners.add((ServletContextListener)eventListener);
        }
        if (eventListener instanceof ServletContextAttributeListener) {
            this._servletContextAttributeListeners.add((ServletContextAttributeListener)eventListener);
        }
        if (eventListener instanceof ServletRequestListener) {
            this._servletRequestListeners.add((ServletRequestListener)eventListener);
        }
        if (eventListener instanceof ServletRequestAttributeListener) {
            this._servletRequestAttributeListeners.add((ServletRequestAttributeListener)eventListener);
        }
    }

    public void removeEventListener(EventListener eventListener) {
        this._eventListeners.remove(eventListener);
        if (eventListener instanceof ContextScopeListener) {
            this._contextListeners.remove(eventListener);
        }
        if (eventListener instanceof ServletContextListener) {
            this._servletContextListeners.remove(eventListener);
        }
        if (eventListener instanceof ServletContextAttributeListener) {
            this._servletContextAttributeListeners.remove(eventListener);
        }
        if (eventListener instanceof ServletRequestListener) {
            this._servletRequestListeners.remove(eventListener);
        }
        if (eventListener instanceof ServletRequestAttributeListener) {
            this._servletRequestAttributeListeners.remove(eventListener);
        }
    }

    protected void addProgrammaticListener(EventListener eventListener) {
        this._programmaticListeners.add(eventListener);
    }

    protected boolean isProgrammaticListener(EventListener eventListener) {
        return this._programmaticListeners.contains(eventListener);
    }

    @ManagedAttribute(value="true for graceful shutdown, which allows existing requests to complete")
    public boolean isShutdown() {
        switch (this._availability) {
            case SHUTDOWN: {
                return true;
            }
        }
        return false;
    }

    public Future<Void> shutdown() {
        this._availability = this.isRunning() ? Availability.SHUTDOWN : Availability.UNAVAILABLE;
        return new FutureCallback(true);
    }

    public boolean isAvailable() {
        return this._availability == Availability.AVAILABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailable(boolean bl) {
        ContextHandler contextHandler = this;
        synchronized (contextHandler) {
            if (bl && this.isRunning()) {
                this._availability = Availability.AVAILABLE;
            } else if (!bl || !this.isRunning()) {
                this._availability = Availability.UNAVAILABLE;
            }
        }
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        this._availability = Availability.STARTING;
        if (this._contextPath == null) {
            throw new IllegalStateException("Null contextPath");
        }
        if (this._logger == null) {
            this._logger = Log.getLogger((String)(this.getDisplayName() == null ? this.getContextPath() : this.getDisplayName()));
        }
        ClassLoader classLoader = null;
        Thread thread = null;
        Context context = null;
        this._attributes.setAttribute("org.eclipse.jetty.server.Executor", (Object)this.getServer().getThreadPool());
        try {
            if (this._classLoader != null) {
                thread = Thread.currentThread();
                classLoader = thread.getContextClassLoader();
                thread.setContextClassLoader(this._classLoader);
            }
            if (this._mimeTypes == null) {
                this._mimeTypes = new MimeTypes();
            }
            context = __context.get();
            __context.set(this._scontext);
            this.startContext();
            this._availability = Availability.AVAILABLE;
            LOG.info("Started {}", new Object[]{this});
            __context.set(context);
            if (this._classLoader != null && thread != null) {
                thread.setContextClassLoader(classLoader);
            }
        }
        catch (Throwable throwable) {
            __context.set(context);
            if (this._classLoader != null && thread != null) {
                thread.setContextClassLoader(classLoader);
            }
            throw throwable;
        }
    }

    protected void startContext() {
        String string = this._initParams.get(MANAGED_ATTRIBUTES);
        if (string != null) {
            this.addEventListener((EventListener)((Object)new ManagedAttributeListener(this, StringUtil.csvSplit((String)string))));
        }
        super.doStart();
        if (!this._servletContextListeners.isEmpty()) {
            ServletContextEvent servletContextEvent = new ServletContextEvent((ServletContext)this._scontext);
            for (ServletContextListener servletContextListener : this._servletContextListeners) {
                this.callContextInitialized(servletContextListener, servletContextEvent);
            }
        }
    }

    protected void stopContext() {
        super.doStop();
        if (!this._servletContextListeners.isEmpty()) {
            ServletContextEvent servletContextEvent = new ServletContextEvent((ServletContext)this._scontext);
            int n = this._servletContextListeners.size();
            while (n-- > 0) {
                this.callContextDestroyed(this._servletContextListeners.get(n), servletContextEvent);
            }
        }
    }

    protected void callContextInitialized(ServletContextListener servletContextListener, ServletContextEvent servletContextEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("contextInitialized: {}->{}", new Object[]{servletContextEvent, servletContextListener});
        }
        servletContextListener.contextInitialized(servletContextEvent);
    }

    protected void callContextDestroyed(ServletContextListener servletContextListener, ServletContextEvent servletContextEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("contextDestroyed: {}->{}", new Object[]{servletContextEvent, servletContextListener});
        }
        servletContextListener.contextDestroyed(servletContextEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        this._availability = Availability.UNAVAILABLE;
        ClassLoader classLoader = null;
        ClassLoader classLoader2 = null;
        Thread thread = null;
        Context context = __context.get();
        __context.set(this._scontext);
        try {
            if (this._classLoader != null) {
                classLoader2 = this._classLoader;
                thread = Thread.currentThread();
                classLoader = thread.getContextClassLoader();
                thread.setContextClassLoader(this._classLoader);
            }
            this.stopContext();
            this.setEventListeners(this._durableListeners.toArray(new EventListener[this._durableListeners.size()]));
            this._durableListeners.clear();
            if (this._errorHandler != null) {
                this._errorHandler.stop();
            }
            for (EventListener eventListener : this._programmaticListeners) {
                this.removeEventListener(eventListener);
            }
            this._programmaticListeners.clear();
        }
        catch (Throwable throwable) {
            LOG.info("Stopped {}", new Object[]{this});
            __context.set(context);
            if ((classLoader == null || classLoader != classLoader2) && thread != null) {
                thread.setContextClassLoader(classLoader);
            }
            throw throwable;
        }
        LOG.info("Stopped {}", new Object[]{this});
        __context.set(context);
        if ((classLoader == null || classLoader != classLoader2) && thread != null) {
            thread.setContextClassLoader(classLoader);
        }
        this._scontext.clearAttributes();
    }

    public boolean checkVirtualHost(Request request) {
        if (this._vhosts != null && this._vhosts.length > 0) {
            String string = this.normalizeHostname(request.getServerName());
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            block4: for (String string2 : this._vhosts) {
                if (string2 == null || string2.length() == 0) continue;
                char c = string2.charAt(0);
                switch (c) {
                    case '*': {
                        if (!string2.startsWith("*.")) continue block4;
                        bl = bl || string2.regionMatches(true, 2, string, string.indexOf(".") + 1, string2.length() - 2);
                        continue block4;
                    }
                    case '@': {
                        bl2 = true;
                        String string3 = request.getHttpChannel().getConnector().getName();
                        boolean bl4 = string3 != null && string2.length() == string3.length() + 1 && string2.endsWith(string3);
                        bl = bl || bl4;
                        bl3 = bl3 || bl4;
                        continue block4;
                    }
                    default: {
                        bl = bl || string2.equalsIgnoreCase(string);
                    }
                }
            }
            if (!bl || bl2 && !bl3) {
                return false;
            }
        }
        return true;
    }

    public boolean checkContextPath(String string) {
        if (this._contextPath.length() > 1) {
            if (!string.startsWith(this._contextPath)) {
                return false;
            }
            if (string.length() > this._contextPath.length() && string.charAt(this._contextPath.length()) != '/') {
                return false;
            }
        }
        return true;
    }

    public boolean checkContext(String string, Request request, HttpServletResponse httpServletResponse) {
        DispatcherType dispatcherType = request.getDispatcherType();
        if (!this.checkVirtualHost(request)) {
            return false;
        }
        if (!this.checkContextPath(string)) {
            return false;
        }
        if (!this._allowNullPathInfo && this._contextPath.length() == string.length() && this._contextPath.length() > 1) {
            request.setHandled(true);
            if (request.getQueryString() != null) {
                httpServletResponse.sendRedirect(URIUtil.addPaths((String)request.getRequestURI(), (String)"/") + "?" + request.getQueryString());
            } else {
                httpServletResponse.sendRedirect(URIUtil.addPaths((String)request.getRequestURI(), (String)"/"));
            }
            return false;
        }
        switch (this._availability) {
            case SHUTDOWN: 
            case UNAVAILABLE: {
                request.setHandled(true);
                httpServletResponse.sendError(503);
                return false;
            }
        }
        return !DispatcherType.REQUEST.equals((Object)dispatcherType) || !request.isHandled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doScope(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("scope {}|{}|{} @ {}", new Object[]{request.getContextPath(), request.getServletPath(), request.getPathInfo(), this});
        }
        Context context = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ClassLoader classLoader = null;
        Thread thread = null;
        String string5 = string;
        DispatcherType dispatcherType = request.getDispatcherType();
        context = request.getContext();
        if (context != this._scontext) {
            if (DispatcherType.REQUEST.equals((Object)dispatcherType) || DispatcherType.ASYNC.equals((Object)dispatcherType) || DispatcherType.ERROR.equals((Object)dispatcherType) && request.getHttpChannelState().isAsync()) {
                if (this._compactPath) {
                    string = URIUtil.compactPath((String)string);
                }
                if (!this.checkContext(string, request, httpServletResponse)) {
                    return;
                }
                if (string.length() > this._contextPath.length()) {
                    if (this._contextPath.length() > 1) {
                        string = string.substring(this._contextPath.length());
                    }
                    string5 = string;
                } else if (this._contextPath.length() == 1) {
                    string = "/";
                    string5 = "/";
                } else {
                    string = "/";
                    string5 = null;
                }
            }
            if (this._classLoader != null) {
                thread = Thread.currentThread();
                classLoader = thread.getContextClassLoader();
                thread.setContextClassLoader(this._classLoader);
            }
        }
        try {
            string2 = request.getContextPath();
            string3 = request.getServletPath();
            string4 = request.getPathInfo();
            request.setContext(this._scontext);
            __context.set(this._scontext);
            if (!DispatcherType.INCLUDE.equals((Object)dispatcherType) && string.startsWith("/")) {
                if (this._contextPath.length() == 1) {
                    request.setContextPath("");
                } else {
                    request.setContextPath(this._contextPath);
                }
                request.setServletPath(null);
                request.setPathInfo(string5);
            }
            if (context != this._scontext) {
                this.enterScope(request, dispatcherType);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("context={}|{}|{} @ {}", new Object[]{request.getContextPath(), request.getServletPath(), request.getPathInfo(), this});
            }
            if (this.never()) {
                this.nextScope(string, request, httpServletRequest, httpServletResponse);
            } else if (this._nextScope != null) {
                this._nextScope.doScope(string, request, httpServletRequest, httpServletResponse);
            } else if (this._outerScope != null) {
                this._outerScope.doHandle(string, request, httpServletRequest, httpServletResponse);
            } else {
                this.doHandle(string, request, httpServletRequest, httpServletResponse);
            }
            if (context != this._scontext) {
                this.exitScope(request);
                if (this._classLoader != null && thread != null) {
                    thread.setContextClassLoader(classLoader);
                }
                request.setContext(context);
                __context.set(context);
                request.setContextPath(string2);
                request.setServletPath(string3);
                request.setPathInfo(string4);
            }
        }
        catch (Throwable throwable) {
            if (context != this._scontext) {
                this.exitScope(request);
                if (this._classLoader != null && thread != null) {
                    thread.setContextClassLoader(classLoader);
                }
                request.setContext(context);
                __context.set(context);
                request.setContextPath(string2);
                request.setServletPath(string3);
                request.setPathInfo(string4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void doHandle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        block27: {
            block28: {
                void var8_16;
                ServletRequestEvent servletRequestEvent;
                boolean bl;
                block24: {
                    block25: {
                        block26: {
                            void var8_14;
                            DispatcherType dispatcherType = request.getDispatcherType();
                            bl = request.takeNewContext();
                            if (bl) {
                                if (!this._servletRequestAttributeListeners.isEmpty()) {
                                    for (ServletRequestAttributeListener object : this._servletRequestAttributeListeners) {
                                        request.addEventListener((EventListener)object);
                                    }
                                }
                                if (!this._servletRequestListeners.isEmpty()) {
                                    servletRequestEvent = new ServletRequestEvent((ServletContext)this._scontext, (ServletRequest)httpServletRequest);
                                    for (ServletRequestListener servletRequestListener : this._servletRequestListeners) {
                                        servletRequestListener.requestInitialized(servletRequestEvent);
                                    }
                                }
                            }
                            if (!DispatcherType.REQUEST.equals((Object)dispatcherType) || !this.isProtectedTarget(string)) break block24;
                            httpServletResponse.sendError(404);
                            request.setHandled(true);
                            if (!bl) break block25;
                            if (this._servletRequestListeners.isEmpty()) break block26;
                            servletRequestEvent = new ServletRequestEvent((ServletContext)this._scontext, (ServletRequest)httpServletRequest);
                            int n = this._servletRequestListeners.size();
                            while (--var8_14 > 0) {
                                this._servletRequestListeners.get((int)var8_14).requestDestroyed(servletRequestEvent);
                            }
                        }
                        if (!this._servletRequestAttributeListeners.isEmpty()) {
                            int n = this._servletRequestAttributeListeners.size();
                            while (n-- > 0) {
                                request.removeEventListener((EventListener)this._servletRequestAttributeListeners.get(n));
                            }
                        }
                    }
                    return;
                }
                try {
                    if (this.never()) {
                        this.nextHandle(string, request, httpServletRequest, httpServletResponse);
                    } else if (this._nextScope != null && this._nextScope == this._handler) {
                        this._nextScope.doHandle(string, request, httpServletRequest, httpServletResponse);
                    } else if (this._handler != null) {
                        this._handler.handle(string, request, httpServletRequest, httpServletResponse);
                    }
                    if (!bl) break block27;
                    if (this._servletRequestListeners.isEmpty()) break block28;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        if (!this._servletRequestListeners.isEmpty()) {
                            ServletRequestEvent servletRequestEvent2 = new ServletRequestEvent((ServletContext)this._scontext, (ServletRequest)httpServletRequest);
                            int n = this._servletRequestListeners.size();
                            while (n-- > 0) {
                                this._servletRequestListeners.get(n).requestDestroyed(servletRequestEvent2);
                            }
                        }
                        if (!this._servletRequestAttributeListeners.isEmpty()) {
                            int n = this._servletRequestAttributeListeners.size();
                            while (n-- > 0) {
                                request.removeEventListener((EventListener)this._servletRequestAttributeListeners.get(n));
                            }
                        }
                    }
                    throw throwable;
                }
                servletRequestEvent = new ServletRequestEvent((ServletContext)this._scontext, (ServletRequest)httpServletRequest);
                int n = this._servletRequestListeners.size();
                while (--var8_16 > 0) {
                    this._servletRequestListeners.get((int)var8_16).requestDestroyed(servletRequestEvent);
                }
            }
            if (!this._servletRequestAttributeListeners.isEmpty()) {
                int n = this._servletRequestAttributeListeners.size();
                while (n-- > 0) {
                    request.removeEventListener((EventListener)this._servletRequestAttributeListeners.get(n));
                }
            }
        }
    }

    protected void enterScope(Request request, Object object) {
        if (!this._contextListeners.isEmpty()) {
            for (ContextScopeListener contextScopeListener : this._contextListeners) {
                try {
                    contextScopeListener.enterScope(this._scontext, request, object);
                }
                catch (Throwable throwable) {
                    LOG.warn(throwable);
                }
            }
        }
    }

    protected void exitScope(Request request) {
        if (!this._contextListeners.isEmpty()) {
            int n = this._contextListeners.size();
            while (n-- > 0) {
                try {
                    this._contextListeners.get(n).exitScope(this._scontext, request);
                }
                catch (Throwable throwable) {
                    LOG.warn(throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Request request, Runnable runnable) {
        ClassLoader classLoader = null;
        Thread thread = null;
        Context context = __context.get();
        if (context == this._scontext) {
            runnable.run();
            return;
        }
        try {
            __context.set(this._scontext);
            if (this._classLoader != null) {
                thread = Thread.currentThread();
                classLoader = thread.getContextClassLoader();
                thread.setContextClassLoader(this._classLoader);
            }
            this.enterScope(request, runnable);
            runnable.run();
        }
        finally {
            this.exitScope(request);
            __context.set(context);
            if (classLoader != null) {
                thread.setContextClassLoader(classLoader);
            }
        }
    }

    public void handle(Runnable runnable) {
        this.handle(null, runnable);
    }

    public boolean isProtectedTarget(String string) {
        if (string == null || this._protectedTargets == null) {
            return false;
        }
        while (string.startsWith("//")) {
            string = URIUtil.compactPath((String)string);
        }
        for (int i = 0; i < this._protectedTargets.length; ++i) {
            String string2 = this._protectedTargets[i];
            if (!StringUtil.startsWithIgnoreCase((String)string, (String)string2)) continue;
            if (string.length() == string2.length()) {
                return true;
            }
            char c = string.charAt(string2.length());
            if (c != '/' && c != '?' && c != '#' && c != ';') continue;
            return true;
        }
        return false;
    }

    public void setProtectedTargets(String[] stringArray) {
        if (stringArray == null) {
            this._protectedTargets = null;
            return;
        }
        this._protectedTargets = Arrays.copyOf(stringArray, stringArray.length);
    }

    public String[] getProtectedTargets() {
        if (this._protectedTargets == null) {
            return null;
        }
        return Arrays.copyOf(this._protectedTargets, this._protectedTargets.length);
    }

    public void removeAttribute(String string) {
        this._attributes.removeAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        this._attributes.setAttribute(string, object);
    }

    public void setAttributes(Attributes attributes) {
        this._attributes.clearAttributes();
        this._attributes.addAll(attributes);
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public void setManagedAttribute(String string, Object object) {
        Object object2 = this._managedAttributes.put(string, object);
        this.updateBean(object2, object);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setContextPath(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null contextPath");
        }
        if (string.endsWith("/*")) {
            LOG.warn(this + " contextPath ends with /*", new Object[0]);
            string = string.substring(0, string.length() - 2);
        } else if (string.length() > 1 && string.endsWith("/")) {
            LOG.warn(this + " contextPath ends with /", new Object[0]);
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() == 0) {
            LOG.warn("Empty contextPath", new Object[0]);
            string = "/";
        }
        this._contextPath = string;
        if (this.getServer() != null && (this.getServer().isStarting() || this.getServer().isStarted())) {
            Handler[] handlerArray = this.getServer().getChildHandlersByClass(ContextHandlerCollection.class);
            for (int i = 0; handlerArray != null && i < handlerArray.length; ++i) {
                ((ContextHandlerCollection)handlerArray[i]).mapContexts();
            }
        }
    }

    public void setDisplayName(String string) {
        this._displayName = string;
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    @ManagedAttribute(value="document root for context")
    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public void setBaseResource(Resource resource) {
        this._baseResource = resource;
    }

    public void setResourceBase(String string) {
        try {
            this.setBaseResource(this.newResource(string));
        }
        catch (Exception exception) {
            LOG.warn(exception.toString(), new Object[0]);
            LOG.debug((Throwable)exception);
            throw new IllegalArgumentException(string);
        }
    }

    public MimeTypes getMimeTypes() {
        if (this._mimeTypes == null) {
            this._mimeTypes = new MimeTypes();
        }
        return this._mimeTypes;
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public void setWelcomeFiles(String[] stringArray) {
        this._welcomeFiles = stringArray;
    }

    @ManagedAttribute(value="Partial URIs of directory welcome files", readonly=true)
    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    @ManagedAttribute(value="The error handler to use for the context")
    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler != null) {
            errorHandler.setServer(this.getServer());
        }
        this.updateBean(this._errorHandler, errorHandler, true);
        this._errorHandler = errorHandler;
    }

    @ManagedAttribute(value="The maximum content size")
    public int getMaxFormContentSize() {
        return this._maxFormContentSize;
    }

    public void setMaxFormContentSize(int n) {
        this._maxFormContentSize = n;
    }

    public int getMaxFormKeys() {
        return this._maxFormKeys;
    }

    public void setMaxFormKeys(int n) {
        this._maxFormKeys = n;
    }

    public boolean isCompactPath() {
        return this._compactPath;
    }

    public void setCompactPath(boolean bl) {
        this._compactPath = bl;
    }

    public String toString() {
        String string;
        String[] stringArray = this.getVirtualHosts();
        StringBuilder stringBuilder = new StringBuilder();
        Package package_ = this.getClass().getPackage();
        if (package_ != null && (string = package_.getName()) != null && string.length() > 0) {
            String[] stringArray2;
            for (String string2 : stringArray2 = string.split("\\.")) {
                stringBuilder.append(string2.charAt(0)).append('.');
            }
        }
        stringBuilder.append(this.getClass().getSimpleName()).append('@').append(Integer.toString(this.hashCode(), 16));
        stringBuilder.append('{').append(this.getContextPath()).append(',').append(this.getBaseResource()).append(',').append((Object)this._availability);
        if (stringArray != null && stringArray.length > 0) {
            stringBuilder.append(',').append(stringArray[0]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public synchronized Class<?> loadClass(String string) {
        if (string == null) {
            return null;
        }
        if (this._classLoader == null) {
            return Loader.loadClass(this.getClass(), (String)string);
        }
        return this._classLoader.loadClass(string);
    }

    public void addLocaleEncoding(String string, String string2) {
        if (this._localeEncodingMap == null) {
            this._localeEncodingMap = new HashMap<String, String>();
        }
        this._localeEncodingMap.put(string, string2);
    }

    public String getLocaleEncoding(String string) {
        if (this._localeEncodingMap == null) {
            return null;
        }
        String string2 = this._localeEncodingMap.get(string);
        return string2;
    }

    public String getLocaleEncoding(Locale locale) {
        if (this._localeEncodingMap == null) {
            return null;
        }
        String string = this._localeEncodingMap.get(locale.toString());
        if (string == null) {
            string = this._localeEncodingMap.get(locale.getLanguage());
        }
        return string;
    }

    public Map<String, String> getLocaleEncodings() {
        if (this._localeEncodingMap == null) {
            return null;
        }
        return Collections.unmodifiableMap(this._localeEncodingMap);
    }

    public Resource getResource(String string) {
        if (string == null || !string.startsWith("/")) {
            throw new MalformedURLException(string);
        }
        if (this._baseResource == null) {
            return null;
        }
        try {
            string = URIUtil.canonicalPath((String)string);
            Resource resource = this._baseResource.addPath(string);
            if (this.checkAlias(string, resource)) {
                return resource;
            }
            return null;
        }
        catch (Exception exception) {
            LOG.ignore((Throwable)exception);
            return null;
        }
    }

    public boolean checkAlias(String string, Resource resource) {
        if (resource.isAlias()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aliased resource: " + resource + "~=" + resource.getAlias(), new Object[0]);
            }
            for (AliasCheck aliasCheck : this._aliasChecks) {
                if (!aliasCheck.check(string, resource)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Aliased resource: " + resource + " approved by " + aliasCheck, new Object[0]);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public Resource newResource(URL uRL) {
        return Resource.newResource((URL)uRL);
    }

    public Resource newResource(URI uRI) {
        return Resource.newResource((URI)uRI);
    }

    public Resource newResource(String string) {
        return Resource.newResource((String)string);
    }

    public Set<String> getResourcePaths(String string) {
        try {
            string = URIUtil.canonicalPath((String)string);
            Resource resource = this.getResource(string);
            if (resource != null && resource.exists()) {
                String[] stringArray;
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                if ((stringArray = resource.list()) != null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    for (int i = 0; i < stringArray.length; ++i) {
                        hashSet.add(string + stringArray[i]);
                    }
                    return hashSet;
                }
            }
        }
        catch (Exception exception) {
            LOG.ignore((Throwable)exception);
        }
        return Collections.emptySet();
    }

    private String normalizeHostname(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith(".")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public void addAliasCheck(AliasCheck aliasCheck) {
        this._aliasChecks.add(aliasCheck);
    }

    public List<AliasCheck> getAliasChecks() {
        return this._aliasChecks;
    }

    public void setAliasChecks(List<AliasCheck> list) {
        this._aliasChecks.clear();
        this._aliasChecks.addAll(list);
    }

    public void clearAliasChecks() {
        this._aliasChecks.clear();
    }

    public static interface ContextScopeListener
    extends EventListener {
        public void enterScope(Context var1, Request var2, Object var3);

        public void exitScope(Context var1, Request var2);
    }

    public static class ApproveNonExistentDirectoryAliases
    implements AliasCheck {
        @Override
        public boolean check(String string, Resource resource) {
            if (resource.exists()) {
                return false;
            }
            String string2 = resource.getAlias().toString();
            String string3 = resource.getURI().toString();
            if (string2.length() > string3.length()) {
                return string2.startsWith(string3) && string2.length() == string3.length() + 1 && string2.endsWith("/");
            }
            if (string2.length() < string3.length()) {
                return string3.startsWith(string2) && string3.length() == string2.length() + 1 && string3.endsWith("/");
            }
            return string2.equals(string3);
        }
    }

    public static class ApproveAliases
    implements AliasCheck {
        @Override
        public boolean check(String string, Resource resource) {
            return true;
        }
    }

    public static interface AliasCheck {
        public boolean check(String var1, Resource var2);
    }

    public static class StaticContext
    extends AttributesMap
    implements ServletContext {
        private int _effectiveMajorVersion = 3;
        private int _effectiveMinorVersion = 1;

        public ServletContext getContext(String string) {
            return null;
        }

        public int getMajorVersion() {
            return 3;
        }

        public String getMimeType(String string) {
            return null;
        }

        public int getMinorVersion() {
            return 1;
        }

        public RequestDispatcher getNamedDispatcher(String string) {
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String string) {
            return null;
        }

        public String getRealPath(String string) {
            return null;
        }

        public URL getResource(String string) {
            return null;
        }

        public InputStream getResourceAsStream(String string) {
            return null;
        }

        public Set<String> getResourcePaths(String string) {
            return null;
        }

        public String getServerInfo() {
            return __serverInfo;
        }

        @Deprecated
        public Servlet getServlet(String string) {
            return null;
        }

        @Deprecated
        public Enumeration<String> getServletNames() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        @Deprecated
        public Enumeration<Servlet> getServlets() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public void log(Exception exception, String string) {
            LOG.warn(string, (Throwable)exception);
        }

        public void log(String string) {
            LOG.info(string, new Object[0]);
        }

        public void log(String string, Throwable throwable) {
            LOG.warn(string, throwable);
        }

        public String getInitParameter(String string) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public String getServletContextName() {
            return "No Context";
        }

        public String getContextPath() {
            return null;
        }

        public boolean setInitParameter(String string, String string2) {
            return false;
        }

        public FilterRegistration.Dynamic addFilter(String string, Class<? extends Filter> clazz) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String string, Filter filter) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String string, String string2) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String string, Class<? extends Servlet> clazz) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String string, Servlet servlet) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String string, String string2) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public <T extends Filter> T createFilter(Class<T> clazz) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public <T extends Servlet> T createServlet(Class<T> clazz) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public FilterRegistration getFilterRegistration(String string) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public ServletRegistration getServletRegistration(String string) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public SessionCookieConfig getSessionCookieConfig() {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
        }

        public void addListener(String string) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
        }

        public <T extends EventListener> void addListener(T t) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
        }

        public void addListener(Class<? extends EventListener> clazz) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
        }

        public <T extends EventListener> T createListener(Class<T> clazz) {
            try {
                return (T)((EventListener)clazz.newInstance());
            }
            catch (InstantiationException instantiationException) {
                throw new ServletException((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ServletException((Throwable)illegalAccessException);
            }
        }

        public ClassLoader getClassLoader() {
            return ContextHandler.class.getClassLoader();
        }

        public int getEffectiveMajorVersion() {
            return this._effectiveMajorVersion;
        }

        public int getEffectiveMinorVersion() {
            return this._effectiveMinorVersion;
        }

        public void setEffectiveMajorVersion(int n) {
            this._effectiveMajorVersion = n;
        }

        public void setEffectiveMinorVersion(int n) {
            this._effectiveMinorVersion = n;
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public void declareRoles(String ... stringArray) {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
        }

        public String getVirtualServerName() {
            return null;
        }
    }

    public class Context
    extends StaticContext {
        protected boolean _enabled = true;
        protected boolean _extendedListenerTypes = false;

        protected Context() {
        }

        public ContextHandler getContextHandler() {
            return ContextHandler.this;
        }

        @Override
        public ServletContext getContext(String string) {
            ContextHandler contextHandler;
            String string2;
            ArrayList<ContextHandler> arrayList = new ArrayList<ContextHandler>();
            Handler[] handlerArray = ContextHandler.this.getServer().getChildHandlersByClass(ContextHandler.class);
            String string3 = null;
            for (Handler handler : handlerArray) {
                if (handler == null || !string.equals(string2 = (contextHandler = (ContextHandler)handler).getContextPath()) && (!string.startsWith(string2) || string.charAt(string2.length()) != '/') && !"/".equals(string2)) continue;
                if (ContextHandler.this.getVirtualHosts() != null && ContextHandler.this.getVirtualHosts().length > 0) {
                    if (contextHandler.getVirtualHosts() == null || contextHandler.getVirtualHosts().length <= 0) continue;
                    for (String string4 : ContextHandler.this.getVirtualHosts()) {
                        for (String string5 : contextHandler.getVirtualHosts()) {
                            if (!string4.equals(string5)) continue;
                            if (string3 == null || string2.length() > string3.length()) {
                                arrayList.clear();
                                string3 = string2;
                            }
                            if (!string3.equals(string2)) continue;
                            arrayList.add(contextHandler);
                        }
                    }
                    continue;
                }
                if (string3 == null || string2.length() > string3.length()) {
                    arrayList.clear();
                    string3 = string2;
                }
                if (!string3.equals(string2)) continue;
                arrayList.add(contextHandler);
            }
            if (arrayList.size() > 0) {
                return ((ContextHandler)arrayList.get((int)0))._scontext;
            }
            string3 = null;
            for (Handler handler : handlerArray) {
                if (handler == null || !string.equals(string2 = (contextHandler = (ContextHandler)handler).getContextPath()) && (!string.startsWith(string2) || string.charAt(string2.length()) != '/') && !"/".equals(string2)) continue;
                if (string3 == null || string2.length() > string3.length()) {
                    arrayList.clear();
                    string3 = string2;
                }
                if (string3 == null || !string3.equals(string2)) continue;
                arrayList.add(contextHandler);
            }
            if (arrayList.size() > 0) {
                return ((ContextHandler)arrayList.get((int)0))._scontext;
            }
            return null;
        }

        @Override
        public String getMimeType(String string) {
            if (ContextHandler.this._mimeTypes == null) {
                return null;
            }
            return ContextHandler.this._mimeTypes.getMimeByExtension(string);
        }

        @Override
        public RequestDispatcher getRequestDispatcher(String string) {
            if (string == null) {
                return null;
            }
            if (!string.startsWith("/")) {
                return null;
            }
            try {
                HttpURI httpURI = new HttpURI(null, null, 0, string);
                String string2 = URIUtil.canonicalPath((String)httpURI.getDecodedPath());
                if (string2 == null) {
                    return null;
                }
                String string3 = this.getContextPath();
                if (string3 != null && string3.length() > 0) {
                    httpURI.setPath(URIUtil.addPaths((String)string3, (String)httpURI.getPath()));
                }
                return new Dispatcher(ContextHandler.this, httpURI, string2);
            }
            catch (Exception exception) {
                LOG.ignore((Throwable)exception);
                return null;
            }
        }

        @Override
        public String getRealPath(String string) {
            if (string == null) {
                return null;
            }
            if (string.length() == 0) {
                string = "/";
            } else if (string.charAt(0) != '/') {
                string = "/" + string;
            }
            try {
                File file;
                Resource resource = ContextHandler.this.getResource(string);
                if (resource != null && (file = resource.getFile()) != null) {
                    return file.getCanonicalPath();
                }
            }
            catch (Exception exception) {
                LOG.ignore((Throwable)exception);
            }
            return null;
        }

        @Override
        public URL getResource(String string) {
            Resource resource = ContextHandler.this.getResource(string);
            if (resource != null && resource.exists()) {
                return resource.getURI().toURL();
            }
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            try {
                URL uRL = this.getResource(string);
                if (uRL == null) {
                    return null;
                }
                Resource resource = Resource.newResource((URL)uRL);
                return resource.getInputStream();
            }
            catch (Exception exception) {
                LOG.ignore((Throwable)exception);
                return null;
            }
        }

        @Override
        public Set<String> getResourcePaths(String string) {
            return ContextHandler.this.getResourcePaths(string);
        }

        @Override
        public void log(Exception exception, String string) {
            ContextHandler.this._logger.warn(string, (Throwable)exception);
        }

        @Override
        public void log(String string) {
            ContextHandler.this._logger.info(string, new Object[0]);
        }

        @Override
        public void log(String string, Throwable throwable) {
            ContextHandler.this._logger.warn(string, throwable);
        }

        @Override
        public String getInitParameter(String string) {
            return ContextHandler.this.getInitParameter(string);
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            return ContextHandler.this.getInitParameterNames();
        }

        public synchronized Object getAttribute(String string) {
            Object object = ContextHandler.this.getAttribute(string);
            if (object == null) {
                object = super.getAttribute(string);
            }
            return object;
        }

        public synchronized Enumeration<String> getAttributeNames() {
            HashSet hashSet = new HashSet();
            Enumeration enumeration = super.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                hashSet.add(enumeration.nextElement());
            }
            enumeration = ContextHandler.this._attributes.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                hashSet.add(enumeration.nextElement());
            }
            return Collections.enumeration(hashSet);
        }

        public synchronized void setAttribute(String string, Object object) {
            Object object2 = super.getAttribute(string);
            if (object == null) {
                super.removeAttribute(string);
            } else {
                super.setAttribute(string, object);
            }
            if (!ContextHandler.this._servletContextAttributeListeners.isEmpty()) {
                ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent((ServletContext)ContextHandler.this._scontext, string, object2 == null ? object : object2);
                for (ServletContextAttributeListener servletContextAttributeListener : ContextHandler.this._servletContextAttributeListeners) {
                    if (object2 == null) {
                        servletContextAttributeListener.attributeAdded(servletContextAttributeEvent);
                        continue;
                    }
                    if (object == null) {
                        servletContextAttributeListener.attributeRemoved(servletContextAttributeEvent);
                        continue;
                    }
                    servletContextAttributeListener.attributeReplaced(servletContextAttributeEvent);
                }
            }
        }

        public synchronized void removeAttribute(String string) {
            Object object = super.getAttribute(string);
            super.removeAttribute(string);
            if (object != null && !ContextHandler.this._servletContextAttributeListeners.isEmpty()) {
                ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent((ServletContext)ContextHandler.this._scontext, string, object);
                for (ServletContextAttributeListener servletContextAttributeListener : ContextHandler.this._servletContextAttributeListeners) {
                    servletContextAttributeListener.attributeRemoved(servletContextAttributeEvent);
                }
            }
        }

        @Override
        public String getServletContextName() {
            String string = ContextHandler.this.getDisplayName();
            if (string == null) {
                string = ContextHandler.this.getContextPath();
            }
            return string;
        }

        @Override
        public String getContextPath() {
            if (ContextHandler.this._contextPath != null && ContextHandler.this._contextPath.equals("/")) {
                return "";
            }
            return ContextHandler.this._contextPath;
        }

        public String toString() {
            return "ServletContext@" + ContextHandler.this.toString();
        }

        @Override
        public boolean setInitParameter(String string, String string2) {
            if (ContextHandler.this.getInitParameter(string) != null) {
                return false;
            }
            ContextHandler.this.getInitParams().put(string, string2);
            return true;
        }

        @Override
        public void addListener(String string) {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            try {
                Class<?> clazz = ContextHandler.this._classLoader == null ? Loader.loadClass(ContextHandler.class, (String)string) : ContextHandler.this._classLoader.loadClass(string);
                this.addListener(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(classNotFoundException);
            }
        }

        @Override
        public <T extends EventListener> void addListener(T t) {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            this.checkListener(t.getClass());
            ContextHandler.this.addEventListener(t);
            ContextHandler.this.addProgrammaticListener(t);
        }

        @Override
        public void addListener(Class<? extends EventListener> clazz) {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            try {
                EventListener eventListener = this.createListener(clazz);
                this.addListener(eventListener);
            }
            catch (ServletException servletException) {
                throw new IllegalArgumentException(servletException);
            }
        }

        @Override
        public <T extends EventListener> T createListener(Class<T> clazz) {
            try {
                return (T)((EventListener)this.createInstance(clazz));
            }
            catch (Exception exception) {
                throw new ServletException((Throwable)exception);
            }
        }

        public void checkListener(Class<? extends EventListener> clazz) {
            int n;
            boolean bl = false;
            for (int i = n = this.isExtendedListenerTypes() ? 0 : 1; i < SERVLET_LISTENER_TYPES.length; ++i) {
                if (!SERVLET_LISTENER_TYPES[i].isAssignableFrom(clazz)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalArgumentException("Inappropriate listener class " + clazz.getName());
            }
        }

        public void setExtendedListenerTypes(boolean bl) {
            this._extendedListenerTypes = bl;
        }

        public boolean isExtendedListenerTypes() {
            return this._extendedListenerTypes;
        }

        @Override
        public ClassLoader getClassLoader() {
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
            if (!ContextHandler.this._usingSecurityManager) {
                return ContextHandler.this._classLoader;
            }
            try {
                Class clazz = Loader.loadClass(((Object)((Object)this)).getClass(), (String)"sun.reflect.Reflection");
                Method method = clazz.getMethod("getCallerClass", Integer.TYPE);
                Class clazz2 = (Class)method.invoke(null, 2);
                boolean bl = false;
                ClassLoader classLoader = clazz2.getClassLoader();
                while (!bl && classLoader != null) {
                    if (classLoader == ContextHandler.this._classLoader) {
                        bl = true;
                        continue;
                    }
                    classLoader = classLoader.getParent();
                }
                if (bl) {
                    return ContextHandler.this._classLoader;
                }
            }
            catch (Exception exception) {
                LOG.warn("Unable to check classloader of caller", (Throwable)exception);
            }
            AccessController.checkPermission(new RuntimePermission("getClassLoader"));
            return ContextHandler.this._classLoader;
        }

        @Override
        public JspConfigDescriptor getJspConfigDescriptor() {
            LOG.warn(ContextHandler.__unimplmented, new Object[0]);
            return null;
        }

        public void setJspConfigDescriptor(JspConfigDescriptor jspConfigDescriptor) {
        }

        @Override
        public void declareRoles(String ... stringArray) {
            if (!ContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (!this._enabled) {
                throw new UnsupportedOperationException();
            }
        }

        public void setEnabled(boolean bl) {
            this._enabled = bl;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public <T> T createInstance(Class<T> clazz) {
            T t = clazz.newInstance();
            return t;
        }

        @Override
        public String getVirtualServerName() {
            String[] stringArray = ContextHandler.this.getVirtualHosts();
            if (stringArray != null && stringArray.length > 0) {
                return stringArray[0];
            }
            return null;
        }
    }

    public static enum Availability {
        UNAVAILABLE,
        STARTING,
        AVAILABLE,
        SHUTDOWN;

    }
}

