/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;

public class AllowSymLinkAliasChecker
implements ContextHandler.AliasCheck {
    private static final Logger LOG = Log.getLogger(AllowSymLinkAliasChecker.class);

    @Override
    public boolean check(String string, Resource resource) {
        if (!(resource instanceof PathResource)) {
            return false;
        }
        PathResource pathResource = (PathResource)resource;
        try {
            Path path = pathResource.getPath();
            Path path2 = pathResource.getAliasPath();
            if (Files.isSymbolicLink(path)) {
                path2 = path.getParent().resolve(path2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("path ={}", new Object[]{path});
                    LOG.debug("alias={}", new Object[]{path2});
                }
                if (Files.isSameFile(path, path2)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Allow symlink {} --> {}", new Object[]{resource, pathResource.getAliasPath()});
                    }
                    return true;
                }
            }
            boolean bl = true;
            Path path3 = path;
            int n = 0;
            while (bl) {
                if (++n > 100) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Too many symlinks {} --> {}", new Object[]{resource, path3});
                    }
                    return false;
                }
                bl = false;
                Path path4 = path3.getRoot();
                for (Path path5 : path3) {
                    Path path6;
                    path4 = path6 = path4.resolve(path5);
                    while (Files.exists(path4, new LinkOption[0]) && Files.isSymbolicLink(path4)) {
                        Path path7 = Files.readSymbolicLink(path4);
                        if (!path7.isAbsolute()) {
                            path7 = path4.getParent().resolve(path7);
                        }
                        path4 = path7;
                        bl = true;
                    }
                }
                path3 = path4;
            }
            if (pathResource.getAliasPath().equals(path3)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Allow path symlink {} --> {}", new Object[]{resource, path3});
                }
                return true;
            }
        }
        catch (Exception exception) {
            LOG.ignore((Throwable)exception);
        }
        return false;
    }
}

