/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;

public abstract class AbstractHandlerContainer
extends AbstractHandler
implements HandlerContainer {
    @Override
    public Handler[] getChildHandlers() {
        ArrayList<Handler> arrayList = new ArrayList<Handler>();
        this.expandChildren(arrayList, null);
        return arrayList.toArray(new Handler[arrayList.size()]);
    }

    @Override
    public Handler[] getChildHandlersByClass(Class<?> clazz) {
        ArrayList<Handler> arrayList = new ArrayList<Handler>();
        this.expandChildren(arrayList, clazz);
        return arrayList.toArray(new Handler[arrayList.size()]);
    }

    @Override
    public <T extends Handler> T getChildHandlerByClass(Class<T> clazz) {
        ArrayList<Handler> arrayList = new ArrayList<Handler>();
        this.expandChildren(arrayList, clazz);
        if (arrayList.isEmpty()) {
            return null;
        }
        return (T)((Handler)arrayList.get(0));
    }

    protected void expandChildren(List<Handler> list, Class<?> clazz) {
    }

    protected void expandHandler(Handler handler, List<Handler> list, Class<?> clazz) {
        if (handler == null) {
            return;
        }
        if (clazz == null || clazz.isAssignableFrom(handler.getClass())) {
            list.add(handler);
        }
        if (handler instanceof AbstractHandlerContainer) {
            ((AbstractHandlerContainer)handler).expandChildren(list, clazz);
        } else if (handler instanceof HandlerContainer) {
            HandlerContainer handlerContainer = (HandlerContainer)((Object)handler);
            Handler[] handlerArray = clazz == null ? handlerContainer.getChildHandlers() : handlerContainer.getChildHandlersByClass(clazz);
            list.addAll(Arrays.asList(handlerArray));
        }
    }

    public static <T extends HandlerContainer> T findContainerOf(HandlerContainer handlerContainer, Class<T> clazz, Handler handler) {
        if (handlerContainer == null || handler == null) {
            return null;
        }
        Handler[] handlerArray = handlerContainer.getChildHandlersByClass(clazz);
        if (handlerArray != null) {
            for (Handler handler2 : handlerArray) {
                HandlerContainer handlerContainer2 = (HandlerContainer)((Object)handler2);
                Handler[] handlerArray2 = handlerContainer2.getChildHandlersByClass(handler.getClass());
                if (handlerArray2 == null) continue;
                for (Handler handler3 : handlerArray2) {
                    if (handler3 != handler) continue;
                    return (T)handlerContainer2;
                }
            }
        }
        return null;
    }

    @Override
    public void setServer(Server server) {
        if (server == this.getServer()) {
            return;
        }
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        super.setServer(server);
        Handler[] handlerArray = this.getHandlers();
        if (handlerArray != null) {
            for (Handler handler : handlerArray) {
                handler.setServer(server);
            }
        }
    }
}

