/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.OutputStream;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpWriter;

public class Utf8HttpWriter
extends HttpWriter {
    int _surrogate = 0;

    public Utf8HttpWriter(HttpOutput httpOutput) {
        super(httpOutput);
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        HttpOutput httpOutput = this._out;
        if (n2 == 0 && httpOutput.isAllContentWritten()) {
            this.close();
            return;
        }
        while (n2 > 0) {
            this._bytes.reset();
            int n3 = n2 > 512 ? 512 : n2;
            byte[] byArray = this._bytes.getBuf();
            int n4 = this._bytes.getCount();
            if (n4 + n3 > byArray.length) {
                n3 = byArray.length - n4;
            }
            for (int i = 0; i < n3; ++i) {
                int n5 = cArray[n + i];
                if (this._surrogate == 0) {
                    if (Character.isHighSurrogate((char)n5)) {
                        this._surrogate = n5;
                        continue;
                    }
                } else if (Character.isLowSurrogate((char)n5)) {
                    n5 = Character.toCodePoint((char)this._surrogate, (char)n5);
                } else {
                    n5 = this._surrogate;
                    this._surrogate = 0;
                    --i;
                }
                if ((n5 & 0xFFFFFF80) == 0) {
                    if (n4 >= byArray.length) {
                        n3 = i;
                        break;
                    }
                    byArray[n4++] = (byte)n5;
                    continue;
                }
                if ((n5 & 0xFFFFF800) == 0) {
                    if (n4 + 2 > byArray.length) {
                        n3 = i;
                        break;
                    }
                    byArray[n4++] = (byte)(0xC0 | n5 >> 6);
                    byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                } else if ((n5 & 0xFFFF0000) == 0) {
                    if (n4 + 3 > byArray.length) {
                        n3 = i;
                        break;
                    }
                    byArray[n4++] = (byte)(0xE0 | n5 >> 12);
                    byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                } else if ((n5 & 0xFF200000) == 0) {
                    if (n4 + 4 > byArray.length) {
                        n3 = i;
                        break;
                    }
                    byArray[n4++] = (byte)(0xF0 | n5 >> 18);
                    byArray[n4++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                } else if ((n5 & 0xF4000000) == 0) {
                    if (n4 + 5 > byArray.length) {
                        n3 = i;
                        break;
                    }
                    byArray[n4++] = (byte)(0xF8 | n5 >> 24);
                    byArray[n4++] = (byte)(0x80 | n5 >> 18 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                } else if ((n5 & Integer.MIN_VALUE) == 0) {
                    if (n4 + 6 > byArray.length) {
                        n3 = i;
                        break;
                    }
                    byArray[n4++] = (byte)(0xFC | n5 >> 30);
                    byArray[n4++] = (byte)(0x80 | n5 >> 24 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n5 >> 18 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                } else {
                    byArray[n4++] = 63;
                }
                this._surrogate = 0;
                if (n4 != byArray.length) continue;
                n3 = i + 1;
                break;
            }
            this._bytes.setCount(n4);
            this._bytes.writeTo((OutputStream)((Object)httpOutput));
            n2 -= n3;
            n += n3;
        }
    }
}

