/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SslConnectionFactory
extends AbstractConnectionFactory {
    private final SslContextFactory _sslContextFactory;
    private final String _nextProtocol;

    public SslConnectionFactory() {
        this(HttpVersion.HTTP_1_1.asString());
    }

    public SslConnectionFactory(@Name(value="next") String string) {
        this((SslContextFactory)null, string);
    }

    public SslConnectionFactory(@Name(value="sslContextFactory") SslContextFactory sslContextFactory, @Name(value="next") String string) {
        super("SSL");
        this._sslContextFactory = sslContextFactory == null ? new SslContextFactory() : sslContextFactory;
        this._nextProtocol = string;
        this.addBean(this._sslContextFactory);
    }

    public SslContextFactory getSslContextFactory() {
        return this._sslContextFactory;
    }

    protected void doStart() {
        super.doStart();
        SSLEngine sSLEngine = this._sslContextFactory.newSSLEngine();
        sSLEngine.setUseClientMode(false);
        SSLSession sSLSession = sSLEngine.getSession();
        if (sSLSession.getPacketBufferSize() > this.getInputBufferSize()) {
            this.setInputBufferSize(sSLSession.getPacketBufferSize());
        }
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        SSLEngine sSLEngine = this._sslContextFactory.newSSLEngine(endPoint.getRemoteAddress());
        sSLEngine.setUseClientMode(false);
        SslConnection sslConnection = this.newSslConnection(connector, endPoint, sSLEngine);
        sslConnection.setRenegotiationAllowed(this._sslContextFactory.isRenegotiationAllowed());
        this.configure((AbstractConnection)sslConnection, connector, endPoint);
        ConnectionFactory connectionFactory = connector.getConnectionFactory(this._nextProtocol);
        SslConnection.DecryptedEndPoint decryptedEndPoint = sslConnection.getDecryptedEndPoint();
        Connection connection = connectionFactory.newConnection(connector, (EndPoint)decryptedEndPoint);
        decryptedEndPoint.setConnection(connection);
        return sslConnection;
    }

    protected SslConnection newSslConnection(Connector connector, EndPoint endPoint, SSLEngine sSLEngine) {
        return new SslConnection(connector.getByteBufferPool(), connector.getExecutor(), endPoint, sSLEngine);
    }

    @Override
    public String toString() {
        return String.format("%s@%x{%s->%s}", this.getClass().getSimpleName(), this.hashCode(), this.getProtocol(), this._nextProtocol);
    }
}

