/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ShutdownThread;

public class ShutdownMonitor {
    private final Set<LifeCycle> _lifeCycles = new CopyOnWriteArraySet<LifeCycle>();
    private boolean DEBUG = System.getProperty("DEBUG") != null;
    private String host = System.getProperty("STOP.HOST", "127.0.0.1");
    private int port = Integer.parseInt(System.getProperty("STOP.PORT", "-1"));
    private String key = System.getProperty("STOP.KEY", null);
    private boolean exitVm = true;
    private ServerSocket serverSocket;
    private Thread thread;

    public static ShutdownMonitor getInstance() {
        return Holder.instance;
    }

    public static synchronized void register(LifeCycle ... lifeCycleArray) {
        ShutdownMonitor.getInstance()._lifeCycles.addAll(Arrays.asList(lifeCycleArray));
    }

    public static synchronized void deregister(LifeCycle lifeCycle) {
        ShutdownMonitor.getInstance()._lifeCycles.remove(lifeCycle);
    }

    public static synchronized boolean isRegistered(LifeCycle lifeCycle) {
        return ShutdownMonitor.getInstance()._lifeCycles.contains(lifeCycle);
    }

    private ShutdownMonitor() {
    }

    private void close(ServerSocket serverSocket) {
        if (serverSocket == null) {
            return;
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            this.debug(iOException);
        }
    }

    private void close(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            this.debug(iOException);
        }
    }

    private void shutdownInput(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.shutdownInput();
        }
        catch (IOException iOException) {
            this.debug(iOException);
        }
    }

    private void debug(String string, Object ... objectArray) {
        if (this.DEBUG) {
            System.err.printf("[ShutdownMonitor] " + string + "%n", objectArray);
        }
    }

    private void debug(Throwable throwable) {
        if (this.DEBUG) {
            throwable.printStackTrace(System.err);
        }
    }

    public String getKey() {
        return this.key;
    }

    public int getPort() {
        return this.port;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public boolean isExitVm() {
        return this.exitVm;
    }

    public void setDebug(boolean bl) {
        this.DEBUG = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExitVm(boolean bl) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                throw new IllegalStateException("ShutdownMonitorThread already started");
            }
            this.exitVm = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(String string) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                throw new IllegalStateException("ShutdownMonitorThread already started");
            }
            this.key = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int n) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                throw new IllegalStateException("ShutdownMonitorThread already started");
            }
            this.port = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        Thread thread = null;
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                if (this.DEBUG) {
                    System.err.printf("ShutdownMonitorThread already started", new Object[0]);
                }
                return;
            }
            this.thread = new Thread(new ShutdownMonitorRunnable());
            this.thread.setDaemon(true);
            this.thread.setName("ShutdownMonitor");
            thread = this.thread;
        }
        if (thread != null) {
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAlive() {
        boolean bl = false;
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            bl = this.thread != null && this.thread.isAlive();
        }
        return bl;
    }

    public String toString() {
        return String.format("%s[port=%d]", this.getClass().getName(), this.port);
    }

    private class ShutdownMonitorRunnable
    implements Runnable {
        public ShutdownMonitorRunnable() {
            this.startListenSocket();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ShutdownMonitor.this.serverSocket == null) {
                return;
            }
            while (ShutdownMonitor.this.serverSocket != null) {
                Socket socket = null;
                try {
                    socket = ShutdownMonitor.this.serverSocket.accept();
                    LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                    String string = lineNumberReader.readLine();
                    if (!ShutdownMonitor.this.key.equals(string)) {
                        System.err.println("Ignoring command with incorrect key");
                        continue;
                    }
                    OutputStream outputStream = socket.getOutputStream();
                    String string2 = lineNumberReader.readLine();
                    ShutdownMonitor.this.debug("command=%s", new Object[]{string2});
                    if ("stop".equalsIgnoreCase(string2)) {
                        ShutdownMonitor.this.debug("Issuing stop...", new Object[0]);
                        for (LifeCycle lifeCycle : ShutdownMonitor.this._lifeCycles) {
                            try {
                                if (lifeCycle.isStarted() && ShutdownThread.isRegistered((LifeCycle)lifeCycle)) {
                                    lifeCycle.stop();
                                }
                                if (!(lifeCycle instanceof Destroyable) || !ShutdownMonitor.this.exitVm) continue;
                                ((Destroyable)lifeCycle).destroy();
                            }
                            catch (Exception exception) {
                                ShutdownMonitor.this.debug(exception);
                            }
                        }
                        this.stopInput(socket);
                        ShutdownMonitor.this.debug("Informing client that we are stopped.", new Object[0]);
                        this.informClient(outputStream, "Stopped\r\n");
                        this.stopOutput(socket);
                        if (!ShutdownMonitor.this.exitVm) continue;
                        ShutdownMonitor.this.debug("Killing JVM", new Object[0]);
                        System.exit(0);
                        continue;
                    }
                    if ("forcestop".equalsIgnoreCase(string2)) {
                        ShutdownMonitor.this.debug("Issuing force stop...", new Object[0]);
                        this.stopLifeCycles(ShutdownMonitor.this.exitVm);
                        this.stopInput(socket);
                        ShutdownMonitor.this.debug("Informing client that we are stopped.", new Object[0]);
                        this.informClient(outputStream, "Stopped\r\n");
                        this.stopOutput(socket);
                        if (!ShutdownMonitor.this.exitVm) continue;
                        ShutdownMonitor.this.debug("Killing JVM", new Object[0]);
                        System.exit(0);
                        continue;
                    }
                    if ("stopexit".equalsIgnoreCase(string2)) {
                        ShutdownMonitor.this.debug("Issuing stop and exit...", new Object[0]);
                        this.stopLifeCycles(true);
                        this.stopInput(socket);
                        ShutdownMonitor.this.debug("Informing client that we are stopped.", new Object[0]);
                        this.informClient(outputStream, "Stopped\r\n");
                        this.stopOutput(socket);
                        ShutdownMonitor.this.debug("Killing JVM", new Object[0]);
                        System.exit(0);
                        continue;
                    }
                    if ("exit".equalsIgnoreCase(string2)) {
                        ShutdownMonitor.this.debug("Killing JVM", new Object[0]);
                        System.exit(0);
                        continue;
                    }
                    if (!"status".equalsIgnoreCase(string2)) continue;
                    this.informClient(outputStream, "OK\r\n");
                }
                catch (Exception exception) {
                    ShutdownMonitor.this.debug(exception);
                    System.err.println(exception.toString());
                }
                finally {
                    ShutdownMonitor.this.close(socket);
                    socket = null;
                }
            }
        }

        public void stopInput(Socket socket) {
            ShutdownMonitor.this.close(ShutdownMonitor.this.serverSocket);
            ShutdownMonitor.this.serverSocket = null;
            ShutdownMonitor.this.shutdownInput(socket);
        }

        public void stopOutput(Socket socket) {
            socket.shutdownOutput();
            ShutdownMonitor.this.close(socket);
            socket = null;
            ShutdownMonitor.this.debug("Shutting down monitor", new Object[0]);
            ShutdownMonitor.this.serverSocket = null;
        }

        public void informClient(OutputStream outputStream, String string) {
            outputStream.write(string.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
        }

        public void stopLifeCycles(boolean bl) {
            for (LifeCycle lifeCycle : ShutdownMonitor.this._lifeCycles) {
                try {
                    if (lifeCycle.isStarted()) {
                        lifeCycle.stop();
                    }
                    if (!(lifeCycle instanceof Destroyable) || !bl) continue;
                    ((Destroyable)lifeCycle).destroy();
                }
                catch (Exception exception) {
                    ShutdownMonitor.this.debug(exception);
                }
            }
        }

        public void startListenSocket() {
            block7: {
                if (ShutdownMonitor.this.port < 0) {
                    if (ShutdownMonitor.this.DEBUG) {
                        System.err.println("ShutdownMonitor not in use (port < 0): " + ShutdownMonitor.this.port);
                    }
                    return;
                }
                try {
                    ShutdownMonitor.this.serverSocket = new ServerSocket();
                    ShutdownMonitor.this.serverSocket.setReuseAddress(true);
                    ShutdownMonitor.this.serverSocket.bind(new InetSocketAddress(InetAddress.getByName(ShutdownMonitor.this.host), ShutdownMonitor.this.port), 1);
                    if (ShutdownMonitor.this.port == 0) {
                        ShutdownMonitor.this.port = ShutdownMonitor.this.serverSocket.getLocalPort();
                        System.out.printf("STOP.PORT=%d%n", ShutdownMonitor.this.port);
                    }
                    if (ShutdownMonitor.this.key != null) break block7;
                    ShutdownMonitor.this.key = Long.toString((long)(9.223372036854776E18 * Math.random() + (double)this.hashCode() + (double)System.currentTimeMillis()), 36);
                    System.out.printf("STOP.KEY=%s%n", ShutdownMonitor.this.key);
                }
                catch (Exception exception) {
                    try {
                        ShutdownMonitor.this.debug(exception);
                        System.err.println("Error binding monitor port " + ShutdownMonitor.this.port + ": " + exception.toString());
                        ShutdownMonitor.this.serverSocket = null;
                    }
                    catch (Throwable throwable) {
                        ShutdownMonitor.this.debug("STOP.PORT=%d", new Object[]{ShutdownMonitor.this.port});
                        ShutdownMonitor.this.debug("STOP.KEY=%s", new Object[]{ShutdownMonitor.this.key});
                        ShutdownMonitor.this.debug("%s", new Object[]{ShutdownMonitor.this.serverSocket});
                        throw throwable;
                    }
                    ShutdownMonitor.this.debug("STOP.PORT=%d", new Object[]{ShutdownMonitor.this.port});
                    ShutdownMonitor.this.debug("STOP.KEY=%s", new Object[]{ShutdownMonitor.this.key});
                    ShutdownMonitor.this.debug("%s", new Object[]{ShutdownMonitor.this.serverSocket});
                }
            }
            ShutdownMonitor.this.debug("STOP.PORT=%d", new Object[]{ShutdownMonitor.this.port});
            ShutdownMonitor.this.debug("STOP.KEY=%s", new Object[]{ShutdownMonitor.this.key});
            ShutdownMonitor.this.debug("%s", new Object[]{ShutdownMonitor.this.serverSocket});
        }
    }

    static class Holder {
        static ShutdownMonitor instance = new ShutdownMonitor();

        Holder() {
        }
    }
}

