/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject(value="HTTP connector using NIO ByteChannels and Selectors")
public class ServerConnector
extends AbstractNetworkConnector {
    private final SelectorManager _manager;
    private volatile ServerSocketChannel _acceptChannel;
    private volatile boolean _inheritChannel = false;
    private volatile int _localPort = -1;
    private volatile int _acceptQueueSize = 0;
    private volatile boolean _reuseAddress = true;
    private volatile int _lingerTime = -1;

    public ServerConnector(@Name(value="server") Server server) {
        this(server, null, null, null, -1, -1, new HttpConnectionFactory());
    }

    public ServerConnector(@Name(value="server") Server server, @Name(value="acceptors") int n, @Name(value="selectors") int n2) {
        this(server, null, null, null, n, n2, new HttpConnectionFactory());
    }

    public ServerConnector(@Name(value="server") Server server, @Name(value="acceptors") int n, @Name(value="selectors") int n2, ConnectionFactory ... connectionFactoryArray) {
        this(server, null, null, null, n, n2, connectionFactoryArray);
    }

    public ServerConnector(@Name(value="server") Server server, ConnectionFactory ... connectionFactoryArray) {
        this(server, null, null, null, -1, -1, connectionFactoryArray);
    }

    public ServerConnector(@Name(value="server") Server server, @Name(value="sslContextFactory") SslContextFactory sslContextFactory) {
        this(server, null, null, null, -1, -1, AbstractConnectionFactory.getFactories(sslContextFactory, new HttpConnectionFactory()));
    }

    public ServerConnector(@Name(value="server") Server server, @Name(value="acceptors") int n, @Name(value="selectors") int n2, @Name(value="sslContextFactory") SslContextFactory sslContextFactory) {
        this(server, null, null, null, n, n2, AbstractConnectionFactory.getFactories(sslContextFactory, new HttpConnectionFactory()));
    }

    public ServerConnector(@Name(value="server") Server server, @Name(value="sslContextFactory") SslContextFactory sslContextFactory, ConnectionFactory ... connectionFactoryArray) {
        this(server, null, null, null, -1, -1, AbstractConnectionFactory.getFactories(sslContextFactory, connectionFactoryArray));
    }

    public ServerConnector(@Name(value="server") Server server, @Name(value="executor") Executor executor, @Name(value="scheduler") Scheduler scheduler, @Name(value="bufferPool") ByteBufferPool byteBufferPool, @Name(value="acceptors") int n, @Name(value="selectors") int n2, ConnectionFactory ... connectionFactoryArray) {
        super(server, executor, scheduler, byteBufferPool, n, connectionFactoryArray);
        this._manager = this.newSelectorManager(this.getExecutor(), this.getScheduler(), n2 > 0 ? n2 : Math.max(1, Math.min(4, Runtime.getRuntime().availableProcessors() / 2)));
        this.addBean(this._manager, true);
        this.setSelectorPriorityDelta(-1);
        this.setAcceptorPriorityDelta(-2);
    }

    protected SelectorManager newSelectorManager(Executor executor, Scheduler scheduler, int n) {
        return new ServerConnectorManager(executor, scheduler, n);
    }

    @Override
    protected void doStart() {
        super.doStart();
        if (this.getAcceptors() == 0) {
            this._acceptChannel.configureBlocking(false);
            this._manager.acceptor(this._acceptChannel);
        }
    }

    @Override
    public boolean isOpen() {
        ServerSocketChannel serverSocketChannel = this._acceptChannel;
        return serverSocketChannel != null && serverSocketChannel.isOpen();
    }

    @Deprecated
    public int getSelectorPriorityDelta() {
        return this._manager.getSelectorPriorityDelta();
    }

    @Deprecated
    public void setSelectorPriorityDelta(int n) {
        this._manager.setSelectorPriorityDelta(n);
    }

    public boolean isInheritChannel() {
        return this._inheritChannel;
    }

    public void setInheritChannel(boolean bl) {
        this._inheritChannel = bl;
    }

    @Override
    public void open() {
        if (this._acceptChannel == null) {
            Object object;
            ServerSocketChannel serverSocketChannel = null;
            if (this.isInheritChannel()) {
                object = System.inheritedChannel();
                if (object instanceof ServerSocketChannel) {
                    serverSocketChannel = (ServerSocketChannel)object;
                } else {
                    this.LOG.warn("Unable to use System.inheritedChannel() [{}]. Trying a new ServerSocketChannel at {}:{}", new Object[]{object, this.getHost(), this.getPort()});
                }
            }
            if (serverSocketChannel == null) {
                serverSocketChannel = ServerSocketChannel.open();
                object = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
                serverSocketChannel.socket().setReuseAddress(this.getReuseAddress());
                serverSocketChannel.socket().bind((SocketAddress)object, this.getAcceptQueueSize());
                this._localPort = serverSocketChannel.socket().getLocalPort();
                if (this._localPort <= 0) {
                    throw new IOException("Server channel not bound");
                }
                this.addBean(serverSocketChannel);
            }
            serverSocketChannel.configureBlocking(true);
            this.addBean(serverSocketChannel);
            this._acceptChannel = serverSocketChannel;
        }
    }

    @Override
    public Future<Void> shutdown() {
        return super.shutdown();
    }

    @Override
    public void close() {
        ServerSocketChannel serverSocketChannel = this._acceptChannel;
        this._acceptChannel = null;
        if (serverSocketChannel != null) {
            this.removeBean(serverSocketChannel);
            if (serverSocketChannel.isOpen()) {
                try {
                    serverSocketChannel.close();
                }
                catch (IOException iOException) {
                    this.LOG.warn((Throwable)iOException);
                }
            }
        }
        this._localPort = -2;
    }

    @Override
    public void accept(int n) {
        ServerSocketChannel serverSocketChannel = this._acceptChannel;
        if (serverSocketChannel != null && serverSocketChannel.isOpen()) {
            SocketChannel socketChannel = serverSocketChannel.accept();
            this.accepted(socketChannel);
        }
    }

    private void accepted(SocketChannel socketChannel) {
        socketChannel.configureBlocking(false);
        Socket socket = socketChannel.socket();
        this.configure(socket);
        this._manager.accept(socketChannel);
    }

    protected void configure(Socket socket) {
        try {
            socket.setTcpNoDelay(true);
            if (this._lingerTime >= 0) {
                socket.setSoLinger(true, this._lingerTime / 1000);
            } else {
                socket.setSoLinger(false, 0);
            }
        }
        catch (SocketException socketException) {
            this.LOG.ignore((Throwable)socketException);
        }
    }

    public SelectorManager getSelectorManager() {
        return this._manager;
    }

    @Override
    public Object getTransport() {
        return this._acceptChannel;
    }

    @Override
    @ManagedAttribute(value="local port")
    public int getLocalPort() {
        return this._localPort;
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel socketChannel, ManagedSelector managedSelector, SelectionKey selectionKey) {
        return new SelectChannelEndPoint(socketChannel, managedSelector, selectionKey, this.getScheduler(), this.getIdleTimeout());
    }

    @ManagedAttribute(value="TCP/IP solinger time or -1 to disable")
    public int getSoLingerTime() {
        return this._lingerTime;
    }

    public void setSoLingerTime(int n) {
        this._lingerTime = n;
    }

    @ManagedAttribute(value="Accept Queue size")
    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    public void setAcceptQueueSize(int n) {
        this._acceptQueueSize = n;
    }

    public boolean getReuseAddress() {
        return this._reuseAddress;
    }

    public void setReuseAddress(boolean bl) {
        this._reuseAddress = bl;
    }

    protected class ServerConnectorManager
    extends SelectorManager {
        public ServerConnectorManager(Executor executor, Scheduler scheduler, int n) {
            super(executor, scheduler, n);
        }

        protected void accepted(SocketChannel socketChannel) {
            ServerConnector.this.accepted(socketChannel);
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel socketChannel, ManagedSelector managedSelector, SelectionKey selectionKey) {
            return ServerConnector.this.newEndPoint(socketChannel, managedSelector, selectionKey);
        }

        public Connection newConnection(SocketChannel socketChannel, EndPoint endPoint, Object object) {
            return ServerConnector.this.getDefaultConnectionFactory().newConnection(ServerConnector.this, endPoint);
        }

        protected void endPointOpened(EndPoint endPoint) {
            super.endPointOpened(endPoint);
            ServerConnector.this.onEndPointOpened(endPoint);
        }

        protected void endPointClosed(EndPoint endPoint) {
            ServerConnector.this.onEndPointClosed(endPoint);
            super.endPointClosed(endPoint);
        }
    }
}

