/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.ClassLoaderDump;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.Uptime;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.Graceful;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.util.thread.ThreadPool;

@ManagedObject(value="Jetty HTTP Servlet server")
public class Server
extends HandlerWrapper
implements Attributes {
    private static final Logger LOG = Log.getLogger(Server.class);
    private final AttributesMap _attributes = new AttributesMap();
    private final ThreadPool _threadPool;
    private final List<Connector> _connectors = new CopyOnWriteArrayList<Connector>();
    private SessionIdManager _sessionIdManager;
    private boolean _stopAtShutdown;
    private boolean _dumpAfterStart = false;
    private boolean _dumpBeforeStop = false;
    private RequestLog _requestLog;
    private final Locker _dateLocker = new Locker();
    private volatile DateField _dateField;

    public Server() {
        this((ThreadPool)null);
    }

    public Server(@Name(value="port") int n) {
        this((ThreadPool)null);
        ServerConnector serverConnector = new ServerConnector(this);
        serverConnector.setPort(n);
        this.setConnectors(new Connector[]{serverConnector});
    }

    public Server(@Name(value="address") InetSocketAddress inetSocketAddress) {
        this((ThreadPool)null);
        ServerConnector serverConnector = new ServerConnector(this);
        serverConnector.setHost(inetSocketAddress.getHostName());
        serverConnector.setPort(inetSocketAddress.getPort());
        this.setConnectors(new Connector[]{serverConnector});
    }

    public Server(@Name(value="threadpool") ThreadPool threadPool) {
        this._threadPool = threadPool != null ? threadPool : new QueuedThreadPool();
        this.addBean(this._threadPool);
        this.setServer(this);
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    public void setRequestLog(RequestLog requestLog) {
        this.updateBean(this._requestLog, requestLog);
        this._requestLog = requestLog;
    }

    @ManagedAttribute(value="version of this server")
    public static String getVersion() {
        return Jetty.VERSION;
    }

    public boolean getStopAtShutdown() {
        return this._stopAtShutdown;
    }

    public void setStopTimeout(long l) {
        super.setStopTimeout(l);
    }

    public void setStopAtShutdown(boolean bl) {
        if (bl) {
            if (!this._stopAtShutdown && this.isStarted()) {
                ShutdownThread.register((LifeCycle[])new LifeCycle[]{this});
            }
        } else {
            ShutdownThread.deregister((LifeCycle)this);
        }
        this._stopAtShutdown = bl;
    }

    @ManagedAttribute(value="connectors for this server", readonly=true)
    public Connector[] getConnectors() {
        ArrayList<Connector> arrayList = new ArrayList<Connector>(this._connectors);
        return arrayList.toArray(new Connector[arrayList.size()]);
    }

    public void addConnector(Connector connector) {
        if (connector.getServer() != this) {
            throw new IllegalArgumentException("Connector " + connector + " cannot be shared among server " + connector.getServer() + " and server " + this);
        }
        if (this._connectors.add(connector)) {
            this.addBean(connector);
        }
    }

    public void removeConnector(Connector connector) {
        if (this._connectors.remove(connector)) {
            this.removeBean(connector);
        }
    }

    public void setConnectors(Connector[] connectorArray) {
        if (connectorArray != null) {
            for (Connector connector : connectorArray) {
                if (connector.getServer() == this) continue;
                throw new IllegalArgumentException("Connector " + connector + " cannot be shared among server " + connector.getServer() + " and server " + this);
            }
        }
        Object[] objectArray = this.getConnectors();
        this.updateBeans(objectArray, connectorArray);
        this._connectors.removeAll(Arrays.asList(objectArray));
        if (connectorArray != null) {
            this._connectors.addAll(Arrays.asList(connectorArray));
        }
    }

    @ManagedAttribute(value="the server thread pool")
    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    @ManagedAttribute(value="dump state to stderr after start")
    public boolean isDumpAfterStart() {
        return this._dumpAfterStart;
    }

    public void setDumpAfterStart(boolean bl) {
        this._dumpAfterStart = bl;
    }

    @ManagedAttribute(value="dump state to stderr before stop")
    public boolean isDumpBeforeStop() {
        return this._dumpBeforeStop;
    }

    public void setDumpBeforeStop(boolean bl) {
        this._dumpBeforeStop = bl;
    }

    public HttpField getDateField() {
        long l = System.currentTimeMillis();
        long l2 = l / 1000L;
        DateField dateField = this._dateField;
        if (dateField == null || dateField._seconds != l2) {
            try (Locker.Lock lock = this._dateLocker.lock();){
                dateField = this._dateField;
                if (dateField == null || dateField._seconds != l2) {
                    PreEncodedHttpField preEncodedHttpField = new PreEncodedHttpField(HttpHeader.DATE, DateGenerator.formatDate((long)l));
                    this._dateField = new DateField(l2, (HttpField)preEncodedHttpField);
                    PreEncodedHttpField preEncodedHttpField2 = preEncodedHttpField;
                    return preEncodedHttpField2;
                }
            }
        }
        return dateField._dateField;
    }

    @Override
    protected void doStart() {
        if (this.getStopAtShutdown()) {
            ShutdownThread.register((LifeCycle[])new LifeCycle[]{this});
        }
        ShutdownMonitor.register(this);
        ShutdownMonitor.getInstance().start();
        LOG.info("jetty-" + Server.getVersion(), new Object[0]);
        HttpGenerator.setJettyVersion((String)HttpConfiguration.SERVER_VERSION);
        MultiException multiException = new MultiException();
        ThreadPool.SizedThreadPool sizedThreadPool = (ThreadPool.SizedThreadPool)this.getBean(ThreadPool.SizedThreadPool.class);
        int n = sizedThreadPool == null ? -1 : sizedThreadPool.getMaxThreads();
        int n2 = 0;
        int n3 = 0;
        if (multiException.size() == 0) {
            for (Connector object : this._connectors) {
                if (object instanceof AbstractConnector) {
                    n3 += ((AbstractConnector)object).getAcceptors();
                }
                if (!(object instanceof ServerConnector)) continue;
                n2 += ((ServerConnector)object).getSelectorManager().getSelectorCount();
            }
        }
        int n4 = 1 + n2 + n3;
        if (n > 0 && n4 > n) {
            throw new IllegalStateException(String.format("Insufficient threads: max=%d < needed(acceptors=%d + selectors=%d + request=1)", n, n3, n2));
        }
        try {
            super.doStart();
        }
        catch (Throwable throwable) {
            multiException.add(throwable);
        }
        for (Connector connector : this._connectors) {
            try {
                connector.start();
            }
            catch (Throwable throwable) {
                multiException.add(throwable);
            }
        }
        if (this.isDumpAfterStart()) {
            this.dumpStdErr();
        }
        multiException.ifExceptionThrow();
        LOG.info(String.format("Started @%dms", Uptime.getUptime()), new Object[0]);
    }

    protected void start(LifeCycle lifeCycle) {
        if (!(lifeCycle instanceof Connector)) {
            super.start(lifeCycle);
        }
    }

    @Override
    protected void doStop() {
        if (this.isDumpBeforeStop()) {
            this.dumpStdErr();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("doStop {}", new Object[]{this});
        }
        MultiException multiException = new MultiException();
        ArrayList<Future> arrayList = new ArrayList<Future>();
        Handler[] handlerArray = this._connectors.iterator();
        while (handlerArray.hasNext()) {
            Handler[] handlerArray2 = handlerArray.next();
            arrayList.add(handlerArray2.shutdown());
        }
        for (Handler object : handlerArray = this.getChildHandlersByClass(Graceful.class)) {
            arrayList.add(((Graceful)object).shutdown());
        }
        long l = this.getStopTimeout();
        if (l > 0L) {
            long l2 = System.currentTimeMillis() + l;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Graceful shutdown {} by ", new Object[]{this, new Date(l2)});
            }
            for (Future future : arrayList) {
                try {
                    if (future.isDone()) continue;
                    future.get(Math.max(1L, l2 - System.currentTimeMillis()), TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    multiException.add((Throwable)exception);
                }
            }
        }
        for (Future future : arrayList) {
            if (future.isDone()) continue;
            future.cancel(true);
        }
        for (Connector connector : this._connectors) {
            try {
                connector.stop();
            }
            catch (Throwable throwable) {
                multiException.add(throwable);
            }
        }
        try {
            super.doStop();
        }
        catch (Throwable throwable) {
            multiException.add(throwable);
        }
        if (this.getStopAtShutdown()) {
            ShutdownThread.deregister((LifeCycle)this);
        }
        ShutdownMonitor.deregister(this);
        multiException.ifExceptionThrow();
    }

    public void handle(HttpChannel httpChannel) {
        String string = httpChannel.getRequest().getPathInfo();
        Request request = httpChannel.getRequest();
        Response response = httpChannel.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} on {}{}", new Object[]{request.getDispatcherType(), httpChannel, "\n" + request.getMethod() + " " + request.getHttpURI() + "\n" + request.getHttpFields()});
        }
        if (HttpMethod.OPTIONS.is(request.getMethod()) || "*".equals(string)) {
            if (!HttpMethod.OPTIONS.is(request.getMethod())) {
                response.sendError(400);
            }
            this.handleOptions(request, response);
            if (!request.isHandled()) {
                this.handle(string, request, request, response);
            }
        } else {
            this.handle(string, request, request, response);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RESPONSE for {} h={}{}", new Object[]{string, request.isHandled(), "\n" + response.getStatus() + " " + response.getReason() + "\n" + response.getHttpFields()});
        }
    }

    protected void handleOptions(Request request, Response response) {
    }

    public void handleAsync(HttpChannel httpChannel) {
        HttpServletResponse httpServletResponse;
        String string;
        Object object;
        HttpChannelState httpChannelState = httpChannel.getRequest().getHttpChannelState();
        AsyncContextEvent asyncContextEvent = httpChannelState.getAsyncContextEvent();
        Request request = httpChannel.getRequest();
        String string2 = asyncContextEvent.getPath();
        if (string2 != null) {
            object = asyncContextEvent.getServletContext();
            string = request.getQueryString();
            request.setURIPathQuery(URIUtil.addPaths((String)(object == null ? null : object.getContextPath()), (String)string2));
            httpServletResponse = request.getHttpURI();
            request.setPathInfo(httpServletResponse.getDecodedPath());
            if (httpServletResponse.getQuery() != null) {
                request.mergeQueryParameters(string, httpServletResponse.getQuery(), true);
            }
        }
        object = request.getPathInfo();
        string = (HttpServletRequest)asyncContextEvent.getSuppliedRequest();
        httpServletResponse = (HttpServletResponse)asyncContextEvent.getSuppliedResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug(string.getDispatcherType() + " " + string.getMethod() + " " + (String)object + " on " + httpChannel, new Object[0]);
            this.handle((String)object, request, (HttpServletRequest)string, httpServletResponse);
            LOG.debug("RESPONSE " + (String)object + "  " + httpChannel.getResponse().getStatus(), new Object[0]);
        } else {
            this.handle((String)object, request, (HttpServletRequest)string, httpServletResponse);
        }
    }

    public void join() {
        this.getThreadPool().join();
    }

    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        this.updateBean(this._sessionIdManager, sessionIdManager);
        this._sessionIdManager = sessionIdManager;
    }

    public void clearAttributes() {
        Enumeration enumeration = this._attributes.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            this.removeBean(this._attributes.getAttribute((String)enumeration.nextElement()));
        }
        this._attributes.clearAttributes();
    }

    public Object getAttribute(String string) {
        return this._attributes.getAttribute(string);
    }

    public Enumeration<String> getAttributeNames() {
        return AttributesMap.getAttributeNamesCopy((Attributes)this._attributes);
    }

    public void removeAttribute(String string) {
        Object object = this._attributes.getAttribute(string);
        if (object != null) {
            this.removeBean(object);
        }
        this._attributes.removeAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        this.addBean(object);
        this._attributes.setAttribute(string, object);
    }

    public URI getURI() {
        NetworkConnector networkConnector = null;
        for (Connector object : this._connectors) {
            if (!(object instanceof NetworkConnector)) continue;
            networkConnector = (NetworkConnector)object;
            break;
        }
        if (networkConnector == null) {
            return null;
        }
        ContextHandler contextHandler = this.getChildHandlerByClass(ContextHandler.class);
        try {
            String string;
            String exception = networkConnector.getDefaultConnectionFactory().getProtocol().startsWith("SSL-") ? "https" : "http";
            String string2 = networkConnector.getHost();
            if (contextHandler != null && contextHandler.getVirtualHosts() != null && contextHandler.getVirtualHosts().length > 0) {
                string2 = contextHandler.getVirtualHosts()[0];
            }
            if (string2 == null) {
                string2 = InetAddress.getLocalHost().getHostAddress();
            }
            String string3 = string = contextHandler == null ? null : contextHandler.getContextPath();
            if (string == null) {
                string = "/";
            }
            return new URI(exception, null, string2, networkConnector.getLocalPort(), string, null, null);
        }
        catch (Exception exception) {
            LOG.warn((Throwable)exception);
            return null;
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    public void dump(Appendable appendable, String string) {
        this.dumpBeans(appendable, string, new Collection[]{Collections.singleton(new ClassLoaderDump(this.getClass().getClassLoader()))});
    }

    public static void main(String ... stringArray) {
        System.err.println(Server.getVersion());
    }

    private static class DateField {
        final long _seconds;
        final HttpField _dateField;

        public DateField(long l, HttpField httpField) {
            this._seconds = l;
            this._dateField = httpField;
        }
    }
}

