/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.ssl.X509;

public class SecureRequestCustomizer
implements HttpConfiguration.Customizer {
    private static final Logger LOG = Log.getLogger(SecureRequestCustomizer.class);
    public static final String CACHED_INFO_ATTR = CachedInfo.class.getName();
    private boolean _sniHostCheck;
    private long _stsMaxAge = -1L;
    private boolean _stsIncludeSubDomains;
    private HttpField _stsField;

    public SecureRequestCustomizer() {
        this(true);
    }

    public SecureRequestCustomizer(@Name(value="sniHostCheck") boolean bl) {
        this(bl, -1L, false);
    }

    public SecureRequestCustomizer(@Name(value="sniHostCheck") boolean bl, @Name(value="stsMaxAgeSeconds") long l, @Name(value="stsIncludeSubdomains") boolean bl2) {
        this._sniHostCheck = bl;
        this._stsMaxAge = l;
        this._stsIncludeSubDomains = bl2;
        this.formatSTS();
    }

    public boolean isSniHostCheck() {
        return this._sniHostCheck;
    }

    public void setSniHostCheck(boolean bl) {
        this._sniHostCheck = bl;
    }

    public long getStsMaxAge() {
        return this._stsMaxAge;
    }

    public void setStsMaxAge(long l) {
        this._stsMaxAge = l;
        this.formatSTS();
    }

    public void setStsMaxAge(long l, TimeUnit timeUnit) {
        this._stsMaxAge = timeUnit.toSeconds(l);
        this.formatSTS();
    }

    public boolean isStsIncludeSubDomains() {
        return this._stsIncludeSubDomains;
    }

    public void setStsIncludeSubDomains(boolean bl) {
        this._stsIncludeSubDomains = bl;
        this.formatSTS();
    }

    private void formatSTS() {
        this._stsField = this._stsMaxAge < 0L ? null : new PreEncodedHttpField(HttpHeader.STRICT_TRANSPORT_SECURITY, String.format("max-age=%d%s", this._stsMaxAge, this._stsIncludeSubDomains ? "; includeSubDomains" : ""));
    }

    @Override
    public void customize(Connector connector, HttpConfiguration httpConfiguration, Request request) {
        if (request.getHttpChannel().getEndPoint() instanceof SslConnection.DecryptedEndPoint) {
            if (request.getHttpURI().getScheme() == null) {
                request.setScheme(HttpScheme.HTTPS.asString());
            }
            SslConnection.DecryptedEndPoint decryptedEndPoint = (SslConnection.DecryptedEndPoint)request.getHttpChannel().getEndPoint();
            SslConnection sslConnection = decryptedEndPoint.getSslConnection();
            SSLEngine sSLEngine = sslConnection.getSSLEngine();
            this.customize(sSLEngine, request);
        }
        if (HttpScheme.HTTPS.is(request.getScheme())) {
            this.customizeSecure(request);
        }
    }

    protected void customizeSecure(Request request) {
        request.setSecure(true);
        if (this._stsField != null) {
            request.getResponse().getHttpFields().add(this._stsField);
        }
    }

    protected void customize(SSLEngine sSLEngine, Request request) {
        Object object;
        String string;
        request.setScheme(HttpScheme.HTTPS.asString());
        SSLSession sSLSession = sSLEngine.getSession();
        if (this._sniHostCheck) {
            string = request.getServerName();
            object = (X509)sSLSession.getValue("org.eclipse.jetty.util.ssl.snix509");
            if (object != null && !object.matches(string)) {
                LOG.warn("Host {} does not match SNI {}", new Object[]{string, object});
                throw new BadMessageException(400, "Host does not match SNI");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Host {} matched SNI {}", new Object[]{string, object});
            }
        }
        try {
            String string2;
            X509Certificate[] x509CertificateArray;
            string = sSLSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sSLSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                object = cachedInfo.getKeySize();
                x509CertificateArray = cachedInfo.getCerts();
                string2 = cachedInfo.getIdStr();
            } else {
                object = SslContextFactory.deduceKeyLength((String)string);
                x509CertificateArray = SslContextFactory.getCertChain((SSLSession)sSLSession);
                byte[] byArray = sSLSession.getId();
                string2 = TypeUtil.toHexString((byte[])byArray);
                cachedInfo = new CachedInfo((Integer)object, x509CertificateArray, string2);
                sSLSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (x509CertificateArray != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", x509CertificateArray);
            }
            request.setAttribute("javax.servlet.request.cipher_suite", string);
            request.setAttribute("javax.servlet.request.key_size", object);
            request.setAttribute("javax.servlet.request.ssl_session_id", string2);
        }
        catch (Exception exception) {
            LOG.warn("EXCEPTION ", (Throwable)exception);
        }
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    private static class CachedInfo {
        private final X509Certificate[] _certs;
        private final Integer _keySize;
        private final String _idStr;

        CachedInfo(Integer n, X509Certificate[] x509CertificateArray, String string) {
            this._keySize = n;
            this._certs = x509CertificateArray;
            this._idStr = string;
        }

        X509Certificate[] getCerts() {
            return this._certs;
        }

        Integer getKeySize() {
            return this._keySize;
        }

        String getIdStr() {
            return this._idStr;
        }
    }
}

