/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Formatter;
import java.util.Locale;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.HttpWriter;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ResponseWriter
extends PrintWriter {
    private static final Logger LOG = Log.getLogger(ResponseWriter.class);
    private static final String __lineSeparator = System.getProperty("line.separator");
    private static final String __trueln = "true" + __lineSeparator;
    private static final String __falseln = "false" + __lineSeparator;
    private final HttpWriter _httpWriter;
    private final Locale _locale;
    private final String _encoding;
    private IOException _ioException;
    private boolean _isClosed = false;
    private Formatter _formatter;

    public ResponseWriter(HttpWriter httpWriter, Locale locale, String string) {
        super((Writer)httpWriter, false);
        this._httpWriter = httpWriter;
        this._locale = locale;
        this._encoding = string;
    }

    public boolean isFor(Locale locale, String string) {
        if (this._locale == null && locale != null) {
            return false;
        }
        if (this._encoding == null && string != null) {
            return false;
        }
        return this._encoding.equalsIgnoreCase(string) && this._locale.equals(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reopen() {
        Object object = this.lock;
        synchronized (object) {
            this._isClosed = false;
            this.clearError();
            this.out = this._httpWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearError() {
        Object object = this.lock;
        synchronized (object) {
            this._ioException = null;
            super.clearError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkError() {
        Object object = this.lock;
        synchronized (object) {
            return this._ioException != null || super.checkError();
        }
    }

    private void setError(Throwable throwable) {
        super.setError();
        if (throwable instanceof IOException) {
            this._ioException = (IOException)throwable;
        } else {
            this._ioException = new IOException(String.valueOf(throwable));
            this._ioException.initCause(throwable);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(throwable);
        }
    }

    @Override
    protected void setError() {
        this.setError(new IOException());
    }

    private void isOpen() {
        if (this._ioException != null) {
            throw new RuntimeIOException((Throwable)this._ioException);
        }
        if (this._isClosed) {
            throw new EofException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.out.close();
                this._isClosed = true;
            }
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.write(n);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            LOG.debug((Throwable)interruptedIOException);
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.write(cArray, n, n2);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            LOG.debug((Throwable)interruptedIOException);
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
    }

    @Override
    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.write(string, n, n2);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            LOG.debug((Throwable)interruptedIOException);
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
    }

    @Override
    public void write(String string) {
        this.write(string, 0, string.length());
    }

    @Override
    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(int n) {
        this.write(String.valueOf(n));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] cArray) {
        this.write(cArray);
    }

    @Override
    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    @Override
    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.write(__lineSeparator);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            LOG.debug((Throwable)interruptedIOException);
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
    }

    @Override
    public void println(boolean bl) {
        this.println(bl ? __trueln : __falseln);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char c) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.write(c);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            LOG.debug((Throwable)interruptedIOException);
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
    }

    @Override
    public void println(int n) {
        this.println(String.valueOf(n));
    }

    @Override
    public void println(long l) {
        this.println(String.valueOf(l));
    }

    @Override
    public void println(float f) {
        this.println(String.valueOf(f));
    }

    @Override
    public void println(double d) {
        this.println(String.valueOf(d));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char[] cArray) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.write(cArray, 0, cArray.length);
                this.out.write(__lineSeparator);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            LOG.debug((Throwable)interruptedIOException);
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String string) {
        if (string == null) {
            string = "null";
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.write(string, 0, string.length());
                this.out.write(__lineSeparator);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            LOG.debug((Throwable)interruptedIOException);
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
    }

    @Override
    public void println(Object object) {
        this.println(String.valueOf(object));
    }

    @Override
    public PrintWriter printf(String string, Object ... objectArray) {
        return this.format(this._locale, string, objectArray);
    }

    @Override
    public PrintWriter printf(Locale locale, String string, Object ... objectArray) {
        return this.format(locale, string, objectArray);
    }

    @Override
    public PrintWriter format(String string, Object ... objectArray) {
        return this.format(this._locale, string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintWriter format(Locale locale, String string, Object ... objectArray) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                if (this._formatter == null || this._formatter.locale() != locale) {
                    this._formatter = new Formatter(this, locale);
                }
                this._formatter.format(locale, string, objectArray);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            LOG.debug((Throwable)interruptedIOException);
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.setError(iOException);
        }
        return this;
    }
}

