/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.channels.IllegalSelectorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.EncodingHttpWriter;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Iso88591HttpWriter;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ResponseWriter;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.Utf8HttpWriter;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Response
implements HttpServletResponse {
    private static final Logger LOG = Log.getLogger(Response.class);
    private static final String __COOKIE_DELIM = "\",;\\ \t";
    private static final String __01Jan1970_COOKIE = DateGenerator.formatCookieDate((long)0L).trim();
    private static final int __MIN_BUFFER_SIZE = 1;
    private static final HttpField __EXPIRES_01JAN1970 = new PreEncodedHttpField(HttpHeader.EXPIRES, DateGenerator.__01Jan1970);
    private static final ThreadLocal<StringBuilder> __cookieBuilder = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder(128);
        }
    };
    public static final String SET_INCLUDE_HEADER_PREFIX = "org.eclipse.jetty.server.include.";
    public static final String HTTP_ONLY_COMMENT = "__HTTP_ONLY__";
    private final HttpChannel _channel;
    private final HttpFields _fields = new HttpFields();
    private final AtomicInteger _include = new AtomicInteger();
    private final HttpOutput _out;
    private int _status = 200;
    private String _reason;
    private Locale _locale;
    private MimeTypes.Type _mimeType;
    private String _characterEncoding;
    private boolean _explicitEncoding;
    private String _contentType;
    private OutputType _outputType = OutputType.NONE;
    private ResponseWriter _writer;
    private long _contentLength = -1L;

    public Response(HttpChannel httpChannel, HttpOutput httpOutput) {
        this._channel = httpChannel;
        this._out = httpOutput;
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    protected void recycle() {
        this._status = 200;
        this._reason = null;
        this._locale = null;
        this._mimeType = null;
        this._characterEncoding = null;
        this._contentType = null;
        this._outputType = OutputType.NONE;
        this._contentLength = -1L;
        this._out.recycle();
        this._fields.clear();
        this._explicitEncoding = false;
    }

    public HttpOutput getHttpOutput() {
        return this._out;
    }

    public boolean isIncluding() {
        return this._include.get() > 0;
    }

    public void include() {
        this._include.incrementAndGet();
    }

    public void included() {
        this._include.decrementAndGet();
        if (this._outputType == OutputType.WRITER) {
            this._writer.reopen();
        }
        this._out.reopen();
    }

    public void addCookie(HttpCookie httpCookie) {
        this.addSetCookie(httpCookie.getName(), httpCookie.getValue(), httpCookie.getDomain(), httpCookie.getPath(), httpCookie.getMaxAge(), httpCookie.getComment(), httpCookie.isSecure(), httpCookie.isHttpOnly(), httpCookie.getVersion());
    }

    public void addCookie(Cookie cookie) {
        int n;
        String string = cookie.getComment();
        boolean bl = false;
        if (string != null && (n = string.indexOf(HTTP_ONLY_COMMENT)) >= 0) {
            bl = true;
            if ((string = string.replace(HTTP_ONLY_COMMENT, "").trim()).length() == 0) {
                string = null;
            }
        }
        this.addSetCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getMaxAge(), string, cookie.getSecure(), bl || cookie.isHttpOnly(), cookie.getVersion());
    }

    public void addSetCookie(String string, String string2, String string3, String string4, long l, String string5, boolean bl, boolean bl2, int n) {
        boolean bl3;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuilder stringBuilder = __cookieBuilder.get();
        stringBuilder.setLength(0);
        boolean bl4 = Response.isQuoteNeededForCookie(string);
        Response.quoteOnlyOrAppend(stringBuilder, string, bl4);
        stringBuilder.append('=');
        String string6 = stringBuilder.toString();
        boolean bl5 = Response.isQuoteNeededForCookie(string2);
        Response.quoteOnlyOrAppend(stringBuilder, string2, bl5);
        boolean bl6 = string3 != null && string3.length() > 0;
        boolean bl7 = bl6 && Response.isQuoteNeededForCookie(string3);
        boolean bl8 = string4 != null && string4.length() > 0;
        boolean bl9 = bl3 = bl8 && Response.isQuoteNeededForCookie(string4);
        if (n == 0 && (string5 != null || bl4 || bl5 || bl7 || bl3 || QuotedStringTokenizer.isQuoted((String)string) || QuotedStringTokenizer.isQuoted((String)string2) || QuotedStringTokenizer.isQuoted((String)string4) || QuotedStringTokenizer.isQuoted((String)string3))) {
            n = 1;
        }
        if (n == 1) {
            stringBuilder.append(";Version=1");
        } else if (n > 1) {
            stringBuilder.append(";Version=").append(n);
        }
        if (bl8) {
            stringBuilder.append(";Path=");
            Response.quoteOnlyOrAppend(stringBuilder, string4, bl3);
        }
        if (bl6) {
            stringBuilder.append(";Domain=");
            Response.quoteOnlyOrAppend(stringBuilder, string3, bl7);
        }
        if (l >= 0L) {
            stringBuilder.append(";Expires=");
            if (l == 0L) {
                stringBuilder.append(__01Jan1970_COOKIE);
            } else {
                DateGenerator.formatCookieDate((StringBuilder)stringBuilder, (long)(System.currentTimeMillis() + 1000L * l));
            }
            if (n >= 1) {
                stringBuilder.append(";Max-Age=");
                stringBuilder.append(l);
            }
        }
        if (bl) {
            stringBuilder.append(";Secure");
        }
        if (bl2) {
            stringBuilder.append(";HttpOnly");
        }
        if (string5 != null) {
            stringBuilder.append(";Comment=");
            Response.quoteOnlyOrAppend(stringBuilder, string5, Response.isQuoteNeededForCookie(string5));
        }
        Iterator iterator = this._fields.iterator();
        while (iterator.hasNext()) {
            String string7;
            HttpField httpField = (HttpField)iterator.next();
            if (httpField.getHeader() != HttpHeader.SET_COOKIE || (string7 = httpField.getValue()) == null || !string7.startsWith(string6) || (bl6 || string7.contains("Domain")) && (!bl6 || !string7.contains(string3)) || (bl8 || string7.contains("Path")) && (!bl8 || !string7.contains(string4))) continue;
            iterator.remove();
        }
        this._fields.add(HttpHeader.SET_COOKIE.toString(), stringBuilder.toString());
        this._fields.put(__EXPIRES_01JAN1970);
    }

    private static boolean isQuoteNeededForCookie(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (QuotedStringTokenizer.isQuoted((String)string)) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (__COOKIE_DELIM.indexOf(c) >= 0) {
                return true;
            }
            if (c >= ' ' && c < '\u007f') continue;
            throw new IllegalArgumentException("Illegal character in cookie value");
        }
        return false;
    }

    private static void quoteOnlyOrAppend(StringBuilder stringBuilder, String string, boolean bl) {
        if (bl) {
            QuotedStringTokenizer.quoteOnly((Appendable)stringBuilder, (String)string);
        } else {
            stringBuilder.append(string);
        }
    }

    public boolean containsHeader(String string) {
        return this._fields.containsKey(string);
    }

    public String encodeURL(String string) {
        int n;
        int n2;
        String string2;
        Request request = this._channel.getRequest();
        SessionManager sessionManager = request.getSessionManager();
        if (sessionManager == null) {
            return string;
        }
        HttpURI httpURI = null;
        if (sessionManager.isCheckingRemoteSessionIdEncoding() && URIUtil.hasScheme((String)string)) {
            httpURI = new HttpURI(string);
            string2 = httpURI.getPath();
            string2 = string2 == null ? "" : string2;
            n2 = httpURI.getPort();
            if (n2 < 0) {
                int n3 = n2 = HttpScheme.HTTPS.asString().equalsIgnoreCase(httpURI.getScheme()) ? 443 : 80;
            }
            if (!request.getServerName().equalsIgnoreCase(httpURI.getHost())) {
                return string;
            }
            if (request.getServerPort() != n2) {
                return string;
            }
            if (!string2.startsWith(request.getContextPath())) {
                return string;
            }
        }
        if ((string2 = sessionManager.getSessionIdPathParameterNamePrefix()) == null) {
            return string;
        }
        if (string == null) {
            return null;
        }
        if (sessionManager.isUsingCookies() && request.isRequestedSessionIdFromCookie() || !sessionManager.isUsingURLs()) {
            n2 = string.indexOf(string2);
            if (n2 != -1) {
                int n4 = string.indexOf("?", n2);
                if (n4 < 0) {
                    n4 = string.indexOf("#", n2);
                }
                if (n4 <= n2) {
                    return string.substring(0, n2);
                }
                return string.substring(0, n2) + string.substring(n4);
            }
            return string;
        }
        HttpSession httpSession = request.getSession(false);
        if (httpSession == null) {
            return string;
        }
        if (!sessionManager.isValid(httpSession)) {
            return string;
        }
        String string3 = sessionManager.getNodeId(httpSession);
        if (httpURI == null) {
            httpURI = new HttpURI(string);
        }
        if ((n = string.indexOf(string2)) != -1) {
            int n5 = string.indexOf("?", n);
            if (n5 < 0) {
                n5 = string.indexOf("#", n);
            }
            if (n5 <= n) {
                return string.substring(0, n + string2.length()) + string3;
            }
            return string.substring(0, n + string2.length()) + string3 + string.substring(n5);
        }
        int n6 = string.indexOf(63);
        if (n6 < 0) {
            n6 = string.indexOf(35);
        }
        if (n6 < 0) {
            return string + ((HttpScheme.HTTPS.is(httpURI.getScheme()) || HttpScheme.HTTP.is(httpURI.getScheme())) && httpURI.getPath() == null ? "/" : "") + string2 + string3;
        }
        return string.substring(0, n6) + ((HttpScheme.HTTPS.is(httpURI.getScheme()) || HttpScheme.HTTP.is(httpURI.getScheme())) && httpURI.getPath() == null ? "/" : "") + string2 + string3 + string.substring(n6);
    }

    public String encodeRedirectURL(String string) {
        return this.encodeURL(string);
    }

    @Deprecated
    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    @Deprecated
    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    public void sendError(int n) {
        this.sendError(n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendError(int n, String string) {
        block37: {
            block38: {
                if (this.isIncluding()) {
                    return;
                }
                if (this.isCommitted()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Aborting on sendError on committed response {} {}", new Object[]{n, string});
                    }
                    n = -1;
                }
                switch (n) {
                    case -1: {
                        this._channel.abort(new IOException());
                        return;
                    }
                    case 102: {
                        this.sendProcessing();
                        return;
                    }
                }
                if (this.isCommitted()) {
                    LOG.warn("Committed before " + n + " " + string, new Object[0]);
                }
                this.resetBuffer();
                this._characterEncoding = null;
                this.setHeader(HttpHeader.EXPIRES, null);
                this.setHeader(HttpHeader.LAST_MODIFIED, null);
                this.setHeader(HttpHeader.CACHE_CONTROL, null);
                this.setHeader(HttpHeader.CONTENT_TYPE, null);
                this.setHeader(HttpHeader.CONTENT_LENGTH, null);
                this._outputType = OutputType.NONE;
                this.setStatus(n);
                this._reason = string;
                Request request = this._channel.getRequest();
                Throwable throwable = (Throwable)request.getAttribute("javax.servlet.error.exception");
                if (string == null) {
                    String string2 = string = throwable == null ? HttpStatus.getMessage((int)n) : throwable.toString();
                }
                if (n == 204 || n == 304 || n == 206 || n < 200) break block38;
                ErrorHandler errorHandler = ErrorHandler.getErrorHandler(this._channel.getServer(), request.getContext() == null ? null : request.getContext().getContextHandler());
                if (errorHandler != null) {
                    request.setAttribute("javax.servlet.error.status_code", new Integer(n));
                    request.setAttribute("javax.servlet.error.message", string);
                    request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
                    request.setAttribute("javax.servlet.error.servlet_name", request.getServletName());
                    errorHandler.handle(null, this._channel.getRequest(), this._channel.getRequest(), this);
                    break block37;
                } else {
                    this.setHeader(HttpHeader.CACHE_CONTROL, "must-revalidate,no-cache,no-store");
                    this.setContentType(MimeTypes.Type.TEXT_HTML_8859_1.toString());
                    try (ByteArrayISO8859Writer byteArrayISO8859Writer = new ByteArrayISO8859Writer(2048);){
                        string = StringUtil.sanitizeXmlString((String)string);
                        String string3 = request.getRequestURI();
                        string3 = StringUtil.sanitizeXmlString((String)string3);
                        byteArrayISO8859Writer.write("<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=ISO-8859-1\"/>\n");
                        byteArrayISO8859Writer.write("<title>Error ");
                        byteArrayISO8859Writer.write(Integer.toString(n));
                        byteArrayISO8859Writer.write(' ');
                        if (string == null) {
                            byteArrayISO8859Writer.write(string);
                        }
                        byteArrayISO8859Writer.write("</title>\n</head>\n<body>\n<h2>HTTP ERROR: ");
                        byteArrayISO8859Writer.write(Integer.toString(n));
                        byteArrayISO8859Writer.write("</h2>\n<p>Problem accessing ");
                        byteArrayISO8859Writer.write(string3);
                        byteArrayISO8859Writer.write(". Reason:\n<pre>    ");
                        byteArrayISO8859Writer.write(string);
                        byteArrayISO8859Writer.write("</pre>");
                        byteArrayISO8859Writer.write("</p>\n<hr />");
                        this.getHttpChannel().getHttpConfiguration().writePoweredBy((Appendable)byteArrayISO8859Writer, null, "<hr/>");
                        byteArrayISO8859Writer.write("\n</body>\n</html>\n");
                        byteArrayISO8859Writer.flush();
                        this.setContentLength(byteArrayISO8859Writer.size());
                        try (ServletOutputStream servletOutputStream = this.getOutputStream();){
                            byteArrayISO8859Writer.writeTo((OutputStream)servletOutputStream);
                            byteArrayISO8859Writer.destroy();
                            break block37;
                        }
                    }
                }
            }
            if (n != 206) {
                this._channel.getRequest().getHttpFields().remove(HttpHeader.CONTENT_TYPE);
                this._channel.getRequest().getHttpFields().remove(HttpHeader.CONTENT_LENGTH);
                this._characterEncoding = null;
                this._mimeType = null;
            }
        }
        this.closeOutput();
    }

    public void sendProcessing() {
        if (this._channel.isExpecting102Processing() && !this.isCommitted()) {
            this._channel.sendResponse(HttpGenerator.PROGRESS_102_INFO, null, true);
        }
    }

    public void sendRedirect(int n, String string) {
        if (n < 300 || n >= 400) {
            throw new IllegalArgumentException("Not a 3xx redirect code");
        }
        if (this.isIncluding()) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (!URIUtil.hasScheme((String)string)) {
            StringBuilder stringBuilder = this._channel.getRequest().getRootURL();
            if (string.startsWith("/")) {
                string = URIUtil.canonicalPath((String)string);
            } else {
                String string2 = this._channel.getRequest().getRequestURI();
                String string3 = string2.endsWith("/") ? string2 : URIUtil.parentPath((String)string2);
                string = URIUtil.canonicalPath((String)URIUtil.addPaths((String)string3, (String)string));
                if (!string.startsWith("/")) {
                    stringBuilder.append('/');
                }
            }
            if (string == null) {
                throw new IllegalStateException("path cannot be above root");
            }
            stringBuilder.append(string);
            string = stringBuilder.toString();
        }
        this.resetBuffer();
        this.setHeader(HttpHeader.LOCATION, string);
        this.setStatus(n);
        this.closeOutput();
    }

    public void sendRedirect(String string) {
        this.sendRedirect(302, string);
    }

    public void setDateHeader(String string, long l) {
        if (!this.isIncluding()) {
            this._fields.putDateField(string, l);
        }
    }

    public void addDateHeader(String string, long l) {
        if (!this.isIncluding()) {
            this._fields.addDateField(string, l);
        }
    }

    public void setHeader(HttpHeader httpHeader, String string) {
        if (HttpHeader.CONTENT_TYPE == httpHeader) {
            this.setContentType(string);
        } else {
            if (this.isIncluding()) {
                return;
            }
            this._fields.put(httpHeader, string);
            if (HttpHeader.CONTENT_LENGTH == httpHeader) {
                this._contentLength = string == null ? -1L : Long.parseLong(string);
            }
        }
    }

    public void setHeader(String string, String string2) {
        if (HttpHeader.CONTENT_TYPE.is(string)) {
            this.setContentType(string2);
        } else {
            if (this.isIncluding()) {
                if (string.startsWith(SET_INCLUDE_HEADER_PREFIX)) {
                    string = string.substring(SET_INCLUDE_HEADER_PREFIX.length());
                } else {
                    return;
                }
            }
            this._fields.put(string, string2);
            if (HttpHeader.CONTENT_LENGTH.is(string)) {
                this._contentLength = string2 == null ? -1L : Long.parseLong(string2);
            }
        }
    }

    public Collection<String> getHeaderNames() {
        HttpFields httpFields = this._fields;
        return httpFields.getFieldNamesCollection();
    }

    public String getHeader(String string) {
        return this._fields.get(string);
    }

    public Collection<String> getHeaders(String string) {
        HttpFields httpFields = this._fields;
        List list = httpFields.getValuesList(string);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public void addHeader(String string, String string2) {
        if (this.isIncluding()) {
            if (string.startsWith(SET_INCLUDE_HEADER_PREFIX)) {
                string = string.substring(SET_INCLUDE_HEADER_PREFIX.length());
            } else {
                return;
            }
        }
        if (HttpHeader.CONTENT_TYPE.is(string)) {
            this.setContentType(string2);
            return;
        }
        if (HttpHeader.CONTENT_LENGTH.is(string)) {
            this.setHeader(string, string2);
            return;
        }
        this._fields.add(string, string2);
    }

    public void setIntHeader(String string, int n) {
        if (!this.isIncluding()) {
            this._fields.putLongField(string, (long)n);
            if (HttpHeader.CONTENT_LENGTH.is(string)) {
                this._contentLength = n;
            }
        }
    }

    public void addIntHeader(String string, int n) {
        if (!this.isIncluding()) {
            this._fields.add(string, Integer.toString(n));
            if (HttpHeader.CONTENT_LENGTH.is(string)) {
                this._contentLength = n;
            }
        }
    }

    public void setStatus(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (!this.isIncluding()) {
            this._status = n;
            this._reason = null;
        }
    }

    @Deprecated
    public void setStatus(int n, String string) {
        this.setStatusWithReason(n, string);
    }

    public void setStatusWithReason(int n, String string) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (!this.isIncluding()) {
            this._status = n;
            this._reason = string;
        }
    }

    public String getCharacterEncoding() {
        if (this._characterEncoding == null) {
            this._characterEncoding = "iso-8859-1";
        }
        return this._characterEncoding;
    }

    public String getContentType() {
        return this._contentType;
    }

    public ServletOutputStream getOutputStream() {
        if (this._outputType == OutputType.WRITER) {
            throw new IllegalStateException("WRITER");
        }
        this._outputType = OutputType.STREAM;
        return this._out;
    }

    public boolean isWriting() {
        return this._outputType == OutputType.WRITER;
    }

    public PrintWriter getWriter() {
        if (this._outputType == OutputType.STREAM) {
            throw new IllegalStateException("STREAM");
        }
        if (this._outputType == OutputType.NONE) {
            String string = this._characterEncoding;
            if (string == null) {
                if (this._mimeType != null && this._mimeType.isCharsetAssumed()) {
                    string = this._mimeType.getCharsetString();
                } else {
                    string = MimeTypes.inferCharsetFromContentType((String)this._contentType);
                    if (string == null) {
                        string = "iso-8859-1";
                    }
                    this.setCharacterEncoding(string, false);
                }
            }
            Locale locale = this.getLocale();
            if (this._writer != null && this._writer.isFor(locale, string)) {
                this._writer.reopen();
            } else {
                this._writer = "iso-8859-1".equalsIgnoreCase(string) ? new ResponseWriter(new Iso88591HttpWriter(this._out), locale, string) : ("utf-8".equalsIgnoreCase(string) ? new ResponseWriter(new Utf8HttpWriter(this._out), locale, string) : new ResponseWriter(new EncodingHttpWriter(this._out, string), locale, string));
            }
            this._outputType = OutputType.WRITER;
        }
        return this._writer;
    }

    public void setContentLength(int n) {
        if (this.isCommitted() || this.isIncluding()) {
            return;
        }
        this._contentLength = n;
        if (this._contentLength > 0L) {
            long l = this._out.getWritten();
            if (l > (long)n) {
                throw new IllegalArgumentException("setContentLength(" + n + ") when already written " + l);
            }
            this._fields.putLongField(HttpHeader.CONTENT_LENGTH, (long)n);
            if (this.isAllContentWritten(l)) {
                try {
                    this.closeOutput();
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException((Throwable)iOException);
                }
            }
        } else if (this._contentLength == 0L) {
            long l = this._out.getWritten();
            if (l > 0L) {
                throw new IllegalArgumentException("setContentLength(0) when already written " + l);
            }
            this._fields.put(HttpHeader.CONTENT_LENGTH, "0");
        } else {
            this._fields.remove(HttpHeader.CONTENT_LENGTH);
        }
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public boolean isAllContentWritten(long l) {
        return this._contentLength >= 0L && l >= this._contentLength;
    }

    public void closeOutput() {
        switch (this._outputType) {
            case WRITER: {
                this._writer.close();
                if (this._out.isClosed()) break;
                this._out.close();
                break;
            }
            case STREAM: {
                this.getOutputStream().close();
                break;
            }
            default: {
                this._out.close();
            }
        }
    }

    public long getLongContentLength() {
        return this._contentLength;
    }

    public void setLongContentLength(long l) {
        if (this.isCommitted() || this.isIncluding()) {
            return;
        }
        this._contentLength = l;
        this._fields.putLongField(HttpHeader.CONTENT_LENGTH.toString(), l);
    }

    public void setContentLengthLong(long l) {
        this.setLongContentLength(l);
    }

    public void setCharacterEncoding(String string) {
        this.setCharacterEncoding(string, true);
    }

    private void setCharacterEncoding(String string, boolean bl) {
        if (this.isIncluding() || this.isWriting()) {
            return;
        }
        if (this._outputType == OutputType.NONE && !this.isCommitted()) {
            if (string == null) {
                this._explicitEncoding = false;
                if (this._characterEncoding != null) {
                    this._characterEncoding = null;
                    if (this._mimeType != null) {
                        this._mimeType = this._mimeType.getBaseType();
                        this._contentType = this._mimeType.asString();
                        this._fields.put(this._mimeType.getContentTypeField());
                    } else if (this._contentType != null) {
                        this._contentType = MimeTypes.getContentTypeWithoutCharset((String)this._contentType);
                        this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
                    }
                }
            } else {
                this._explicitEncoding = bl;
                String string2 = this._characterEncoding = HttpGenerator.__STRICT ? string : StringUtil.normalizeCharset((String)string);
                if (this._mimeType != null) {
                    this._contentType = this._mimeType.getBaseType().asString() + ";charset=" + this._characterEncoding;
                    this._mimeType = (MimeTypes.Type)MimeTypes.CACHE.get(this._contentType);
                    if (this._mimeType == null || HttpGenerator.__STRICT) {
                        this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
                    } else {
                        this._fields.put(this._mimeType.getContentTypeField());
                    }
                } else if (this._contentType != null) {
                    this._contentType = MimeTypes.getContentTypeWithoutCharset((String)this._contentType) + ";charset=" + this._characterEncoding;
                    this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
                }
            }
        }
    }

    public void setContentType(String string) {
        if (this.isCommitted() || this.isIncluding()) {
            return;
        }
        if (string == null) {
            if (this.isWriting() && this._characterEncoding != null) {
                throw new IllegalSelectorException();
            }
            if (this._locale == null) {
                this._characterEncoding = null;
            }
            this._mimeType = null;
            this._contentType = null;
            this._fields.remove(HttpHeader.CONTENT_TYPE);
        } else {
            this._contentType = string;
            this._mimeType = (MimeTypes.Type)MimeTypes.CACHE.get(string);
            String string2 = this._mimeType != null && this._mimeType.getCharset() != null && !this._mimeType.isCharsetAssumed() ? this._mimeType.getCharsetString() : MimeTypes.getCharsetFromContentType((String)string);
            if (string2 == null) {
                if (this._characterEncoding != null) {
                    this._contentType = string + ";charset=" + this._characterEncoding;
                    this._mimeType = null;
                }
            } else if (this.isWriting() && !string2.equalsIgnoreCase(this._characterEncoding)) {
                this._mimeType = null;
                this._contentType = MimeTypes.getContentTypeWithoutCharset((String)this._contentType);
                if (this._characterEncoding != null) {
                    this._contentType = this._contentType + ";charset=" + this._characterEncoding;
                }
            } else {
                this._characterEncoding = string2;
                this._explicitEncoding = true;
            }
            if (HttpGenerator.__STRICT || this._mimeType == null) {
                this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
            } else {
                this._contentType = this._mimeType.asString();
                this._fields.put(this._mimeType.getContentTypeField());
            }
        }
    }

    public void setBufferSize(int n) {
        if (this.isCommitted() || this.getContentCount() > 0L) {
            throw new IllegalStateException("Committed or content written");
        }
        if (n <= 0) {
            n = 1;
        }
        this._out.setBufferSize(n);
    }

    public int getBufferSize() {
        return this._out.getBufferSize();
    }

    public void flushBuffer() {
        if (!this._out.isClosed()) {
            this._out.flush();
        }
    }

    public void reset() {
        this.resetForForward();
        this._status = 200;
        this._reason = null;
        this._contentLength = -1L;
        this._fields.clear();
        String string = this._channel.getRequest().getHeader(HttpHeader.CONNECTION.asString());
        if (string != null) {
            for (String string2 : StringUtil.csvSplit(null, (String)string, (int)0, (int)string.length())) {
                HttpHeaderValue httpHeaderValue = (HttpHeaderValue)HttpHeaderValue.CACHE.get(string2);
                if (httpHeaderValue == null) continue;
                switch (httpHeaderValue) {
                    case CLOSE: {
                        this._fields.put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.toString());
                        break;
                    }
                    case KEEP_ALIVE: {
                        if (!HttpVersion.HTTP_1_0.is(this._channel.getRequest().getProtocol())) break;
                        this._fields.put(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.toString());
                        break;
                    }
                    case TE: {
                        this._fields.put(HttpHeader.CONNECTION, HttpHeaderValue.TE.toString());
                        break;
                    }
                }
            }
        }
    }

    public void reset(boolean bl) {
        if (!bl) {
            this.reset();
        } else {
            ArrayList arrayList = new ArrayList(5);
            Enumeration enumeration = this._fields.getValues(HttpHeader.SET_COOKIE.asString());
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            this.reset();
            for (String string : arrayList) {
                this._fields.add(HttpHeader.SET_COOKIE, string);
            }
        }
    }

    public void resetForForward() {
        this.resetBuffer();
        this._outputType = OutputType.NONE;
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this._out.resetBuffer();
    }

    protected MetaData.Response newResponseMetaData() {
        return new MetaData.Response(this._channel.getRequest().getHttpVersion(), this.getStatus(), this.getReason(), this._fields, this.getLongContentLength());
    }

    public MetaData.Response getCommittedMetaData() {
        MetaData.Response response = this._channel.getCommittedMetaData();
        if (response == null) {
            return this.newResponseMetaData();
        }
        return response;
    }

    public boolean isCommitted() {
        return this._channel.isCommitted();
    }

    public void setLocale(Locale locale) {
        if (locale == null || this.isCommitted() || this.isIncluding()) {
            return;
        }
        this._locale = locale;
        this._fields.put(HttpHeader.CONTENT_LANGUAGE, locale.toString().replace('_', '-'));
        if (this._outputType != OutputType.NONE) {
            return;
        }
        if (this._channel.getRequest().getContext() == null) {
            return;
        }
        String string = this._channel.getRequest().getContext().getContextHandler().getLocaleEncoding(locale);
        if (string != null && string.length() > 0 && !this._explicitEncoding) {
            this.setCharacterEncoding(string, false);
        }
    }

    public Locale getLocale() {
        if (this._locale == null) {
            return Locale.getDefault();
        }
        return this._locale;
    }

    public int getStatus() {
        return this._status;
    }

    public String getReason() {
        return this._reason;
    }

    public HttpFields getHttpFields() {
        return this._fields;
    }

    public long getContentCount() {
        return this._out.getWritten();
    }

    public String toString() {
        return String.format("%s %d %s%n%s", this._channel.getRequest().getHttpVersion(), this._status, this._reason == null ? "" : this._reason, this._fields);
    }

    public void putHeaders(HttpContent httpContent, long l, boolean bl) {
        HttpField httpField;
        HttpField httpField2;
        HttpField httpField3 = httpContent.getLastModified();
        if (httpField3 != null) {
            this._fields.put(httpField3);
        }
        if (l == 0L) {
            this._fields.put(httpContent.getContentLength());
            this._contentLength = httpContent.getContentLengthValue();
        } else if (l > 0L) {
            this._fields.putLongField(HttpHeader.CONTENT_LENGTH, l);
            this._contentLength = l;
        }
        HttpField httpField4 = httpContent.getContentType();
        if (httpField4 != null) {
            this._fields.put(httpField4);
            this._contentType = httpField4.getValue();
            this._characterEncoding = httpContent.getCharacterEncoding();
            this._mimeType = httpContent.getMimeType();
        }
        if ((httpField2 = httpContent.getContentEncoding()) != null) {
            this._fields.put(httpField2);
        }
        if (bl && (httpField = httpContent.getETag()) != null) {
            this._fields.put(httpField);
        }
    }

    public static void putHeaders(HttpServletResponse httpServletResponse, HttpContent httpContent, long l, boolean bl) {
        String string;
        String string2;
        String string3;
        long l2 = httpContent.getResource().lastModified();
        if (l2 >= 0L) {
            httpServletResponse.setDateHeader(HttpHeader.LAST_MODIFIED.asString(), l2);
        }
        if (l == 0L) {
            l = httpContent.getContentLengthValue();
        }
        if (l >= 0L) {
            if (l < Integer.MAX_VALUE) {
                httpServletResponse.setContentLength((int)l);
            } else {
                httpServletResponse.setHeader(HttpHeader.CONTENT_LENGTH.asString(), Long.toString(l));
            }
        }
        if ((string3 = httpContent.getContentTypeValue()) != null && httpServletResponse.getContentType() == null) {
            httpServletResponse.setContentType(string3);
        }
        if ((string2 = httpContent.getContentEncodingValue()) != null) {
            httpServletResponse.setHeader(HttpHeader.CONTENT_ENCODING.asString(), string2);
        }
        if (bl && (string = httpContent.getETagValue()) != null) {
            httpServletResponse.setHeader(HttpHeader.ETAG.asString(), string);
        }
    }

    public static enum OutputType {
        NONE,
        STREAM,
        WRITER;

    }
}

