/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.ResourceHttpContent;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class ResourceContentFactory
implements HttpContent.Factory {
    private final ResourceFactory _factory;
    private final MimeTypes _mimeTypes;
    private final boolean _gzip;

    public ResourceContentFactory(ResourceFactory resourceFactory, MimeTypes mimeTypes, boolean bl) {
        this._factory = resourceFactory;
        this._mimeTypes = mimeTypes;
        this._gzip = bl;
    }

    public HttpContent getContent(String string, int n) {
        Resource resource = this._factory.getResource(string);
        HttpContent httpContent = this.load(string, resource, n);
        return httpContent;
    }

    private HttpContent load(String string, Resource resource, int n) {
        String string2;
        Resource resource2;
        if (resource == null || !resource.exists()) {
            return null;
        }
        if (resource.isDirectory()) {
            return new ResourceHttpContent(resource, this._mimeTypes.getMimeByExtension(resource.toString()), n);
        }
        String string3 = this._mimeTypes.getMimeByExtension(string);
        if (this._gzip && (resource2 = this._factory.getResource(string2 = string + ".gz")).exists() && resource2.lastModified() >= resource.lastModified() && resource2.length() < resource.length()) {
            return new ResourceHttpContent(resource, string3, n, (HttpContent)new ResourceHttpContent(resource2, this._mimeTypes.getMimeByExtension(string2), n));
        }
        return new ResourceHttpContent(resource, string3, n);
    }

    public String toString() {
        return "ResourceContentFactory[" + this._factory + "]@" + this.hashCode();
    }
}

