/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.GzipHttpContent;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.ResourceHttpContent;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class ResourceCache
implements HttpContent.Factory {
    private static final Logger LOG = Log.getLogger(ResourceCache.class);
    private final ConcurrentMap<String, CachedHttpContent> _cache;
    private final AtomicInteger _cachedSize;
    private final AtomicInteger _cachedFiles;
    private final ResourceFactory _factory;
    private final ResourceCache _parent;
    private final MimeTypes _mimeTypes;
    private final boolean _etags;
    private final boolean _gzip;
    private final boolean _useFileMappedBuffer;
    private int _maxCachedFileSize = 0x8000000;
    private int _maxCachedFiles = 2048;
    private int _maxCacheSize = 0x10000000;

    public ResourceCache(ResourceCache resourceCache, ResourceFactory resourceFactory, MimeTypes mimeTypes, boolean bl, boolean bl2, boolean bl3) {
        this._factory = resourceFactory;
        this._cache = new ConcurrentHashMap<String, CachedHttpContent>();
        this._cachedSize = new AtomicInteger();
        this._cachedFiles = new AtomicInteger();
        this._mimeTypes = mimeTypes;
        this._parent = resourceCache;
        this._useFileMappedBuffer = bl;
        this._etags = bl2;
        this._gzip = bl3;
    }

    public int getCachedSize() {
        return this._cachedSize.get();
    }

    public int getCachedFiles() {
        return this._cachedFiles.get();
    }

    public int getMaxCachedFileSize() {
        return this._maxCachedFileSize;
    }

    public void setMaxCachedFileSize(int n) {
        this._maxCachedFileSize = n;
        this.shrinkCache();
    }

    public int getMaxCacheSize() {
        return this._maxCacheSize;
    }

    public void setMaxCacheSize(int n) {
        this._maxCacheSize = n;
        this.shrinkCache();
    }

    public int getMaxCachedFiles() {
        return this._maxCachedFiles;
    }

    public void setMaxCachedFiles(int n) {
        this._maxCachedFiles = n;
        this.shrinkCache();
    }

    public boolean isUseFileMappedBuffer() {
        return this._useFileMappedBuffer;
    }

    public void flushCache() {
        if (this._cache != null) {
            while (this._cache.size() > 0) {
                for (String string : this._cache.keySet()) {
                    CachedHttpContent cachedHttpContent = (CachedHttpContent)this._cache.remove(string);
                    if (cachedHttpContent == null) continue;
                    cachedHttpContent.invalidate();
                }
            }
        }
    }

    @Deprecated
    public HttpContent lookup(String string) {
        return this.getContent(string, this._maxCachedFileSize);
    }

    public HttpContent getContent(String string, int n) {
        HttpContent httpContent;
        CachedHttpContent cachedHttpContent = (CachedHttpContent)this._cache.get(string);
        if (cachedHttpContent != null && cachedHttpContent.isValid()) {
            return cachedHttpContent;
        }
        Resource resource = this._factory.getResource(string);
        HttpContent httpContent2 = this.load(string, resource, n);
        if (httpContent2 != null) {
            return httpContent2;
        }
        if (this._parent != null && (httpContent = this._parent.getContent(string, n)) != null) {
            return httpContent;
        }
        return null;
    }

    protected boolean isCacheable(Resource resource) {
        if (this._maxCachedFiles <= 0) {
            return false;
        }
        long l = resource.length();
        return l > 0L && (this._useFileMappedBuffer || l < (long)this._maxCachedFileSize && l < (long)this._maxCacheSize);
    }

    private HttpContent load(String string, Resource resource, int n) {
        if (resource == null || !resource.exists()) {
            return null;
        }
        if (resource.isDirectory()) {
            return new ResourceHttpContent(resource, this._mimeTypes.getMimeByExtension(resource.toString()), this.getMaxCachedFileSize());
        }
        if (this.isCacheable(resource)) {
            Object object;
            Object object2 = null;
            if (this._gzip) {
                object = string + ".gz";
                CachedHttpContent cachedHttpContent = (CachedHttpContent)this._cache.get(object);
                if (cachedHttpContent == null || !cachedHttpContent.isValid()) {
                    CachedHttpContent cachedHttpContent2;
                    cachedHttpContent = null;
                    Resource resource2 = this._factory.getResource((String)object);
                    if (resource2.exists() && resource2.lastModified() >= resource.lastModified() && resource2.length() < resource.length() && (cachedHttpContent2 = this._cache.putIfAbsent((String)object, cachedHttpContent = new CachedHttpContent((String)object, resource2, null))) != null) {
                        cachedHttpContent.invalidate();
                        cachedHttpContent = cachedHttpContent2;
                    }
                }
                object2 = new CachedHttpContent(string, resource, cachedHttpContent);
            } else {
                object2 = new CachedHttpContent(string, resource, null);
            }
            object = this._cache.putIfAbsent(string, (CachedHttpContent)object2);
            if (object != null) {
                ((CachedHttpContent)object2).invalidate();
                object2 = object;
            }
            return object2;
        }
        String string2 = this._mimeTypes.getMimeByExtension(string);
        if (this._gzip) {
            String string3 = string + ".gz";
            CachedHttpContent cachedHttpContent = (CachedHttpContent)this._cache.get(string3);
            if (cachedHttpContent != null && cachedHttpContent.isValid() && cachedHttpContent.getResource().lastModified() >= resource.lastModified()) {
                return new ResourceHttpContent(resource, string2, n, (HttpContent)cachedHttpContent);
            }
            Resource resource3 = this._factory.getResource(string3);
            if (resource3.exists() && resource3.lastModified() >= resource.lastModified() && resource3.length() < resource.length()) {
                return new ResourceHttpContent(resource, string2, n, (HttpContent)new ResourceHttpContent(resource3, this._mimeTypes.getMimeByExtension(string3), n));
            }
        }
        return new ResourceHttpContent(resource, string2, n);
    }

    private void shrinkCache() {
        block0: while (this._cache.size() > 0 && (this._cachedFiles.get() > this._maxCachedFiles || this._cachedSize.get() > this._maxCacheSize)) {
            TreeSet<CachedHttpContent> treeSet = new TreeSet<CachedHttpContent>(new Comparator<CachedHttpContent>(){

                @Override
                public int compare(CachedHttpContent cachedHttpContent, CachedHttpContent cachedHttpContent2) {
                    if (cachedHttpContent._lastAccessed < cachedHttpContent2._lastAccessed) {
                        return -1;
                    }
                    if (cachedHttpContent._lastAccessed > cachedHttpContent2._lastAccessed) {
                        return 1;
                    }
                    if (cachedHttpContent._contentLengthValue < cachedHttpContent2._contentLengthValue) {
                        return -1;
                    }
                    return cachedHttpContent._key.compareTo(cachedHttpContent2._key);
                }
            });
            for (CachedHttpContent cachedHttpContent : this._cache.values()) {
                treeSet.add(cachedHttpContent);
            }
            for (CachedHttpContent cachedHttpContent : treeSet) {
                if (this._cachedFiles.get() <= this._maxCachedFiles && this._cachedSize.get() <= this._maxCacheSize) continue block0;
                if (cachedHttpContent != this._cache.remove(cachedHttpContent.getKey())) continue;
                cachedHttpContent.invalidate();
            }
        }
    }

    protected ByteBuffer getIndirectBuffer(Resource resource) {
        try {
            return BufferUtil.toBuffer((Resource)resource, (boolean)true);
        }
        catch (IOException | IllegalArgumentException exception) {
            LOG.warn((Throwable)exception);
            return null;
        }
    }

    protected ByteBuffer getDirectBuffer(Resource resource) {
        try {
            if (this._useFileMappedBuffer && resource.getFile() != null && resource.length() < Integer.MAX_VALUE) {
                return BufferUtil.toMappedBuffer((File)resource.getFile());
            }
            return BufferUtil.toBuffer((Resource)resource, (boolean)true);
        }
        catch (IOException | IllegalArgumentException exception) {
            LOG.warn((Throwable)exception);
            return null;
        }
    }

    public String toString() {
        return "ResourceCache[" + this._parent + "," + this._factory + "]@" + this.hashCode();
    }

    public class CachedGzipHttpContent
    extends GzipHttpContent {
        private final CachedHttpContent _content;
        private final CachedHttpContent _contentGz;
        private final HttpField _etag;

        CachedGzipHttpContent(CachedHttpContent cachedHttpContent, CachedHttpContent cachedHttpContent2) {
            super((HttpContent)cachedHttpContent, (HttpContent)cachedHttpContent2);
            this._content = cachedHttpContent;
            this._contentGz = cachedHttpContent2;
            this._etag = ResourceCache.this._etags ? new PreEncodedHttpField(HttpHeader.ETAG, this._content.getResource().getWeakETag("--gzip")) : null;
        }

        public boolean isValid() {
            return this._contentGz.isValid() && this._content.isValid() && this._content.getResource().lastModified() <= this._contentGz.getResource().lastModified();
        }

        public HttpField getETag() {
            if (this._etag != null) {
                return this._etag;
            }
            return super.getETag();
        }

        public String getETagValue() {
            if (this._etag != null) {
                return this._etag.getValue();
            }
            return super.getETagValue();
        }

        public String toString() {
            return "Cached" + super.toString();
        }
    }

    public class CachedHttpContent
    implements HttpContent {
        final String _key;
        final Resource _resource;
        final int _contentLengthValue;
        final HttpField _contentType;
        final String _characterEncoding;
        final MimeTypes.Type _mimeType;
        final HttpField _contentLength;
        final HttpField _lastModified;
        final long _lastModifiedValue;
        final HttpField _etag;
        final CachedGzipHttpContent _gzipped;
        volatile long _lastAccessed;
        AtomicReference<ByteBuffer> _indirectBuffer = new AtomicReference();
        AtomicReference<ByteBuffer> _directBuffer = new AtomicReference();

        CachedHttpContent(String string, Resource resource, CachedHttpContent cachedHttpContent) {
            this._key = string;
            this._resource = resource;
            String string2 = ResourceCache.this._mimeTypes.getMimeByExtension(this._resource.toString());
            this._contentType = string2 == null ? null : new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, string2);
            this._characterEncoding = this._contentType == null ? null : MimeTypes.getCharsetFromContentType((String)string2);
            this._mimeType = this._contentType == null ? null : (MimeTypes.Type)MimeTypes.CACHE.get(MimeTypes.getContentTypeWithoutCharset((String)string2));
            boolean bl = resource.exists();
            this._lastModifiedValue = bl ? resource.lastModified() : -1L;
            this._lastModified = this._lastModifiedValue == -1L ? null : new PreEncodedHttpField(HttpHeader.LAST_MODIFIED, DateGenerator.formatDate((long)this._lastModifiedValue));
            this._contentLengthValue = bl ? (int)resource.length() : 0;
            this._contentLength = new PreEncodedHttpField(HttpHeader.CONTENT_LENGTH, Long.toString(this._contentLengthValue));
            if (ResourceCache.this._cachedFiles.incrementAndGet() > ResourceCache.this._maxCachedFiles) {
                ResourceCache.this.shrinkCache();
            }
            this._lastAccessed = System.currentTimeMillis();
            this._etag = ResourceCache.this._etags ? new PreEncodedHttpField(HttpHeader.ETAG, resource.getWeakETag()) : null;
            this._gzipped = cachedHttpContent == null ? null : new CachedGzipHttpContent(this, cachedHttpContent);
        }

        public String getKey() {
            return this._key;
        }

        public boolean isCached() {
            return this._key != null;
        }

        public boolean isMiss() {
            return false;
        }

        public Resource getResource() {
            return this._resource;
        }

        public HttpField getETag() {
            return this._etag;
        }

        public String getETagValue() {
            return this._etag.getValue();
        }

        boolean isValid() {
            if (this._lastModifiedValue == this._resource.lastModified() && (long)this._contentLengthValue == this._resource.length()) {
                this._lastAccessed = System.currentTimeMillis();
                return true;
            }
            if (this == ResourceCache.this._cache.remove(this._key)) {
                this.invalidate();
            }
            return false;
        }

        protected void invalidate() {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = this._indirectBuffer.get();
            if (byteBuffer2 != null && this._indirectBuffer.compareAndSet(byteBuffer2, null)) {
                ResourceCache.this._cachedSize.addAndGet(-BufferUtil.length((ByteBuffer)byteBuffer2));
            }
            if ((byteBuffer = this._directBuffer.get()) != null && !BufferUtil.isMappedBuffer((ByteBuffer)byteBuffer) && this._directBuffer.compareAndSet(byteBuffer, null)) {
                ResourceCache.this._cachedSize.addAndGet(-BufferUtil.length((ByteBuffer)byteBuffer));
            }
            ResourceCache.this._cachedFiles.decrementAndGet();
            this._resource.close();
        }

        public HttpField getLastModified() {
            return this._lastModified;
        }

        public String getLastModifiedValue() {
            return this._lastModified == null ? null : this._lastModified.getValue();
        }

        public HttpField getContentType() {
            return this._contentType;
        }

        public String getContentTypeValue() {
            return this._contentType == null ? null : this._contentType.getValue();
        }

        public HttpField getContentEncoding() {
            return null;
        }

        public String getContentEncodingValue() {
            return null;
        }

        public String getCharacterEncoding() {
            return this._characterEncoding;
        }

        public MimeTypes.Type getMimeType() {
            return this._mimeType;
        }

        public void release() {
        }

        public ByteBuffer getIndirectBuffer() {
            ByteBuffer byteBuffer = this._indirectBuffer.get();
            if (byteBuffer == null) {
                ByteBuffer byteBuffer2 = ResourceCache.this.getIndirectBuffer(this._resource);
                if (byteBuffer2 == null) {
                    LOG.warn("Could not load " + this, new Object[0]);
                } else if (this._indirectBuffer.compareAndSet(null, byteBuffer2)) {
                    byteBuffer = byteBuffer2;
                    if (ResourceCache.this._cachedSize.addAndGet(BufferUtil.length((ByteBuffer)byteBuffer)) > ResourceCache.this._maxCacheSize) {
                        ResourceCache.this.shrinkCache();
                    }
                } else {
                    byteBuffer = this._indirectBuffer.get();
                }
            }
            if (byteBuffer == null) {
                return null;
            }
            return byteBuffer.slice();
        }

        public ByteBuffer getDirectBuffer() {
            ByteBuffer byteBuffer = this._directBuffer.get();
            if (byteBuffer == null) {
                ByteBuffer byteBuffer2 = ResourceCache.this.getDirectBuffer(this._resource);
                if (byteBuffer2 == null) {
                    LOG.warn("Could not load " + this, new Object[0]);
                } else if (this._directBuffer.compareAndSet(null, byteBuffer2)) {
                    byteBuffer = byteBuffer2;
                    if (!BufferUtil.isMappedBuffer((ByteBuffer)byteBuffer) && ResourceCache.this._cachedSize.addAndGet(BufferUtil.length((ByteBuffer)byteBuffer)) > ResourceCache.this._maxCacheSize) {
                        ResourceCache.this.shrinkCache();
                    }
                } else {
                    byteBuffer = this._directBuffer.get();
                }
            }
            if (byteBuffer == null) {
                return null;
            }
            return byteBuffer.asReadOnlyBuffer();
        }

        public HttpField getContentLength() {
            return this._contentLength;
        }

        public long getContentLengthValue() {
            return this._contentLengthValue;
        }

        public InputStream getInputStream() {
            ByteBuffer byteBuffer = this.getIndirectBuffer();
            if (byteBuffer != null && byteBuffer.hasArray()) {
                return new ByteArrayInputStream(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            }
            return this._resource.getInputStream();
        }

        public ReadableByteChannel getReadableByteChannel() {
            return this._resource.getReadableByteChannel();
        }

        public String toString() {
            return String.format("CachedContent@%x{r=%s,e=%b,lm=%s,ct=%s,gz=%b}", this.hashCode(), this._resource, this._resource.exists(), this._lastModified, this._contentType, this._gzipped != null);
        }

        public HttpContent getGzipContent() {
            return this._gzipped != null && this._gzipped.isValid() ? this._gzipped : null;
        }
    }
}

