/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.CookieCutter;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.PushBuilder;
import org.eclipse.jetty.server.PushBuilderImpl;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.MultiPartInputStreamParser;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Request
implements HttpServletRequest {
    public static final String __MULTIPART_CONFIG_ELEMENT = "org.eclipse.jetty.multipartConfig";
    public static final String __MULTIPART_INPUT_STREAM = "org.eclipse.jetty.multiPartInputStream";
    public static final String __MULTIPART_CONTEXT = "org.eclipse.jetty.multiPartContext";
    private static final Logger LOG = Log.getLogger(Request.class);
    private static final Collection<Locale> __defaultLocale = Collections.singleton(Locale.getDefault());
    private static final int __NONE = 0;
    private static final int _STREAM = 1;
    private static final int __READER = 2;
    private static final MultiMap<String> NO_PARAMS = new MultiMap();
    private final HttpChannel _channel;
    private final List<ServletRequestAttributeListener> _requestAttributeListeners = new ArrayList<ServletRequestAttributeListener>();
    private final HttpInput _input;
    private MetaData.Request _metadata;
    private String _contextPath;
    private String _servletPath;
    private String _pathInfo;
    private boolean _secure;
    private boolean _asyncSupported = true;
    private boolean _newContext;
    private boolean _cookiesExtracted = false;
    private boolean _handled = false;
    private boolean _paramsExtracted;
    private boolean _requestedSessionIdFromCookie = false;
    private Attributes _attributes;
    private Authentication _authentication;
    private String _characterEncoding;
    private ContextHandler.Context _context;
    private CookieCutter _cookies;
    private DispatcherType _dispatcherType;
    private int _inputState = 0;
    private MultiMap<String> _queryParameters;
    private MultiMap<String> _contentParameters;
    private MultiMap<String> _parameters;
    private String _queryEncoding;
    private BufferedReader _reader;
    private String _readerEncoding;
    private InetSocketAddress _remote;
    private String _requestedSessionId;
    private Map<Object, HttpSession> _savedNewSessions;
    private UserIdentity.Scope _scope;
    private HttpSession _session;
    private SessionManager _sessionManager;
    private long _timeStamp;
    private MultiPartInputStreamParser _multiPartInputStream;
    private AsyncContextState _async;

    public static Request getBaseRequest(ServletRequest servletRequest) {
        if (servletRequest instanceof Request) {
            return (Request)servletRequest;
        }
        Object object = servletRequest.getAttribute(HttpChannel.class.getName());
        if (object instanceof HttpChannel) {
            return ((HttpChannel)object).getRequest();
        }
        while (servletRequest instanceof ServletRequestWrapper) {
            servletRequest = ((ServletRequestWrapper)servletRequest).getRequest();
        }
        if (servletRequest instanceof Request) {
            return (Request)servletRequest;
        }
        return null;
    }

    public Request(HttpChannel httpChannel, HttpInput httpInput) {
        this._channel = httpChannel;
        this._input = httpInput;
    }

    public HttpFields getHttpFields() {
        return this._metadata.getFields();
    }

    public HttpInput getHttpInput() {
        return this._input;
    }

    public boolean isPush() {
        return Boolean.TRUE.equals(this.getAttribute("org.eclipse.jetty.pushed"));
    }

    public boolean isPushSupported() {
        return this.getHttpChannel().getHttpTransport().isPushSupported();
    }

    public PushBuilder getPushBuilder() {
        Object object2;
        if (!this.isPushSupported()) {
            throw new IllegalStateException();
        }
        HttpFields httpFields = new HttpFields(this.getHttpFields().size() + 5);
        boolean bl = false;
        UserIdentity userIdentity = null;
        Authentication authentication = null;
        block7: for (Object object2 : this.getHttpFields()) {
            HttpHeader httpHeader = object2.getHeader();
            if (httpHeader == null) {
                httpFields.add((HttpField)object2);
                continue;
            }
            switch (httpHeader) {
                case IF_MATCH: 
                case IF_RANGE: 
                case IF_UNMODIFIED_SINCE: 
                case RANGE: 
                case EXPECT: 
                case REFERER: 
                case COOKIE: {
                    continue block7;
                }
                case AUTHORIZATION: {
                    userIdentity = this.getUserIdentity();
                    authentication = this._authentication;
                    continue block7;
                }
                case IF_NONE_MATCH: 
                case IF_MODIFIED_SINCE: {
                    bl = true;
                    continue block7;
                }
            }
            httpFields.add((HttpField)object2);
        }
        Object object3 = null;
        try {
            object2 = this.getSession();
            if (object2 != null) {
                object2.getLastAccessedTime();
                object3 = object2.getId();
            } else {
                object3 = this.getRequestedSessionId();
            }
        }
        catch (IllegalStateException illegalStateException) {
            object3 = this.getRequestedSessionId();
        }
        object2 = new PushBuilderImpl(this, httpFields, this.getMethod(), this.getQueryString(), (String)object3, bl);
        object2.addHeader("referer", this.getRequestURL().toString());
        return object2;
    }

    public void addEventListener(EventListener eventListener) {
        if (eventListener instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners.add((ServletRequestAttributeListener)eventListener);
        }
        if (eventListener instanceof AsyncListener) {
            throw new IllegalArgumentException(eventListener.getClass().toString());
        }
    }

    public void extractParameters() {
        if (this._paramsExtracted) {
            return;
        }
        this._paramsExtracted = true;
        if (this._queryParameters == null) {
            this.extractQueryParameters();
        }
        if (this._contentParameters == null) {
            this.extractContentParameters();
        }
        this.restoreParameters();
    }

    private void extractQueryParameters() {
        if (this._metadata.getURI() == null || !this._metadata.getURI().hasQuery()) {
            this._queryParameters = NO_PARAMS;
        } else {
            this._queryParameters = new MultiMap();
            if (this._queryEncoding == null) {
                this._metadata.getURI().decodeQueryTo(this._queryParameters);
            } else {
                try {
                    this._metadata.getURI().decodeQueryTo(this._queryParameters, this._queryEncoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn((Throwable)unsupportedEncodingException);
                    }
                    LOG.warn(unsupportedEncodingException.toString(), new Object[0]);
                }
            }
        }
    }

    private void extractContentParameters() {
        String string = this.getContentType();
        if (string == null || string.isEmpty()) {
            this._contentParameters = NO_PARAMS;
        } else {
            this._contentParameters = new MultiMap();
            string = HttpFields.valueParameters((String)string, null);
            int n = this.getContentLength();
            if (n != 0) {
                if (MimeTypes.Type.FORM_ENCODED.is(string) && this._inputState == 0 && this._channel.getHttpConfiguration().isFormEncodedMethod(this.getMethod())) {
                    this.extractFormParameters(this._contentParameters);
                } else if (string.startsWith("multipart/form-data") && this.getAttribute(__MULTIPART_CONFIG_ELEMENT) != null && this._multiPartInputStream == null) {
                    this.extractMultipartParameters(this._contentParameters);
                }
            }
        }
    }

    public void extractFormParameters(MultiMap<String> multiMap) {
        try {
            int n;
            Object object;
            Object object2;
            int n2 = -1;
            int n3 = -1;
            if (this._context != null) {
                n2 = this._context.getContextHandler().getMaxFormContentSize();
                n3 = this._context.getContextHandler().getMaxFormKeys();
            }
            if (n2 < 0) {
                object2 = this._channel.getServer().getAttribute("org.eclipse.jetty.server.Request.maxFormContentSize");
                if (object2 == null) {
                    n2 = 200000;
                } else if (object2 instanceof Number) {
                    object = (Number)object2;
                    n2 = ((Number)object).intValue();
                } else if (object2 instanceof String) {
                    n2 = Integer.valueOf((String)object2);
                }
            }
            if (n3 < 0) {
                object2 = this._channel.getServer().getAttribute("org.eclipse.jetty.server.Request.maxFormKeys");
                if (object2 == null) {
                    n3 = 1000;
                } else if (object2 instanceof Number) {
                    object = (Number)object2;
                    n3 = ((Number)object).intValue();
                } else if (object2 instanceof String) {
                    n3 = Integer.valueOf((String)object2);
                }
            }
            if ((n = this.getContentLength()) > n2 && n2 > 0) {
                throw new IllegalStateException("Form too large: " + n + " > " + n2);
            }
            object = this.getInputStream();
            if (this._input.isAsync()) {
                throw new IllegalStateException("Cannot extract parameters with async IO");
            }
            UrlEncoded.decodeTo((InputStream)object, multiMap, (String)this.getCharacterEncoding(), (int)(n < 0 ? n2 : -1), (int)n3);
        }
        catch (IOException iOException) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Throwable)iOException);
            }
            LOG.warn(iOException.toString(), new Object[0]);
        }
    }

    private void extractMultipartParameters(MultiMap<String> multiMap) {
        try {
            this.getParts(multiMap);
        }
        catch (IOException | ServletException throwable) {
            LOG.warn(throwable);
            throw new RuntimeException(throwable);
        }
    }

    public AsyncContext getAsyncContext() {
        HttpChannelState httpChannelState = this.getHttpChannelState();
        if (this._async == null || !httpChannelState.isAsyncStarted()) {
            throw new IllegalStateException(httpChannelState.getStatusString());
        }
        return this._async;
    }

    public HttpChannelState getHttpChannelState() {
        return this._channel.getState();
    }

    public Object getAttribute(String string) {
        if (string.startsWith("org.eclipse.jetty")) {
            if (Server.class.getName().equals(string)) {
                return this._channel.getServer();
            }
            if (HttpChannel.class.getName().equals(string)) {
                return this._channel;
            }
            if (HttpConnection.class.getName().equals(string) && this._channel.getHttpTransport() instanceof HttpConnection) {
                return this._channel.getHttpTransport();
            }
        }
        return this._attributes == null ? null : this._attributes.getAttribute(string);
    }

    public Enumeration<String> getAttributeNames() {
        if (this._attributes == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return AttributesMap.getAttributeNamesCopy((Attributes)this._attributes);
    }

    public Attributes getAttributes() {
        if (this._attributes == null) {
            this._attributes = new AttributesMap();
        }
        return this._attributes;
    }

    public Authentication getAuthentication() {
        return this._authentication;
    }

    public String getAuthType() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getAuthMethod();
        }
        return null;
    }

    public String getCharacterEncoding() {
        if (this._characterEncoding == null) {
            this.getContentType();
        }
        return this._characterEncoding;
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    public int getContentLength() {
        if (this._metadata.getContentLength() != Long.MIN_VALUE) {
            return (int)this._metadata.getContentLength();
        }
        return (int)this._metadata.getFields().getLongField(HttpHeader.CONTENT_LENGTH.toString());
    }

    public long getContentLengthLong() {
        if (this._metadata.getContentLength() != Long.MIN_VALUE) {
            return this._metadata.getContentLength();
        }
        return this._metadata.getFields().getLongField(HttpHeader.CONTENT_LENGTH.toString());
    }

    public long getContentRead() {
        return this._input.getContentConsumed();
    }

    public String getContentType() {
        String string = this._metadata.getFields().get(HttpHeader.CONTENT_TYPE);
        if (this._characterEncoding == null && string != null) {
            String string2;
            MimeTypes.Type type = (MimeTypes.Type)MimeTypes.CACHE.get(string);
            String string3 = string2 = type == null || type.getCharset() == null ? MimeTypes.getCharsetFromContentType((String)string) : type.getCharset().toString();
            if (string2 != null) {
                this._characterEncoding = string2;
            }
        }
        return string;
    }

    public ContextHandler.Context getContext() {
        return this._context;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public Cookie[] getCookies() {
        if (this._metadata == null || this._cookiesExtracted) {
            if (this._cookies == null || this._cookies.getCookies().length == 0) {
                return null;
            }
            return this._cookies.getCookies();
        }
        this._cookiesExtracted = true;
        Enumeration enumeration = this._metadata.getFields().getValues(HttpHeader.COOKIE.toString());
        if (enumeration != null) {
            if (this._cookies == null) {
                this._cookies = new CookieCutter();
            }
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this._cookies.addCookieField(string);
            }
        }
        if (this._cookies == null || this._cookies.getCookies().length == 0) {
            return null;
        }
        return this._cookies.getCookies();
    }

    public long getDateHeader(String string) {
        return this._metadata == null ? -1L : this._metadata.getFields().getDateField(string);
    }

    public DispatcherType getDispatcherType() {
        return this._dispatcherType;
    }

    public String getHeader(String string) {
        return this._metadata == null ? null : this._metadata.getFields().get(string);
    }

    public Enumeration<String> getHeaderNames() {
        if (this._metadata == null) {
            return Collections.emptyEnumeration();
        }
        return this._metadata.getFields().getFieldNames();
    }

    public Enumeration<String> getHeaders(String string) {
        if (this._metadata == null) {
            return Collections.emptyEnumeration();
        }
        Enumeration enumeration = this._metadata.getFields().getValues(string);
        if (enumeration == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return enumeration;
    }

    public int getInputState() {
        return this._inputState;
    }

    public ServletInputStream getInputStream() {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException("READER");
        }
        this._inputState = 1;
        if (this._channel.isExpecting100Continue()) {
            this._channel.continue100(this._input.available());
        }
        return this._input;
    }

    public int getIntHeader(String string) {
        return this._metadata == null ? -1 : (int)this._metadata.getFields().getLongField(string);
    }

    public Locale getLocale() {
        if (this._metadata == null) {
            return Locale.getDefault();
        }
        Enumeration enumeration = this._metadata.getFields().getValues(HttpHeader.ACCEPT_LANGUAGE.toString(), ", \t");
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Locale.getDefault();
        }
        List list = HttpFields.qualityList((Enumeration)enumeration);
        if (list.size() == 0) {
            return Locale.getDefault();
        }
        int n = list.size();
        if (n > 0) {
            String string = (String)list.get(0);
            string = HttpFields.valueParameters((String)string, null);
            String string2 = "";
            int n2 = string.indexOf(45);
            if (n2 > -1) {
                string2 = string.substring(n2 + 1).trim();
                string = string.substring(0, n2).trim();
            }
            return new Locale(string, string2);
        }
        return Locale.getDefault();
    }

    public Enumeration<Locale> getLocales() {
        if (this._metadata == null) {
            return Collections.enumeration(__defaultLocale);
        }
        Enumeration enumeration = this._metadata.getFields().getValues(HttpHeader.ACCEPT_LANGUAGE.toString(), ", \t");
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Collections.enumeration(__defaultLocale);
        }
        List list = HttpFields.qualityList((Enumeration)enumeration);
        if (list.size() == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        for (String string : list) {
            string = HttpFields.valueParameters((String)string, null);
            String string2 = "";
            int n = string.indexOf(45);
            if (n > -1) {
                string2 = string.substring(n + 1).trim();
                string = string.substring(0, n).trim();
            }
            arrayList.add(new Locale(string, string2));
        }
        if (arrayList.size() == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        return Collections.enumeration(arrayList);
    }

    public String getLocalAddr() {
        InetSocketAddress inetSocketAddress;
        if (this._channel == null) {
            try {
                String string = InetAddress.getLocalHost().getHostAddress();
                if ("0.0.0.0".equals(string)) {
                    return null;
                }
                return string;
            }
            catch (UnknownHostException unknownHostException) {
                LOG.ignore((Throwable)unknownHostException);
            }
        }
        if ((inetSocketAddress = this._channel.getLocalAddress()) == null) {
            return "";
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            return inetSocketAddress.getHostString();
        }
        return inetAddress.getHostAddress();
    }

    public String getLocalName() {
        if (this._channel == null) {
            try {
                String string = InetAddress.getLocalHost().getHostName();
                if ("0.0.0.0".equals(string)) {
                    return null;
                }
                return string;
            }
            catch (UnknownHostException unknownHostException) {
                LOG.ignore((Throwable)unknownHostException);
            }
        }
        InetSocketAddress inetSocketAddress = this._channel.getLocalAddress();
        return inetSocketAddress.getHostString();
    }

    public int getLocalPort() {
        if (this._channel == null) {
            return 0;
        }
        InetSocketAddress inetSocketAddress = this._channel.getLocalAddress();
        return inetSocketAddress.getPort();
    }

    public String getMethod() {
        return this._metadata == null ? null : this._metadata.getMethod();
    }

    public String getParameter(String string) {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        if (this._parameters == null) {
            this.restoreParameters();
        }
        return (String)this._parameters.getValue(string, 0);
    }

    public Map<String, String[]> getParameterMap() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        if (this._parameters == null) {
            this.restoreParameters();
        }
        return Collections.unmodifiableMap(this._parameters.toStringArrayMap());
    }

    public Enumeration<String> getParameterNames() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        if (this._parameters == null) {
            this.restoreParameters();
        }
        return Collections.enumeration(this._parameters.keySet());
    }

    public String[] getParameterValues(String string) {
        List list;
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        if (this._parameters == null) {
            this.restoreParameters();
        }
        if ((list = this._parameters.getValues(string)) == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    private void restoreParameters() {
        if (this._queryParameters == null) {
            this.extractQueryParameters();
        }
        if (this._queryParameters == NO_PARAMS || this._queryParameters.size() == 0) {
            this._parameters = this._contentParameters;
        } else if (this._contentParameters == NO_PARAMS || this._contentParameters.size() == 0) {
            this._parameters = this._queryParameters;
        } else {
            this._parameters = new MultiMap();
            this._parameters.addAllValues(this._queryParameters);
            this._parameters.addAllValues(this._contentParameters);
        }
    }

    public MultiMap<String> getQueryParameters() {
        return this._queryParameters;
    }

    public void setQueryParameters(MultiMap<String> multiMap) {
        this._queryParameters = multiMap;
    }

    public void setContentParameters(MultiMap<String> multiMap) {
        this._contentParameters = multiMap;
    }

    public void resetParameters() {
        this._parameters = null;
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public String getPathTranslated() {
        if (this._pathInfo == null || this._context == null) {
            return null;
        }
        return this._context.getRealPath(this._pathInfo);
    }

    public String getProtocol() {
        if (this._metadata == null) {
            return null;
        }
        HttpVersion httpVersion = this._metadata.getVersion();
        if (httpVersion == null) {
            return null;
        }
        return httpVersion.toString();
    }

    public HttpVersion getHttpVersion() {
        return this._metadata == null ? null : this._metadata.getVersion();
    }

    public String getQueryEncoding() {
        return this._queryEncoding;
    }

    public String getQueryString() {
        return this._metadata.getURI().getQuery();
    }

    public BufferedReader getReader() {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException("STREAMED");
        }
        if (this._inputState == 2) {
            return this._reader;
        }
        String string = this.getCharacterEncoding();
        if (string == null) {
            string = "iso-8859-1";
        }
        if (this._reader == null || !string.equalsIgnoreCase(this._readerEncoding)) {
            final ServletInputStream servletInputStream = this.getInputStream();
            this._readerEncoding = string;
            this._reader = new BufferedReader(new InputStreamReader((InputStream)servletInputStream, string)){

                @Override
                public void close() {
                    servletInputStream.close();
                }
            };
        }
        this._inputState = 2;
        return this._reader;
    }

    public String getRealPath(String string) {
        if (this._context == null) {
            return null;
        }
        return this._context.getRealPath(string);
    }

    public InetSocketAddress getRemoteInetSocketAddress() {
        InetSocketAddress inetSocketAddress = this._remote;
        if (inetSocketAddress == null) {
            inetSocketAddress = this._channel.getRemoteAddress();
        }
        return inetSocketAddress;
    }

    public String getRemoteAddr() {
        InetSocketAddress inetSocketAddress = this._remote;
        if (inetSocketAddress == null) {
            inetSocketAddress = this._channel.getRemoteAddress();
        }
        if (inetSocketAddress == null) {
            return "";
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            return inetSocketAddress.getHostString();
        }
        return inetAddress.getHostAddress();
    }

    public String getRemoteHost() {
        InetSocketAddress inetSocketAddress = this._remote;
        if (inetSocketAddress == null) {
            inetSocketAddress = this._channel.getRemoteAddress();
        }
        return inetSocketAddress == null ? "" : inetSocketAddress.getHostString();
    }

    public int getRemotePort() {
        InetSocketAddress inetSocketAddress = this._remote;
        if (inetSocketAddress == null) {
            inetSocketAddress = this._channel.getRemoteAddress();
        }
        return inetSocketAddress == null ? 0 : inetSocketAddress.getPort();
    }

    public String getRemoteUser() {
        Principal principal = this.getUserPrincipal();
        if (principal == null) {
            return null;
        }
        return principal.getName();
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (string == null || this._context == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            String string2 = URIUtil.addPaths((String)this._servletPath, (String)this._pathInfo);
            int n = string2.lastIndexOf("/");
            string2 = n > 1 ? string2.substring(0, n + 1) : "/";
            string = URIUtil.addPaths((String)string2, (String)string);
        }
        return this._context.getRequestDispatcher(string);
    }

    public String getRequestedSessionId() {
        return this._requestedSessionId;
    }

    public String getRequestURI() {
        MetaData.Request request = this._metadata;
        return request == null ? null : this._metadata.getURI().getPath();
    }

    public StringBuffer getRequestURL() {
        StringBuffer stringBuffer = new StringBuffer(128);
        URIUtil.appendSchemeHostPort((StringBuffer)stringBuffer, (String)this.getScheme(), (String)this.getServerName(), (int)this.getServerPort());
        stringBuffer.append(this.getRequestURI());
        return stringBuffer;
    }

    public Response getResponse() {
        return this._channel.getResponse();
    }

    public StringBuilder getRootURL() {
        StringBuilder stringBuilder = new StringBuilder(128);
        URIUtil.appendSchemeHostPort((StringBuilder)stringBuilder, (String)this.getScheme(), (String)this.getServerName(), (int)this.getServerPort());
        return stringBuilder;
    }

    public String getScheme() {
        String string = this._metadata == null ? null : this._metadata.getURI().getScheme();
        return string == null ? HttpScheme.HTTP.asString() : string;
    }

    public String getServerName() {
        String string = this._metadata.getURI().getHost();
        if (string != null) {
            return string;
        }
        return this.findServerName();
    }

    private String findServerName() {
        HttpField httpField = this._metadata.getFields().getField(HttpHeader.HOST);
        if (httpField != null) {
            HostPortHttpField hostPortHttpField = httpField instanceof HostPortHttpField ? (HostPortHttpField)httpField : new HostPortHttpField(httpField.getValue());
            this._metadata.getURI().setAuthority(hostPortHttpField.getHost(), hostPortHttpField.getPort());
            return hostPortHttpField.getHost();
        }
        String string = this.getLocalName();
        if (string != null) {
            return string;
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            LOG.ignore((Throwable)unknownHostException);
            return null;
        }
    }

    public int getServerPort() {
        int n;
        HttpURI httpURI = this._metadata.getURI();
        int n2 = n = httpURI.getHost() == null ? this.findServerPort() : httpURI.getPort();
        if (n <= 0) {
            if (this.getScheme().equalsIgnoreCase("https")) {
                return 443;
            }
            return 80;
        }
        return n;
    }

    private int findServerPort() {
        HttpField httpField = this._metadata.getFields().getField(HttpHeader.HOST);
        if (httpField != null) {
            HostPortHttpField hostPortHttpField = httpField instanceof HostPortHttpField ? (HostPortHttpField)httpField : new HostPortHttpField(httpField.getValue());
            this._metadata.getURI().setAuthority(hostPortHttpField.getHost(), hostPortHttpField.getPort());
            return hostPortHttpField.getPort();
        }
        if (this._channel != null) {
            return this.getLocalPort();
        }
        return -1;
    }

    public ServletContext getServletContext() {
        return this._context;
    }

    public String getServletName() {
        if (this._scope != null) {
            return this._scope.getName();
        }
        return null;
    }

    public String getServletPath() {
        if (this._servletPath == null) {
            this._servletPath = "";
        }
        return this._servletPath;
    }

    public ServletResponse getServletResponse() {
        return this._channel.getResponse();
    }

    public String changeSessionId() {
        HttpSession httpSession = this.getSession(false);
        if (httpSession == null) {
            throw new IllegalStateException("No session");
        }
        if (httpSession instanceof AbstractSession) {
            AbstractSession abstractSession = (AbstractSession)httpSession;
            abstractSession.renewId(this);
            if (this.getRemoteUser() != null) {
                abstractSession.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", Boolean.TRUE);
            }
            if (abstractSession.isIdChanged()) {
                this._channel.getResponse().addCookie(this._sessionManager.getSessionCookie(abstractSession, this.getContextPath(), this.isSecure()));
            }
        }
        return httpSession.getId();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        if (this._session != null) {
            if (this._sessionManager != null && !this._sessionManager.isValid(this._session)) {
                this._session = null;
            } else {
                return this._session;
            }
        }
        if (!bl) {
            return null;
        }
        if (this.getResponse().isCommitted()) {
            throw new IllegalStateException("Response is committed");
        }
        if (this._sessionManager == null) {
            throw new IllegalStateException("No SessionManager");
        }
        this._session = this._sessionManager.newHttpSession(this);
        HttpCookie httpCookie = this._sessionManager.getSessionCookie(this._session, this.getContextPath(), this.isSecure());
        if (httpCookie != null) {
            this._channel.getResponse().addCookie(httpCookie);
        }
        return this._session;
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public HttpURI getHttpURI() {
        return this._metadata == null ? null : this._metadata.getURI();
    }

    public void setHttpURI(HttpURI httpURI) {
        this._metadata.setURI(httpURI);
    }

    public UserIdentity getUserIdentity() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getUserIdentity();
        }
        return null;
    }

    public UserIdentity getResolvedUserIdentity() {
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getUserIdentity();
        }
        return null;
    }

    public UserIdentity.Scope getUserIdentityScope() {
        return this._scope;
    }

    public Principal getUserPrincipal() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            UserIdentity userIdentity = ((Authentication.User)this._authentication).getUserIdentity();
            return userIdentity.getUserPrincipal();
        }
        return null;
    }

    public boolean isHandled() {
        return this._handled;
    }

    public boolean isAsyncStarted() {
        return this.getHttpChannelState().isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this._asyncSupported;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._requestedSessionId != null && this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdValid() {
        if (this._requestedSessionId == null) {
            return false;
        }
        HttpSession httpSession = this.getSession(false);
        return httpSession != null && this._sessionManager.getSessionIdManager().getClusterId(this._requestedSessionId).equals(this._sessionManager.getClusterId(httpSession));
    }

    public boolean isSecure() {
        return this._secure;
    }

    public void setSecure(boolean bl) {
        this._secure = bl;
    }

    public boolean isUserInRole(String string) {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).isUserInRole(this._scope, string);
        }
        return false;
    }

    public HttpSession recoverNewSession(Object object) {
        if (this._savedNewSessions == null) {
            return null;
        }
        return this._savedNewSessions.get(object);
    }

    public void setMetaData(MetaData.Request request) {
        String string;
        this._metadata = request;
        this.setMethod(request.getMethod());
        HttpURI httpURI = request.getURI();
        String string2 = httpURI.getDecodedPath();
        if (string2 == null || string2.length() == 0) {
            if (!httpURI.isAbsolute()) {
                this.setPathInfo("");
                throw new BadMessageException(400, "Bad URI");
            }
            string2 = "/";
            httpURI.setPath(string2);
            string = string2;
        } else if (!string2.startsWith("/")) {
            if (!"*".equals(string2) && !HttpMethod.CONNECT.is(this.getMethod())) {
                this.setPathInfo(string2);
                throw new BadMessageException(400, "Bad URI");
            }
            string = string2;
        } else {
            string = URIUtil.canonicalPath((String)string2);
        }
        if (string == null) {
            this.setPathInfo(string2);
            throw new BadMessageException(400, "Bad URI");
        }
        this.setPathInfo(string);
    }

    public MetaData.Request getMetaData() {
        return this._metadata;
    }

    public boolean hasMetaData() {
        return this._metadata != null;
    }

    protected void recycle() {
        this._metadata = null;
        if (this._context != null) {
            throw new IllegalStateException("Request in context!");
        }
        if (this._inputState == 2) {
            try {
                int n = this._reader.read();
                while (n != -1) {
                    n = this._reader.read();
                }
            }
            catch (Exception exception) {
                LOG.ignore((Throwable)exception);
                this._reader = null;
            }
        }
        this._dispatcherType = null;
        this.setAuthentication(Authentication.NOT_CHECKED);
        this.getHttpChannelState().recycle();
        if (this._async != null) {
            this._async.reset();
        }
        this._async = null;
        this._asyncSupported = true;
        this._handled = false;
        if (this._attributes != null) {
            this._attributes.clearAttributes();
        }
        this._characterEncoding = null;
        this._contextPath = null;
        if (this._cookies != null) {
            this._cookies.reset();
        }
        this._cookiesExtracted = false;
        this._context = null;
        this._newContext = false;
        this._pathInfo = null;
        this._queryEncoding = null;
        this._requestedSessionId = null;
        this._requestedSessionIdFromCookie = false;
        this._secure = false;
        this._session = null;
        this._sessionManager = null;
        this._scope = null;
        this._servletPath = null;
        this._timeStamp = 0L;
        this._queryParameters = null;
        this._contentParameters = null;
        this._parameters = null;
        this._paramsExtracted = false;
        this._inputState = 0;
        if (this._savedNewSessions != null) {
            this._savedNewSessions.clear();
        }
        this._savedNewSessions = null;
        this._multiPartInputStream = null;
        this._remote = null;
        this._input.recycle();
    }

    public void removeAttribute(String string) {
        Object object;
        Object object2 = object = this._attributes == null ? null : this._attributes.getAttribute(string);
        if (this._attributes != null) {
            this._attributes.removeAttribute(string);
        }
        if (object != null && !this._requestAttributeListeners.isEmpty()) {
            ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent((ServletContext)this._context, (ServletRequest)this, string, object);
            for (ServletRequestAttributeListener servletRequestAttributeListener : this._requestAttributeListeners) {
                servletRequestAttributeListener.attributeRemoved(servletRequestAttributeEvent);
            }
        }
    }

    public void removeEventListener(EventListener eventListener) {
        this._requestAttributeListeners.remove(eventListener);
    }

    public void saveNewSession(Object object, HttpSession httpSession) {
        if (this._savedNewSessions == null) {
            this._savedNewSessions = new HashMap<Object, HttpSession>();
        }
        this._savedNewSessions.put(object, httpSession);
    }

    public void setAsyncSupported(boolean bl) {
        this._asyncSupported = bl;
    }

    public void setAttribute(String string, Object object) {
        Object object2;
        Object object3 = object2 = this._attributes == null ? null : this._attributes.getAttribute(string);
        if ("org.eclipse.jetty.server.Request.queryEncoding".equals(string)) {
            this.setQueryEncoding(object == null ? null : object.toString());
        } else if ("org.eclipse.jetty.server.sendContent".equals(string)) {
            LOG.warn("Deprecated: org.eclipse.jetty.server.sendContent", new Object[0]);
        }
        if (this._attributes == null) {
            this._attributes = new AttributesMap();
        }
        this._attributes.setAttribute(string, object);
        if (!this._requestAttributeListeners.isEmpty()) {
            ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent((ServletContext)this._context, (ServletRequest)this, string, object2 == null ? object : object2);
            for (ServletRequestAttributeListener servletRequestAttributeListener : this._requestAttributeListeners) {
                if (object2 == null) {
                    servletRequestAttributeListener.attributeAdded(servletRequestAttributeEvent);
                    continue;
                }
                if (object == null) {
                    servletRequestAttributeListener.attributeRemoved(servletRequestAttributeEvent);
                    continue;
                }
                servletRequestAttributeListener.attributeReplaced(servletRequestAttributeEvent);
            }
        }
    }

    public void setAttributes(Attributes attributes) {
        this._attributes = attributes;
    }

    public void setAuthentication(Authentication authentication) {
        this._authentication = authentication;
    }

    public void setCharacterEncoding(String string) {
        if (this._inputState != 0) {
            return;
        }
        this._characterEncoding = string;
        if (!StringUtil.isUTF8((String)string)) {
            try {
                Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new UnsupportedEncodingException(unsupportedCharsetException.getMessage());
            }
        }
    }

    public void setCharacterEncodingUnchecked(String string) {
        this._characterEncoding = string;
    }

    public void setContentType(String string) {
        this._metadata.getFields().put(HttpHeader.CONTENT_TYPE, string);
    }

    public void setContext(ContextHandler.Context context) {
        this._newContext = this._context != context;
        this._context = context;
    }

    public boolean takeNewContext() {
        boolean bl = this._newContext;
        this._newContext = false;
        return bl;
    }

    public void setContextPath(String string) {
        this._contextPath = string;
    }

    public void setCookies(Cookie[] cookieArray) {
        if (this._cookies == null) {
            this._cookies = new CookieCutter();
        }
        this._cookies.setCookies(cookieArray);
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        this._dispatcherType = dispatcherType;
    }

    public void setHandled(boolean bl) {
        this._handled = bl;
    }

    public void setMethod(String string) {
        this._metadata.setMethod(string);
    }

    public boolean isHead() {
        return this._metadata != null && HttpMethod.HEAD.is(this._metadata.getMethod());
    }

    public void setPathInfo(String string) {
        this._pathInfo = string;
    }

    public void setQueryEncoding(String string) {
        this._queryEncoding = string;
    }

    public void setQueryString(String string) {
        this._metadata.getURI().setQuery(string);
        this._queryEncoding = null;
    }

    public void setRemoteAddr(InetSocketAddress inetSocketAddress) {
        this._remote = inetSocketAddress;
    }

    public void setRequestedSessionId(String string) {
        this._requestedSessionId = string;
    }

    public void setRequestedSessionIdFromCookie(boolean bl) {
        this._requestedSessionIdFromCookie = bl;
    }

    public void setURIPathQuery(String string) {
        this._metadata.getURI().setPathQuery(string);
    }

    public void setScheme(String string) {
        this._metadata.getURI().setScheme(string);
    }

    public void setAuthority(String string, int n) {
        this._metadata.getURI().setAuthority(string, n);
    }

    public void setServletPath(String string) {
        this._servletPath = string;
    }

    public void setSession(HttpSession httpSession) {
        this._session = httpSession;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this._sessionManager = sessionManager;
    }

    public void setTimeStamp(long l) {
        this._timeStamp = l;
    }

    public void setUserIdentityScope(UserIdentity.Scope scope) {
        this._scope = scope;
    }

    public AsyncContext startAsync() {
        if (!this._asyncSupported) {
            throw new IllegalStateException("!asyncSupported");
        }
        HttpChannelState httpChannelState = this.getHttpChannelState();
        if (this._async == null) {
            this._async = new AsyncContextState(httpChannelState);
        }
        AsyncContextEvent asyncContextEvent = new AsyncContextEvent(this._context, this._async, httpChannelState, this, (ServletRequest)this, (ServletResponse)this.getResponse());
        httpChannelState.startAsync(asyncContextEvent);
        return this._async;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        if (!this._asyncSupported) {
            throw new IllegalStateException("!asyncSupported");
        }
        HttpChannelState httpChannelState = this.getHttpChannelState();
        if (this._async == null) {
            this._async = new AsyncContextState(httpChannelState);
        }
        AsyncContextEvent asyncContextEvent = new AsyncContextEvent(this._context, this._async, httpChannelState, this, servletRequest, servletResponse);
        asyncContextEvent.setDispatchContext(this.getServletContext());
        asyncContextEvent.setDispatchPath(URIUtil.addPaths((String)this.getServletPath(), (String)this.getPathInfo()));
        httpChannelState.startAsync(asyncContextEvent);
        return this._async;
    }

    public String toString() {
        return String.format("%s%s%s %s%s@%x", this.getClass().getSimpleName(), this._handled ? "[" : "(", this.getMethod(), this.getHttpURI(), this._handled ? "]" : ")", this.hashCode());
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this, (ServletResponse)httpServletResponse));
            return !(this._authentication instanceof Authentication.ResponseSent);
        }
        httpServletResponse.sendError(401);
        return false;
    }

    public Part getPart(String string) {
        this.getParts();
        return this._multiPartInputStream.getPart(string);
    }

    public Collection<Part> getParts() {
        if (this.getContentType() == null || !this.getContentType().startsWith("multipart/form-data")) {
            throw new ServletException("Content-Type != multipart/form-data");
        }
        return this.getParts(null);
    }

    private Collection<Part> getParts(MultiMap<String> multiMap) {
        if (this._multiPartInputStream == null) {
            this._multiPartInputStream = (MultiPartInputStreamParser)this.getAttribute(__MULTIPART_INPUT_STREAM);
        }
        if (this._multiPartInputStream == null) {
            MultipartConfigElement multipartConfigElement = (MultipartConfigElement)this.getAttribute(__MULTIPART_CONFIG_ELEMENT);
            if (multipartConfigElement == null) {
                throw new IllegalStateException("No multipart config for servlet");
            }
            this._multiPartInputStream = new MultiPartInputStreamParser((InputStream)this.getInputStream(), this.getContentType(), multipartConfigElement, this._context != null ? (File)this._context.getAttribute("javax.servlet.context.tempdir") : null);
            this.setAttribute(__MULTIPART_INPUT_STREAM, this._multiPartInputStream);
            this.setAttribute(__MULTIPART_CONTEXT, (Object)this._context);
            Collection collection = this._multiPartInputStream.getParts();
            ByteArrayOutputStream byteArrayOutputStream = null;
            for (Part part : collection) {
                MultiPartInputStreamParser.MultiPart multiPart = (MultiPartInputStreamParser.MultiPart)part;
                if (multiPart.getContentDispositionFilename() != null) continue;
                String string = null;
                if (multiPart.getContentType() != null) {
                    string = MimeTypes.getCharsetFromContentType((String)multiPart.getContentType());
                }
                try (InputStream inputStream = multiPart.getInputStream();){
                    if (byteArrayOutputStream == null) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                    }
                    IO.copy((InputStream)inputStream, byteArrayOutputStream);
                    String string2 = new String(byteArrayOutputStream.toByteArray(), string == null ? StandardCharsets.UTF_8 : Charset.forName(string));
                    if (this._contentParameters == null) {
                        this._contentParameters = multiMap == null ? new MultiMap() : multiMap;
                    }
                    this._contentParameters.add(multiPart.getName(), (Object)string2);
                }
                byteArrayOutputStream.reset();
            }
        }
        return this._multiPartInputStream.getParts();
    }

    public void login(String string, String string2) {
        if (this._authentication instanceof Authentication.Deferred) {
            this._authentication = ((Authentication.Deferred)this._authentication).login(string, string2, (ServletRequest)this);
            if (this._authentication == null) {
                throw new Authentication.Failed("Authentication failed for username '" + string + "'");
            }
        } else {
            throw new Authentication.Failed("Authenticated failed for username '" + string + "'. Already authenticated as " + this._authentication);
        }
    }

    public void logout() {
        if (this._authentication instanceof Authentication.User) {
            ((Authentication.User)this._authentication).logout();
        }
        this._authentication = Authentication.UNAUTHENTICATED;
    }

    public void mergeQueryParameters(String string, String string2, boolean bl) {
        MultiMap multiMap;
        MultiMap multiMap2;
        MultiMap multiMap3 = null;
        if (string2 != null) {
            multiMap3 = new MultiMap();
            UrlEncoded.decodeTo((String)string2, (MultiMap)multiMap3, (Charset)UrlEncoded.ENCODING);
        }
        if ((multiMap2 = this._queryParameters) == null && string != null) {
            multiMap2 = new MultiMap();
            UrlEncoded.decodeTo((String)string, (MultiMap)multiMap2, (String)this.getQueryEncoding());
        }
        if (multiMap3 == null || multiMap3.size() == 0) {
            multiMap = multiMap2 == null ? NO_PARAMS : multiMap2;
        } else if (multiMap2 == null || multiMap2.size() == 0) {
            multiMap = multiMap3 == null ? NO_PARAMS : multiMap3;
        } else {
            multiMap = new MultiMap(multiMap3);
            multiMap.addAllValues(multiMap2);
        }
        this.setQueryParameters(multiMap);
        this.resetParameters();
        if (bl) {
            if (string2 == null) {
                this.setQueryString(string);
            } else if (string == null) {
                this.setQueryString(string2);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                if (string2 != null) {
                    stringBuilder.append(string2);
                }
                for (Map.Entry entry : multiMap.entrySet()) {
                    if (multiMap3 != null && multiMap3.containsKey(entry.getKey())) continue;
                    for (String string3 : (List)entry.getValue()) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append("&");
                        }
                        URIUtil.encodePath((StringBuilder)stringBuilder, (String)((String)entry.getKey()));
                        stringBuilder.append('=');
                        URIUtil.encodePath((StringBuilder)stringBuilder, (String)string3);
                    }
                }
                this.setQueryString(stringBuilder.toString());
            }
        }
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> clazz) {
        throw new ServletException("HttpServletRequest.upgrade() not supported in Jetty");
    }
}

