/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Set;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.server.PushBuilder;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class PushBuilderImpl
implements PushBuilder {
    private static final Logger LOG = Log.getLogger(PushBuilderImpl.class);
    private static final HttpField JettyPush = new HttpField("x-http2-push", "PushBuilder");
    private final Request _request;
    private final HttpFields _fields;
    private String _method;
    private String _queryString;
    private String _sessionId;
    private boolean _conditional;
    private String _path;
    private String _etag;
    private String _lastModified;

    public PushBuilderImpl(Request request, HttpFields httpFields, String string, String string2, String string3, boolean bl) {
        this._request = request;
        this._fields = httpFields;
        this._method = string;
        this._queryString = string2;
        this._sessionId = string3;
        this._conditional = bl;
        this._fields.add(JettyPush);
        if (LOG.isDebugEnabled()) {
            LOG.debug("PushBuilder({} {}?{} s={} c={})", new Object[]{this._method, this._request.getRequestURI(), this._queryString, this._sessionId, this._conditional});
        }
    }

    @Override
    public String getMethod() {
        return this._method;
    }

    @Override
    public PushBuilder method(String string) {
        this._method = string;
        return this;
    }

    @Override
    public String getQueryString() {
        return this._queryString;
    }

    @Override
    public PushBuilder queryString(String string) {
        this._queryString = string;
        return this;
    }

    @Override
    public String getSessionId() {
        return this._sessionId;
    }

    @Override
    public PushBuilder sessionId(String string) {
        this._sessionId = string;
        return this;
    }

    @Override
    public boolean isConditional() {
        return this._conditional;
    }

    @Override
    public PushBuilder conditional(boolean bl) {
        this._conditional = bl;
        return this;
    }

    @Override
    public Set<String> getHeaderNames() {
        return this._fields.getFieldNamesCollection();
    }

    @Override
    public String getHeader(String string) {
        return this._fields.get(string);
    }

    @Override
    public PushBuilder setHeader(String string, String string2) {
        this._fields.put(string, string2);
        return this;
    }

    @Override
    public PushBuilder addHeader(String string, String string2) {
        this._fields.add(string, string2);
        return this;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public PushBuilder path(String string) {
        this._path = string;
        return this;
    }

    @Override
    public String getEtag() {
        return this._etag;
    }

    @Override
    public PushBuilder etag(String string) {
        this._etag = string;
        return this;
    }

    @Override
    public String getLastModified() {
        return this._lastModified;
    }

    @Override
    public PushBuilder lastModified(String string) {
        this._lastModified = string;
        return this;
    }

    @Override
    public void push() {
        if (HttpMethod.POST.is(this._method) || HttpMethod.PUT.is(this._method)) {
            throw new IllegalStateException("Bad Method " + this._method);
        }
        if (this._path == null || this._path.length() == 0) {
            throw new IllegalStateException("Bad Path " + this._path);
        }
        String string = this._path;
        String string2 = this._queryString;
        int n = string.indexOf(63);
        if (n >= 0) {
            string2 = string2 != null && string2.length() > 0 ? this._path.substring(n + 1) + '&' + string2 : this._path.substring(n + 1);
            string = this._path.substring(0, n);
        }
        if (!string.startsWith("/")) {
            string = URIUtil.addPaths((String)this._request.getContextPath(), (String)string);
        }
        String string3 = null;
        if (this._sessionId != null && this._request.isRequestedSessionIdFromURL()) {
            string3 = "jsessionid=" + this._sessionId;
        }
        if (this._conditional) {
            if (this._etag != null) {
                this._fields.add(HttpHeader.IF_NONE_MATCH, this._etag);
            } else if (this._lastModified != null) {
                this._fields.add(HttpHeader.IF_MODIFIED_SINCE, this._lastModified);
            }
        }
        HttpURI httpURI = HttpURI.createHttpURI((String)this._request.getScheme(), (String)this._request.getServerName(), (int)this._request.getServerPort(), (String)this._path, (String)string3, (String)string2, null);
        MetaData.Request request = new MetaData.Request(this._method, httpURI, this._request.getHttpVersion(), this._fields);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Push {} {} inm={} ims={}", new Object[]{this._method, httpURI, this._fields.get(HttpHeader.IF_NONE_MATCH), this._fields.get(HttpHeader.IF_MODIFIED_SINCE)});
        }
        this._request.getHttpChannel().getHttpTransport().push(request);
        this._path = null;
        this._etag = null;
        this._lastModified = null;
    }
}

