/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ProxyConnectionFactory
extends AbstractConnectionFactory {
    private static final Logger LOG = Log.getLogger(ProxyConnectionFactory.class);
    private final String _next;

    public ProxyConnectionFactory() {
        super("proxy");
        this._next = null;
    }

    public ProxyConnectionFactory(String string) {
        super("proxy");
        this._next = string;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        String string = this._next;
        if (string == null) {
            Iterator<String> iterator = connector.getProtocols().iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                if (!this.getProtocol().equalsIgnoreCase(string2)) continue;
                string = iterator.next();
                break;
            }
        }
        return new ProxyConnection(endPoint, connector, string);
    }

    public static class ProxyEndPoint
    implements EndPoint {
        private final EndPoint _endp;
        private final InetSocketAddress _remote;
        private final InetSocketAddress _local;

        public ProxyEndPoint(EndPoint endPoint, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
            this._endp = endPoint;
            this._remote = inetSocketAddress;
            this._local = inetSocketAddress2;
        }

        public boolean isOptimizedForDirectBuffers() {
            return this._endp.isOptimizedForDirectBuffers();
        }

        public InetSocketAddress getLocalAddress() {
            return this._local;
        }

        public InetSocketAddress getRemoteAddress() {
            return this._remote;
        }

        public boolean isOpen() {
            return this._endp.isOpen();
        }

        public long getCreatedTimeStamp() {
            return this._endp.getCreatedTimeStamp();
        }

        public void shutdownOutput() {
            this._endp.shutdownOutput();
        }

        public boolean isOutputShutdown() {
            return this._endp.isOutputShutdown();
        }

        public boolean isInputShutdown() {
            return this._endp.isInputShutdown();
        }

        public void close() {
            this._endp.close();
        }

        public int fill(ByteBuffer byteBuffer) {
            return this._endp.fill(byteBuffer);
        }

        public boolean flush(ByteBuffer ... byteBufferArray) {
            return this._endp.flush(byteBufferArray);
        }

        public Object getTransport() {
            return this._endp.getTransport();
        }

        public long getIdleTimeout() {
            return this._endp.getIdleTimeout();
        }

        public void setIdleTimeout(long l) {
            this._endp.setIdleTimeout(l);
        }

        public void fillInterested(Callback callback) {
            this._endp.fillInterested(callback);
        }

        public boolean isFillInterested() {
            return this._endp.isFillInterested();
        }

        public void write(Callback callback, ByteBuffer ... byteBufferArray) {
            this._endp.write(callback, byteBufferArray);
        }

        public Connection getConnection() {
            return this._endp.getConnection();
        }

        public void setConnection(Connection connection) {
            this._endp.setConnection(connection);
        }

        public void onOpen() {
            this._endp.onOpen();
        }

        public void onClose() {
            this._endp.onClose();
        }

        public void upgrade(Connection connection) {
            this._endp.upgrade(connection);
        }
    }

    public static class ProxyConnection
    extends AbstractConnection {
        private final int[] __size = new int[]{29, 23, 21, 13, 5, 3, 1};
        private final Connector _connector;
        private final String _next;
        private final StringBuilder _builder = new StringBuilder();
        private final String[] _field = new String[6];
        private int _fields;
        private int _length;

        protected ProxyConnection(EndPoint endPoint, Connector connector, String string) {
            super(endPoint, connector.getExecutor());
            this._connector = connector;
            this._next = string;
        }

        public void onOpen() {
            super.onOpen();
            this.fillInterested();
        }

        public void onFillable() {
            try {
                byte by;
                Buffer buffer = null;
                block2: while (true) {
                    int n = Math.max(1, this.__size[this._fields] - this._builder.length());
                    if (buffer == null || buffer.capacity() != n) {
                        buffer = BufferUtil.allocate((int)n);
                    } else {
                        BufferUtil.clear((ByteBuffer)buffer);
                    }
                    int n2 = this.getEndPoint().fill((ByteBuffer)buffer);
                    if (n2 < 0) {
                        this.getEndPoint().shutdownOutput();
                        return;
                    }
                    if (n2 == 0) {
                        this.fillInterested();
                        return;
                    }
                    this._length += n2;
                    if (this._length >= 108) {
                        LOG.warn("PROXY line too long {} for {}", new Object[]{this._length, this.getEndPoint()});
                        this.close();
                        return;
                    }
                    while (true) {
                        if (!buffer.hasRemaining()) continue block2;
                        by = ((ByteBuffer)buffer).get();
                        if (this._fields >= 6) break block2;
                        if (by == 32 || by == 13 && this._fields == 5) {
                            this._field[this._fields++] = this._builder.toString();
                            this._builder.setLength(0);
                            continue;
                        }
                        if (by < 32) {
                            LOG.warn("Bad character {} for {}", new Object[]{by & 0xFF, this.getEndPoint()});
                            this.close();
                            return;
                        }
                        this._builder.append((char)by);
                    }
                    break;
                }
                if (by != 10) {
                    LOG.warn("Bad CRLF for {}", new Object[]{this.getEndPoint()});
                    this.close();
                    return;
                }
                if (!"PROXY".equals(this._field[0])) {
                    LOG.warn("Not PROXY protocol for {}", new Object[]{this.getEndPoint()});
                    this.close();
                    return;
                }
                InetSocketAddress inetSocketAddress = new InetSocketAddress(this._field[2], Integer.parseInt(this._field[4]));
                InetSocketAddress inetSocketAddress2 = new InetSocketAddress(this._field[3], Integer.parseInt(this._field[5]));
                ConnectionFactory connectionFactory = this._connector.getConnectionFactory(this._next);
                if (connectionFactory == null) {
                    LOG.info("Next protocol '{}' for {}", new Object[]{this._next, this.getEndPoint()});
                    this.close();
                    return;
                }
                ProxyEndPoint proxyEndPoint = new ProxyEndPoint(this.getEndPoint(), inetSocketAddress, inetSocketAddress2);
                Connection connection = connectionFactory.newConnection(this._connector, proxyEndPoint);
                proxyEndPoint.upgrade(connection);
            }
            catch (Throwable throwable) {
                LOG.warn("PROXY error for " + this.getEndPoint(), throwable);
                this.close();
            }
        }
    }
}

