/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.io.NetworkTrafficSelectChannelEndPoint;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;

public class NetworkTrafficServerConnector
extends ServerConnector {
    private final List<NetworkTrafficListener> listeners = new CopyOnWriteArrayList<NetworkTrafficListener>();

    public NetworkTrafficServerConnector(Server server) {
        this(server, null, null, null, 0, 0, new HttpConnectionFactory());
    }

    public NetworkTrafficServerConnector(Server server, ConnectionFactory connectionFactory, SslContextFactory sslContextFactory) {
        super(server, sslContextFactory, connectionFactory);
    }

    public NetworkTrafficServerConnector(Server server, ConnectionFactory connectionFactory) {
        super(server, connectionFactory);
    }

    public NetworkTrafficServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool byteBufferPool, int n, int n2, ConnectionFactory ... connectionFactoryArray) {
        super(server, executor, scheduler, byteBufferPool, n, n2, connectionFactoryArray);
    }

    public NetworkTrafficServerConnector(Server server, SslContextFactory sslContextFactory) {
        super(server, sslContextFactory);
    }

    public void addNetworkTrafficListener(NetworkTrafficListener networkTrafficListener) {
        this.listeners.add(networkTrafficListener);
    }

    public void removeNetworkTrafficListener(NetworkTrafficListener networkTrafficListener) {
        this.listeners.remove(networkTrafficListener);
    }

    @Override
    protected SelectChannelEndPoint newEndPoint(SocketChannel socketChannel, ManagedSelector managedSelector, SelectionKey selectionKey) {
        NetworkTrafficSelectChannelEndPoint networkTrafficSelectChannelEndPoint = new NetworkTrafficSelectChannelEndPoint(socketChannel, managedSelector, selectionKey, this.getScheduler(), this.getIdleTimeout(), this.listeners);
        return networkTrafficSelectChannelEndPoint;
    }
}

