/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.SslConnectionFactory;

public abstract class NegotiatingServerConnectionFactory
extends AbstractConnectionFactory {
    private final List<String> negotiatedProtocols = new ArrayList<String>();
    private String defaultProtocol;

    public static void checkProtocolNegotiationAvailable() {
        if (!NegotiatingServerConnectionFactory.isAvailableInBootClassPath("org.eclipse.jetty.alpn.ALPN")) {
            throw new IllegalStateException("No ALPN classes available");
        }
    }

    private static boolean isAvailableInBootClassPath(String string) {
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
            if (clazz.getClassLoader() != null) {
                throw new IllegalStateException(string + " must be on JVM boot classpath");
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public NegotiatingServerConnectionFactory(String string, String ... stringArray) {
        super(string);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if ((string2 = string2.trim()).isEmpty()) continue;
                this.negotiatedProtocols.add(string2.trim());
            }
        }
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void setDefaultProtocol(String string) {
        String string2 = string == null ? "" : string.trim();
        this.defaultProtocol = string2.isEmpty() ? null : string2;
    }

    public List<String> getNegotiatedProtocols() {
        return this.negotiatedProtocols;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        Object object;
        Object object2;
        Object object3;
        List<String> list = this.negotiatedProtocols;
        if (list.isEmpty()) {
            list = new ArrayList<String>(connector.getProtocols());
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = connector.getConnectionFactory((String)object2);
                if (!(object instanceof SslConnectionFactory) && !(object instanceof NegotiatingServerConnectionFactory)) continue;
                object3.remove();
            }
        }
        if ((object3 = this.defaultProtocol) == null && !list.isEmpty()) {
            object3 = list.get(0);
        }
        object2 = null;
        object = endPoint;
        while (object2 == null && object != null) {
            if (object instanceof SslConnection.DecryptedEndPoint) {
                object2 = ((SslConnection.DecryptedEndPoint)object).getSslConnection().getSSLEngine();
                continue;
            }
            object = null;
        }
        return this.configure(this.newServerConnection(connector, endPoint, (SSLEngine)object2, list, (String)object3), connector, endPoint);
    }

    protected abstract AbstractConnection newServerConnection(Connector var1, EndPoint var2, SSLEngine var3, List<String> var4, String var5);

    @Override
    public String toString() {
        return String.format("%s@%x{%s,%s,%s}", this.getClass().getSimpleName(), this.hashCode(), this.getProtocols(), this.getDefaultProtocol(), this.getNegotiatedProtocols());
    }
}

