/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.MultiPartInputStreamParser;

public class MultiPartCleanerListener
implements ServletRequestListener {
    public static final MultiPartCleanerListener INSTANCE = new MultiPartCleanerListener();

    protected MultiPartCleanerListener() {
    }

    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        ContextHandler.Context context;
        MultiPartInputStreamParser multiPartInputStreamParser = (MultiPartInputStreamParser)servletRequestEvent.getServletRequest().getAttribute("org.eclipse.jetty.multiPartInputStream");
        if (multiPartInputStreamParser != null && (context = (ContextHandler.Context)((Object)servletRequestEvent.getServletRequest().getAttribute("org.eclipse.jetty.multiPartContext"))) == servletRequestEvent.getServletContext()) {
            try {
                multiPartInputStreamParser.deleteParts();
            }
            catch (MultiException multiException) {
                servletRequestEvent.getServletContext().log("Errors deleting multipart tmp files", (Throwable)multiException);
            }
        }
    }

    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
    }
}

