/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;

public class LocalConnector
extends AbstractConnector {
    private final BlockingQueue<LocalEndPoint> _connects = new LinkedBlockingQueue<LocalEndPoint>();

    public LocalConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool byteBufferPool, int n, ConnectionFactory ... connectionFactoryArray) {
        super(server, executor, scheduler, byteBufferPool, n, connectionFactoryArray);
        this.setIdleTimeout(30000L);
    }

    public LocalConnector(Server server) {
        this(server, null, null, null, -1, new HttpConnectionFactory());
    }

    public LocalConnector(Server server, SslContextFactory sslContextFactory) {
        this(server, null, null, null, -1, AbstractConnectionFactory.getFactories(sslContextFactory, new HttpConnectionFactory()));
    }

    public LocalConnector(Server server, ConnectionFactory connectionFactory) {
        this(server, null, null, null, -1, connectionFactory);
    }

    public LocalConnector(Server server, ConnectionFactory connectionFactory, SslContextFactory sslContextFactory) {
        this(server, null, null, null, -1, AbstractConnectionFactory.getFactories(sslContextFactory, connectionFactory));
    }

    @Override
    public Object getTransport() {
        return this;
    }

    public String getResponses(String string) {
        return this.getResponses(string, 5L, TimeUnit.SECONDS);
    }

    public String getResponses(String string, long l, TimeUnit timeUnit) {
        ByteBuffer byteBuffer = this.getResponses(BufferUtil.toBuffer((String)string, (Charset)StandardCharsets.UTF_8), l, timeUnit);
        return byteBuffer == null ? null : BufferUtil.toString((ByteBuffer)byteBuffer, (Charset)StandardCharsets.UTF_8);
    }

    public ByteBuffer getResponses(ByteBuffer byteBuffer) {
        return this.getResponses(byteBuffer, 5L, TimeUnit.SECONDS);
    }

    public ByteBuffer getResponses(ByteBuffer byteBuffer, long l, TimeUnit timeUnit) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("requests {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)byteBuffer)});
        }
        LocalEndPoint localEndPoint = this.executeRequest(byteBuffer);
        localEndPoint.waitUntilClosedOrIdleFor(l, timeUnit);
        ByteBuffer byteBuffer2 = localEndPoint.takeOutput();
        if (localEndPoint.isOutputShutdown()) {
            localEndPoint.close();
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("responses {}", new Object[]{BufferUtil.toUTF8String((ByteBuffer)byteBuffer2)});
        }
        return byteBuffer2;
    }

    public LocalEndPoint executeRequest(String string) {
        return this.executeRequest(BufferUtil.toBuffer((String)string, (Charset)StandardCharsets.UTF_8));
    }

    private LocalEndPoint executeRequest(ByteBuffer byteBuffer) {
        if (!this.isStarted()) {
            throw new IllegalStateException("!STARTED");
        }
        LocalEndPoint localEndPoint = new LocalEndPoint();
        localEndPoint.addInput(byteBuffer);
        this._connects.add(localEndPoint);
        return localEndPoint;
    }

    @Override
    protected void accept(int n) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("accepting {}", (long)n);
        }
        LocalEndPoint localEndPoint = this._connects.take();
        localEndPoint.onOpen();
        this.onEndPointOpened((EndPoint)localEndPoint);
        Connection connection = this.getDefaultConnectionFactory().newConnection(this, (EndPoint)localEndPoint);
        localEndPoint.setConnection(connection);
        connection.onOpen();
    }

    public class LocalEndPoint
    extends ByteArrayEndPoint {
        private final CountDownLatch _closed;

        public LocalEndPoint() {
            super(LocalConnector.this.getScheduler(), LocalConnector.this.getIdleTimeout());
            this._closed = new CountDownLatch(1);
            this.setGrowOutput(true);
        }

        protected void execute(Runnable runnable) {
            LocalConnector.this.getExecutor().execute(runnable);
        }

        public void close() {
            boolean bl = this.isOpen();
            super.close();
            if (bl) {
                this.getConnection().onClose();
                this.onClose();
            }
        }

        public void onClose() {
            LocalConnector.this.onEndPointClosed((EndPoint)this);
            super.onClose();
            this._closed.countDown();
        }

        public void shutdownOutput() {
            super.shutdownOutput();
            this.close();
        }

        public void waitUntilClosed() {
            while (this.isOpen()) {
                try {
                    if (this._closed.await(10L, TimeUnit.SECONDS)) continue;
                    break;
                }
                catch (Exception exception) {
                    LocalConnector.this.LOG.warn((Throwable)exception);
                }
            }
        }

        public void waitUntilClosedOrIdleFor(long l, TimeUnit timeUnit) {
            Thread.yield();
            int n = this.getOutput().remaining();
            while (this.isOpen()) {
                try {
                    if (this._closed.await(l, timeUnit)) continue;
                    if (n == this.getOutput().remaining()) {
                        if (LocalConnector.this.LOG.isDebugEnabled()) {
                            LocalConnector.this.LOG.debug("idle for {} {}", new Object[]{l, timeUnit});
                        }
                        return;
                    }
                    n = this.getOutput().remaining();
                }
                catch (Exception exception) {
                    LocalConnector.this.LOG.warn((Throwable)exception);
                }
            }
        }
    }
}

