/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InclusiveByteRange {
    private static final Logger LOG = Log.getLogger(InclusiveByteRange.class);
    long first = 0L;
    long last = 0L;

    public InclusiveByteRange(long l, long l2) {
        this.first = l;
        this.last = l2;
    }

    public long getFirst() {
        return this.first;
    }

    public long getLast() {
        return this.last;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<InclusiveByteRange> satisfiableRanges(Enumeration<String> enumeration, long l) {
        Object object = null;
        block4: while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=,", false);
            String string2 = null;
            try {
                while (true) {
                    if (!stringTokenizer.hasMoreTokens()) continue block4;
                    try {
                        long l2;
                        long l3;
                        block13: {
                            string2 = stringTokenizer.nextToken().trim();
                            l3 = -1L;
                            l2 = -1L;
                            int n = string2.indexOf(45);
                            if (n < 0 || string2.indexOf("-", n + 1) >= 0) {
                                if ("bytes".equals(string2)) continue;
                                LOG.warn("Bad range format: {}", new Object[]{string2});
                                continue block4;
                            }
                            if (n == 0) {
                                if (n + 1 < string2.length()) {
                                    l2 = Long.parseLong(string2.substring(n + 1).trim());
                                    break block13;
                                } else {
                                    LOG.warn("Bad range format: {}", new Object[]{string2});
                                    continue;
                                }
                            }
                            if (n + 1 < string2.length()) {
                                l3 = Long.parseLong(string2.substring(0, n).trim());
                                l2 = Long.parseLong(string2.substring(n + 1).trim());
                            } else {
                                l3 = Long.parseLong(string2.substring(0, n).trim());
                            }
                        }
                        if (l3 == -1L && l2 == -1L || l3 != -1L && l2 != -1L && l3 > l2) continue block4;
                        if (l3 >= l) continue;
                        InclusiveByteRange inclusiveByteRange = new InclusiveByteRange(l3, l2);
                        object = LazyList.add(object, (Object)inclusiveByteRange);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOG.warn("Bad range format: {}", new Object[]{string2});
                        LOG.ignore((Throwable)numberFormatException);
                    }
                }
            }
            catch (Exception exception) {
                LOG.warn("Bad range format: {}", new Object[]{string2});
                LOG.ignore((Throwable)exception);
                continue;
            }
            break;
        }
        return LazyList.getList(object, (boolean)true);
    }

    public long getFirst(long l) {
        if (this.first < 0L) {
            long l2 = l - this.last;
            if (l2 < 0L) {
                l2 = 0L;
            }
            return l2;
        }
        return this.first;
    }

    public long getLast(long l) {
        if (this.first < 0L) {
            return l - 1L;
        }
        if (this.last < 0L || this.last >= l) {
            return l - 1L;
        }
        return this.last;
    }

    public long getSize(long l) {
        return this.getLast(l) - this.getFirst(l) + 1L;
    }

    public String toHeaderRangeString(long l) {
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append("bytes ");
        stringBuilder.append(this.getFirst(l));
        stringBuilder.append('-');
        stringBuilder.append(this.getLast(l));
        stringBuilder.append("/");
        stringBuilder.append(l);
        return stringBuilder.toString();
    }

    public static String to416HeaderRangeString(long l) {
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append("bytes */");
        stringBuilder.append(l);
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(60);
        stringBuilder.append(Long.toString(this.first));
        stringBuilder.append(":");
        stringBuilder.append(Long.toString(this.last));
        return stringBuilder.toString();
    }
}

