/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritePendingException;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpOutput
extends ServletOutputStream
implements Runnable {
    private static Logger LOG = Log.getLogger(HttpOutput.class);
    private final HttpChannel _channel;
    private final SharedBlockingCallback _writeBlock;
    private Interceptor _interceptor;
    private long _written;
    private ByteBuffer _aggregate;
    private int _bufferSize;
    private int _commitSize;
    private WriteListener _writeListener;
    private volatile Throwable _onError;
    private final AtomicReference<OutputState> _state = new AtomicReference<OutputState>(OutputState.OPEN);

    public HttpOutput(HttpChannel httpChannel) {
        this._channel = httpChannel;
        this._interceptor = httpChannel;
        this._writeBlock = new SharedBlockingCallback(){

            protected long getIdleTimeout() {
                long l = HttpOutput.this.getHttpChannel().getHttpConfiguration().getBlockingTimeout();
                if (l > 0L) {
                    return l;
                }
                if (l < 0L) {
                    return -1L;
                }
                return HttpOutput.this._channel.getIdleTimeout();
            }
        };
        HttpConfiguration httpConfiguration = httpChannel.getHttpConfiguration();
        this._bufferSize = httpConfiguration.getOutputBufferSize();
        this._commitSize = httpConfiguration.getOutputAggregationSize();
        if (this._commitSize > this._bufferSize) {
            LOG.warn("OutputAggregationSize {} exceeds bufferSize {}", new Object[]{this._commitSize, this._bufferSize});
            this._commitSize = this._bufferSize;
        }
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    public Interceptor getInterceptor() {
        return this._interceptor;
    }

    public void setInterceptor(Interceptor interceptor) {
        this._interceptor = interceptor;
    }

    public boolean isWritten() {
        return this._written > 0L;
    }

    public long getWritten() {
        return this._written;
    }

    public void reopen() {
        this._state.set(OutputState.OPEN);
    }

    public boolean isAllContentWritten() {
        return this._channel.getResponse().isAllContentWritten(this._written);
    }

    protected SharedBlockingCallback.Blocker acquireWriteBlockingCallback() {
        return this._writeBlock.acquire();
    }

    private void write(ByteBuffer byteBuffer, boolean bl) {
        try (SharedBlockingCallback.Blocker blocker = this._writeBlock.acquire();){
            this.write(byteBuffer, bl, (Callback)blocker);
            blocker.block();
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(throwable);
            }
            this.abort(throwable);
            throw throwable;
        }
    }

    protected void write(ByteBuffer byteBuffer, boolean bl, Callback callback) {
        this._interceptor.write(byteBuffer, bl, callback);
    }

    private void abort(Throwable throwable) {
        this.closed();
        this._channel.abort(throwable);
    }

    public void close() {
        block8: while (true) {
            OutputState outputState = this._state.get();
            switch (outputState) {
                case CLOSED: {
                    return;
                }
                case UNREADY: {
                    if (!this._state.compareAndSet(outputState, OutputState.ERROR)) continue block8;
                    this._writeListener.onError(this._onError == null ? new EofException("Async close") : this._onError);
                    continue block8;
                }
            }
            if (this._state.compareAndSet(outputState, OutputState.CLOSED)) break;
        }
        try {
            this.write(BufferUtil.hasContent((ByteBuffer)this._aggregate) ? this._aggregate : BufferUtil.EMPTY_BUFFER, !this._channel.getResponse().isIncluding());
        }
        catch (IOException iOException) {
        }
        finally {
            this.releaseBuffer();
        }
    }

    void closed() {
        block9: while (true) {
            OutputState outputState = this._state.get();
            switch (outputState) {
                case CLOSED: {
                    return;
                }
                case UNREADY: {
                    if (!this._state.compareAndSet(outputState, OutputState.ERROR)) continue block9;
                    this._writeListener.onError(this._onError == null ? new EofException("Async closed") : this._onError);
                    continue block9;
                }
            }
            if (this._state.compareAndSet(outputState, OutputState.CLOSED)) break;
        }
        try {
            this._channel.getResponse().closeOutput();
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(throwable);
            }
            this.abort(throwable);
        }
        finally {
            this.releaseBuffer();
        }
    }

    private void releaseBuffer() {
        if (this._aggregate != null) {
            this._channel.getConnector().getByteBufferPool().release(this._aggregate);
            this._aggregate = null;
        }
    }

    public boolean isClosed() {
        return this._state.get() == OutputState.CLOSED;
    }

    public void flush() {
        block8: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    this.write(BufferUtil.hasContent((ByteBuffer)this._aggregate) ? this._aggregate : BufferUtil.EMPTY_BUFFER, false);
                    return;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called");
                }
                case READY: {
                    if (!this._state.compareAndSet(OutputState.READY, OutputState.PENDING)) continue block8;
                    new AsyncFlush().iterate();
                    return;
                }
                case UNREADY: 
                case PENDING: {
                    throw new WritePendingException();
                }
                case ERROR: {
                    throw new EofException(this._onError);
                }
                case CLOSED: {
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public void write(byte[] byArray, int n, int n2) {
        this._written += (long)n2;
        boolean bl = this._channel.getResponse().isAllContentWritten(this._written);
        block8: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    break block8;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called");
                }
                case READY: {
                    if (!this._state.compareAndSet(OutputState.READY, OutputState.PENDING)) continue block8;
                    if (!bl && n2 <= this._commitSize) {
                        int n3;
                        if (this._aggregate == null) {
                            this._aggregate = this._channel.getByteBufferPool().acquire(this.getBufferSize(), this._interceptor.isOptimizedForDirectBuffers());
                        }
                        if ((n3 = BufferUtil.fill((ByteBuffer)this._aggregate, (byte[])byArray, (int)n, (int)n2)) == n2 && !BufferUtil.isFull((ByteBuffer)this._aggregate)) {
                            if (!this._state.compareAndSet(OutputState.PENDING, OutputState.ASYNC)) {
                                throw new IllegalStateException();
                            }
                            return;
                        }
                        n += n3;
                        n2 -= n3;
                    }
                    new AsyncWrite(byArray, n, n2, bl).iterate();
                    return;
                }
                case UNREADY: 
                case PENDING: {
                    throw new WritePendingException();
                }
                case ERROR: {
                    throw new EofException(this._onError);
                }
                case CLOSED: {
                    throw new EofException("Closed");
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            break;
        }
        int n4 = this.getBufferSize();
        if (!bl && n2 <= this._commitSize) {
            int n5;
            if (this._aggregate == null) {
                this._aggregate = this._channel.getByteBufferPool().acquire(n4, this._interceptor.isOptimizedForDirectBuffers());
            }
            if ((n5 = BufferUtil.fill((ByteBuffer)this._aggregate, (byte[])byArray, (int)n, (int)n2)) == n2 && !BufferUtil.isFull((ByteBuffer)this._aggregate)) {
                return;
            }
            n += n5;
            n2 -= n5;
        }
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            this.write(this._aggregate, bl && n2 == 0);
            if (n2 > 0 && !bl && n2 <= this._commitSize && n2 <= BufferUtil.space((ByteBuffer)this._aggregate)) {
                BufferUtil.append((ByteBuffer)this._aggregate, (byte[])byArray, (int)n, (int)n2);
                return;
            }
        }
        if (n2 > 0) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            ByteBuffer byteBuffer2 = byteBuffer.duplicate();
            while (n2 > this.getBufferSize()) {
                int n6 = byteBuffer2.position();
                int n7 = n6 + this.getBufferSize();
                byteBuffer2.limit(n6 + this.getBufferSize());
                this.write(byteBuffer2, false);
                byteBuffer2.limit(n7 + Math.min(n2 -= this.getBufferSize(), this.getBufferSize()));
                byteBuffer2.position(n7);
            }
            this.write(byteBuffer2, bl);
        } else if (bl) {
            this.write(BufferUtil.EMPTY_BUFFER, true);
        }
        if (bl) {
            this.closed();
        }
    }

    public void write(ByteBuffer byteBuffer) {
        this._written += (long)byteBuffer.remaining();
        boolean bl = this._channel.getResponse().isAllContentWritten(this._written);
        block8: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    break block8;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called");
                }
                case READY: {
                    if (!this._state.compareAndSet(OutputState.READY, OutputState.PENDING)) continue block8;
                    new AsyncWrite(byteBuffer, bl).iterate();
                    return;
                }
                case UNREADY: 
                case PENDING: {
                    throw new WritePendingException();
                }
                case ERROR: {
                    throw new EofException(this._onError);
                }
                case CLOSED: {
                    throw new EofException("Closed");
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            break;
        }
        int n = BufferUtil.length((ByteBuffer)byteBuffer);
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            this.write(this._aggregate, bl && n == 0);
        }
        if (n > 0) {
            this.write(byteBuffer, bl);
        } else if (bl) {
            this.write(BufferUtil.EMPTY_BUFFER, true);
        }
        if (bl) {
            this.closed();
        }
    }

    public void write(int n) {
        ++this._written;
        boolean bl = this._channel.getResponse().isAllContentWritten(this._written);
        block8: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    if (this._aggregate == null) {
                        this._aggregate = this._channel.getByteBufferPool().acquire(this.getBufferSize(), this._interceptor.isOptimizedForDirectBuffers());
                    }
                    BufferUtil.append((ByteBuffer)this._aggregate, (byte)((byte)n));
                    if (!bl && !BufferUtil.isFull((ByteBuffer)this._aggregate)) break block8;
                    this.write(this._aggregate, bl);
                    if (!bl) break block8;
                    this.closed();
                    break block8;
                }
                case ASYNC: {
                    throw new IllegalStateException("isReady() not called");
                }
                case READY: {
                    if (!this._state.compareAndSet(OutputState.READY, OutputState.PENDING)) continue block8;
                    if (this._aggregate == null) {
                        this._aggregate = this._channel.getByteBufferPool().acquire(this.getBufferSize(), this._interceptor.isOptimizedForDirectBuffers());
                    }
                    BufferUtil.append((ByteBuffer)this._aggregate, (byte)((byte)n));
                    if (!bl && !BufferUtil.isFull((ByteBuffer)this._aggregate)) {
                        if (!this._state.compareAndSet(OutputState.PENDING, OutputState.ASYNC)) {
                            throw new IllegalStateException();
                        }
                        return;
                    }
                    new AsyncFlush().iterate();
                    return;
                }
                case UNREADY: 
                case PENDING: {
                    throw new WritePendingException();
                }
                case ERROR: {
                    throw new EofException(this._onError);
                }
                case CLOSED: {
                    throw new EofException("Closed");
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            break;
        }
    }

    public void print(String string) {
        if (this.isClosed()) {
            throw new IOException("Closed");
        }
        this.write(string.getBytes(this._channel.getResponse().getCharacterEncoding()));
    }

    public void sendContent(ByteBuffer byteBuffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent({})", new Object[]{BufferUtil.toDetailString((ByteBuffer)byteBuffer)});
        }
        this.write(byteBuffer, true);
        this.closed();
    }

    public void sendContent(InputStream inputStream) {
        try (SharedBlockingCallback.Blocker blocker = this._writeBlock.acquire();){
            new InputStreamWritingCB(inputStream, (Callback)blocker).iterate();
            blocker.block();
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(throwable);
            }
            this.abort(throwable);
            throw throwable;
        }
    }

    public void sendContent(ReadableByteChannel readableByteChannel) {
        try (SharedBlockingCallback.Blocker blocker = this._writeBlock.acquire();){
            new ReadableByteChannelWritingCB(readableByteChannel, (Callback)blocker).iterate();
            blocker.block();
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(throwable);
            }
            this.abort(throwable);
            throw throwable;
        }
    }

    public void sendContent(HttpContent httpContent) {
        try (SharedBlockingCallback.Blocker blocker = this._writeBlock.acquire();){
            this.sendContent(httpContent, (Callback)blocker);
            blocker.block();
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(throwable);
            }
            this.abort(throwable);
            throw throwable;
        }
    }

    public void sendContent(ByteBuffer byteBuffer, final Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent(buffer={},{})", new Object[]{BufferUtil.toDetailString((ByteBuffer)byteBuffer), callback});
        }
        this.write(byteBuffer, true, new Callback(){

            public void succeeded() {
                HttpOutput.this.closed();
                callback.succeeded();
            }

            public void failed(Throwable throwable) {
                HttpOutput.this.abort(throwable);
                callback.failed(throwable);
            }
        });
    }

    public void sendContent(InputStream inputStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent(stream={},{})", new Object[]{inputStream, callback});
        }
        new InputStreamWritingCB(inputStream, callback).iterate();
    }

    public void sendContent(ReadableByteChannel readableByteChannel, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent(channel={},{})", new Object[]{readableByteChannel, callback});
        }
        new ReadableByteChannelWritingCB(readableByteChannel, callback).iterate();
    }

    public void sendContent(HttpContent httpContent, Callback callback) {
        ByteBuffer byteBuffer;
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent(http={},{})", new Object[]{httpContent, callback});
        }
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            callback.failed((Throwable)new IOException("cannot sendContent() after write()"));
            return;
        }
        if (this._channel.isCommitted()) {
            callback.failed((Throwable)new IOException("committed"));
            return;
        }
        block7: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    if (this._state.compareAndSet(OutputState.OPEN, OutputState.PENDING)) break block7;
                    continue block7;
                }
                case ERROR: {
                    callback.failed((Throwable)new EofException(this._onError));
                    return;
                }
                case CLOSED: {
                    callback.failed((Throwable)new EofException("Closed"));
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            break;
        }
        ByteBuffer byteBuffer2 = byteBuffer = this._channel.useDirectBuffers() ? httpContent.getDirectBuffer() : null;
        if (byteBuffer == null) {
            byteBuffer = httpContent.getIndirectBuffer();
        }
        if (byteBuffer != null) {
            this.sendContent(byteBuffer, callback);
            return;
        }
        try {
            ReadableByteChannel readableByteChannel = httpContent.getReadableByteChannel();
            if (readableByteChannel != null) {
                this.sendContent(readableByteChannel, callback);
                return;
            }
            InputStream inputStream = httpContent.getInputStream();
            if (inputStream != null) {
                this.sendContent(inputStream, callback);
                return;
            }
            throw new IllegalArgumentException("unknown content for " + httpContent);
        }
        catch (Throwable throwable) {
            this.abort(throwable);
            callback.failed(throwable);
            return;
        }
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
        this._commitSize = n;
    }

    public void recycle() {
        this.resetBuffer();
        this._interceptor = this._channel;
    }

    public void resetBuffer() {
        this._written = 0L;
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            BufferUtil.clear((ByteBuffer)this._aggregate);
        }
        this.reopen();
    }

    public void setWriteListener(WriteListener writeListener) {
        if (!this._channel.getState().isAsync()) {
            throw new IllegalStateException("!ASYNC");
        }
        if (this._state.compareAndSet(OutputState.OPEN, OutputState.READY)) {
            this._writeListener = writeListener;
            if (this._channel.getState().onWritePossible()) {
                this._channel.execute(this._channel);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReady() {
        block9: while (true) {
            switch (this._state.get()) {
                case OPEN: {
                    return true;
                }
                case ASYNC: {
                    if (!this._state.compareAndSet(OutputState.ASYNC, OutputState.READY)) continue block9;
                    return true;
                }
                case READY: {
                    return true;
                }
                case PENDING: {
                    if (this._state.compareAndSet(OutputState.PENDING, OutputState.UNREADY)) return false;
                    continue block9;
                }
                case UNREADY: {
                    return false;
                }
                case ERROR: {
                    return true;
                }
                case CLOSED: {
                    return true;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    @Override
    public void run() {
        block8: while (true) {
            OutputState outputState = this._state.get();
            if (this._onError != null) {
                switch (outputState) {
                    case CLOSED: 
                    case ERROR: {
                        this._onError = null;
                        break;
                    }
                    default: {
                        if (!this._state.compareAndSet(outputState, OutputState.ERROR)) continue block8;
                        Throwable throwable = this._onError;
                        this._onError = null;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("onError", throwable);
                        }
                        this._writeListener.onError(throwable);
                        this.close();
                        break;
                    }
                }
                break;
            }
            switch (this._state.get()) {
                case CLOSED: 
                case UNREADY: 
                case READY: 
                case PENDING: {
                    try {
                        this._writeListener.onWritePossible();
                        break block8;
                    }
                    catch (Throwable throwable) {
                        this._onError = throwable;
                        continue block8;
                    }
                }
                default: {
                    this._onError = new IllegalStateException("state=" + (Object)((Object)this._state.get()));
                    continue block8;
                }
            }
            break;
        }
    }

    private void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Throwable throwable) {
            LOG.ignore(throwable);
        }
    }

    public String toString() {
        return String.format("%s@%x{%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state.get()});
    }

    static /* synthetic */ AtomicReference access$200(HttpOutput httpOutput) {
        return httpOutput._state;
    }

    private class ReadableByteChannelWritingCB
    extends IteratingNestedCallback {
        private final ReadableByteChannel _in;
        private final ByteBuffer _buffer;
        private boolean _eof;

        public ReadableByteChannelWritingCB(ReadableByteChannel readableByteChannel, Callback callback) {
            super(callback);
            this._in = readableByteChannel;
            this._buffer = HttpOutput.this._channel.getByteBufferPool().acquire(HttpOutput.this.getBufferSize(), HttpOutput.this._channel.useDirectBuffers());
        }

        protected IteratingCallback.Action process() {
            if (this._eof) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("EOF of {}", new Object[]{this});
                }
                this._in.close();
                HttpOutput.this.closed();
                HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
                return IteratingCallback.Action.SUCCEEDED;
            }
            this._buffer.clear();
            while (this._buffer.hasRemaining() && !this._eof) {
                this._eof = this._in.read(this._buffer) < 0;
            }
            this._buffer.flip();
            HttpOutput.this.write(this._buffer, this._eof, (Callback)this);
            return IteratingCallback.Action.SCHEDULED;
        }

        public void onCompleteFailure(Throwable throwable) {
            HttpOutput.this.abort(throwable);
            HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
            HttpOutput.this.close(this._in);
            super.onCompleteFailure(throwable);
        }
    }

    private class InputStreamWritingCB
    extends IteratingNestedCallback {
        private final InputStream _in;
        private final ByteBuffer _buffer;
        private boolean _eof;

        public InputStreamWritingCB(InputStream inputStream, Callback callback) {
            super(callback);
            this._in = inputStream;
            this._buffer = HttpOutput.this._channel.getByteBufferPool().acquire(HttpOutput.this.getBufferSize(), false);
        }

        protected IteratingCallback.Action process() {
            if (this._eof) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("EOF of {}", new Object[]{this});
                }
                this._in.close();
                HttpOutput.this.closed();
                HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
                return IteratingCallback.Action.SUCCEEDED;
            }
            int n = 0;
            while (n < this._buffer.capacity() && !this._eof) {
                int n2 = this._in.read(this._buffer.array(), this._buffer.arrayOffset() + n, this._buffer.capacity() - n);
                if (n2 < 0) {
                    this._eof = true;
                    continue;
                }
                n += n2;
            }
            this._buffer.position(0);
            this._buffer.limit(n);
            HttpOutput.this.write(this._buffer, this._eof, (Callback)this);
            return IteratingCallback.Action.SCHEDULED;
        }

        public void onCompleteFailure(Throwable throwable) {
            HttpOutput.this.abort(throwable);
            HttpOutput.this._channel.getByteBufferPool().release(this._buffer);
            HttpOutput.this.close(this._in);
            super.onCompleteFailure(throwable);
        }
    }

    private class AsyncWrite
    extends AsyncICB {
        private final ByteBuffer _buffer;
        private final ByteBuffer _slice;
        private final boolean _complete;
        private final int _len;
        protected volatile boolean _completed;

        public AsyncWrite(byte[] byArray, int n, int n2, boolean bl) {
            this._buffer = ByteBuffer.wrap(byArray, n, n2);
            this._len = n2;
            this._slice = this._len < HttpOutput.this.getBufferSize() ? null : this._buffer.duplicate();
            this._complete = bl;
        }

        public AsyncWrite(ByteBuffer byteBuffer, boolean bl) {
            this._buffer = byteBuffer;
            this._len = byteBuffer.remaining();
            if (this._buffer.isDirect() || this._len < HttpOutput.this.getBufferSize()) {
                this._slice = null;
            } else {
                this._slice = this._buffer.duplicate();
                this._buffer.position(this._buffer.limit());
            }
            this._complete = bl;
        }

        protected IteratingCallback.Action process() {
            if (BufferUtil.hasContent((ByteBuffer)HttpOutput.this._aggregate)) {
                this._completed = this._len == 0;
                HttpOutput.this.write(HttpOutput.this._aggregate, this._complete && this._completed, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (!this._complete && this._len < BufferUtil.space((ByteBuffer)HttpOutput.this._aggregate) && this._len < HttpOutput.this._commitSize) {
                int n = BufferUtil.flipToFill((ByteBuffer)HttpOutput.this._aggregate);
                BufferUtil.put((ByteBuffer)this._buffer, (ByteBuffer)HttpOutput.this._aggregate);
                BufferUtil.flipToFlush((ByteBuffer)HttpOutput.this._aggregate, (int)n);
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (this._buffer.hasRemaining()) {
                if (this._slice == null) {
                    this._completed = true;
                    HttpOutput.this.write(this._buffer, this._complete, (Callback)this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                int n = this._buffer.position();
                int n2 = Math.min(HttpOutput.this.getBufferSize(), this._buffer.remaining());
                int n3 = n + n2;
                this._slice.limit(n3);
                this._buffer.position(n3);
                this._slice.position(n);
                this._completed = !this._buffer.hasRemaining();
                HttpOutput.this.write(this._slice, this._complete && this._completed, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (this._complete && !this._completed) {
                this._completed = true;
                HttpOutput.this.write(BufferUtil.EMPTY_BUFFER, true, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (LOG.isDebugEnabled() && this._completed) {
                LOG.debug("EOF of {}", new Object[]{this});
            }
            return IteratingCallback.Action.SUCCEEDED;
        }

        @Override
        protected void onCompleteSuccess() {
            super.onCompleteSuccess();
            if (this._complete) {
                HttpOutput.this.closed();
            }
        }
    }

    private class AsyncFlush
    extends AsyncICB {
        protected volatile boolean _flushed;

        protected IteratingCallback.Action process() {
            if (BufferUtil.hasContent((ByteBuffer)HttpOutput.this._aggregate)) {
                this._flushed = true;
                HttpOutput.this.write(HttpOutput.this._aggregate, false, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (!this._flushed) {
                this._flushed = true;
                HttpOutput.this.write(BufferUtil.EMPTY_BUFFER, false, (Callback)this);
                return IteratingCallback.Action.SCHEDULED;
            }
            return IteratingCallback.Action.SUCCEEDED;
        }
    }

    private abstract class AsyncICB
    extends IteratingCallback {
        private AsyncICB() {
        }

        /*
         * Unable to fully structure code
         */
        protected void onCompleteSuccess() {
            block5: while (true) {
                var1_1 = (OutputState)HttpOutput.access$200(HttpOutput.this).get();
                switch (3.$SwitchMap$org$eclipse$jetty$server$HttpOutput$OutputState[var1_1.ordinal()]) {
                    case 6: {
                        if (HttpOutput.access$200(HttpOutput.this).compareAndSet(OutputState.PENDING, OutputState.ASYNC)) break block5;
                        continue block5;
                    }
                    case 2: {
                        if (HttpOutput.access$200(HttpOutput.this).compareAndSet(OutputState.UNREADY, OutputState.READY)) ** break;
                        continue block5;
                        if (!HttpOutput.access$000(HttpOutput.this).getState().onWritePossible()) break block5;
                        HttpOutput.access$000(HttpOutput.this).execute(HttpOutput.access$000(HttpOutput.this));
                        break block5;
                    }
                    case 1: {
                        break block5;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                break;
            }
        }

        public void onCompleteFailure(Throwable throwable) {
            HttpOutput.this._onError = throwable == null ? new IOException() : throwable;
            if (HttpOutput.this._channel.getState().onWritePossible()) {
                HttpOutput.this._channel.execute(HttpOutput.this._channel);
            }
        }
    }

    private static enum OutputState {
        OPEN,
        ASYNC,
        READY,
        PENDING,
        UNREADY,
        ERROR,
        CLOSED;

    }

    public static interface Interceptor {
        public void write(ByteBuffer var1, boolean var2, Callback var3);

        public Interceptor getNextInterceptor();

        public boolean isOptimizedForDirectBuffers();
    }
}

