/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeoutException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpInput
extends ServletInputStream
implements Runnable {
    private static final Logger LOG = Log.getLogger(HttpInput.class);
    private static final Content EOF_CONTENT = new EofContent("EOF");
    private static final Content EARLY_EOF_CONTENT = new EofContent("EARLY_EOF");
    private final byte[] _oneByteBuffer = new byte[1];
    private final Queue<Content> _inputQ = new ArrayDeque<Content>();
    private final HttpChannelState _channelState;
    private ReadListener _listener;
    private State _state = STREAM;
    private long _contentConsumed;
    private long _blockingTimeoutAt = -1L;
    protected static final State STREAM = new State(){

        @Override
        public boolean blockForContent(HttpInput httpInput) {
            httpInput.blockForContent();
            return true;
        }

        public String toString() {
            return "STREAM";
        }
    };
    protected static final State ASYNC = new State(){

        @Override
        public int noContent() {
            return 0;
        }

        public String toString() {
            return "ASYNC";
        }
    };
    protected static final State EARLY_EOF = new EOFState(){

        @Override
        public int noContent() {
            throw new EofException("Early EOF");
        }

        public String toString() {
            return "EARLY_EOF";
        }
    };
    protected static final State EOF = new EOFState(){

        public String toString() {
            return "EOF";
        }
    };
    protected static final State AEOF = new EOFState(){

        public String toString() {
            return "AEOF";
        }
    };

    public HttpInput(HttpChannelState httpChannelState) {
        this._channelState = httpChannelState;
        if (this._channelState.getHttpChannel().getHttpConfiguration().getBlockingTimeout() > 0L) {
            this._blockingTimeoutAt = 0L;
        }
    }

    protected HttpChannelState getHttpChannelState() {
        return this._channelState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Queue<Content> queue = this._inputQ;
        synchronized (queue) {
            Content content = this._inputQ.poll();
            while (content != null) {
                content.failed(null);
                content = this._inputQ.poll();
            }
            this._listener = null;
            this._state = STREAM;
            this._contentConsumed = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        int n = 0;
        boolean bl = false;
        Queue<Content> queue = this._inputQ;
        synchronized (queue) {
            Content content = this._inputQ.peek();
            if (content == null) {
                try {
                    this.produceContent();
                }
                catch (IOException iOException) {
                    bl = this.failed(iOException);
                }
                content = this._inputQ.peek();
            }
            if (content != null) {
                n = this.remaining(content);
            }
        }
        if (bl) {
            this.wake();
        }
        return n;
    }

    private void wake() {
        this._channelState.getHttpChannel().getConnector().getExecutor().execute(this._channelState.getHttpChannel());
    }

    public int read() {
        int n = this.read(this._oneByteBuffer, 0, 1);
        if (n == 0) {
            throw new IllegalStateException("unready read=0");
        }
        return n < 0 ? -1 : this._oneByteBuffer[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) {
        Queue<Content> queue = this._inputQ;
        synchronized (queue) {
            if (this._blockingTimeoutAt >= 0L && !this.isAsync()) {
                this._blockingTimeoutAt = System.currentTimeMillis() + this.getHttpChannelState().getHttpChannel().getHttpConfiguration().getBlockingTimeout();
            }
            do {
                Content content;
                if ((content = this.nextContent()) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} read {} from {}", new Object[]{this, n2, content});
                }
                int n3 = this.get(content, byArray, n, n2);
                this.consumeNonContent();
                return n3;
            } while (this._state.blockForContent(this));
            return this._state.noContent();
        }
    }

    protected void produceContent() {
    }

    protected Content nextContent() {
        Content content = this.pollContent();
        if (content == null && !this.isFinished()) {
            this.produceContent();
            content = this.pollContent();
        }
        return content;
    }

    protected Content pollContent() {
        Content content = this._inputQ.peek();
        while (content != null && this.remaining(content) == 0) {
            this._inputQ.poll();
            content.succeeded();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} consumed {}", new Object[]{this, content});
            }
            if (content == EOF_CONTENT) {
                if (this._listener == null) {
                    this._state = EOF;
                } else {
                    this._state = AEOF;
                    boolean bl = this._channelState.onReadReady();
                    if (bl) {
                        this.wake();
                    }
                }
            } else if (content == EARLY_EOF_CONTENT) {
                this._state = EARLY_EOF;
            }
            content = this._inputQ.peek();
        }
        return content;
    }

    protected void consumeNonContent() {
        Content content = this._inputQ.peek();
        while (content != null && this.remaining(content) == 0 && !(content instanceof EofContent)) {
            this._inputQ.poll();
            content.succeeded();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} consumed {}", new Object[]{this, content});
            }
            content = this._inputQ.peek();
        }
    }

    protected Content nextReadable() {
        Content content = this.pollReadable();
        if (content == null && !this.isFinished()) {
            this.produceContent();
            content = this.pollReadable();
        }
        return content;
    }

    protected Content pollReadable() {
        Content content = this._inputQ.peek();
        while (content != null) {
            if (content == EOF_CONTENT || content == EARLY_EOF_CONTENT || this.remaining(content) > 0) {
                return content;
            }
            this._inputQ.poll();
            content.succeeded();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} consumed {}", new Object[]{this, content});
            }
            content = this._inputQ.peek();
        }
        return null;
    }

    protected int remaining(Content content) {
        return content.remaining();
    }

    protected int get(Content content, byte[] byArray, int n, int n2) {
        int n3 = Math.min(content.remaining(), n2);
        content.getContent().get(byArray, n, n3);
        this._contentConsumed += (long)n3;
        return n3;
    }

    protected void skip(Content content, int n) {
        int n2 = Math.min(content.remaining(), n);
        ByteBuffer byteBuffer = content.getContent();
        byteBuffer.position(byteBuffer.position() + n2);
        this._contentConsumed += (long)n2;
        if (n2 > 0 && !content.hasContent()) {
            this.pollContent();
        }
    }

    protected void blockForContent() {
        try {
            long l = 0L;
            if (this._blockingTimeoutAt >= 0L && (l = this._blockingTimeoutAt - System.currentTimeMillis()) <= 0L) {
                throw new TimeoutException();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} blocking for content timeout={} ...", new Object[]{this, l});
            }
            if (l > 0L) {
                this._inputQ.wait(l);
            } else {
                this._inputQ.wait();
            }
            if (this._blockingTimeoutAt > 0L && System.currentTimeMillis() >= this._blockingTimeoutAt) {
                throw new TimeoutException();
            }
        }
        catch (Throwable throwable) {
            throw (IOException)new InterruptedIOException().initCause(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addContent(Content content) {
        boolean bl = false;
        Queue<Content> queue = this._inputQ;
        synchronized (queue) {
            this._inputQ.offer(content);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} addContent {}", new Object[]{this, content});
            }
            if (this._listener == null) {
                this._inputQ.notify();
            } else {
                bl = this._channelState.onReadPossible();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasContent() {
        Queue<Content> queue = this._inputQ;
        synchronized (queue) {
            return this._inputQ.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock() {
        Queue<Content> queue = this._inputQ;
        synchronized (queue) {
            this._inputQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentConsumed() {
        Queue<Content> queue = this._inputQ;
        synchronized (queue) {
            return this._contentConsumed;
        }
    }

    public boolean earlyEOF() {
        return this.addContent(EARLY_EOF_CONTENT);
    }

    public boolean eof() {
        return this.addContent(EOF_CONTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consumeAll() {
        Queue<Content> queue = this._inputQ;
        synchronized (queue) {
            try {
                Content content;
                while (!this.isFinished() && (content = this.nextContent()) != null) {
                    this.skip(content, this.remaining(content));
                }
                return this.isFinished() && !this.isError();
            }
            catch (IOException iOException) {
                LOG.debug((Throwable)iOException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isError() {
        Queue<Content> queue = this._inputQ;
        synchronized (queue) {
            return this._state instanceof ErrorState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsync() {
        Queue<Content> queue = this._inputQ;
        synchronized (queue) {
            return this._state == ASYNC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Queue<Content> queue = this._inputQ;
        synchronized (queue) {
            return this._state instanceof EOFState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        try {
            Queue<Content> queue = this._inputQ;
            synchronized (queue) {
                if (this._listener == null) {
                    return true;
                }
                if (this._state instanceof EOFState) {
                    return true;
                }
                if (this.nextReadable() != null) {
                    return true;
                }
                this._channelState.onReadUnready();
            }
            return false;
        }
        catch (IOException iOException) {
            LOG.ignore((Throwable)iOException);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadListener(ReadListener readListener) {
        readListener = Objects.requireNonNull(readListener);
        boolean bl = false;
        try {
            Queue<Content> queue = this._inputQ;
            synchronized (queue) {
                boolean bl2;
                if (this._listener != null) {
                    throw new IllegalStateException("ReadListener already set");
                }
                if (this._state != STREAM) {
                    throw new IllegalStateException("State " + STREAM + " != " + this._state);
                }
                this._state = ASYNC;
                this._listener = readListener;
                boolean bl3 = bl2 = this.nextContent() != null;
                if (bl2) {
                    bl = this._channelState.onReadReady();
                } else {
                    this._channelState.onReadUnready();
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
        if (bl) {
            this.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean failed(Throwable throwable) {
        boolean bl = false;
        Queue<Content> queue = this._inputQ;
        synchronized (queue) {
            if (this._state instanceof ErrorState) {
                LOG.warn(throwable);
            } else {
                this._state = new ErrorState(throwable);
            }
            if (this._listener == null) {
                this._inputQ.notify();
            } else {
                bl = this._channelState.onReadPossible();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable throwable;
        ReadListener readListener;
        boolean bl = false;
        Queue<Content> queue = this._inputQ;
        synchronized (queue) {
            if (this._state == EOF) {
                return;
            }
            if (this._state == AEOF) {
                this._state = EOF;
                bl = true;
            }
            readListener = this._listener;
            throwable = this._state instanceof ErrorState ? ((ErrorState)this._state).getError() : null;
        }
        try {
            if (throwable != null) {
                this._channelState.getHttpChannel().getResponse().getHttpFields().add(HttpConnection.CONNECTION_CLOSE);
                readListener.onError(throwable);
            } else if (bl) {
                readListener.onAllDataRead();
            } else {
                readListener.onDataAvailable();
            }
        }
        catch (Throwable throwable2) {
            LOG.warn(throwable2.toString(), new Object[0]);
            LOG.debug(throwable2);
            try {
                if (bl || throwable == null) {
                    this._channelState.getHttpChannel().getResponse().getHttpFields().add(HttpConnection.CONNECTION_CLOSE);
                    readListener.onError(throwable2);
                }
            }
            catch (Throwable throwable3) {
                LOG.warn(throwable3.toString(), new Object[0]);
                LOG.debug(throwable3);
                throw new RuntimeIOException(throwable3);
            }
        }
    }

    public String toString() {
        return String.format("%s@%x[c=%d,s=%s]", this.getClass().getSimpleName(), this.hashCode(), this._contentConsumed, this._state);
    }

    protected class ErrorState
    extends EOFState {
        final Throwable _error;

        ErrorState(Throwable throwable) {
            this._error = throwable;
        }

        public Throwable getError() {
            return this._error;
        }

        @Override
        public int noContent() {
            if (this._error instanceof IOException) {
                throw (IOException)this._error;
            }
            throw new IOException(this._error);
        }

        public String toString() {
            return "ERROR:" + this._error;
        }
    }

    protected static class EOFState
    extends State {
        protected EOFState() {
        }
    }

    protected static abstract class State {
        protected State() {
        }

        public boolean blockForContent(HttpInput httpInput) {
            return false;
        }

        public int noContent() {
            return -1;
        }
    }

    public static class Content
    implements Callback {
        private final ByteBuffer _content;

        public Content(ByteBuffer byteBuffer) {
            this._content = byteBuffer;
        }

        public boolean isNonBlocking() {
            return true;
        }

        public ByteBuffer getContent() {
            return this._content;
        }

        public boolean hasContent() {
            return this._content.hasRemaining();
        }

        public int remaining() {
            return this._content.remaining();
        }

        public String toString() {
            return String.format("Content@%x{%s}", this.hashCode(), BufferUtil.toDetailString((ByteBuffer)this._content));
        }
    }

    public static class EofContent
    extends PoisonPillContent {
        EofContent(String string) {
            super(string);
        }
    }

    public static class PoisonPillContent
    extends Content {
        private final String _name;

        public PoisonPillContent(String string) {
            super(BufferUtil.EMPTY_BUFFER);
            this._name = string;
        }

        @Override
        public String toString() {
            return this._name;
        }
    }
}

