/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.TreeTrie;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="HTTP Configuration")
public class HttpConfiguration {
    public static final String SERVER_VERSION = "Jetty(" + Jetty.VERSION + ")";
    private final List<Customizer> _customizers = new CopyOnWriteArrayList<Customizer>();
    private final Trie<Boolean> _formEncodedMethods = new TreeTrie();
    private int _outputBufferSize = 32768;
    private int _outputAggregationSize = this._outputBufferSize / 4;
    private int _requestHeaderSize = 8192;
    private int _responseHeaderSize = 8192;
    private int _headerCacheSize = 512;
    private int _securePort;
    private long _blockingTimeout = -1L;
    private String _secureScheme = HttpScheme.HTTPS.asString();
    private boolean _sendServerVersion = true;
    private boolean _sendXPoweredBy = false;
    private boolean _sendDateHeader = true;
    private boolean _delayDispatchUntilContent = true;
    private boolean _persistentConnectionsEnabled = true;
    private int _maxErrorDispatches = 10;

    public HttpConfiguration() {
        this._formEncodedMethods.put(HttpMethod.POST.asString(), (Object)Boolean.TRUE);
        this._formEncodedMethods.put(HttpMethod.PUT.asString(), (Object)Boolean.TRUE);
    }

    public HttpConfiguration(HttpConfiguration httpConfiguration) {
        this._customizers.addAll(httpConfiguration._customizers);
        for (String string : httpConfiguration._formEncodedMethods.keySet()) {
            this._formEncodedMethods.put(string, (Object)Boolean.TRUE);
        }
        this._outputBufferSize = httpConfiguration._outputBufferSize;
        this._outputAggregationSize = httpConfiguration._outputAggregationSize;
        this._requestHeaderSize = httpConfiguration._requestHeaderSize;
        this._responseHeaderSize = httpConfiguration._responseHeaderSize;
        this._headerCacheSize = httpConfiguration._headerCacheSize;
        this._secureScheme = httpConfiguration._secureScheme;
        this._securePort = httpConfiguration._securePort;
        this._blockingTimeout = httpConfiguration._blockingTimeout;
        this._sendDateHeader = httpConfiguration._sendDateHeader;
        this._sendServerVersion = httpConfiguration._sendServerVersion;
        this._sendXPoweredBy = httpConfiguration._sendXPoweredBy;
        this._delayDispatchUntilContent = httpConfiguration._delayDispatchUntilContent;
        this._persistentConnectionsEnabled = httpConfiguration._persistentConnectionsEnabled;
        this._maxErrorDispatches = httpConfiguration._maxErrorDispatches;
    }

    public void addCustomizer(Customizer customizer) {
        this._customizers.add(customizer);
    }

    public List<Customizer> getCustomizers() {
        return this._customizers;
    }

    public <T> T getCustomizer(Class<T> clazz) {
        for (Customizer customizer : this._customizers) {
            if (!clazz.isAssignableFrom(customizer.getClass())) continue;
            return (T)customizer;
        }
        return null;
    }

    @ManagedAttribute(value="The size in bytes of the output buffer used to aggregate HTTP output")
    public int getOutputBufferSize() {
        return this._outputBufferSize;
    }

    @ManagedAttribute(value="The maximum size in bytes for HTTP output to be aggregated")
    public int getOutputAggregationSize() {
        return this._outputAggregationSize;
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for a HTTP request header")
    public int getRequestHeaderSize() {
        return this._requestHeaderSize;
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for a HTTP response header")
    public int getResponseHeaderSize() {
        return this._responseHeaderSize;
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for a HTTP header field cache")
    public int getHeaderCacheSize() {
        return this._headerCacheSize;
    }

    @ManagedAttribute(value="The port to which Integral or Confidential security constraints are redirected")
    public int getSecurePort() {
        return this._securePort;
    }

    @ManagedAttribute(value="The scheme with which Integral or Confidential security constraints are redirected")
    public String getSecureScheme() {
        return this._secureScheme;
    }

    @ManagedAttribute(value="True if HTTP/1 persistent connection are enabled")
    public boolean isPersistentConnectionsEnabled() {
        return this._persistentConnectionsEnabled;
    }

    @ManagedAttribute(value="Timeout in MS for blocking operations.")
    public long getBlockingTimeout() {
        return this._blockingTimeout;
    }

    public void setBlockingTimeout(long l) {
        this._blockingTimeout = l;
    }

    public void setPersistentConnectionsEnabled(boolean bl) {
        this._persistentConnectionsEnabled = bl;
    }

    public void setSendServerVersion(boolean bl) {
        this._sendServerVersion = bl;
    }

    @ManagedAttribute(value="if true, send the Server header in responses")
    public boolean getSendServerVersion() {
        return this._sendServerVersion;
    }

    public void writePoweredBy(Appendable appendable, String string, String string2) {
        if (this.getSendServerVersion()) {
            if (string != null) {
                appendable.append(string);
            }
            appendable.append(Jetty.POWERED_BY);
            if (string2 != null) {
                appendable.append(string2);
            }
        }
    }

    public void setSendXPoweredBy(boolean bl) {
        this._sendXPoweredBy = bl;
    }

    @ManagedAttribute(value="if true, send the X-Powered-By header in responses")
    public boolean getSendXPoweredBy() {
        return this._sendXPoweredBy;
    }

    public void setSendDateHeader(boolean bl) {
        this._sendDateHeader = bl;
    }

    @ManagedAttribute(value="if true, include the date in HTTP headers")
    public boolean getSendDateHeader() {
        return this._sendDateHeader;
    }

    public void setDelayDispatchUntilContent(boolean bl) {
        this._delayDispatchUntilContent = bl;
    }

    @ManagedAttribute(value="if true, delay the application dispatch until content is available")
    public boolean isDelayDispatchUntilContent() {
        return this._delayDispatchUntilContent;
    }

    public void setCustomizers(List<Customizer> list) {
        this._customizers.clear();
        this._customizers.addAll(list);
    }

    public void setOutputBufferSize(int n) {
        this._outputBufferSize = n;
        this.setOutputAggregationSize(n / 4);
    }

    public void setOutputAggregationSize(int n) {
        this._outputAggregationSize = n;
    }

    public void setRequestHeaderSize(int n) {
        this._requestHeaderSize = n;
    }

    public void setResponseHeaderSize(int n) {
        this._responseHeaderSize = n;
    }

    public void setHeaderCacheSize(int n) {
        this._headerCacheSize = n;
    }

    public void setSecurePort(int n) {
        this._securePort = n;
    }

    public void setSecureScheme(String string) {
        this._secureScheme = string;
    }

    public String toString() {
        return String.format("%s@%x{%d/%d,%d/%d,%s://:%d,%s}", this.getClass().getSimpleName(), this.hashCode(), this._outputBufferSize, this._outputAggregationSize, this._requestHeaderSize, this._responseHeaderSize, this._secureScheme, this._securePort, this._customizers);
    }

    public void setFormEncodedMethods(String ... stringArray) {
        this._formEncodedMethods.clear();
        for (String string : stringArray) {
            this.addFormEncodedMethod(string);
        }
    }

    public Set<String> getFormEncodedMethods() {
        return this._formEncodedMethods.keySet();
    }

    public void addFormEncodedMethod(String string) {
        this._formEncodedMethods.put(string, (Object)Boolean.TRUE);
    }

    public boolean isFormEncodedMethod(String string) {
        return Boolean.TRUE.equals(this._formEncodedMethods.get(string));
    }

    @ManagedAttribute(value="The maximum ERROR dispatches for a request for loop prevention (default 10)")
    public int getMaxErrorDispatches() {
        return this._maxErrorDispatches;
    }

    public void setMaxErrorDispatches(int n) {
        this._maxErrorDispatches = n;
    }

    public static interface ConnectionFactory {
        public HttpConfiguration getHttpConfiguration();
    }

    public static interface Customizer {
        public void customize(Connector var1, HttpConfiguration var2, Request var3);
    }
}

