/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannelState {
    private static final Logger LOG = Log.getLogger(HttpChannelState.class);
    private static final long DEFAULT_TIMEOUT = Long.getLong("org.eclipse.jetty.server.HttpChannelState.DEFAULT_TIMEOUT", 30000L);
    private final boolean DEBUG = LOG.isDebugEnabled();
    private final Locker _locker = new Locker();
    private final HttpChannel _channel;
    private List<AsyncListener> _asyncListeners;
    private State _state;
    private Async _async;
    private boolean _initial;
    private boolean _asyncReadPossible;
    private boolean _asyncReadUnready;
    private boolean _asyncWrite;
    private long _timeoutMs = DEFAULT_TIMEOUT;
    private AsyncContextEvent _event;

    protected HttpChannelState(HttpChannel httpChannel) {
        this._channel = httpChannel;
        this._state = State.IDLE;
        this._async = null;
        this._initial = true;
    }

    public State getState() {
        try (Locker.Lock lock = this._locker.lock();){
            State state = this._state;
            return state;
        }
    }

    public void addListener(AsyncListener asyncListener) {
        try (Locker.Lock lock = this._locker.lock();){
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(asyncListener);
        }
    }

    public void setTimeout(long l) {
        try (Locker.Lock lock = this._locker.lock();){
            this._timeoutMs = l;
        }
    }

    public long getTimeout() {
        try (Locker.Lock lock = this._locker.lock();){
            long l = this._timeoutMs;
            return l;
        }
    }

    public AsyncContextEvent getAsyncContextEvent() {
        try (Locker.Lock lock = this._locker.lock();){
            AsyncContextEvent asyncContextEvent = this._event;
            return asyncContextEvent;
        }
    }

    public String toString() {
        try (Locker.Lock lock = this._locker.lock();){
            Object[] objectArray = new Object[7];
            objectArray[0] = this.getClass().getSimpleName();
            objectArray[1] = this.hashCode();
            objectArray[2] = this._state;
            objectArray[3] = this._async;
            objectArray[4] = this._initial;
            objectArray[5] = this._asyncReadPossible ? (this._asyncReadUnready ? "PU" : "P!U") : (this._asyncReadUnready ? "!PU" : "!P!U");
            objectArray[6] = this._asyncWrite;
            String string = String.format("%s@%x{s=%s a=%s i=%b r=%s w=%b}", objectArray);
            return string;
        }
    }

    private String getStatusStringLocked() {
        return String.format("s=%s i=%b a=%s", new Object[]{this._state, this._initial, this._async});
    }

    public String getStatusString() {
        try (Locker.Lock lock = this._locker.lock();){
            String string = this.getStatusStringLocked();
            return string;
        }
    }

    protected Action handling() {
        if (this.DEBUG) {
            LOG.debug("{} handling {}", new Object[]{this, this._state});
        }
        Throwable throwable = null;
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._state) {
                case IDLE: {
                    this._initial = true;
                    this._state = State.DISPATCHED;
                    Action action = Action.DISPATCH;
                    return action;
                }
                case COMPLETING: {
                    Action action = Action.COMPLETE;
                    return action;
                }
                case COMPLETED: {
                    Action action = Action.TERMINATED;
                    return action;
                }
                case ASYNC_WOKEN: {
                    Enum enum_;
                    if (this._asyncReadPossible) {
                        this._state = State.ASYNC_IO;
                        this._asyncReadUnready = false;
                        Action action = Action.READ_CALLBACK;
                        return action;
                    }
                    if (this._asyncWrite) {
                        this._state = State.ASYNC_IO;
                        this._asyncWrite = false;
                        Action action = Action.WRITE_CALLBACK;
                        return action;
                    }
                    if (this._async != null) {
                        enum_ = this._async;
                        switch (4.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$Async[enum_.ordinal()]) {
                            case 1: {
                                this._state = State.COMPLETING;
                                Action action = Action.COMPLETE;
                                return action;
                            }
                            case 2: {
                                this._state = State.DISPATCHED;
                                this._async = null;
                                Action action = Action.ASYNC_DISPATCH;
                                return action;
                            }
                            case 3: {
                                break;
                            }
                            case 4: {
                                this._state = State.DISPATCHED;
                                this._async = null;
                                Action action = Action.ERROR_DISPATCH;
                                return action;
                            }
                            case 5: {
                                Action action = Action.WAIT;
                                return action;
                            }
                            case 6: {
                                this._state = State.DISPATCHED;
                                Action action = Action.ASYNC_ERROR;
                                return action;
                            }
                            default: {
                                throw new IllegalStateException(this.getStatusStringLocked());
                            }
                        }
                    }
                    enum_ = Action.WAIT;
                    return enum_;
                }
            }
            try {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void startAsync(final AsyncContextEvent asyncContextEvent) {
        List<AsyncListener> list;
        try (Object object = this._locker.lock();){
            if (this._state != State.DISPATCHED || this._async != null) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            this._async = Async.STARTED;
            this._event = asyncContextEvent;
            list = this._asyncListeners;
            this._asyncListeners = null;
        }
        if (list != null) {
            object = new Runnable(){

                @Override
                public void run() {
                    for (AsyncListener asyncListener : list) {
                        try {
                            asyncListener.onStartAsync((AsyncEvent)asyncContextEvent);
                        }
                        catch (Exception exception) {
                            LOG.warn((Throwable)exception);
                        }
                    }
                }

                public String toString() {
                    return "startAsync";
                }
            };
            this.runInContext(asyncContextEvent, (Runnable)object);
        }
    }

    protected void error(Throwable throwable) {
        try (Locker.Lock lock = this._locker.lock();){
            if (this._event != null) {
                this._event.addThrowable(throwable);
            }
            this._async = Async.ERRORING;
        }
    }

    protected Action unhandle() {
        Action action;
        AsyncContextEvent asyncContextEvent = null;
        boolean bl = false;
        if (this.DEBUG) {
            LOG.debug("{} unhandle {}", new Object[]{this, this._state});
        }
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._state) {
                case COMPLETING: 
                case COMPLETED: {
                    Action action2 = Action.TERMINATED;
                    return action2;
                }
                case ASYNC_IO: 
                case DISPATCHED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            if (this._async != null) {
                this._initial = false;
                switch (this._async) {
                    case COMPLETE: {
                        this._state = State.COMPLETING;
                        this._async = null;
                        action = Action.COMPLETE;
                        break;
                    }
                    case DISPATCH: {
                        this._state = State.DISPATCHED;
                        this._async = null;
                        action = Action.ASYNC_DISPATCH;
                        break;
                    }
                    case EXPIRED: {
                        this._state = State.DISPATCHED;
                        this._async = null;
                        action = Action.ERROR_DISPATCH;
                        break;
                    }
                    case STARTED: {
                        if (this._asyncReadUnready && this._asyncReadPossible) {
                            this._state = State.ASYNC_IO;
                            this._asyncReadUnready = false;
                            action = Action.READ_CALLBACK;
                            break;
                        }
                        if (this._asyncWrite) {
                            this._asyncWrite = false;
                            this._state = State.ASYNC_IO;
                            action = Action.WRITE_CALLBACK;
                            break;
                        }
                        asyncContextEvent = this._event;
                        bl = this._asyncReadUnready;
                        this._state = State.ASYNC_WAIT;
                        action = Action.WAIT;
                        break;
                    }
                    case EXPIRING: {
                        asyncContextEvent = this._event;
                        this._state = State.ASYNC_WAIT;
                        action = Action.WAIT;
                        break;
                    }
                    case ERRORING: {
                        this._state = State.DISPATCHED;
                        action = Action.ASYNC_ERROR;
                        break;
                    }
                    case ERRORED: {
                        this._state = State.DISPATCHED;
                        action = Action.ERROR_DISPATCH;
                        this._async = null;
                        break;
                    }
                    default: {
                        this._state = State.COMPLETING;
                        action = Action.COMPLETE;
                        break;
                    }
                }
            } else {
                this._state = State.COMPLETING;
                action = Action.COMPLETE;
            }
        }
        if (asyncContextEvent != null) {
            this.scheduleTimeout(asyncContextEvent);
        }
        if (bl) {
            this._channel.asyncReadFillInterested();
        }
        return action;
    }

    /*
     * Unable to fully structure code
     */
    public void dispatch(ServletContext var1_1, String var2_2) {
        block23: {
            var3_3 = false;
            var4_4 = null;
            var5_5 = this._locker.lock();
            var6_6 = null;
            try {
                var7_7 = false;
                var4_4 = this._event;
                switch (4.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$Async[this._async.ordinal()]) {
                    case 5: {
                        var7_7 = true;
                        break;
                    }
                    case 3: 
                    case 7: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException(this.getStatusStringLocked());
                    }
                }
                this._async = Async.DISPATCH;
                if (var1_1 != null) {
                    this._event.setDispatchContext(var1_1);
                }
                if (var2_2 != null) {
                    this._event.setDispatchPath(var2_2);
                }
                if (!var7_7) break block23;
                switch (4.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$State[this._state.ordinal()]) {
                    case 4: 
                    case 5: 
                    case 7: {
                        ** break;
lbl25:
                        // 1 sources

                        break;
                    }
                    case 6: {
                        this._state = State.ASYNC_WOKEN;
                        var3_3 = true;
                        ** break;
lbl30:
                        // 1 sources

                        break;
                    }
                    default: {
                        HttpChannelState.LOG.warn("async dispatched when complete {}", new Object[]{this});
                        break;
                    }
                }
            }
            catch (Throwable var7_9) {
                var6_6 = var7_9;
                throw var7_9;
            }
            finally {
                if (var5_5 != null) {
                    if (var6_6 != null) {
                        try {
                            var5_5.close();
                        }
                        catch (Throwable var7_8) {
                            var6_6.addSuppressed(var7_8);
                        }
                    } else {
                        var5_5.close();
                    }
                }
            }
        }
        this.cancelTimeout(var4_4);
        if (var3_3) {
            this.scheduleDispatch();
        }
    }

    protected void onTimeout() {
        List<AsyncListener> list;
        AsyncContextEvent asyncContextEvent;
        try (Object object = this._locker.lock();){
            if (this._async != Async.STARTED) {
                return;
            }
            this._async = Async.EXPIRING;
            asyncContextEvent = this._event;
            list = this._asyncListeners;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Async timeout {}", new Object[]{this});
        }
        if (list != null) {
            object = new Runnable(){

                @Override
                public void run() {
                    for (AsyncListener asyncListener : list) {
                        try {
                            asyncListener.onTimeout((AsyncEvent)asyncContextEvent);
                        }
                        catch (Exception exception) {
                            LOG.debug((Throwable)exception);
                            asyncContextEvent.addThrowable(exception);
                            HttpChannelState.this._channel.getRequest().setAttribute("javax.servlet.error.exception", asyncContextEvent.getThrowable());
                            break;
                        }
                    }
                }

                public String toString() {
                    return "onTimeout";
                }
            };
            this.runInContext(asyncContextEvent, (Runnable)object);
        }
        boolean bl = false;
        var4_3 = this._locker.lock();
        Throwable throwable = null;
        try {
            switch (this._async) {
                case EXPIRING: {
                    if (asyncContextEvent.getThrowable() == null) {
                        this._async = Async.EXPIRED;
                        this._event.addThrowable(new TimeoutException("Async API violation"));
                        break;
                    }
                    this._async = Async.ERRORING;
                    break;
                }
                case COMPLETE: 
                case DISPATCH: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this._state == State.ASYNC_WAIT) {
                this._state = State.ASYNC_WOKEN;
                bl = true;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (var4_3 != null) {
                if (throwable != null) {
                    try {
                        var4_3.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    var4_3.close();
                }
            }
        }
        if (bl) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatch after async timeout {}", new Object[]{this});
            }
            this.scheduleDispatch();
        }
    }

    public void complete() {
        boolean bl = false;
        AsyncContextEvent asyncContextEvent = null;
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl2 = false;
            asyncContextEvent = this._event;
            switch (this._async) {
                case STARTED: {
                    bl2 = true;
                    break;
                }
                case EXPIRING: 
                case ERRORED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            this._async = Async.COMPLETE;
            if (bl2 && this._state == State.ASYNC_WAIT) {
                bl = true;
                this._state = State.ASYNC_WOKEN;
            }
        }
        this.cancelTimeout(asyncContextEvent);
        if (bl) {
            this.runInContext(asyncContextEvent, this._channel);
        }
    }

    public void errorComplete() {
        try (Locker.Lock lock = this._locker.lock();){
            this._async = Async.COMPLETE;
            this._event.setDispatchContext(null);
            this._event.setDispatchPath(null);
        }
        this.cancelTimeout();
    }

    protected void onError() {
        AsyncContextEvent asyncContextEvent;
        List<AsyncListener> list;
        Throwable throwable = null;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._state != State.DISPATCHED) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            list = this._asyncListeners;
            asyncContextEvent = this._event;
            this._async = Async.ERRORED;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        if (asyncContextEvent != null && list != null) {
            asyncContextEvent.getSuppliedRequest().setAttribute("javax.servlet.error.exception", (Object)asyncContextEvent.getThrowable());
            asyncContextEvent.getSuppliedRequest().setAttribute("javax.servlet.error.message", (Object)asyncContextEvent.getThrowable().getMessage());
            for (AsyncListener asyncListener : list) {
                try {
                    asyncListener.onError((AsyncEvent)asyncContextEvent);
                }
                catch (Exception exception) {
                    LOG.info("Exception while invoking listener " + asyncListener, (Throwable)exception);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void onComplete() {
        var3_1 /* !! */  = this._locker.lock();
        var4_2 = null;
        try {
            switch (4.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$State[this._state.ordinal()]) {
                case 2: {
                    var1_3 = this._asyncListeners;
                    var2_4 = this._event;
                    this._state = State.COMPLETED;
                    this._async = null;
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
        }
        catch (Throwable var5_6) {
            var4_2 = var5_6;
            throw var5_6;
        }
        finally {
            if (var3_1 /* !! */  != null) {
                if (var4_2 != null) {
                    try {
                        var3_1 /* !! */ .close();
                    }
                    catch (Throwable var5_5) {
                        var4_2.addSuppressed(var5_5);
                    }
                } else {
                    var3_1 /* !! */ .close();
                }
            }
        }
        if (var2_4 != null) {
            if (var1_3 != null) {
                var3_1 /* !! */  = new Runnable(){

                    @Override
                    public void run() {
                        for (AsyncListener asyncListener : var1_3) {
                            try {
                                asyncListener.onComplete((AsyncEvent)var2_4);
                            }
                            catch (Exception exception) {
                                LOG.warn((Throwable)exception);
                            }
                        }
                    }

                    public String toString() {
                        return "onComplete";
                    }
                };
                this.runInContext(var2_4, (Runnable)var3_1 /* !! */ );
            }
            var2_4.completed();
        }
    }

    protected void recycle() {
        this.cancelTimeout();
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._state) {
                case ASYNC_IO: 
                case DISPATCHED: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                case UPGRADED: {
                    return;
                }
            }
            this._asyncListeners = null;
            this._state = State.IDLE;
            this._async = null;
            this._initial = true;
            this._asyncReadUnready = false;
            this._asyncReadPossible = false;
            this._asyncWrite = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
        }
    }

    public void upgrade() {
        this.cancelTimeout();
        try (Locker.Lock lock = this._locker.lock();){
            switch (this._state) {
                case IDLE: 
                case COMPLETED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            this._asyncListeners = null;
            this._state = State.UPGRADED;
            this._async = null;
            this._initial = true;
            this._asyncReadUnready = false;
            this._asyncReadPossible = false;
            this._asyncWrite = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
        }
    }

    protected void scheduleDispatch() {
        this._channel.execute(this._channel);
    }

    protected void scheduleTimeout(AsyncContextEvent asyncContextEvent) {
        Scheduler scheduler = this._channel.getScheduler();
        if (scheduler != null && this._timeoutMs > 0L) {
            asyncContextEvent.setTimeoutTask(scheduler.schedule((Runnable)asyncContextEvent, this._timeoutMs, TimeUnit.MILLISECONDS));
        }
    }

    protected void cancelTimeout() {
        AsyncContextEvent asyncContextEvent;
        try (Locker.Lock lock = this._locker.lock();){
            asyncContextEvent = this._event;
        }
        this.cancelTimeout(asyncContextEvent);
    }

    protected void cancelTimeout(AsyncContextEvent asyncContextEvent) {
        if (asyncContextEvent != null) {
            asyncContextEvent.cancelTimeoutTask();
        }
    }

    public boolean isIdle() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._state == State.IDLE;
            return bl;
        }
    }

    public boolean isExpired() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._async == Async.EXPIRED;
            return bl;
        }
    }

    public boolean isInitial() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._initial;
            return bl;
        }
    }

    public boolean isSuspended() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._state == State.ASYNC_WAIT || this._state == State.DISPATCHED && this._async == Async.STARTED;
            return bl;
        }
    }

    boolean isCompleting() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._state == State.COMPLETING;
            return bl;
        }
    }

    boolean isCompleted() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._state == State.COMPLETED;
            return bl;
        }
    }

    public boolean isAsyncStarted() {
        try (Locker.Lock lock = this._locker.lock();){
            if (this._state == State.DISPATCHED) {
                boolean bl = this._async != null;
                return bl;
            }
            boolean bl = this._async == Async.STARTED || this._async == Async.EXPIRING;
            return bl;
        }
    }

    public boolean isAsync() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = !this._initial || this._async != null;
            return bl;
        }
    }

    public Request getBaseRequest() {
        return this._channel.getRequest();
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    public ContextHandler getContextHandler() {
        AsyncContextEvent asyncContextEvent;
        try (Locker.Lock lock = this._locker.lock();){
            asyncContextEvent = this._event;
        }
        return this.getContextHandler(asyncContextEvent);
    }

    ContextHandler getContextHandler(AsyncContextEvent asyncContextEvent) {
        ContextHandler.Context context;
        if (asyncContextEvent != null && (context = (ContextHandler.Context)asyncContextEvent.getServletContext()) != null) {
            return context.getContextHandler();
        }
        return null;
    }

    public ServletResponse getServletResponse() {
        AsyncContextEvent asyncContextEvent;
        try (Locker.Lock lock = this._locker.lock();){
            asyncContextEvent = this._event;
        }
        return this.getServletResponse(asyncContextEvent);
    }

    public ServletResponse getServletResponse(AsyncContextEvent asyncContextEvent) {
        if (asyncContextEvent != null && asyncContextEvent.getSuppliedResponse() != null) {
            return asyncContextEvent.getSuppliedResponse();
        }
        return this._channel.getResponse();
    }

    void runInContext(AsyncContextEvent asyncContextEvent, Runnable runnable) {
        ContextHandler contextHandler = this.getContextHandler(asyncContextEvent);
        if (contextHandler == null) {
            runnable.run();
        } else {
            contextHandler.handle(this._channel.getRequest(), runnable);
        }
    }

    public Object getAttribute(String string) {
        return this._channel.getRequest().getAttribute(string);
    }

    public void removeAttribute(String string) {
        this._channel.getRequest().removeAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        this._channel.getRequest().setAttribute(string, object);
    }

    public void onReadUnready() {
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            if (!this._asyncReadUnready) {
                this._asyncReadUnready = true;
                this._asyncReadPossible = false;
                if (this._state == State.ASYNC_WAIT) {
                    bl = true;
                }
            }
        }
        if (bl) {
            this._channel.asyncReadFillInterested();
        }
    }

    public boolean onReadPossible() {
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._asyncReadPossible = true;
            if (this._state == State.ASYNC_WAIT && this._asyncReadUnready) {
                bl = true;
                this._state = State.ASYNC_WOKEN;
            }
        }
        return bl;
    }

    public boolean onReadReady() {
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._asyncReadUnready = true;
            this._asyncReadPossible = true;
            if (this._state == State.ASYNC_WAIT) {
                bl = true;
                this._state = State.ASYNC_WOKEN;
            }
        }
        return bl;
    }

    public boolean isReadPossible() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._asyncReadPossible;
            return bl;
        }
    }

    public boolean onWritePossible() {
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._asyncWrite = true;
            if (this._state == State.ASYNC_WAIT) {
                this._state = State.ASYNC_WOKEN;
                bl = true;
            }
        }
        return bl;
    }

    public static enum Async {
        STARTED,
        DISPATCH,
        COMPLETE,
        EXPIRING,
        EXPIRED,
        ERRORING,
        ERRORED;

    }

    public static enum Action {
        DISPATCH,
        ASYNC_DISPATCH,
        ERROR_DISPATCH,
        ASYNC_ERROR,
        WRITE_CALLBACK,
        READ_CALLBACK,
        COMPLETE,
        TERMINATED,
        WAIT;

    }

    public static enum State {
        IDLE,
        DISPATCHED,
        ASYNC_WAIT,
        ASYNC_WOKEN,
        ASYNC_IO,
        COMPLETING,
        COMPLETED,
        UPGRADED;

    }
}

