/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpInputOverHTTP;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

class HttpChannelOverHttp
extends HttpChannel
implements HttpParser.RequestHandler {
    private static final Logger LOG = Log.getLogger(HttpChannelOverHttp.class);
    private static final HttpField PREAMBLE_UPGRADE_H2C = new HttpField(HttpHeader.UPGRADE, "h2c");
    private final HttpFields _fields = new HttpFields();
    private final MetaData.Request _metadata = new MetaData.Request(this._fields);
    private final HttpConnection _httpConnection;
    private HttpField _connection;
    private HttpField _upgrade = null;
    private boolean _delayedForContent;
    private boolean _unknownExpectation = false;
    private boolean _expect100Continue = false;
    private boolean _expect102Processing = false;

    public HttpChannelOverHttp(HttpConnection httpConnection, Connector connector, HttpConfiguration httpConfiguration, EndPoint endPoint, HttpTransport httpTransport) {
        super(connector, httpConfiguration, endPoint, httpTransport);
        this._httpConnection = httpConnection;
        this._metadata.setURI(new HttpURI());
    }

    @Override
    protected HttpInput newHttpInput(HttpChannelState httpChannelState) {
        return new HttpInputOverHTTP(httpChannelState);
    }

    @Override
    public void recycle() {
        super.recycle();
        this._unknownExpectation = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        this._metadata.recycle();
        this._connection = null;
        this._fields.clear();
        this._upgrade = null;
    }

    @Override
    public boolean isExpecting100Continue() {
        return this._expect100Continue;
    }

    @Override
    public boolean isExpecting102Processing() {
        return this._expect102Processing;
    }

    public boolean startRequest(String string, String string2, HttpVersion httpVersion) {
        this._metadata.setMethod(string);
        if (HttpMethod.CONNECT.is(string)) {
            this._metadata.getURI().parseConnect(string2);
        } else {
            this._metadata.getURI().parse(string2);
        }
        this._metadata.setHttpVersion(httpVersion);
        this._unknownExpectation = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        return false;
    }

    public void parsedHeader(HttpField httpField) {
        HttpHeader httpHeader = httpField.getHeader();
        String string = httpField.getValue();
        if (httpHeader != null) {
            block0 : switch (httpHeader) {
                case CONNECTION: {
                    this._connection = httpField;
                    break;
                }
                case HOST: {
                    if (this._metadata.getURI().isAbsolute() || !(httpField instanceof HostPortHttpField)) break;
                    HostPortHttpField hostPortHttpField = (HostPortHttpField)httpField;
                    this._metadata.getURI().setAuthority(hostPortHttpField.getHost(), hostPortHttpField.getPort());
                    break;
                }
                case EXPECT: {
                    if (this._metadata.getVersion() != HttpVersion.HTTP_1_1) break;
                    HttpHeaderValue httpHeaderValue = (HttpHeaderValue)HttpHeaderValue.CACHE.get(string);
                    switch (httpHeaderValue == null ? HttpHeaderValue.UNKNOWN : httpHeaderValue) {
                        case CONTINUE: {
                            this._expect100Continue = true;
                            break block0;
                        }
                        case PROCESSING: {
                            this._expect102Processing = true;
                            break block0;
                        }
                    }
                    String[] stringArray = httpField.getValues();
                    block14: for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                        httpHeaderValue = (HttpHeaderValue)HttpHeaderValue.CACHE.get(stringArray[i].trim());
                        if (httpHeaderValue == null) {
                            this._unknownExpectation = true;
                            continue;
                        }
                        switch (httpHeaderValue) {
                            case CONTINUE: {
                                this._expect100Continue = true;
                                continue block14;
                            }
                            case PROCESSING: {
                                this._expect102Processing = true;
                                continue block14;
                            }
                            default: {
                                this._unknownExpectation = true;
                            }
                        }
                    }
                    break;
                }
                case UPGRADE: {
                    this._upgrade = httpField;
                    break;
                }
            }
        }
        this._fields.add(httpField);
    }

    @Override
    public void continue100(int n) {
        if (this.isExpecting100Continue()) {
            this._expect100Continue = false;
            if (n == 0) {
                if (this.getResponse().isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                boolean bl = this.sendResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!bl) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }

    public void earlyEOF() {
        if (this._metadata.getMethod() == null) {
            this._httpConnection.close();
        } else {
            this.onEarlyEOF();
        }
    }

    public boolean content(ByteBuffer byteBuffer) {
        HttpInput.Content content = this._httpConnection.newContent(byteBuffer);
        boolean bl = this.onContent(content) || this._delayedForContent;
        this._delayedForContent = false;
        return bl;
    }

    @Override
    public void asyncReadFillInterested() {
        this._httpConnection.asyncReadFillInterested();
    }

    public void badMessage(int n, String string) {
        this._httpConnection.getGenerator().setPersistent(false);
        try {
            this.onRequest(this._metadata);
        }
        catch (Exception exception) {
            LOG.ignore((Throwable)exception);
        }
        this.onBadMessage(n, string);
    }

    public boolean headerComplete() {
        boolean bl;
        switch (this._metadata.getVersion()) {
            case HTTP_1_0: {
                bl = this.getHttpConfiguration().isPersistentConnectionsEnabled() ? (this._connection != null ? (this._connection.contains(HttpHeaderValue.KEEP_ALIVE.asString()) ? true : this._fields.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString())) : false) : false;
                if (!bl) {
                    bl = HttpMethod.CONNECT.is(this._metadata.getMethod());
                }
                if (!bl) break;
                this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE);
                break;
            }
            case HTTP_1_1: {
                if (this._unknownExpectation) {
                    this.badMessage(417, null);
                    return false;
                }
                bl = this.getHttpConfiguration().isPersistentConnectionsEnabled() ? (this._connection != null ? (this._connection.contains(HttpHeaderValue.CLOSE.asString()) ? false : !this._fields.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) : true) : false;
                if (!bl) {
                    bl = HttpMethod.CONNECT.is(this._metadata.getMethod());
                }
                if (!bl) {
                    this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                }
                if (this._upgrade == null || !this.upgrade()) break;
                return true;
            }
            case HTTP_2: {
                this._upgrade = PREAMBLE_UPGRADE_H2C;
                if (HttpMethod.PRI.is(this._metadata.getMethod()) && "*".equals(this._metadata.getURI().toString()) && this._fields.size() == 0 && this.upgrade()) {
                    return true;
                }
                this.badMessage(426, null);
                return false;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (!bl) {
            this._httpConnection.getGenerator().setPersistent(false);
        }
        this.onRequest(this._metadata);
        this._delayedForContent = this.getHttpConfiguration().isDelayDispatchUntilContent() && this._httpConnection.getParser().getContentLength() > 0L && !this.isExpecting100Continue() && !this.isCommitted() && this._httpConnection.isRequestBufferEmpty();
        return !this._delayedForContent;
    }

    private boolean upgrade() {
        ConnectionFactory connectionFactory2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("upgrade {} {}", new Object[]{this, this._upgrade});
        }
        if (!(this._upgrade == PREAMBLE_UPGRADE_H2C || this._connection != null && this._connection.contains("upgrade"))) {
            throw new BadMessageException(400);
        }
        ConnectionFactory.Upgrading upgrading = null;
        for (ConnectionFactory connectionFactory2 : this.getConnector().getConnectionFactories()) {
            if (!(connectionFactory2 instanceof ConnectionFactory.Upgrading) || !connectionFactory2.getProtocols().contains(this._upgrade.getValue())) continue;
            upgrading = (ConnectionFactory.Upgrading)connectionFactory2;
            break;
        }
        if (upgrading == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No factory for {} in {}", new Object[]{this._upgrade, this.getConnector()});
            }
            return false;
        }
        HttpFields httpFields = new HttpFields();
        connectionFactory2 = upgrading.upgradeConnection(this.getConnector(), this.getEndPoint(), this._metadata, httpFields);
        if (connectionFactory2 == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Upgrade ignored for {} by {}", new Object[]{this._upgrade, upgrading});
            }
            return false;
        }
        try {
            if (this._upgrade != PREAMBLE_UPGRADE_H2C) {
                this.sendResponse(new MetaData.Response(HttpVersion.HTTP_1_1, 101, httpFields, 0L), null, true);
            }
        }
        catch (IOException iOException) {
            throw new BadMessageException(500, null, (Throwable)iOException);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Upgrade from {} to {}", new Object[]{this.getEndPoint().getConnection(), connectionFactory2});
        }
        this.getRequest().setAttribute("org.eclipse.jetty.server.HttpConnection.UPGRADE", connectionFactory2);
        this.getResponse().setStatus(101);
        this.getHttpTransport().onCompleted();
        return true;
    }

    @Override
    protected void handleException(Throwable throwable) {
        this._httpConnection.getGenerator().setPersistent(false);
        super.handleException(throwable);
    }

    @Override
    public void abort(Throwable throwable) {
        super.abort(throwable);
        this._httpConnection.getGenerator().setPersistent(false);
    }

    public boolean messageComplete() {
        return this.onRequestComplete();
    }

    public int getHeaderCacheSize() {
        return this.getHttpConfiguration().getHeaderCacheSize();
    }
}

