/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.QuietServletException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogCollection;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannel
implements Runnable,
HttpOutput.Interceptor {
    private static final Logger LOG = Log.getLogger(HttpChannel.class);
    private final AtomicBoolean _committed = new AtomicBoolean();
    private final AtomicInteger _requests = new AtomicInteger();
    private final Connector _connector;
    private final HttpConfiguration _configuration;
    private final EndPoint _endPoint;
    private final HttpTransport _transport;
    private final HttpChannelState _state;
    private final Request _request;
    private final Response _response;
    private MetaData.Response _committedMetaData;
    private RequestLog _requestLog;
    private long _written;

    public HttpChannel(Connector connector, HttpConfiguration httpConfiguration, EndPoint endPoint, HttpTransport httpTransport) {
        this._connector = connector;
        this._configuration = httpConfiguration;
        this._endPoint = endPoint;
        this._transport = httpTransport;
        this._state = new HttpChannelState(this);
        this._request = new Request(this, this.newHttpInput(this._state));
        this._response = new Response(this, this.newHttpOutput());
        RequestLog requestLog = this._requestLog = this._connector == null ? null : this._connector.getServer().getRequestLog();
        if (LOG.isDebugEnabled()) {
            LOG.debug("new {} -> {},{},{}", new Object[]{this, this._endPoint, this._endPoint.getConnection(), this._state});
        }
    }

    protected HttpInput newHttpInput(HttpChannelState httpChannelState) {
        return new HttpInput(httpChannelState);
    }

    protected HttpOutput newHttpOutput() {
        return new HttpOutput(this);
    }

    public HttpChannelState getState() {
        return this._state;
    }

    public long getBytesWritten() {
        return this._written;
    }

    public int getRequests() {
        return this._requests.get();
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpTransport getHttpTransport() {
        return this._transport;
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    public void setRequestLog(RequestLog requestLog) {
        this._requestLog = requestLog;
    }

    public void addRequestLog(RequestLog requestLog) {
        if (this._requestLog == null) {
            this._requestLog = requestLog;
        } else if (this._requestLog instanceof RequestLogCollection) {
            ((RequestLogCollection)this._requestLog).add(requestLog);
        } else {
            this._requestLog = new RequestLogCollection(this._requestLog, requestLog);
        }
    }

    public MetaData.Response getCommittedMetaData() {
        return this._committedMetaData;
    }

    public long getIdleTimeout() {
        return this._endPoint.getIdleTimeout();
    }

    public void setIdleTimeout(long l) {
        this._endPoint.setIdleTimeout(l);
    }

    public ByteBufferPool getByteBufferPool() {
        return this._connector.getByteBufferPool();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._configuration;
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return this.getHttpTransport().isOptimizedForDirectBuffers();
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    public InetSocketAddress getLocalAddress() {
        return this._endPoint.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this._endPoint.getRemoteAddress();
    }

    public void continue100(int n) {
        throw new UnsupportedOperationException();
    }

    public void recycle() {
        this._committed.set(false);
        this._request.recycle();
        this._response.recycle();
        this._committedMetaData = null;
        this._requestLog = this._connector == null ? null : this._connector.getServer().getRequestLog();
        this._written = 0L;
    }

    public void asyncReadFillInterested() {
    }

    @Override
    public void run() {
        this.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean handle() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} handle {} ", new Object[]{this, this._request.getHttpURI()});
        }
        HttpChannelState.Action action = this._state.handling();
        block25: while (!this.getServer().isStopped()) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} action {}", new Object[]{this, action});
                }
                switch (action) {
                    case TERMINATED: 
                    case WAIT: {
                        break block25;
                    }
                    case DISPATCH: {
                        if (!this._request.hasMetaData()) {
                            throw new IllegalStateException("state=" + this._state);
                        }
                        this._request.setHandled(false);
                        this._response.getHttpOutput().reopen();
                        List<HttpConfiguration.Customizer> list = this._configuration.getCustomizers();
                        if (!list.isEmpty()) {
                            for (HttpConfiguration.Customizer customizer : list) {
                                customizer.customize(this.getConnector(), this._configuration, this._request);
                            }
                        }
                        try {
                            this._request.setDispatcherType(DispatcherType.REQUEST);
                            this.getServer().handle(this);
                            break;
                        }
                        finally {
                            this._request.setDispatcherType(null);
                        }
                    }
                    case ASYNC_DISPATCH: {
                        this._request.setHandled(false);
                        this._response.getHttpOutput().reopen();
                        try {
                            this._request.setDispatcherType(DispatcherType.ASYNC);
                            this.getServer().handleAsync(this);
                            break;
                        }
                        finally {
                            this._request.setDispatcherType(null);
                        }
                    }
                    case ERROR_DISPATCH: {
                        String string;
                        void var4_11;
                        List<HttpConfiguration.Customizer> list = this._state.getAsyncContextEvent().getThrowable();
                        Object object2 = (Integer)this._request.getAttribute("org.eclipse.jetty.server.ERROR_DISPATCH");
                        object2 = object2 == null ? Integer.valueOf(1) : Integer.valueOf((Integer)object2 + 1);
                        this._request.setAttribute("org.eclipse.jetty.server.ERROR_DISPATCH", object2);
                        if ((Integer)object2 > this.getHttpConfiguration().getMaxErrorDispatches()) {
                            LOG.warn("ERROR_DISPATCH loop detected on {} {}", new Object[]{this._request, list});
                            try {
                                this._response.sendError(500);
                                break block25;
                            }
                            finally {
                                this._state.errorComplete();
                            }
                        }
                        this._request.setHandled(false);
                        this._response.resetBuffer();
                        this._response.getHttpOutput().reopen();
                        if (list == null || list instanceof TimeoutException) {
                            String string2 = "Async Timeout";
                        } else {
                            String string3 = HttpStatus.Code.INTERNAL_SERVER_ERROR.getMessage();
                            this._request.setAttribute("javax.servlet.error.exception", list);
                        }
                        this._request.setAttribute("javax.servlet.error.status_code", 500);
                        this._request.setAttribute("javax.servlet.error.message", var4_11);
                        this._request.setAttribute("javax.servlet.error.request_uri", this._request.getRequestURI());
                        this._response.setStatusWithReason(500, (String)var4_11);
                        ErrorHandler errorHandler = ErrorHandler.getErrorHandler(this.getServer(), this._state.getContextHandler());
                        if (errorHandler instanceof ErrorHandler.ErrorPageMapper && (string = ((ErrorHandler.ErrorPageMapper)((Object)errorHandler)).getErrorPage((HttpServletRequest)this._state.getAsyncContextEvent().getSuppliedRequest())) != null) {
                            this._state.getAsyncContextEvent().setDispatchPath(string);
                        }
                        try {
                            this._request.setDispatcherType(DispatcherType.ERROR);
                            this.getServer().handleAsync(this);
                            break;
                        }
                        finally {
                            this._request.setDispatcherType(null);
                        }
                    }
                    case READ_CALLBACK: {
                        List<HttpConfiguration.Customizer> list = this._state.getContextHandler();
                        if (list != null) {
                            ((ContextHandler)((Object)list)).handle(this._request, this._request.getHttpInput());
                            break;
                        }
                        this._request.getHttpInput().run();
                        break;
                    }
                    case WRITE_CALLBACK: {
                        List<HttpConfiguration.Customizer> list = this._state.getContextHandler();
                        if (list != null) {
                            ((ContextHandler)((Object)list)).handle(this._request, this._response.getHttpOutput());
                            break;
                        }
                        this._response.getHttpOutput().run();
                        break;
                    }
                    case ASYNC_ERROR: {
                        this._state.onError();
                        break;
                    }
                    case COMPLETE: {
                        if (!this._response.isCommitted() && !this._request.isHandled()) {
                            this._response.sendError(404);
                        } else {
                            this._response.closeOutput();
                        }
                        this._request.setHandled(true);
                        this._state.onComplete();
                        this.onCompleted();
                        break block25;
                    }
                    default: {
                        throw new IllegalStateException("state=" + this._state);
                    }
                }
            }
            catch (BadMessageException | EofException | QuietServletException object) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Throwable)object);
                }
                this.handleException((Throwable)object);
            }
            catch (Throwable throwable) {
                if ("ContinuationThrowable".equals(throwable.getClass().getSimpleName())) {
                    LOG.ignore(throwable);
                }
                if (this._connector.isStarted()) {
                    LOG.warn(String.valueOf(this._request.getHttpURI()), throwable);
                } else {
                    LOG.debug(String.valueOf(this._request.getHttpURI()), throwable);
                }
                this.handleException(throwable);
            }
            action = this._state.unhandle();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} handle exit, result {}", new Object[]{this, action});
        }
        boolean bl = action == HttpChannelState.Action.WAIT;
        return !bl;
    }

    protected void handleException(Throwable throwable) {
        block15: {
            if (this._state.isAsyncStarted()) {
                Throwable throwable2 = this._state.getAsyncContextEvent().getThrowable();
                if (throwable2 == null) {
                    this._state.error(throwable);
                } else {
                    throwable2.addSuppressed(throwable);
                    LOG.warn("Error while handling async error: ", throwable2);
                    this.abort(throwable);
                    this._state.errorComplete();
                }
            } else {
                try {
                    this._request.setHandled(true);
                    this._request.setAttribute("javax.servlet.error.exception", throwable);
                    this._request.setAttribute("javax.servlet.error.exception_type", throwable.getClass());
                    if (this.isCommitted()) {
                        this.abort(throwable);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Could not send response error 500, already committed", throwable);
                        }
                    } else {
                        this._response.setHeader(HttpHeader.CONNECTION.asString(), HttpHeaderValue.CLOSE.asString());
                        if (throwable instanceof BadMessageException) {
                            BadMessageException badMessageException = (BadMessageException)throwable;
                            this._response.sendError(badMessageException.getCode(), badMessageException.getReason());
                        } else if (throwable instanceof UnavailableException) {
                            if (((UnavailableException)throwable).isPermanent()) {
                                this._response.sendError(404);
                            } else {
                                this._response.sendError(503);
                            }
                        } else {
                            this._response.sendError(500);
                        }
                    }
                }
                catch (Throwable throwable3) {
                    this.abort(throwable3);
                    if (!LOG.isDebugEnabled()) break block15;
                    LOG.debug("Could not commit response error 500", throwable3);
                }
            }
        }
    }

    public boolean isExpecting100Continue() {
        return false;
    }

    public boolean isExpecting102Processing() {
        return false;
    }

    public String toString() {
        return String.format("%s@%x{r=%s,c=%b,a=%s,uri=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._requests, this._committed.get(), this._state.getState(), this._request.getHttpURI()});
    }

    public void onRequest(MetaData.Request request) {
        this._requests.incrementAndGet();
        this._request.setTimeStamp(System.currentTimeMillis());
        HttpFields httpFields = this._response.getHttpFields();
        if (this._configuration.getSendDateHeader() && !httpFields.contains(HttpHeader.DATE)) {
            httpFields.put(this._connector.getServer().getDateField());
        }
        this._request.setMetaData(request);
    }

    public boolean onContent(HttpInput.Content content) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} content {}", new Object[]{this, content});
        }
        return this._request.getHttpInput().addContent(content);
    }

    public boolean onRequestComplete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onRequestComplete", new Object[]{this});
        }
        return this._request.getHttpInput().eof();
    }

    public void onCompleted() {
        if (this._requestLog != null) {
            this._requestLog.log(this._request, this._response);
        }
        this._transport.onCompleted();
    }

    public boolean onEarlyEOF() {
        return this._request.getHttpInput().earlyEOF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBadMessage(int n, String string) {
        if (n < 400 || n > 599) {
            n = 400;
        }
        try {
            if (this._state.handling() == HttpChannelState.Action.DISPATCH) {
                ByteBuffer byteBuffer = null;
                HttpFields httpFields = new HttpFields();
                ErrorHandler errorHandler = (ErrorHandler)this.getServer().getBean(ErrorHandler.class);
                if (errorHandler != null) {
                    byteBuffer = errorHandler.badMessageError(n, string, httpFields);
                }
                this.sendResponse(new MetaData.Response(HttpVersion.HTTP_1_1, n, string, httpFields, (long)BufferUtil.length((ByteBuffer)byteBuffer)), byteBuffer, true);
            }
        }
        catch (IOException iOException) {
            LOG.debug((Throwable)iOException);
        }
        finally {
            if (this._state.unhandle() != HttpChannelState.Action.COMPLETE) {
                throw new IllegalStateException();
            }
            this._state.onComplete();
            this.onCompleted();
        }
    }

    protected boolean sendResponse(MetaData.Response response, ByteBuffer byteBuffer, boolean bl, Callback callback) {
        boolean bl2 = this._committed.compareAndSet(false, true);
        if (bl2) {
            if (response == null) {
                response = this._response.newResponseMetaData();
            }
            this.commit(response);
            int n = response.getStatus();
            CommitCallback commitCallback = n < 200 && n >= 100 ? new Commit100Callback(callback) : new CommitCallback(callback);
            this._transport.send(response, this._request.isHead(), byteBuffer, bl, commitCallback);
        } else if (response == null) {
            this._transport.send(null, this._request.isHead(), byteBuffer, bl, callback);
        } else {
            callback.failed((Throwable)new IllegalStateException("committed"));
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sendResponse(MetaData.Response response, ByteBuffer byteBuffer, boolean bl) {
        try (SharedBlockingCallback.Blocker blocker = this._response.getHttpOutput().acquireWriteBlockingCallback();){
            boolean bl2 = this.sendResponse(response, byteBuffer, bl, (Callback)blocker);
            blocker.block();
            boolean bl3 = bl2;
            return bl3;
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(throwable);
            }
            this.abort(throwable);
            throw throwable;
        }
    }

    protected void commit(MetaData.Response response) {
        this._committedMetaData = response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Commit {} to {}", new Object[]{response, this});
        }
    }

    public boolean isCommitted() {
        return this._committed.get();
    }

    @Override
    public void write(ByteBuffer byteBuffer, boolean bl, Callback callback) {
        this._written += (long)BufferUtil.length((ByteBuffer)byteBuffer);
        this.sendResponse(null, byteBuffer, bl, callback);
    }

    @Override
    public HttpOutput.Interceptor getNextInterceptor() {
        return null;
    }

    protected void execute(Runnable runnable) {
        this._connector.getExecutor().execute(runnable);
    }

    public Scheduler getScheduler() {
        return this._connector.getScheduler();
    }

    public boolean useDirectBuffers() {
        return this.getEndPoint() instanceof ChannelEndPoint;
    }

    public void abort(Throwable throwable) {
        this._transport.abort(throwable);
    }

    private class Commit100Callback
    extends CommitCallback {
        private Commit100Callback(Callback callback) {
            super(callback);
        }

        @Override
        public void succeeded() {
            if (HttpChannel.this._committed.compareAndSet(true, false)) {
                super.succeeded();
            } else {
                super.failed(new IllegalStateException());
            }
        }
    }

    private class CommitCallback
    implements Callback {
        private final Callback _callback;

        private CommitCallback(Callback callback) {
            this._callback = callback;
        }

        public boolean isNonBlocking() {
            return this._callback.isNonBlocking();
        }

        public void succeeded() {
            this._callback.succeeded();
        }

        public void failed(final Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Commit failed", throwable);
            }
            if (throwable instanceof EofException || throwable instanceof ClosedChannelException) {
                this._callback.failed(throwable);
                HttpChannel.this._response.getHttpOutput().closed();
            } else {
                HttpChannel.this._transport.send(HttpGenerator.RESPONSE_500_INFO, false, null, true, new Callback(){

                    public void succeeded() {
                        CommitCallback.this._callback.failed(throwable);
                        HttpChannel.this._response.getHttpOutput().closed();
                    }

                    public void failed(Throwable throwable2) {
                        CommitCallback.this._callback.failed(throwable);
                        HttpChannel.this._response.getHttpOutput().closed();
                    }
                });
            }
        }
    }
}

