/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.net.InetSocketAddress;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;

public class ForwardedRequestCustomizer
implements HttpConfiguration.Customizer {
    private HostPortHttpField _hostHeader;
    private String _forwardedHostHeader = HttpHeader.X_FORWARDED_HOST.toString();
    private String _forwardedServerHeader = HttpHeader.X_FORWARDED_SERVER.toString();
    private String _forwardedForHeader = HttpHeader.X_FORWARDED_FOR.toString();
    private String _forwardedProtoHeader = HttpHeader.X_FORWARDED_PROTO.toString();
    private String _forwardedCipherSuiteHeader;
    private String _forwardedSslSessionIdHeader;

    public String getHostHeader() {
        return this._hostHeader.getValue();
    }

    public void setHostHeader(String string) {
        this._hostHeader = new HostPortHttpField(string);
    }

    public String getForwardedHostHeader() {
        return this._forwardedHostHeader;
    }

    public void setForwardedHostHeader(String string) {
        this._forwardedHostHeader = string;
    }

    public String getForwardedServerHeader() {
        return this._forwardedServerHeader;
    }

    public void setForwardedServerHeader(String string) {
        this._forwardedServerHeader = string;
    }

    public String getForwardedForHeader() {
        return this._forwardedForHeader;
    }

    public void setForwardedForHeader(String string) {
        this._forwardedForHeader = string;
    }

    public String getForwardedProtoHeader() {
        return this._forwardedProtoHeader;
    }

    public void setForwardedProtoHeader(String string) {
        this._forwardedProtoHeader = string;
    }

    public String getForwardedCipherSuiteHeader() {
        return this._forwardedCipherSuiteHeader;
    }

    public void setForwardedCipherSuiteHeader(String string) {
        this._forwardedCipherSuiteHeader = string;
    }

    public String getForwardedSslSessionIdHeader() {
        return this._forwardedSslSessionIdHeader;
    }

    public void setForwardedSslSessionIdHeader(String string) {
        this._forwardedSslSessionIdHeader = string;
    }

    @Override
    public void customize(Connector connector, HttpConfiguration httpConfiguration, Request request) {
        String string;
        HttpFields httpFields = request.getHttpFields();
        if (this.getForwardedCipherSuiteHeader() != null && (string = httpFields.get(this.getForwardedCipherSuiteHeader())) != null) {
            request.setAttribute("javax.servlet.request.cipher_suite", string);
        }
        if (this.getForwardedSslSessionIdHeader() != null && (string = httpFields.get(this.getForwardedSslSessionIdHeader())) != null) {
            request.setAttribute("javax.servlet.request.ssl_session_id", string);
            request.setScheme(HttpScheme.HTTPS.asString());
        }
        string = this.getLeftMostFieldValue(httpFields, this.getForwardedHostHeader());
        String string2 = this.getLeftMostFieldValue(httpFields, this.getForwardedServerHeader());
        String string3 = this.getLeftMostFieldValue(httpFields, this.getForwardedForHeader());
        String string4 = this.getLeftMostFieldValue(httpFields, this.getForwardedProtoHeader());
        if (this._hostHeader != null) {
            httpFields.put((HttpField)this._hostHeader);
            request.setAuthority(this._hostHeader.getHost(), this._hostHeader.getPort());
        } else if (string != null) {
            HostPortHttpField hostPortHttpField = new HostPortHttpField(string);
            httpFields.put((HttpField)hostPortHttpField);
            request.setAuthority(hostPortHttpField.getHost(), hostPortHttpField.getPort());
        } else if (string2 != null) {
            request.setAuthority(string2, request.getServerPort());
        }
        if (string3 != null) {
            request.setRemoteAddr(InetSocketAddress.createUnresolved(string3, request.getRemotePort()));
        }
        if (string4 != null) {
            request.setScheme(string4);
            if (string4.equals(httpConfiguration.getSecureScheme())) {
                request.setSecure(true);
            }
        }
    }

    protected String getLeftMostFieldValue(HttpFields httpFields, String string) {
        if (string == null) {
            return null;
        }
        String string2 = httpFields.get(string);
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(44);
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n);
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

