/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpWriter;

public class EncodingHttpWriter
extends HttpWriter {
    final Writer _converter;

    public EncodingHttpWriter(HttpOutput httpOutput, String string) {
        super(httpOutput);
        try {
            this._converter = new OutputStreamWriter((OutputStream)this._bytes, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        HttpOutput httpOutput = this._out;
        if (n2 == 0 && httpOutput.isAllContentWritten()) {
            httpOutput.close();
            return;
        }
        while (n2 > 0) {
            this._bytes.reset();
            int n3 = n2 > 512 ? 512 : n2;
            this._converter.write(cArray, n, n3);
            this._converter.flush();
            this._bytes.writeTo((OutputStream)((Object)httpOutput));
            n2 -= n3;
            n += n3;
        }
    }
}

