/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.ServletRequestHttpWrapper;
import org.eclipse.jetty.server.ServletResponseHttpWrapper;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.MultiMap;

public class Dispatcher
implements RequestDispatcher {
    public static final String __INCLUDE_PREFIX = "javax.servlet.include.";
    public static final String __FORWARD_PREFIX = "javax.servlet.forward.";
    private final ContextHandler _contextHandler;
    private final HttpURI _uri;
    private final String _pathInContext;
    private final String _named;

    public Dispatcher(ContextHandler contextHandler, HttpURI httpURI, String string) {
        this._contextHandler = contextHandler;
        this._uri = httpURI;
        this._pathInContext = string;
        this._named = null;
    }

    public Dispatcher(ContextHandler contextHandler, String string) {
        this._contextHandler = contextHandler;
        this._uri = null;
        this._pathInContext = null;
        this._named = string;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) {
        this.forward(servletRequest, servletResponse, DispatcherType.FORWARD);
    }

    public void error(ServletRequest servletRequest, ServletResponse servletResponse) {
        this.forward(servletRequest, servletResponse, DispatcherType.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest object, ServletResponse object2) {
        Request request = Request.getBaseRequest(object);
        if (!(object instanceof HttpServletRequest)) {
            object = new ServletRequestHttpWrapper((ServletRequest)object);
        }
        if (!(object2 instanceof HttpServletResponse)) {
            object2 = new ServletResponseHttpWrapper((ServletResponse)object2);
        }
        DispatcherType dispatcherType = request.getDispatcherType();
        Attributes attributes = request.getAttributes();
        MultiMap<String> multiMap = request.getQueryParameters();
        try {
            request.setDispatcherType(DispatcherType.INCLUDE);
            request.getResponse().include();
            if (this._named != null) {
                this._contextHandler.handle(this._named, request, (HttpServletRequest)object, (HttpServletResponse)object2);
            } else {
                IncludeAttributes includeAttributes = new IncludeAttributes(attributes);
                includeAttributes._requestURI = this._uri.getPath();
                includeAttributes._contextPath = this._contextHandler.getContextPath();
                includeAttributes._servletPath = null;
                includeAttributes._pathInfo = this._pathInContext;
                includeAttributes._query = this._uri.getQuery();
                if (includeAttributes._query != null) {
                    request.mergeQueryParameters(request.getQueryString(), includeAttributes._query, false);
                }
                request.setAttributes(includeAttributes);
                this._contextHandler.handle(this._pathInContext, request, (HttpServletRequest)object, (HttpServletResponse)object2);
            }
        }
        finally {
            request.setAttributes(attributes);
            request.getResponse().included();
            request.setQueryParameters(multiMap);
            request.resetParameters();
            request.setDispatcherType(dispatcherType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forward(ServletRequest object, ServletResponse object2, DispatcherType dispatcherType) {
        Request request = Request.getBaseRequest(object);
        Response response = request.getResponse();
        response.resetForForward();
        if (!(object instanceof HttpServletRequest)) {
            object = new ServletRequestHttpWrapper((ServletRequest)object);
        }
        if (!(object2 instanceof HttpServletResponse)) {
            object2 = new ServletResponseHttpWrapper((ServletResponse)object2);
        }
        boolean bl = request.isHandled();
        HttpURI httpURI = request.getHttpURI();
        String string = request.getContextPath();
        String string2 = request.getServletPath();
        String string3 = request.getPathInfo();
        MultiMap<String> multiMap = request.getQueryParameters();
        Attributes attributes = request.getAttributes();
        DispatcherType dispatcherType2 = request.getDispatcherType();
        try {
            request.setHandled(false);
            request.setDispatcherType(dispatcherType);
            if (this._named != null) {
                this._contextHandler.handle(this._named, request, (HttpServletRequest)object, (HttpServletResponse)object2);
            } else {
                ForwardAttributes forwardAttributes = new ForwardAttributes(attributes);
                if (attributes.getAttribute("javax.servlet.forward.request_uri") != null) {
                    forwardAttributes._pathInfo = (String)attributes.getAttribute("javax.servlet.forward.path_info");
                    forwardAttributes._query = (String)attributes.getAttribute("javax.servlet.forward.query_string");
                    forwardAttributes._requestURI = (String)attributes.getAttribute("javax.servlet.forward.request_uri");
                    forwardAttributes._contextPath = (String)attributes.getAttribute("javax.servlet.forward.context_path");
                    forwardAttributes._servletPath = (String)attributes.getAttribute("javax.servlet.forward.servlet_path");
                } else {
                    forwardAttributes._pathInfo = string3;
                    forwardAttributes._query = httpURI.getQuery();
                    forwardAttributes._requestURI = httpURI.getPath();
                    forwardAttributes._contextPath = string;
                    forwardAttributes._servletPath = string2;
                }
                HttpURI httpURI2 = new HttpURI(httpURI.getScheme(), httpURI.getHost(), httpURI.getPort(), this._uri.getPath(), this._uri.getParam(), this._uri.getQuery(), this._uri.getFragment());
                request.setHttpURI(httpURI2);
                request.setContextPath(this._contextHandler.getContextPath());
                request.setServletPath(null);
                request.setPathInfo(this._pathInContext);
                if (this._uri.getQuery() != null || httpURI.getQuery() != null) {
                    request.mergeQueryParameters(httpURI.getQuery(), this._uri.getQuery(), true);
                }
                request.setAttributes(forwardAttributes);
                this._contextHandler.handle(this._pathInContext, request, (HttpServletRequest)object, (HttpServletResponse)object2);
                if (!request.getHttpChannelState().isAsync()) {
                    this.commitResponse((ServletResponse)object2, request);
                }
            }
        }
        finally {
            request.setHandled(bl);
            request.setHttpURI(httpURI);
            request.setContextPath(string);
            request.setServletPath(string2);
            request.setPathInfo(string3);
            request.setQueryParameters(multiMap);
            request.resetParameters();
            request.setAttributes(attributes);
            request.setDispatcherType(dispatcherType2);
        }
    }

    @Deprecated
    public void push(ServletRequest servletRequest) {
        Request request = Request.getBaseRequest(servletRequest);
        HttpFields httpFields = new HttpFields(request.getHttpFields());
        String string = request.getQueryString();
        if (this._uri.hasQuery()) {
            string = string == null ? this._uri.getQuery() : string + "&" + this._uri.getQuery();
        }
        HttpURI httpURI = HttpURI.createHttpURI((String)servletRequest.getScheme(), (String)servletRequest.getServerName(), (int)servletRequest.getServerPort(), (String)this._uri.getPath(), (String)request.getHttpURI().getParam(), (String)string, null);
        MetaData.Request request2 = new MetaData.Request(HttpMethod.GET.asString(), httpURI, request.getHttpVersion(), httpFields);
        request.getHttpChannel().getHttpTransport().push(request2);
    }

    public String toString() {
        return String.format("Dispatcher@0x%x{%s,%s}", this.hashCode(), this._named, this._uri);
    }

    private void commitResponse(ServletResponse servletResponse, Request request) {
        if (request.getResponse().isWriting()) {
            try {
                servletResponse.getWriter().close();
            }
            catch (IllegalStateException illegalStateException) {
                servletResponse.getOutputStream().close();
            }
        } else {
            try {
                servletResponse.getOutputStream().close();
            }
            catch (IllegalStateException illegalStateException) {
                servletResponse.getWriter().close();
            }
        }
    }

    private class IncludeAttributes
    implements Attributes {
        final Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        IncludeAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        public Object getAttribute(String string) {
            if (Dispatcher.this._named == null) {
                if (string.equals("javax.servlet.include.path_info")) {
                    return this._pathInfo;
                }
                if (string.equals("javax.servlet.include.servlet_path")) {
                    return this._servletPath;
                }
                if (string.equals("javax.servlet.include.context_path")) {
                    return this._contextPath;
                }
                if (string.equals("javax.servlet.include.query_string")) {
                    return this._query;
                }
                if (string.equals("javax.servlet.include.request_uri")) {
                    return this._requestURI;
                }
            } else if (string.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attr.getAttribute(string);
        }

        public Enumeration<String> getAttributeNames() {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = this._attr.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.startsWith(Dispatcher.__INCLUDE_PREFIX)) continue;
                hashSet.add(string);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    hashSet.add("javax.servlet.include.path_info");
                } else {
                    hashSet.remove("javax.servlet.include.path_info");
                }
                hashSet.add("javax.servlet.include.request_uri");
                hashSet.add("javax.servlet.include.servlet_path");
                hashSet.add("javax.servlet.include.context_path");
                if (this._query != null) {
                    hashSet.add("javax.servlet.include.query_string");
                } else {
                    hashSet.remove("javax.servlet.include.query_string");
                }
            }
            return Collections.enumeration(hashSet);
        }

        public void setAttribute(String string, Object object) {
            if (Dispatcher.this._named == null && string.startsWith("javax.servlet.")) {
                if (string.equals("javax.servlet.include.path_info")) {
                    this._pathInfo = (String)object;
                } else if (string.equals("javax.servlet.include.request_uri")) {
                    this._requestURI = (String)object;
                } else if (string.equals("javax.servlet.include.servlet_path")) {
                    this._servletPath = (String)object;
                } else if (string.equals("javax.servlet.include.context_path")) {
                    this._contextPath = (String)object;
                } else if (string.equals("javax.servlet.include.query_string")) {
                    this._query = (String)object;
                } else if (object == null) {
                    this._attr.removeAttribute(string);
                } else {
                    this._attr.setAttribute(string, object);
                }
            } else if (object == null) {
                this._attr.removeAttribute(string);
            } else {
                this._attr.setAttribute(string, object);
            }
        }

        public String toString() {
            return "INCLUDE+" + this._attr.toString();
        }

        public void clearAttributes() {
            throw new IllegalStateException();
        }

        public void removeAttribute(String string) {
            this.setAttribute(string, null);
        }
    }

    private class ForwardAttributes
    implements Attributes {
        final Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        ForwardAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        public Object getAttribute(String string) {
            if (Dispatcher.this._named == null) {
                if (string.equals("javax.servlet.forward.path_info")) {
                    return this._pathInfo;
                }
                if (string.equals("javax.servlet.forward.request_uri")) {
                    return this._requestURI;
                }
                if (string.equals("javax.servlet.forward.servlet_path")) {
                    return this._servletPath;
                }
                if (string.equals("javax.servlet.forward.context_path")) {
                    return this._contextPath;
                }
                if (string.equals("javax.servlet.forward.query_string")) {
                    return this._query;
                }
            }
            if (string.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attr.getAttribute(string);
        }

        public Enumeration<String> getAttributeNames() {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = this._attr.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.startsWith(Dispatcher.__INCLUDE_PREFIX) || string.startsWith(Dispatcher.__FORWARD_PREFIX)) continue;
                hashSet.add(string);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    hashSet.add("javax.servlet.forward.path_info");
                } else {
                    hashSet.remove("javax.servlet.forward.path_info");
                }
                hashSet.add("javax.servlet.forward.request_uri");
                hashSet.add("javax.servlet.forward.servlet_path");
                hashSet.add("javax.servlet.forward.context_path");
                if (this._query != null) {
                    hashSet.add("javax.servlet.forward.query_string");
                } else {
                    hashSet.remove("javax.servlet.forward.query_string");
                }
            }
            return Collections.enumeration(hashSet);
        }

        public void setAttribute(String string, Object object) {
            if (Dispatcher.this._named == null && string.startsWith("javax.servlet.")) {
                if (string.equals("javax.servlet.forward.path_info")) {
                    this._pathInfo = (String)object;
                } else if (string.equals("javax.servlet.forward.request_uri")) {
                    this._requestURI = (String)object;
                } else if (string.equals("javax.servlet.forward.servlet_path")) {
                    this._servletPath = (String)object;
                } else if (string.equals("javax.servlet.forward.context_path")) {
                    this._contextPath = (String)object;
                } else if (string.equals("javax.servlet.forward.query_string")) {
                    this._query = (String)object;
                } else if (object == null) {
                    this._attr.removeAttribute(string);
                } else {
                    this._attr.setAttribute(string, object);
                }
            } else if (object == null) {
                this._attr.removeAttribute(string);
            } else {
                this._attr.setAttribute(string, object);
            }
        }

        public String toString() {
            return "FORWARD+" + this._attr.toString();
        }

        public void clearAttributes() {
            throw new IllegalStateException();
        }

        public void removeAttribute(String string) {
            this.setAttribute(string, null);
        }
    }
}

