/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.EventListener;
import java.util.Locale;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Debug Listener")
public class DebugListener
extends AbstractLifeCycle
implements ServletContextListener {
    private static final Logger LOG = Log.getLogger(DebugListener.class);
    private static final DateCache __date = new DateCache("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    private final String _attr = String.format("__R%s@%x", ((Object)((Object)this)).getClass().getSimpleName(), System.identityHashCode((Object)this));
    private final PrintStream _out;
    private boolean _renameThread;
    private boolean _showHeaders;
    private boolean _dumpContext;
    final AsyncListener _asyncListener = new AsyncListener(){

        public void onTimeout(AsyncEvent asyncEvent) {
            String string = DebugListener.this.findContextName(((AsyncContextEvent)asyncEvent).getServletContext());
            String string2 = DebugListener.this.findRequestName(asyncEvent.getAsyncContext().getRequest());
            DebugListener.this.log("!  ctx=%s r=%s onTimeout %s", string, string2, ((AsyncContextEvent)asyncEvent).getHttpChannelState());
        }

        public void onStartAsync(AsyncEvent asyncEvent) {
            String string = DebugListener.this.findContextName(((AsyncContextEvent)asyncEvent).getServletContext());
            String string2 = DebugListener.this.findRequestName(asyncEvent.getAsyncContext().getRequest());
            DebugListener.this.log("!  ctx=%s r=%s onStartAsync %s", string, string2, ((AsyncContextEvent)asyncEvent).getHttpChannelState());
        }

        public void onError(AsyncEvent asyncEvent) {
            String string = DebugListener.this.findContextName(((AsyncContextEvent)asyncEvent).getServletContext());
            String string2 = DebugListener.this.findRequestName(asyncEvent.getAsyncContext().getRequest());
            DebugListener.this.log("!! ctx=%s r=%s onError %s %s", string, string2, asyncEvent.getThrowable(), ((AsyncContextEvent)asyncEvent).getHttpChannelState());
        }

        public void onComplete(AsyncEvent asyncEvent) {
            AsyncContextEvent asyncContextEvent = (AsyncContextEvent)asyncEvent;
            String string = DebugListener.this.findContextName(asyncContextEvent.getServletContext());
            String string2 = DebugListener.this.findRequestName(asyncContextEvent.getAsyncContext().getRequest());
            Request request = Request.getBaseRequest(asyncContextEvent.getAsyncContext().getRequest());
            Response response = request.getResponse();
            String string3 = DebugListener.this._showHeaders ? "\n" + response.getHttpFields().toString() : "";
            DebugListener.this.log("!  ctx=%s r=%s onComplete %s %d%s", string, string2, asyncContextEvent.getHttpChannelState(), response.getStatus(), string3);
        }
    };
    final ServletRequestListener _servletRequestListener = new ServletRequestListener(){

        public void requestInitialized(ServletRequestEvent servletRequestEvent) {
            String string = DebugListener.this.findContextName(servletRequestEvent.getServletContext());
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequestEvent.getServletRequest();
            String string2 = DebugListener.this.findRequestName((ServletRequest)httpServletRequest);
            DispatcherType dispatcherType = httpServletRequest.getDispatcherType();
            if (dispatcherType == DispatcherType.REQUEST) {
                Request request = Request.getBaseRequest((ServletRequest)httpServletRequest);
                String string3 = DebugListener.this._showHeaders ? "\n" + request.getMetaData().getFields().toString() : "";
                StringBuffer stringBuffer = httpServletRequest.getRequestURL();
                if (httpServletRequest.getQueryString() != null) {
                    stringBuffer.append('?').append(httpServletRequest.getQueryString());
                }
                DebugListener.this.log(">> %s ctx=%s r=%s %s %s %s %s %s%s", dispatcherType, string, string2, dispatcherType, httpServletRequest.getMethod(), stringBuffer.toString(), httpServletRequest.getProtocol(), request.getHttpChannel(), string3);
            } else {
                DebugListener.this.log(">> %s ctx=%s r=%s", dispatcherType, string, string2);
            }
        }

        public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
            String string = DebugListener.this.findContextName(servletRequestEvent.getServletContext());
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequestEvent.getServletRequest();
            String string2 = DebugListener.this.findRequestName((ServletRequest)httpServletRequest);
            DispatcherType dispatcherType = httpServletRequest.getDispatcherType();
            if (servletRequestEvent.getServletRequest().isAsyncStarted()) {
                servletRequestEvent.getServletRequest().getAsyncContext().addListener(DebugListener.this._asyncListener);
                DebugListener.this.log("<< %s ctx=%s r=%s async=true", dispatcherType, string, string2);
            } else {
                Request request = Request.getBaseRequest((ServletRequest)httpServletRequest);
                String string3 = DebugListener.this._showHeaders ? "\n" + request.getResponse().getHttpFields().toString() : "";
                DebugListener.this.log("<< %s ctx=%s r=%s async=false %d%s", dispatcherType, string, string2, Request.getBaseRequest((ServletRequest)httpServletRequest).getResponse().getStatus(), string3);
            }
        }
    };
    final ContextHandler.ContextScopeListener _contextScopeListener = new ContextHandler.ContextScopeListener(){

        @Override
        public void enterScope(ContextHandler.Context context, Request request, Object object) {
            String string = DebugListener.this.findContextName(context);
            if (request == null) {
                DebugListener.this.log(">  ctx=%s %s", string, object);
            } else {
                String string2 = DebugListener.this.findRequestName((ServletRequest)request);
                if (DebugListener.this._renameThread) {
                    Thread thread = Thread.currentThread();
                    thread.setName(String.format("%s#%s", thread.getName(), string2));
                }
                DebugListener.this.log(">  ctx=%s r=%s %s", string, string2, object);
            }
        }

        @Override
        public void exitScope(ContextHandler.Context context, Request request) {
            String string = DebugListener.this.findContextName(context);
            if (request == null) {
                DebugListener.this.log("<  ctx=%s", string);
            } else {
                Thread thread;
                String string2 = DebugListener.this.findRequestName((ServletRequest)request);
                DebugListener.this.log("<  ctx=%s r=%s", string, string2);
                if (DebugListener.this._renameThread && (thread = Thread.currentThread()).getName().endsWith(string2)) {
                    thread.setName(thread.getName().substring(0, thread.getName().length() - string2.length() - 1));
                }
            }
        }
    };

    public DebugListener() {
        this(null, false, false, false);
    }

    public DebugListener(@Name(value="renameThread") boolean bl, @Name(value="showHeaders") boolean bl2, @Name(value="dumpContext") boolean bl3) {
        this(null, bl, bl2, bl3);
    }

    public DebugListener(@Name(value="outputStream") OutputStream outputStream, @Name(value="renameThread") boolean bl, @Name(value="showHeaders") boolean bl2, @Name(value="dumpContext") boolean bl3) {
        this._out = outputStream == null ? null : new PrintStream(outputStream);
        this._renameThread = bl;
        this._showHeaders = bl2;
        this._dumpContext = bl3;
    }

    @ManagedAttribute(value="Rename thread within context scope")
    public boolean isRenameThread() {
        return this._renameThread;
    }

    public void setRenameThread(boolean bl) {
        this._renameThread = bl;
    }

    @ManagedAttribute(value="Show request headers")
    public boolean isShowHeaders() {
        return this._showHeaders;
    }

    public void setShowHeaders(boolean bl) {
        this._showHeaders = bl;
    }

    @ManagedAttribute(value="Dump contexts at start")
    public boolean isDumpContext() {
        return this._dumpContext;
    }

    public void setDumpContext(boolean bl) {
        this._dumpContext = bl;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        servletContextEvent.getServletContext().addListener((EventListener)this._servletRequestListener);
        ContextHandler contextHandler = ContextHandler.getContextHandler(servletContextEvent.getServletContext());
        contextHandler.addEventListener(this._contextScopeListener);
        String string = this.findContextName(servletContextEvent.getServletContext());
        this.log("^  ctx=%s %s", string, servletContextEvent.getServletContext());
        if (this._dumpContext) {
            if (this._out == null) {
                contextHandler.dumpStdErr();
            } else {
                try {
                    contextHandler.dump(this._out);
                }
                catch (Exception exception) {
                    LOG.warn((Throwable)exception);
                }
            }
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        String string = this.findContextName(servletContextEvent.getServletContext());
        this.log("v  ctx=%s %s", string, servletContextEvent.getServletContext());
    }

    protected String findContextName(ServletContext servletContext) {
        if (servletContext == null) {
            return null;
        }
        String string = (String)servletContext.getAttribute(this._attr);
        if (string == null) {
            string = String.format("%s@%x", servletContext.getContextPath(), servletContext.hashCode());
            servletContext.setAttribute(this._attr, (Object)string);
        }
        return string;
    }

    protected String findRequestName(ServletRequest servletRequest) {
        if (servletRequest == null) {
            return null;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String string = (String)servletRequest.getAttribute(this._attr);
        if (string == null) {
            string = String.format("%s@%x", httpServletRequest.getRequestURI(), servletRequest.hashCode());
            servletRequest.setAttribute(this._attr, (Object)string);
        }
        return string;
    }

    protected void log(String string, Object ... objectArray) {
        if (!this.isRunning()) {
            return;
        }
        String string2 = String.format(string, objectArray);
        long l = System.currentTimeMillis();
        long l2 = l % 1000L;
        if (this._out != null) {
            this._out.printf("%s.%03d:%s%n", __date.formatNow(l), l2, string2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.info(string2, new Object[0]);
        }
    }
}

