/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.Cookie;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class CookieCutter {
    private static final Logger LOG = Log.getLogger(CookieCutter.class);
    private Cookie[] _cookies;
    private Cookie[] _lastCookies;
    private final List<String> _fieldList = new ArrayList<String>();
    int _fields;

    public Cookie[] getCookies() {
        if (this._cookies != null) {
            return this._cookies;
        }
        if (this._lastCookies != null && this._fields == this._fieldList.size()) {
            this._cookies = this._lastCookies;
        } else {
            this.parseFields();
        }
        this._lastCookies = this._cookies;
        return this._cookies;
    }

    public void setCookies(Cookie[] cookieArray) {
        this._cookies = cookieArray;
        this._lastCookies = null;
        this._fieldList.clear();
        this._fields = 0;
    }

    public void reset() {
        this._cookies = null;
        this._fields = 0;
    }

    public void addCookieField(String string) {
        if (string == null) {
            return;
        }
        if ((string = string.trim()).length() == 0) {
            return;
        }
        if (this._fieldList.size() > this._fields) {
            if (string.equals(this._fieldList.get(this._fields))) {
                ++this._fields;
                return;
            }
            while (this._fieldList.size() > this._fields) {
                this._fieldList.remove(this._fields);
            }
        }
        this._cookies = null;
        this._lastCookies = null;
        this._fieldList.add(this._fields++, string);
    }

    protected void parseFields() {
        this._lastCookies = null;
        this._cookies = null;
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        int n = 0;
        while (this._fieldList.size() > this._fields) {
            this._fieldList.remove(this._fields);
        }
        for (String string : this._fieldList) {
            String string2 = null;
            String string3 = null;
            Cookie cookie = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = -1;
            int n3 = -1;
            int n4 = string.length();
            int n5 = n4 - 1;
            block19: for (int i = 0; i < n4; ++i) {
                block46: {
                    char c;
                    block45: {
                        c = string.charAt(i);
                        if (!bl2) break block45;
                        if (bl3) {
                            bl3 = false;
                            continue;
                        }
                        switch (c) {
                            case '\"': {
                                n3 = i;
                                bl2 = false;
                                if (i == n5) {
                                    if (bl) {
                                        string3 = string.substring(n2, n3 + 1);
                                    } else {
                                        string2 = string.substring(n2, n3 + 1);
                                        string3 = "";
                                    }
                                }
                                break block46;
                            }
                            case '\\': {
                                bl3 = true;
                                break;
                            }
                        }
                        continue;
                    }
                    if (bl) {
                        switch (c) {
                            case '\t': 
                            case ' ': {
                                continue block19;
                            }
                            case '\"': {
                                if (n2 < 0) {
                                    bl2 = true;
                                    n2 = i;
                                }
                                n3 = i;
                                if (i != n5) continue block19;
                                string3 = string.substring(n2, n3 + 1);
                                break;
                            }
                            case ';': {
                                string3 = n2 >= 0 ? string.substring(n2, n3 + 1) : "";
                                n2 = -1;
                                bl = false;
                                break;
                            }
                            default: {
                                if (n2 < 0) {
                                    n2 = i;
                                }
                                n3 = i;
                                if (i != n5) continue block19;
                                string3 = string.substring(n2, n3 + 1);
                                break;
                            }
                        }
                    } else {
                        switch (c) {
                            case '\t': 
                            case ' ': {
                                continue block19;
                            }
                            case '\"': {
                                if (n2 < 0) {
                                    bl2 = true;
                                    n2 = i;
                                }
                                n3 = i;
                                if (i != n5) continue block19;
                                string2 = string.substring(n2, n3 + 1);
                                string3 = "";
                                break;
                            }
                            case ';': {
                                if (n2 >= 0) {
                                    string2 = string.substring(n2, n3 + 1);
                                    string3 = "";
                                }
                                n2 = -1;
                                break;
                            }
                            case '=': {
                                if (n2 >= 0) {
                                    string2 = string.substring(n2, n3 + 1);
                                }
                                n2 = -1;
                                bl = true;
                                continue block19;
                            }
                            default: {
                                if (n2 < 0) {
                                    n2 = i;
                                }
                                n3 = i;
                                if (i != n5) continue block19;
                                string2 = string.substring(n2, n3 + 1);
                                string3 = "";
                            }
                        }
                    }
                }
                if (string3 == null || string2 == null) continue;
                string2 = QuotedStringTokenizer.unquoteOnly((String)string2);
                string3 = QuotedStringTokenizer.unquoteOnly((String)string3);
                try {
                    if (string2.startsWith("$")) {
                        String string4 = string2.toLowerCase(Locale.ENGLISH);
                        if ("$path".equals(string4)) {
                            if (cookie != null) {
                                cookie.setPath(string3);
                            }
                        } else if ("$domain".equals(string4)) {
                            if (cookie != null) {
                                cookie.setDomain(string3);
                            }
                        } else if ("$port".equals(string4)) {
                            if (cookie != null) {
                                cookie.setComment("$port=" + string3);
                            }
                        } else if ("$version".equals(string4)) {
                            n = Integer.parseInt(string3);
                        }
                    } else {
                        cookie = new Cookie(string2, string3);
                        if (n > 0) {
                            cookie.setVersion(n);
                        }
                        arrayList.add(cookie);
                    }
                }
                catch (Exception exception) {
                    LOG.debug((Throwable)exception);
                }
                string2 = null;
                string3 = null;
            }
        }
        this._cookies = arrayList.toArray(new Cookie[arrayList.size()]);
        this._lastCookies = this._cookies;
    }
}

