/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;

public class ClassLoaderDump
implements Dumpable {
    final ClassLoader _loader;

    public ClassLoaderDump(ClassLoader classLoader) {
        this._loader = classLoader;
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable appendable, String string) {
        if (this._loader == null) {
            appendable.append("No ClassLoader\n");
        } else {
            appendable.append(String.valueOf(this._loader)).append("\n");
            ClassLoader classLoader = this._loader.getParent();
            if (classLoader != null) {
                if (this._loader instanceof URLClassLoader) {
                    ContainerLifeCycle.dump((Appendable)appendable, (String)string, (Collection[])new Collection[]{TypeUtil.asList((Object[])((URLClassLoader)this._loader).getURLs()), Collections.singleton(classLoader.toString())});
                } else {
                    ContainerLifeCycle.dump((Appendable)appendable, (String)string, (Collection[])new Collection[]{Collections.singleton(classLoader.toString())});
                }
            }
        }
    }
}

