/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AsyncNCSARequestLog
extends NCSARequestLog {
    private static final Logger LOG = Log.getLogger(AsyncNCSARequestLog.class);
    private final BlockingQueue<String> _queue;
    private transient WriterThread _thread;
    private boolean _warnedFull;

    public AsyncNCSARequestLog() {
        this(null, null);
    }

    public AsyncNCSARequestLog(BlockingQueue<String> blockingQueue) {
        this(null, blockingQueue);
    }

    public AsyncNCSARequestLog(String string) {
        this(string, null);
    }

    public AsyncNCSARequestLog(String string, BlockingQueue<String> blockingArrayQueue) {
        super(string);
        if (blockingArrayQueue == null) {
            blockingArrayQueue = new BlockingArrayQueue(1024);
        }
        this._queue = blockingArrayQueue;
    }

    @Override
    protected synchronized void doStart() {
        super.doStart();
        this._thread = new WriterThread();
        this._thread.start();
    }

    @Override
    protected void doStop() {
        this._thread.interrupt();
        this._thread.join();
        super.doStop();
        this._thread = null;
    }

    @Override
    public void write(String string) {
        if (!this._queue.offer(string)) {
            if (this._warnedFull) {
                LOG.warn("Log Queue overflow", new Object[0]);
            }
            this._warnedFull = true;
        }
    }

    private class WriterThread
    extends Thread {
        WriterThread() {
            this.setName("AsyncNCSARequestLog@" + Integer.toString(AsyncNCSARequestLog.this.hashCode(), 16));
        }

        @Override
        public void run() {
            while (AsyncNCSARequestLog.this.isRunning()) {
                try {
                    String string = (String)AsyncNCSARequestLog.this._queue.poll(10L, TimeUnit.SECONDS);
                    if (string != null) {
                        AsyncNCSARequestLog.super.write(string);
                    }
                    while (!AsyncNCSARequestLog.this._queue.isEmpty()) {
                        string = (String)AsyncNCSARequestLog.this._queue.poll();
                        if (string == null) continue;
                        AsyncNCSARequestLog.super.write(string);
                    }
                }
                catch (IOException iOException) {
                    LOG.warn((Throwable)iOException);
                }
                catch (InterruptedException interruptedException) {
                    LOG.ignore((Throwable)interruptedException);
                }
            }
        }
    }
}

