/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.handler.ContextHandler;

public class AsyncContextState
implements AsyncContext {
    private final HttpChannel _channel;
    volatile HttpChannelState _state;

    public AsyncContextState(HttpChannelState httpChannelState) {
        this._state = httpChannelState;
        this._channel = this._state.getHttpChannel();
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    HttpChannelState state() {
        HttpChannelState httpChannelState = this._state;
        if (httpChannelState == null) {
            throw new IllegalStateException("AsyncContext completed");
        }
        return httpChannelState;
    }

    public void addListener(final AsyncListener asyncListener, final ServletRequest servletRequest, final ServletResponse servletResponse) {
        AsyncListener asyncListener2 = new AsyncListener(){

            public void onTimeout(AsyncEvent asyncEvent) {
                asyncListener.onTimeout(new AsyncEvent(asyncEvent.getAsyncContext(), servletRequest, servletResponse, asyncEvent.getThrowable()));
            }

            public void onStartAsync(AsyncEvent asyncEvent) {
                asyncListener.onStartAsync(new AsyncEvent(asyncEvent.getAsyncContext(), servletRequest, servletResponse, asyncEvent.getThrowable()));
            }

            public void onError(AsyncEvent asyncEvent) {
                asyncListener.onError(new AsyncEvent(asyncEvent.getAsyncContext(), servletRequest, servletResponse, asyncEvent.getThrowable()));
            }

            public void onComplete(AsyncEvent asyncEvent) {
                asyncListener.onComplete(new AsyncEvent(asyncEvent.getAsyncContext(), servletRequest, servletResponse, asyncEvent.getThrowable()));
            }
        };
        this.state().addListener(asyncListener2);
    }

    public void addListener(AsyncListener asyncListener) {
        this.state().addListener(asyncListener);
    }

    public void complete() {
        this.state().complete();
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) {
        ContextHandler contextHandler = this.state().getContextHandler();
        if (contextHandler != null) {
            return (T)((AsyncListener)contextHandler.getServletContext().createListener(clazz));
        }
        try {
            return (T)((AsyncListener)clazz.newInstance());
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    public void dispatch() {
        this.state().dispatch(null, null);
    }

    public void dispatch(String string) {
        this.state().dispatch(null, string);
    }

    public void dispatch(ServletContext servletContext, String string) {
        this.state().dispatch(servletContext, string);
    }

    public ServletRequest getRequest() {
        return this.state().getAsyncContextEvent().getSuppliedRequest();
    }

    public ServletResponse getResponse() {
        return this.state().getAsyncContextEvent().getSuppliedResponse();
    }

    public long getTimeout() {
        return this.state().getTimeout();
    }

    public boolean hasOriginalRequestAndResponse() {
        HttpChannel httpChannel = this.state().getHttpChannel();
        return httpChannel.getRequest() == this.getRequest() && httpChannel.getResponse() == this.getResponse();
    }

    public void setTimeout(long l) {
        this.state().setTimeout(l);
    }

    public void start(final Runnable runnable) {
        final HttpChannel httpChannel = this.state().getHttpChannel();
        httpChannel.execute(new Runnable(){

            @Override
            public void run() {
                AsyncContextState.this.state().getAsyncContextEvent().getContext().getContextHandler().handle(httpChannel.getRequest(), runnable);
            }
        });
    }

    public void reset() {
        this._state = null;
    }

    public HttpChannelState getHttpChannelState() {
        return this.state();
    }
}

