/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.thread.Scheduler;

public class AsyncContextEvent
extends AsyncEvent
implements Runnable {
    private final ContextHandler.Context _context;
    private final AsyncContextState _asyncContext;
    private volatile HttpChannelState _state;
    private ServletContext _dispatchContext;
    private String _dispatchPath;
    private volatile Scheduler.Task _timeoutTask;
    private Throwable _throwable;

    public AsyncContextEvent(ContextHandler.Context context, AsyncContextState asyncContextState, HttpChannelState httpChannelState, Request request, ServletRequest servletRequest, ServletResponse servletResponse) {
        super(null, servletRequest, servletResponse, null);
        this._context = context;
        this._asyncContext = asyncContextState;
        this._state = httpChannelState;
        if (request.getAttribute("javax.servlet.async.request_uri") == null) {
            String string = (String)request.getAttribute("javax.servlet.forward.request_uri");
            if (string != null) {
                request.setAttribute("javax.servlet.async.request_uri", string);
                request.setAttribute("javax.servlet.async.context_path", request.getAttribute("javax.servlet.forward.context_path"));
                request.setAttribute("javax.servlet.async.servlet_path", request.getAttribute("javax.servlet.forward.servlet_path"));
                request.setAttribute("javax.servlet.async.path_info", request.getAttribute("javax.servlet.forward.path_info"));
                request.setAttribute("javax.servlet.async.query_string", request.getAttribute("javax.servlet.forward.query_string"));
            } else {
                request.setAttribute("javax.servlet.async.request_uri", request.getRequestURI());
                request.setAttribute("javax.servlet.async.context_path", request.getContextPath());
                request.setAttribute("javax.servlet.async.servlet_path", request.getServletPath());
                request.setAttribute("javax.servlet.async.path_info", request.getPathInfo());
                request.setAttribute("javax.servlet.async.query_string", request.getQueryString());
            }
        }
    }

    public ServletContext getSuspendedContext() {
        return this._context;
    }

    public ContextHandler.Context getContext() {
        return this._context;
    }

    public ServletContext getDispatchContext() {
        return this._dispatchContext;
    }

    public ServletContext getServletContext() {
        return this._dispatchContext == null ? this._context : this._dispatchContext;
    }

    public String getPath() {
        return this._dispatchPath;
    }

    public void setTimeoutTask(Scheduler.Task task) {
        this._timeoutTask = task;
    }

    public void cancelTimeoutTask() {
        Scheduler.Task task = this._timeoutTask;
        this._timeoutTask = null;
        if (task != null) {
            task.cancel();
        }
    }

    public AsyncContext getAsyncContext() {
        return this._asyncContext;
    }

    public Throwable getThrowable() {
        return this._throwable;
    }

    public void setDispatchContext(ServletContext servletContext) {
        this._dispatchContext = servletContext;
    }

    public void setDispatchPath(String string) {
        this._dispatchPath = string;
    }

    public void completed() {
        this._timeoutTask = null;
        this._asyncContext.reset();
    }

    public HttpChannelState getHttpChannelState() {
        return this._state;
    }

    @Override
    public void run() {
        Scheduler.Task task = this._timeoutTask;
        this._timeoutTask = null;
        if (task != null) {
            this._state.onTimeout();
        }
    }

    public void addThrowable(Throwable throwable) {
        if (this._throwable == null) {
            this._throwable = throwable;
        } else {
            this._throwable.addSuppressed(throwable);
        }
    }
}

