/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.Cookie;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractNCSARequestLog
extends AbstractLifeCycle
implements RequestLog {
    protected static final Logger LOG = Log.getLogger(AbstractNCSARequestLog.class);
    private static ThreadLocal<StringBuilder> _buffers = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder(256);
        }
    };
    private String[] _ignorePaths;
    private boolean _extended;
    private transient PathMap<String> _ignorePathMap;
    private boolean _logLatency = false;
    private boolean _logCookies = false;
    private boolean _logServer = false;
    private boolean _preferProxiedForAddress;
    private transient DateCache _logDateCache;
    private String _logDateFormat = "dd/MMM/yyyy:HH:mm:ss Z";
    private Locale _logLocale = Locale.getDefault();
    private String _logTimeZone = "GMT";

    protected abstract boolean isEnabled();

    public abstract void write(String var1);

    private void append(StringBuilder stringBuilder, String string) {
        if (string == null || string.length() == 0) {
            stringBuilder.append('-');
        } else {
            stringBuilder.append(string);
        }
    }

    @Override
    public void log(Request request, Response response) {
        try {
            Object object;
            int n = response.getCommittedMetaData().getStatus();
            long l = response.getHttpChannel().getBytesWritten();
            if (this._ignorePathMap != null && this._ignorePathMap.getMatch(request.getRequestURI()) != null) {
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            StringBuilder stringBuilder = _buffers.get();
            stringBuilder.setLength(0);
            if (this._logServer) {
                this.append(stringBuilder, request.getServerName());
                stringBuilder.append(' ');
            }
            String string = null;
            if (this._preferProxiedForAddress) {
                string = request.getHeader(HttpHeader.X_FORWARDED_FOR.toString());
            }
            if (string == null) {
                string = request.getRemoteAddr();
            }
            stringBuilder.append(string);
            stringBuilder.append(" - ");
            Authentication authentication = request.getAuthentication();
            this.append(stringBuilder, authentication instanceof Authentication.User ? ((Authentication.User)authentication).getUserIdentity().getUserPrincipal().getName() : null);
            stringBuilder.append(" [");
            if (this._logDateCache != null) {
                stringBuilder.append(this._logDateCache.format(request.getTimeStamp()));
            } else {
                stringBuilder.append(request.getTimeStamp());
            }
            stringBuilder.append("] \"");
            this.append(stringBuilder, request.getMethod());
            stringBuilder.append(' ');
            this.append(stringBuilder, request.getHttpURI().toString());
            stringBuilder.append(' ');
            this.append(stringBuilder, request.getProtocol());
            stringBuilder.append("\" ");
            if (n >= 0) {
                stringBuilder.append((char)(48 + n / 100 % 10));
                stringBuilder.append((char)(48 + n / 10 % 10));
                stringBuilder.append((char)(48 + n % 10));
            } else {
                stringBuilder.append(n);
            }
            if (l >= 0L) {
                stringBuilder.append(' ');
                if (l > 99999L) {
                    stringBuilder.append(l);
                } else {
                    if (l > 9999L) {
                        stringBuilder.append((char)(48L + l / 10000L % 10L));
                    }
                    if (l > 999L) {
                        stringBuilder.append((char)(48L + l / 1000L % 10L));
                    }
                    if (l > 99L) {
                        stringBuilder.append((char)(48L + l / 100L % 10L));
                    }
                    if (l > 9L) {
                        stringBuilder.append((char)(48L + l / 10L % 10L));
                    }
                    stringBuilder.append((char)(48L + l % 10L));
                }
                stringBuilder.append(' ');
            } else {
                stringBuilder.append(" - ");
            }
            if (this._extended) {
                this.logExtended(request, stringBuilder);
            }
            if (this._logCookies) {
                object = request.getCookies();
                if (object == null || ((Cookie[])object).length == 0) {
                    stringBuilder.append(" -");
                } else {
                    stringBuilder.append(" \"");
                    for (int i = 0; i < ((Cookie[])object).length; ++i) {
                        if (i != 0) {
                            stringBuilder.append(';');
                        }
                        stringBuilder.append(object[i].getName());
                        stringBuilder.append('=');
                        stringBuilder.append(object[i].getValue());
                    }
                    stringBuilder.append('\"');
                }
            }
            if (this._logLatency) {
                long l2 = System.currentTimeMillis();
                if (this._logLatency) {
                    stringBuilder.append(' ');
                    stringBuilder.append(l2 - request.getTimeStamp());
                }
            }
            object = stringBuilder.toString();
            this.write((String)object);
        }
        catch (IOException iOException) {
            LOG.warn((Throwable)iOException);
        }
    }

    protected void logExtended(Request request, StringBuilder stringBuilder) {
        String string = request.getHeader(HttpHeader.REFERER.toString());
        if (string == null) {
            stringBuilder.append("\"-\" ");
        } else {
            stringBuilder.append('\"');
            stringBuilder.append(string);
            stringBuilder.append("\" ");
        }
        String string2 = request.getHeader(HttpHeader.USER_AGENT.toString());
        if (string2 == null) {
            stringBuilder.append("\"-\" ");
        } else {
            stringBuilder.append('\"');
            stringBuilder.append(string2);
            stringBuilder.append('\"');
        }
    }

    public void setIgnorePaths(String[] stringArray) {
        this._ignorePaths = stringArray;
    }

    public String[] getIgnorePaths() {
        return this._ignorePaths;
    }

    public void setLogCookies(boolean bl) {
        this._logCookies = bl;
    }

    public boolean getLogCookies() {
        return this._logCookies;
    }

    public void setLogServer(boolean bl) {
        this._logServer = bl;
    }

    public boolean getLogServer() {
        return this._logServer;
    }

    public void setLogLatency(boolean bl) {
        this._logLatency = bl;
    }

    public boolean getLogLatency() {
        return this._logLatency;
    }

    @Deprecated
    public void setLogDispatch(boolean bl) {
    }

    @Deprecated
    public boolean isLogDispatch() {
        return false;
    }

    public void setPreferProxiedForAddress(boolean bl) {
        this._preferProxiedForAddress = bl;
    }

    public boolean getPreferProxiedForAddress() {
        return this._preferProxiedForAddress;
    }

    public void setExtended(boolean bl) {
        this._extended = bl;
    }

    @ManagedAttribute(value="use extended NCSA format")
    public boolean isExtended() {
        return this._extended;
    }

    protected synchronized void doStart() {
        if (this._logDateFormat != null) {
            this._logDateCache = new DateCache(this._logDateFormat, this._logLocale, this._logTimeZone);
        }
        if (this._ignorePaths != null && this._ignorePaths.length > 0) {
            this._ignorePathMap = new PathMap();
            for (int i = 0; i < this._ignorePaths.length; ++i) {
                this._ignorePathMap.put(this._ignorePaths[i], (Object)this._ignorePaths[i]);
            }
        } else {
            this._ignorePathMap = null;
        }
        super.doStart();
    }

    protected void doStop() {
        this._logDateCache = null;
        super.doStop();
    }

    public void setLogDateFormat(String string) {
        this._logDateFormat = string;
    }

    public String getLogDateFormat() {
        return this._logDateFormat;
    }

    public void setLogLocale(Locale locale) {
        this._logLocale = locale;
    }

    public Locale getLogLocale() {
        return this._logLocale;
    }

    public void setLogTimeZone(String string) {
        this._logTimeZone = string;
    }

    @ManagedAttribute(value="the timezone")
    public String getLogTimeZone() {
        return this._logTimeZone;
    }
}

