/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject(value="Abstract implementation of the Connector Interface")
public abstract class AbstractConnector
extends ContainerLifeCycle
implements Connector,
Dumpable {
    protected final Logger LOG = Log.getLogger(this.getClass());
    private final Map<String, ConnectionFactory> _factories = new LinkedHashMap<String, ConnectionFactory>();
    private final Server _server;
    private final Executor _executor;
    private final Scheduler _scheduler;
    private final ByteBufferPool _byteBufferPool;
    private final Thread[] _acceptors;
    private final Set<EndPoint> _endpoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<EndPoint> _immutableEndPoints = Collections.unmodifiableSet(this._endpoints);
    private volatile CountDownLatch _stopping;
    private long _idleTimeout = 30000L;
    private String _defaultProtocol;
    private ConnectionFactory _defaultConnectionFactory;
    private String _name;
    private int _acceptorPriorityDelta;

    public AbstractConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool byteBufferPool, int n, ConnectionFactory ... connectionFactoryArray) {
        this._server = server;
        Executor executor2 = this._executor = executor != null ? executor : this._server.getThreadPool();
        if (scheduler == null) {
            scheduler = (Scheduler)this._server.getBean(Scheduler.class);
        }
        Object object = this._scheduler = scheduler != null ? scheduler : new ScheduledExecutorScheduler();
        if (byteBufferPool == null) {
            byteBufferPool = (ByteBufferPool)this._server.getBean(ByteBufferPool.class);
        }
        this._byteBufferPool = byteBufferPool != null ? byteBufferPool : new ArrayByteBufferPool();
        this.addBean(this._server, false);
        this.addBean(this._executor);
        if (executor == null) {
            this.unmanage(this._executor);
        }
        this.addBean(this._scheduler);
        this.addBean(this._byteBufferPool);
        for (ConnectionFactory connectionFactory : connectionFactoryArray) {
            this.addConnectionFactory(connectionFactory);
        }
        int n2 = Runtime.getRuntime().availableProcessors();
        if (n < 0) {
            n = Math.max(1, Math.min(4, n2 / 8));
        }
        if (n > n2) {
            this.LOG.warn("Acceptors should be <= availableProcessors: " + this, new Object[0]);
        }
        this._acceptors = new Thread[n];
    }

    @Override
    public Server getServer() {
        return this._server;
    }

    @Override
    public Executor getExecutor() {
        return this._executor;
    }

    @Override
    public ByteBufferPool getByteBufferPool() {
        return this._byteBufferPool;
    }

    @Override
    @ManagedAttribute(value="Idle timeout")
    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(long l) {
        this._idleTimeout = l;
    }

    @ManagedAttribute(value="number of acceptor threads")
    public int getAcceptors() {
        return this._acceptors.length;
    }

    protected void doStart() {
        this._defaultConnectionFactory = this.getConnectionFactory(this._defaultProtocol);
        if (this._defaultConnectionFactory == null) {
            throw new IllegalStateException("No protocol factory for default protocol: " + this._defaultProtocol);
        }
        super.doStart();
        this._stopping = new CountDownLatch(this._acceptors.length);
        for (int i = 0; i < this._acceptors.length; ++i) {
            Acceptor acceptor = new Acceptor(i);
            this.addBean(acceptor);
            this.getExecutor().execute(acceptor);
        }
        this.LOG.info("Started {}", new Object[]{this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interruptAcceptors() {
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            for (Thread thread : this._acceptors) {
                if (thread == null) continue;
                thread.interrupt();
            }
        }
    }

    public Future<Void> shutdown() {
        return new FutureCallback(true);
    }

    protected void doStop() {
        this.interruptAcceptors();
        long l = this.getStopTimeout();
        CountDownLatch countDownLatch = this._stopping;
        if (l > 0L && countDownLatch != null) {
            countDownLatch.await(l, TimeUnit.MILLISECONDS);
        }
        this._stopping = null;
        super.doStop();
        for (Acceptor acceptor : this.getBeans(Acceptor.class)) {
            this.removeBean(acceptor);
        }
        this.LOG.info("Stopped {}", new Object[]{this});
    }

    public void join() {
        this.join(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(long l) {
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            for (Thread thread : this._acceptors) {
                if (thread == null) continue;
                thread.join(l);
            }
        }
    }

    protected abstract void accept(int var1);

    protected boolean isAccepting() {
        return this.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionFactory getConnectionFactory(String string) {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            return this._factories.get(StringUtil.asciiToLowerCase((String)string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getConnectionFactory(Class<T> clazz) {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            for (ConnectionFactory connectionFactory : this._factories.values()) {
                if (!clazz.isAssignableFrom(connectionFactory.getClass())) continue;
                return (T)connectionFactory;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionFactory(ConnectionFactory connectionFactory) {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            HashSet<ConnectionFactory> hashSet = new HashSet<ConnectionFactory>();
            for (String string : connectionFactory.getProtocols()) {
                String object = StringUtil.asciiToLowerCase((String)string);
                ConnectionFactory connectionFactory2 = this._factories.remove(object);
                if (connectionFactory2 != null) {
                    if (connectionFactory2.getProtocol().equals(this._defaultProtocol)) {
                        this._defaultProtocol = null;
                    }
                    hashSet.add(connectionFactory2);
                }
                this._factories.put(object, connectionFactory);
            }
            for (ConnectionFactory connectionFactory3 : this._factories.values()) {
                hashSet.remove(connectionFactory3);
            }
            for (ConnectionFactory connectionFactory4 : hashSet) {
                this.removeBean(connectionFactory4);
                if (!this.LOG.isDebugEnabled()) continue;
                this.LOG.debug("{} removed {}", new Object[]{this, connectionFactory4});
            }
            this.addBean(connectionFactory);
            if (this._defaultProtocol == null) {
                this._defaultProtocol = connectionFactory.getProtocol();
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("{} added {}", new Object[]{this, connectionFactory});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirstConnectionFactory(ConnectionFactory connectionFactory) {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            ArrayList<ConnectionFactory> arrayList = new ArrayList<ConnectionFactory>(this._factories.values());
            this._factories.clear();
            this.addConnectionFactory(connectionFactory);
            for (ConnectionFactory connectionFactory2 : arrayList) {
                this.addConnectionFactory(connectionFactory2);
            }
            this._defaultProtocol = connectionFactory.getProtocol();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIfAbsentConnectionFactory(ConnectionFactory connectionFactory) {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            String string = StringUtil.asciiToLowerCase((String)connectionFactory.getProtocol());
            if (this._factories.containsKey(string)) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("{} addIfAbsent ignored {}", new Object[]{this, connectionFactory});
                }
            } else {
                this._factories.put(string, connectionFactory);
                this.addBean(connectionFactory);
                if (this._defaultProtocol == null) {
                    this._defaultProtocol = connectionFactory.getProtocol();
                }
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("{} addIfAbsent added {}", new Object[]{this, connectionFactory});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionFactory removeConnectionFactory(String string) {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            ConnectionFactory connectionFactory = this._factories.remove(StringUtil.asciiToLowerCase((String)string));
            this.removeBean(connectionFactory);
            return connectionFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ConnectionFactory> getConnectionFactories() {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            return this._factories.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionFactories(Collection<ConnectionFactory> collection) {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            ArrayList<ConnectionFactory> arrayList = new ArrayList<ConnectionFactory>(this._factories.values());
            for (ConnectionFactory connectionFactory : arrayList) {
                this.removeConnectionFactory(connectionFactory.getProtocol());
            }
            for (ConnectionFactory connectionFactory : collection) {
                if (connectionFactory == null) continue;
                this.addConnectionFactory(connectionFactory);
            }
        }
    }

    @ManagedAttribute(value="The priority delta to apply to acceptor threads")
    public int getAcceptorPriorityDelta() {
        return this._acceptorPriorityDelta;
    }

    public void setAcceptorPriorityDelta(int n) {
        int n2 = this._acceptorPriorityDelta;
        this._acceptorPriorityDelta = n;
        if (n2 != n && this.isStarted()) {
            for (Thread thread : this._acceptors) {
                thread.setPriority(Math.max(1, Math.min(10, thread.getPriority() - n2 + n)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedAttribute(value="Protocols supported by this connector")
    public List<String> getProtocols() {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            return new ArrayList<String>(this._factories.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConnectionFactories() {
        Map<String, ConnectionFactory> map = this._factories;
        synchronized (map) {
            this._factories.clear();
        }
    }

    @ManagedAttribute(value="This connector's default protocol")
    public String getDefaultProtocol() {
        return this._defaultProtocol;
    }

    public void setDefaultProtocol(String string) {
        this._defaultProtocol = StringUtil.asciiToLowerCase((String)string);
        if (this.isRunning()) {
            this._defaultConnectionFactory = this.getConnectionFactory(this._defaultProtocol);
        }
    }

    @Override
    public ConnectionFactory getDefaultConnectionFactory() {
        if (this.isStarted()) {
            return this._defaultConnectionFactory;
        }
        return this.getConnectionFactory(this._defaultProtocol);
    }

    @Override
    public Collection<EndPoint> getConnectedEndPoints() {
        return this._immutableEndPoints;
    }

    protected void onEndPointOpened(EndPoint endPoint) {
        this._endpoints.add(endPoint);
    }

    protected void onEndPointClosed(EndPoint endPoint) {
        this._endpoints.remove(endPoint);
    }

    @Override
    public Scheduler getScheduler() {
        return this._scheduler;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String toString() {
        return String.format("%s@%x{%s,%s}", this._name == null ? this.getClass().getSimpleName() : this._name, this.hashCode(), this.getDefaultProtocol(), this.getProtocols());
    }

    private class Acceptor
    implements Runnable {
        private final int _id;
        private String _name;

        private Acceptor(int n) {
            this._id = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            String string = thread.getName();
            this._name = String.format("%s-acceptor-%d@%x-%s", string, this._id, this.hashCode(), AbstractConnector.this.toString());
            thread.setName(this._name);
            int n = thread.getPriority();
            if (AbstractConnector.this._acceptorPriorityDelta != 0) {
                thread.setPriority(Math.max(1, Math.min(10, n + AbstractConnector.this._acceptorPriorityDelta)));
            }
            Object object = AbstractConnector.this;
            synchronized (object) {
                ((AbstractConnector)AbstractConnector.this)._acceptors[this._id] = thread;
            }
            try {
                while (AbstractConnector.this.isAccepting()) {
                    try {
                        AbstractConnector.this.accept(this._id);
                    }
                    catch (Throwable throwable) {
                        if (AbstractConnector.this.isAccepting()) {
                            AbstractConnector.this.LOG.warn(throwable);
                            continue;
                        }
                        AbstractConnector.this.LOG.ignore(throwable);
                    }
                }
            }
            finally {
                thread.setName(string);
                if (AbstractConnector.this._acceptorPriorityDelta != 0) {
                    thread.setPriority(n);
                }
                object = AbstractConnector.this;
                synchronized (object) {
                    ((AbstractConnector)AbstractConnector.this)._acceptors[this._id] = null;
                }
                object = AbstractConnector.this._stopping;
                if (object != null) {
                    ((CountDownLatch)object).countDown();
                }
            }
        }

        public String toString() {
            String string = this._name;
            if (string == null) {
                return String.format("acceptor-%d@%x", this._id, this.hashCode());
            }
            return string;
        }
    }
}

