/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@ManagedObject
public abstract class AbstractConnectionFactory
extends ContainerLifeCycle
implements ConnectionFactory {
    private final String _protocol;
    private final List<String> _protocols;
    private int _inputbufferSize = 8192;

    protected AbstractConnectionFactory(String string) {
        this._protocol = string;
        this._protocols = Collections.unmodifiableList(Arrays.asList(string));
    }

    protected AbstractConnectionFactory(String ... stringArray) {
        this._protocol = stringArray[0];
        this._protocols = Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    @Override
    @ManagedAttribute(value="The protocol name", readonly=true)
    public String getProtocol() {
        return this._protocol;
    }

    @Override
    public List<String> getProtocols() {
        return this._protocols;
    }

    @ManagedAttribute(value="The buffer size used to read from the network")
    public int getInputBufferSize() {
        return this._inputbufferSize;
    }

    public void setInputBufferSize(int n) {
        this._inputbufferSize = n;
    }

    protected AbstractConnection configure(AbstractConnection abstractConnection, Connector connector, EndPoint endPoint) {
        abstractConnection.setInputBufferSize(this.getInputBufferSize());
        if (connector instanceof ContainerLifeCycle) {
            ContainerLifeCycle containerLifeCycle = (ContainerLifeCycle)connector;
            for (Connection.Listener listener : containerLifeCycle.getBeans(Connection.Listener.class)) {
                abstractConnection.addListener(listener);
            }
        }
        for (Connection.Listener listener : this.getBeans(Connection.Listener.class)) {
            abstractConnection.addListener(listener);
        }
        return abstractConnection;
    }

    public String toString() {
        return String.format("%s@%x%s", this.getClass().getSimpleName(), this.hashCode(), this.getProtocols());
    }

    public static ConnectionFactory[] getFactories(SslContextFactory sslContextFactory, ConnectionFactory ... connectionFactoryArray) {
        connectionFactoryArray = (ConnectionFactory[])ArrayUtil.removeNulls((Object[])connectionFactoryArray);
        if (sslContextFactory == null) {
            return connectionFactoryArray;
        }
        for (ConnectionFactory connectionFactory : connectionFactoryArray) {
            HttpConfiguration httpConfiguration;
            if (!(connectionFactory instanceof HttpConfiguration.ConnectionFactory) || (httpConfiguration = ((HttpConfiguration.ConnectionFactory)((Object)connectionFactory)).getHttpConfiguration()).getCustomizer(SecureRequestCustomizer.class) != null) continue;
            httpConfiguration.addCustomizer(new SecureRequestCustomizer());
        }
        return (ConnectionFactory[])ArrayUtil.prependToArray((Object)new SslConnectionFactory(sslContextFactory, connectionFactoryArray[0].getProtocol()), (Object[])connectionFactoryArray, ConnectionFactory.class);
    }
}

