/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SpnegoAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(SpnegoAuthenticator.class);
    private String _authMethod = "SPNEGO";

    public SpnegoAuthenticator() {
    }

    public SpnegoAuthenticator(String string) {
        this._authMethod = string;
    }

    @Override
    public String getAuthMethod() {
        return this._authMethod;
    }

    @Override
    public Authentication validateRequest(ServletRequest servletRequest, ServletResponse servletResponse, boolean bl) {
        String string;
        UserIdentity userIdentity;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String string2 = httpServletRequest.getHeader(HttpHeader.AUTHORIZATION.asString());
        if (!bl) {
            return new DeferredAuthentication(this);
        }
        if (string2 == null) {
            try {
                if (DeferredAuthentication.isDeferred(httpServletResponse)) {
                    return Authentication.UNAUTHENTICATED;
                }
                LOG.debug("SpengoAuthenticator: sending challenge", new Object[0]);
                httpServletResponse.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), HttpHeader.NEGOTIATE.asString());
                httpServletResponse.sendError(401);
                return Authentication.SEND_CONTINUE;
            }
            catch (IOException iOException) {
                throw new ServerAuthException(iOException);
            }
        }
        if (string2 != null && string2.startsWith(HttpHeader.NEGOTIATE.asString()) && (userIdentity = this.login(null, string = string2.substring(10), servletRequest)) != null) {
            return new UserAuthentication(this.getAuthMethod(), userIdentity);
        }
        return Authentication.UNAUTHENTICATED;
    }

    @Override
    public boolean secureResponse(ServletRequest servletRequest, ServletResponse servletResponse, boolean bl, Authentication.User user) {
        return true;
    }
}

