/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class LoginAuthenticator
implements Authenticator {
    private static final Logger LOG = Log.getLogger(LoginAuthenticator.class);
    protected LoginService _loginService;
    protected IdentityService _identityService;
    private boolean _renewSession;

    protected LoginAuthenticator() {
    }

    @Override
    public void prepareRequest(ServletRequest servletRequest) {
    }

    public UserIdentity login(String string, Object object, ServletRequest servletRequest) {
        UserIdentity userIdentity = this._loginService.login(string, object, servletRequest);
        if (userIdentity != null) {
            this.renewSession((HttpServletRequest)servletRequest, (HttpServletResponse)(servletRequest instanceof Request ? ((Request)servletRequest).getResponse() : null));
            return userIdentity;
        }
        return null;
    }

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration authConfiguration) {
        this._loginService = authConfiguration.getLoginService();
        if (this._loginService == null) {
            throw new IllegalStateException("No LoginService for " + this + " in " + authConfiguration);
        }
        this._identityService = authConfiguration.getIdentityService();
        if (this._identityService == null) {
            throw new IllegalStateException("No IdentityService for " + this + " in " + authConfiguration);
        }
        this._renewSession = authConfiguration.isSessionRenewedOnAuthentication();
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession renewSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (this._renewSession && httpSession != null) {
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                if (httpSession.getAttribute("org.eclipse.jetty.security.sessionCreatedSecure") != Boolean.TRUE) {
                    if (httpSession instanceof AbstractSession) {
                        AbstractSession abstractSession = (AbstractSession)httpSession;
                        String string = abstractSession.getId();
                        abstractSession.renewId(httpServletRequest);
                        abstractSession.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", (Object)Boolean.TRUE);
                        if (abstractSession.isIdChanged() && httpServletResponse != null && httpServletResponse instanceof Response) {
                            ((Response)httpServletResponse).addCookie(abstractSession.getSessionManager().getSessionCookie((HttpSession)abstractSession, httpServletRequest.getContextPath(), httpServletRequest.isSecure()));
                        }
                        LOG.debug("renew {}->{}", new Object[]{string, abstractSession.getId()});
                    } else {
                        LOG.warn("Unable to renew session " + httpSession, new Object[0]);
                    }
                    return httpSession;
                }
            }
        }
        return httpSession;
    }
}

