/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class FormAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(FormAuthenticator.class);
    public static final String __FORM_LOGIN_PAGE = "org.eclipse.jetty.security.form_login_page";
    public static final String __FORM_ERROR_PAGE = "org.eclipse.jetty.security.form_error_page";
    public static final String __FORM_DISPATCH = "org.eclipse.jetty.security.dispatch";
    public static final String __J_URI = "org.eclipse.jetty.security.form_URI";
    public static final String __J_POST = "org.eclipse.jetty.security.form_POST";
    public static final String __J_METHOD = "org.eclipse.jetty.security.form_METHOD";
    public static final String __J_SECURITY_CHECK = "/j_security_check";
    public static final String __J_USERNAME = "j_username";
    public static final String __J_PASSWORD = "j_password";
    private String _formErrorPage;
    private String _formErrorPath;
    private String _formLoginPage;
    private String _formLoginPath;
    private boolean _dispatch;
    private boolean _alwaysSaveUri;

    public FormAuthenticator() {
    }

    public FormAuthenticator(String string, String string2, boolean bl) {
        this();
        if (string != null) {
            this.setLoginPage(string);
        }
        if (string2 != null) {
            this.setErrorPage(string2);
        }
        this._dispatch = bl;
    }

    public void setAlwaysSaveUri(boolean bl) {
        this._alwaysSaveUri = bl;
    }

    public boolean getAlwaysSaveUri() {
        return this._alwaysSaveUri;
    }

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration authConfiguration) {
        String string;
        String string2;
        super.setConfiguration(authConfiguration);
        String string3 = authConfiguration.getInitParameter(__FORM_LOGIN_PAGE);
        if (string3 != null) {
            this.setLoginPage(string3);
        }
        if ((string2 = authConfiguration.getInitParameter(__FORM_ERROR_PAGE)) != null) {
            this.setErrorPage(string2);
        }
        this._dispatch = (string = authConfiguration.getInitParameter(__FORM_DISPATCH)) == null ? this._dispatch : Boolean.valueOf(string);
    }

    @Override
    public String getAuthMethod() {
        return "FORM";
    }

    private void setLoginPage(String string) {
        if (!string.startsWith("/")) {
            LOG.warn("form-login-page must start with /", new Object[0]);
            string = "/" + string;
        }
        this._formLoginPage = string;
        this._formLoginPath = string;
        if (this._formLoginPath.indexOf(63) > 0) {
            this._formLoginPath = this._formLoginPath.substring(0, this._formLoginPath.indexOf(63));
        }
    }

    private void setErrorPage(String string) {
        if (string == null || string.trim().length() == 0) {
            this._formErrorPath = null;
            this._formErrorPage = null;
        } else {
            if (!string.startsWith("/")) {
                LOG.warn("form-error-page must start with /", new Object[0]);
                string = "/" + string;
            }
            this._formErrorPage = string;
            this._formErrorPath = string;
            if (this._formErrorPath.indexOf(63) > 0) {
                this._formErrorPath = this._formErrorPath.substring(0, this._formErrorPath.indexOf(63));
            }
        }
    }

    @Override
    public UserIdentity login(String string, Object object, ServletRequest servletRequest) {
        UserIdentity userIdentity = super.login(string, object, servletRequest);
        if (userIdentity != null) {
            HttpSession httpSession = ((HttpServletRequest)servletRequest).getSession(true);
            SessionAuthentication sessionAuthentication = new SessionAuthentication(this.getAuthMethod(), userIdentity, object);
            httpSession.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)sessionAuthentication);
        }
        return userIdentity;
    }

    @Override
    public void prepareRequest(ServletRequest servletRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null || httpSession.getAttribute("org.eclipse.jetty.security.UserIdentity") == null) {
            return;
        }
        String string = (String)httpSession.getAttribute(__J_URI);
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = (String)httpSession.getAttribute(__J_METHOD);
        if (string2 == null || string2.length() == 0) {
            return;
        }
        StringBuffer stringBuffer = httpServletRequest.getRequestURL();
        if (httpServletRequest.getQueryString() != null) {
            stringBuffer.append("?").append(httpServletRequest.getQueryString());
        }
        if (!string.equals(stringBuffer.toString())) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Restoring original method {} for {} with method {}", new Object[]{string2, string, httpServletRequest.getMethod()});
        }
        Request request = Request.getBaseRequest((ServletRequest)servletRequest);
        request.setMethod(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Authentication validateRequest(ServletRequest servletRequest, ServletResponse servletResponse, boolean bl) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        Request request = Request.getBaseRequest((ServletRequest)httpServletRequest);
        Response response = request.getResponse();
        String string = httpServletRequest.getRequestURI();
        if (string == null) {
            string = "/";
        }
        if (!(bl |= this.isJSecurityCheck(string))) {
            return new DeferredAuthentication(this);
        }
        if (this.isLoginOrErrorPage(URIUtil.addPaths((String)httpServletRequest.getServletPath(), (String)httpServletRequest.getPathInfo())) && !DeferredAuthentication.isDeferred(httpServletResponse)) {
            return new DeferredAuthentication(this);
        }
        HttpSession httpSession = httpServletRequest.getSession(true);
        try {
            if (this.isJSecurityCheck(string)) {
                String string2 = httpServletRequest.getParameter(__J_USERNAME);
                String string3 = httpServletRequest.getParameter(__J_PASSWORD);
                UserIdentity userIdentity = this.login(string2, string3, (ServletRequest)httpServletRequest);
                LOG.debug("jsecuritycheck {} {}", new Object[]{string2, userIdentity});
                httpSession = httpServletRequest.getSession(true);
                if (userIdentity != null) {
                    FormAuthentication formAuthentication;
                    String string4;
                    HttpSession httpSession2 = httpSession;
                    synchronized (httpSession2) {
                        string4 = (String)httpSession.getAttribute(__J_URI);
                        if ((string4 == null || string4.length() == 0) && (string4 = httpServletRequest.getContextPath()).length() == 0) {
                            string4 = "/";
                        }
                        formAuthentication = new FormAuthentication(this.getAuthMethod(), userIdentity);
                    }
                    LOG.debug("authenticated {}->{}", new Object[]{formAuthentication, string4});
                    httpServletResponse.setContentLength(0);
                    int n = request.getHttpVersion().getVersion() < HttpVersion.HTTP_1_1.getVersion() ? 302 : 303;
                    response.sendRedirect(n, httpServletResponse.encodeRedirectURL(string4));
                    return formAuthentication;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Form authentication FAILED for " + StringUtil.printable((String)string2), new Object[0]);
                }
                if (this._formErrorPage == null) {
                    LOG.debug("auth failed {}->403", new Object[]{string2});
                    if (httpServletResponse != null) {
                        httpServletResponse.sendError(403);
                    }
                } else if (this._dispatch) {
                    LOG.debug("auth failed {}=={}", new Object[]{string2, this._formErrorPage});
                    RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(this._formErrorPage);
                    httpServletResponse.setHeader(HttpHeader.CACHE_CONTROL.asString(), HttpHeaderValue.NO_CACHE.asString());
                    httpServletResponse.setDateHeader(HttpHeader.EXPIRES.asString(), 1L);
                    requestDispatcher.forward((ServletRequest)new FormRequest(httpServletRequest), (ServletResponse)new FormResponse(httpServletResponse));
                } else {
                    LOG.debug("auth failed {}->{}", new Object[]{string2, this._formErrorPage});
                    int n = request.getHttpVersion().getVersion() < HttpVersion.HTTP_1_1.getVersion() ? 302 : 303;
                    response.sendRedirect(n, httpServletResponse.encodeRedirectURL(URIUtil.addPaths((String)httpServletRequest.getContextPath(), (String)this._formErrorPage)));
                }
                return Authentication.SEND_FAILURE;
            }
            Authentication authentication = (Authentication)httpSession.getAttribute("org.eclipse.jetty.security.UserIdentity");
            if (authentication != null) {
                if (authentication instanceof Authentication.User && this._loginService != null && !this._loginService.validate(((Authentication.User)authentication).getUserIdentity())) {
                    LOG.debug("auth revoked {}", new Object[]{authentication});
                    httpSession.removeAttribute("org.eclipse.jetty.security.UserIdentity");
                } else {
                    HttpSession httpSession3 = httpSession;
                    synchronized (httpSession3) {
                        String string5 = (String)httpSession.getAttribute(__J_URI);
                        if (string5 != null) {
                            LOG.debug("auth retry {}->{}", new Object[]{authentication, string5});
                            StringBuffer stringBuffer = httpServletRequest.getRequestURL();
                            if (httpServletRequest.getQueryString() != null) {
                                stringBuffer.append("?").append(httpServletRequest.getQueryString());
                            }
                            if (string5.equals(stringBuffer.toString())) {
                                MultiMap multiMap = (MultiMap)httpSession.getAttribute(__J_POST);
                                if (multiMap != null) {
                                    LOG.debug("auth rePOST {}->{}", new Object[]{authentication, string5});
                                    request.setContentParameters(multiMap);
                                }
                                httpSession.removeAttribute(__J_URI);
                                httpSession.removeAttribute(__J_METHOD);
                                httpSession.removeAttribute(__J_POST);
                            }
                        }
                    }
                    LOG.debug("auth {}", new Object[]{authentication});
                    return authentication;
                }
            }
            if (DeferredAuthentication.isDeferred(httpServletResponse)) {
                LOG.debug("auth deferred {}", new Object[]{httpSession.getId()});
                return Authentication.UNAUTHENTICATED;
            }
            HttpSession httpSession4 = httpSession;
            synchronized (httpSession4) {
                if (httpSession.getAttribute(__J_URI) == null || this._alwaysSaveUri) {
                    StringBuffer stringBuffer = httpServletRequest.getRequestURL();
                    if (httpServletRequest.getQueryString() != null) {
                        stringBuffer.append("?").append(httpServletRequest.getQueryString());
                    }
                    httpSession.setAttribute(__J_URI, (Object)stringBuffer.toString());
                    httpSession.setAttribute(__J_METHOD, (Object)httpServletRequest.getMethod());
                    if (MimeTypes.Type.FORM_ENCODED.is(servletRequest.getContentType()) && HttpMethod.POST.is(httpServletRequest.getMethod())) {
                        MultiMap multiMap = new MultiMap();
                        request.extractFormParameters(multiMap);
                        httpSession.setAttribute(__J_POST, (Object)multiMap);
                    }
                }
            }
            if (this._dispatch) {
                LOG.debug("challenge {}=={}", new Object[]{httpSession.getId(), this._formLoginPage});
                httpSession4 = httpServletRequest.getRequestDispatcher(this._formLoginPage);
                httpServletResponse.setHeader(HttpHeader.CACHE_CONTROL.asString(), HttpHeaderValue.NO_CACHE.asString());
                httpServletResponse.setDateHeader(HttpHeader.EXPIRES.asString(), 1L);
                httpSession4.forward((ServletRequest)new FormRequest(httpServletRequest), (ServletResponse)new FormResponse(httpServletResponse));
            } else {
                LOG.debug("challenge {}->{}", new Object[]{httpSession.getId(), this._formLoginPage});
                int n = request.getHttpVersion().getVersion() < HttpVersion.HTTP_1_1.getVersion() ? 302 : 303;
                response.sendRedirect(n, httpServletResponse.encodeRedirectURL(URIUtil.addPaths((String)httpServletRequest.getContextPath(), (String)this._formLoginPage)));
            }
            return Authentication.SEND_CONTINUE;
        }
        catch (IOException | ServletException throwable) {
            throw new ServerAuthException(throwable);
        }
    }

    public boolean isJSecurityCheck(String string) {
        int n = string.indexOf(__J_SECURITY_CHECK);
        if (n < 0) {
            return false;
        }
        int n2 = n + __J_SECURITY_CHECK.length();
        if (n2 == string.length()) {
            return true;
        }
        char c = string.charAt(n2);
        return c == ';' || c == '#' || c == '/' || c == '?';
    }

    public boolean isLoginOrErrorPage(String string) {
        return string != null && (string.equals(this._formErrorPath) || string.equals(this._formLoginPath));
    }

    @Override
    public boolean secureResponse(ServletRequest servletRequest, ServletResponse servletResponse, boolean bl, Authentication.User user) {
        return true;
    }

    public static class FormAuthentication
    extends UserAuthentication
    implements Authentication.ResponseSent {
        public FormAuthentication(String string, UserIdentity userIdentity) {
            super(string, userIdentity);
        }

        @Override
        public String toString() {
            return "Form" + super.toString();
        }
    }

    protected static class FormResponse
    extends HttpServletResponseWrapper {
        public FormResponse(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        public void addDateHeader(String string, long l) {
            if (this.notIgnored(string)) {
                super.addDateHeader(string, l);
            }
        }

        public void addHeader(String string, String string2) {
            if (this.notIgnored(string)) {
                super.addHeader(string, string2);
            }
        }

        public void setDateHeader(String string, long l) {
            if (this.notIgnored(string)) {
                super.setDateHeader(string, l);
            }
        }

        public void setHeader(String string, String string2) {
            if (this.notIgnored(string)) {
                super.setHeader(string, string2);
            }
        }

        private boolean notIgnored(String string) {
            return !HttpHeader.CACHE_CONTROL.is(string) && !HttpHeader.PRAGMA.is(string) && !HttpHeader.ETAG.is(string) && !HttpHeader.EXPIRES.is(string) && !HttpHeader.LAST_MODIFIED.is(string) && !HttpHeader.AGE.is(string);
        }
    }

    protected static class FormRequest
    extends HttpServletRequestWrapper {
        public FormRequest(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
        }

        public long getDateHeader(String string) {
            if (string.toLowerCase(Locale.ENGLISH).startsWith("if-")) {
                return -1L;
            }
            return super.getDateHeader(string);
        }

        public String getHeader(String string) {
            if (string.toLowerCase(Locale.ENGLISH).startsWith("if-")) {
                return null;
            }
            return super.getHeader(string);
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(Collections.list(super.getHeaderNames()));
        }

        public Enumeration<String> getHeaders(String string) {
            if (string.toLowerCase(Locale.ENGLISH).startsWith("if-")) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getHeaders(string);
        }
    }
}

