/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.BitSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

public class DigestAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(DigestAuthenticator.class);
    SecureRandom _random = new SecureRandom();
    private long _maxNonceAgeMs = 60000L;
    private int _maxNC = 1024;
    private ConcurrentMap<String, Nonce> _nonceMap = new ConcurrentHashMap<String, Nonce>();
    private Queue<Nonce> _nonceQueue = new ConcurrentLinkedQueue<Nonce>();

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration authConfiguration) {
        String string;
        super.setConfiguration(authConfiguration);
        String string2 = authConfiguration.getInitParameter("maxNonceAge");
        if (string2 != null) {
            this._maxNonceAgeMs = Long.valueOf(string2);
        }
        if ((string = authConfiguration.getInitParameter("maxNonceCount")) != null) {
            this._maxNC = Integer.valueOf(string);
        }
    }

    public int getMaxNonceCount() {
        return this._maxNC;
    }

    public void setMaxNonceCount(int n) {
        this._maxNC = n;
    }

    public long getMaxNonceAge() {
        return this._maxNonceAgeMs;
    }

    public synchronized void setMaxNonceAge(long l) {
        this._maxNonceAgeMs = l;
    }

    @Override
    public String getAuthMethod() {
        return "DIGEST";
    }

    @Override
    public boolean secureResponse(ServletRequest servletRequest, ServletResponse servletResponse, boolean bl, Authentication.User user) {
        return true;
    }

    @Override
    public Authentication validateRequest(ServletRequest servletRequest, ServletResponse servletResponse, boolean bl) {
        if (!bl) {
            return new DeferredAuthentication(this);
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String string = httpServletRequest.getHeader(HttpHeader.AUTHORIZATION.asString());
        try {
            String string2;
            boolean bl2 = false;
            if (string != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Credentials: " + string, new Object[0]);
                }
                string2 = new QuotedStringTokenizer(string, "=, ", true, false);
                Digest digest = new Digest(httpServletRequest.getMethod());
                String string3 = null;
                String string4 = null;
                block7: while (string2.hasMoreTokens()) {
                    String string5 = string2.nextToken();
                    char c = string5.length() == 1 ? string5.charAt(0) : (char)'\u0000';
                    switch (c) {
                        case '=': {
                            string4 = string3;
                            string3 = string5;
                            continue block7;
                        }
                        case ',': {
                            string4 = null;
                            continue block7;
                        }
                        case ' ': {
                            continue block7;
                        }
                    }
                    string3 = string5;
                    if (string4 == null) continue;
                    if ("username".equalsIgnoreCase(string4)) {
                        digest.username = string5;
                    } else if ("realm".equalsIgnoreCase(string4)) {
                        digest.realm = string5;
                    } else if ("nonce".equalsIgnoreCase(string4)) {
                        digest.nonce = string5;
                    } else if ("nc".equalsIgnoreCase(string4)) {
                        digest.nc = string5;
                    } else if ("cnonce".equalsIgnoreCase(string4)) {
                        digest.cnonce = string5;
                    } else if ("qop".equalsIgnoreCase(string4)) {
                        digest.qop = string5;
                    } else if ("uri".equalsIgnoreCase(string4)) {
                        digest.uri = string5;
                    } else if ("response".equalsIgnoreCase(string4)) {
                        digest.response = string5;
                    }
                    string4 = null;
                }
                int n = this.checkNonce(digest, (Request)httpServletRequest);
                if (n > 0) {
                    UserIdentity userIdentity = this.login(digest.username, (Object)digest, servletRequest);
                    if (userIdentity != null) {
                        return new UserAuthentication(this.getAuthMethod(), userIdentity);
                    }
                } else if (n == 0) {
                    bl2 = true;
                }
            }
            if (!DeferredAuthentication.isDeferred(httpServletResponse)) {
                string2 = httpServletRequest.getContextPath();
                if (string2 == null) {
                    string2 = "/";
                }
                httpServletResponse.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), "Digest realm=\"" + this._loginService.getName() + "\", domain=\"" + string2 + "\", nonce=\"" + this.newNonce((Request)httpServletRequest) + "\", algorithm=MD5, qop=\"auth\"," + " stale=" + bl2);
                httpServletResponse.sendError(401);
                return Authentication.SEND_CONTINUE;
            }
            return Authentication.UNAUTHENTICATED;
        }
        catch (IOException iOException) {
            throw new ServerAuthException(iOException);
        }
    }

    public String newNonce(Request request) {
        byte[] byArray;
        Nonce nonce;
        do {
            byArray = new byte[24];
            this._random.nextBytes(byArray);
        } while (this._nonceMap.putIfAbsent(nonce._nonce, nonce = new Nonce(new String(B64Code.encode((byte[])byArray)), request.getTimeStamp(), this._maxNC)) != null);
        this._nonceQueue.add(nonce);
        return nonce._nonce;
    }

    private int checkNonce(Digest digest, Request request) {
        long l = request.getTimeStamp() - this._maxNonceAgeMs;
        Nonce nonce = this._nonceQueue.peek();
        while (nonce != null && nonce._ts < l) {
            this._nonceQueue.remove(nonce);
            this._nonceMap.remove(nonce._nonce);
            nonce = this._nonceQueue.peek();
        }
        try {
            nonce = (Nonce)this._nonceMap.get(digest.nonce);
            if (nonce == null) {
                return 0;
            }
            long l2 = Long.parseLong(digest.nc, 16);
            if (l2 >= (long)this._maxNC) {
                return 0;
            }
            if (nonce.seen((int)l2)) {
                return -1;
            }
            return 1;
        }
        catch (Exception exception) {
            LOG.ignore((Throwable)exception);
            return -1;
        }
    }

    private static class Digest
    extends Credential {
        private static final long serialVersionUID = -2484639019549527724L;
        final String method;
        String username = "";
        String realm = "";
        String nonce = "";
        String nc = "";
        String cnonce = "";
        String qop = "";
        String uri = "";
        String response = "";

        Digest(String string) {
            this.method = string;
        }

        public boolean check(Object object) {
            if (object instanceof char[]) {
                object = new String((char[])object);
            }
            String string = object instanceof String ? (String)object : object.toString();
            try {
                byte[] byArray;
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (object instanceof Credential.MD5) {
                    byArray = ((Credential.MD5)object).getDigest();
                } else {
                    messageDigest.update(this.username.getBytes(StandardCharsets.ISO_8859_1));
                    messageDigest.update((byte)58);
                    messageDigest.update(this.realm.getBytes(StandardCharsets.ISO_8859_1));
                    messageDigest.update((byte)58);
                    messageDigest.update(string.getBytes(StandardCharsets.ISO_8859_1));
                    byArray = messageDigest.digest();
                }
                messageDigest.reset();
                messageDigest.update(this.method.getBytes(StandardCharsets.ISO_8859_1));
                messageDigest.update((byte)58);
                messageDigest.update(this.uri.getBytes(StandardCharsets.ISO_8859_1));
                byte[] byArray2 = messageDigest.digest();
                messageDigest.update(TypeUtil.toString((byte[])byArray, (int)16).getBytes(StandardCharsets.ISO_8859_1));
                messageDigest.update((byte)58);
                messageDigest.update(this.nonce.getBytes(StandardCharsets.ISO_8859_1));
                messageDigest.update((byte)58);
                messageDigest.update(this.nc.getBytes(StandardCharsets.ISO_8859_1));
                messageDigest.update((byte)58);
                messageDigest.update(this.cnonce.getBytes(StandardCharsets.ISO_8859_1));
                messageDigest.update((byte)58);
                messageDigest.update(this.qop.getBytes(StandardCharsets.ISO_8859_1));
                messageDigest.update((byte)58);
                messageDigest.update(TypeUtil.toString((byte[])byArray2, (int)16).getBytes(StandardCharsets.ISO_8859_1));
                byte[] byArray3 = messageDigest.digest();
                return TypeUtil.toString((byte[])byArray3, (int)16).equalsIgnoreCase(this.response);
            }
            catch (Exception exception) {
                LOG.warn((Throwable)exception);
                return false;
            }
        }

        public String toString() {
            return this.username + "," + this.response;
        }
    }

    private static class Nonce {
        final String _nonce;
        final long _ts;
        final BitSet _seen;

        public Nonce(String string, long l, int n) {
            this._nonce = string;
            this._ts = l;
            this._seen = new BitSet(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean seen(int n) {
            Nonce nonce = this;
            synchronized (nonce) {
                if (n >= this._seen.size()) {
                    return true;
                }
                boolean bl = this._seen.get(n);
                this._seen.set(n);
                return bl;
            }
        }
    }
}

