/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DeferredAuthentication
implements Authentication.Deferred {
    private static final Logger LOG = Log.getLogger(DeferredAuthentication.class);
    protected final LoginAuthenticator _authenticator;
    private Object _previousAssociation;
    static final HttpServletResponse __deferredResponse = new HttpServletResponse(){

        public void addCookie(Cookie cookie) {
        }

        public void addDateHeader(String string, long l) {
        }

        public void addHeader(String string, String string2) {
        }

        public void addIntHeader(String string, int n) {
        }

        public boolean containsHeader(String string) {
            return false;
        }

        public String encodeRedirectURL(String string) {
            return null;
        }

        public String encodeRedirectUrl(String string) {
            return null;
        }

        public String encodeURL(String string) {
            return null;
        }

        public String encodeUrl(String string) {
            return null;
        }

        public void sendError(int n) {
        }

        public void sendError(int n, String string) {
        }

        public void sendRedirect(String string) {
        }

        public void setDateHeader(String string, long l) {
        }

        public void setHeader(String string, String string2) {
        }

        public void setIntHeader(String string, int n) {
        }

        public void setStatus(int n) {
        }

        public void setStatus(int n, String string) {
        }

        public void flushBuffer() {
        }

        public int getBufferSize() {
            return 1024;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public ServletOutputStream getOutputStream() {
            return __nullOut;
        }

        public PrintWriter getWriter() {
            return IO.getNullPrintWriter();
        }

        public boolean isCommitted() {
            return true;
        }

        public void reset() {
        }

        public void resetBuffer() {
        }

        public void setBufferSize(int n) {
        }

        public void setCharacterEncoding(String string) {
        }

        public void setContentLength(int n) {
        }

        public void setContentLengthLong(long l) {
        }

        public void setContentType(String string) {
        }

        public void setLocale(Locale locale) {
        }

        public Collection<String> getHeaderNames() {
            return Collections.emptyList();
        }

        public String getHeader(String string) {
            return null;
        }

        public Collection<String> getHeaders(String string) {
            return Collections.emptyList();
        }

        public int getStatus() {
            return 0;
        }
    };
    private static ServletOutputStream __nullOut = new ServletOutputStream(){

        public void write(int n) {
        }

        public void print(String string) {
        }

        public void println(String string) {
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public boolean isReady() {
            return false;
        }
    };

    public DeferredAuthentication(LoginAuthenticator loginAuthenticator) {
        if (loginAuthenticator == null) {
            throw new NullPointerException("No Authenticator");
        }
        this._authenticator = loginAuthenticator;
    }

    public Authentication authenticate(ServletRequest servletRequest) {
        try {
            Authentication authentication = this._authenticator.validateRequest(servletRequest, (ServletResponse)__deferredResponse, true);
            if (authentication != null && authentication instanceof Authentication.User && !(authentication instanceof Authentication.ResponseSent)) {
                LoginService loginService = this._authenticator.getLoginService();
                IdentityService identityService = loginService.getIdentityService();
                if (identityService != null) {
                    this._previousAssociation = identityService.associate(((Authentication.User)authentication).getUserIdentity());
                }
                return authentication;
            }
        }
        catch (ServerAuthException serverAuthException) {
            LOG.debug((Throwable)serverAuthException);
        }
        return this;
    }

    public Authentication authenticate(ServletRequest servletRequest, ServletResponse servletResponse) {
        try {
            LoginService loginService = this._authenticator.getLoginService();
            IdentityService identityService = loginService.getIdentityService();
            Authentication authentication = this._authenticator.validateRequest(servletRequest, servletResponse, true);
            if (authentication instanceof Authentication.User && identityService != null) {
                this._previousAssociation = identityService.associate(((Authentication.User)authentication).getUserIdentity());
            }
            return authentication;
        }
        catch (ServerAuthException serverAuthException) {
            LOG.debug((Throwable)serverAuthException);
            return this;
        }
    }

    public Authentication login(String string, Object object, ServletRequest servletRequest) {
        if (string == null) {
            return null;
        }
        UserIdentity userIdentity = this._authenticator.login(string, object, servletRequest);
        if (userIdentity != null) {
            IdentityService identityService = this._authenticator.getLoginService().getIdentityService();
            UserAuthentication userAuthentication = new UserAuthentication("API", userIdentity);
            if (identityService != null) {
                this._previousAssociation = identityService.associate(userIdentity);
            }
            return userAuthentication;
        }
        return null;
    }

    public Object getPreviousAssociation() {
        return this._previousAssociation;
    }

    public static boolean isDeferred(HttpServletResponse httpServletResponse) {
        return httpServletResponse == __deferredResponse;
    }
}

