/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.CertificateUtils;
import org.eclipse.jetty.util.security.CertificateValidator;
import org.eclipse.jetty.util.security.Password;

public class ClientCertAuthenticator
extends LoginAuthenticator {
    private static final String PASSWORD_PROPERTY = "org.eclipse.jetty.ssl.password";
    private String _trustStorePath;
    private String _trustStoreProvider;
    private String _trustStoreType = "JKS";
    private transient Password _trustStorePassword;
    private boolean _validateCerts;
    private String _crlPath;
    private int _maxCertPathLength = -1;
    private boolean _enableCRLDP = false;
    private boolean _enableOCSP = false;
    private String _ocspResponderURL;

    @Override
    public String getAuthMethod() {
        return "CLIENT_CERT";
    }

    @Override
    public Authentication validateRequest(ServletRequest servletRequest, ServletResponse servletResponse, boolean bl) {
        if (!bl) {
            return new DeferredAuthentication(this);
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        Certificate[] certificateArray = (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
        try {
            if (certificateArray != null && certificateArray.length > 0) {
                if (this._validateCerts) {
                    KeyStore object = this.getKeyStore(this._trustStorePath, this._trustStoreType, this._trustStoreProvider, this._trustStorePassword == null ? null : this._trustStorePassword.toString());
                    Collection<? extends CRL> collection = this.loadCRL(this._crlPath);
                    CertificateValidator certificateValidator = new CertificateValidator(object, collection);
                    certificateValidator.validate(certificateArray);
                }
                for (X509Certificate x509Certificate : certificateArray) {
                    char[] cArray;
                    String string;
                    UserIdentity userIdentity;
                    if (x509Certificate == null) continue;
                    Principal principal = x509Certificate.getSubjectDN();
                    if (principal == null) {
                        principal = x509Certificate.getIssuerDN();
                    }
                    if ((userIdentity = this.login(string = principal == null ? "clientcert" : principal.getName(), cArray = B64Code.encode((byte[])x509Certificate.getSignature()), servletRequest)) == null) continue;
                    return new UserAuthentication(this.getAuthMethod(), userIdentity);
                }
            }
            if (!DeferredAuthentication.isDeferred(httpServletResponse)) {
                httpServletResponse.sendError(403);
                return Authentication.SEND_FAILURE;
            }
            return Authentication.UNAUTHENTICATED;
        }
        catch (Exception exception) {
            throw new ServerAuthException(exception.getMessage());
        }
    }

    @Deprecated
    protected KeyStore getKeyStore(InputStream inputStream, String string, String string2, String string3, String string4) {
        return this.getKeyStore(string, string2, string3, string4);
    }

    protected KeyStore getKeyStore(String string, String string2, String string3, String string4) {
        return CertificateUtils.getKeyStore((Resource)Resource.newResource((String)string), (String)string2, (String)string3, (String)string4);
    }

    protected Collection<? extends CRL> loadCRL(String string) {
        return CertificateUtils.loadCRL((String)string);
    }

    @Override
    public boolean secureResponse(ServletRequest servletRequest, ServletResponse servletResponse, boolean bl, Authentication.User user) {
        return true;
    }

    public boolean isValidateCerts() {
        return this._validateCerts;
    }

    public void setValidateCerts(boolean bl) {
        this._validateCerts = bl;
    }

    public String getTrustStore() {
        return this._trustStorePath;
    }

    public void setTrustStore(String string) {
        this._trustStorePath = string;
    }

    public String getTrustStoreProvider() {
        return this._trustStoreProvider;
    }

    public void setTrustStoreProvider(String string) {
        this._trustStoreProvider = string;
    }

    public String getTrustStoreType() {
        return this._trustStoreType;
    }

    public void setTrustStoreType(String string) {
        this._trustStoreType = string;
    }

    public void setTrustStorePassword(String string) {
        this._trustStorePassword = Password.getPassword((String)PASSWORD_PROPERTY, (String)string, null);
    }

    public String getCrlPath() {
        return this._crlPath;
    }

    public void setCrlPath(String string) {
        this._crlPath = string;
    }

    public int getMaxCertPathLength() {
        return this._maxCertPathLength;
    }

    public void setMaxCertPathLength(int n) {
        this._maxCertPathLength = n;
    }

    public boolean isEnableCRLDP() {
        return this._enableCRLDP;
    }

    public void setEnableCRLDP(boolean bl) {
        this._enableCRLDP = bl;
    }

    public boolean isEnableOCSP() {
        return this._enableOCSP;
    }

    public void setEnableOCSP(boolean bl) {
        this._enableOCSP = bl;
    }

    public String getOcspResponderURL() {
        return this._ocspResponderURL;
    }

    public void setOcspResponderURL(String string) {
        this._ocspResponderURL = string;
    }
}

