/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

public enum UserDataConstraint {
    None,
    Integral,
    Confidential;


    public static UserDataConstraint get(int n) {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException("Expected -1, 0, 1, or 2, not: " + n);
        }
        if (n == -1) {
            return None;
        }
        return UserDataConstraint.values()[n];
    }

    public UserDataConstraint combine(UserDataConstraint userDataConstraint) {
        if (this.compareTo(userDataConstraint) < 0) {
            return this;
        }
        return userDataConstraint;
    }
}

