/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.util.Properties;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SpnegoUserPrincipal;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoLoginService
extends AbstractLifeCycle
implements LoginService {
    private static final Logger LOG = Log.getLogger(SpnegoLoginService.class);
    protected IdentityService _identityService;
    protected String _name;
    private String _config;
    private String _targetName;

    public SpnegoLoginService() {
    }

    public SpnegoLoginService(String string) {
        this.setName(string);
    }

    public SpnegoLoginService(String string, String string2) {
        this.setName(string);
        this.setConfig(string2);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._name = string;
    }

    public String getConfig() {
        return this._config;
    }

    public void setConfig(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._config = string;
    }

    protected void doStart() {
        Properties properties = new Properties();
        Resource resource = Resource.newResource((String)this._config);
        properties.load(resource.getInputStream());
        this._targetName = properties.getProperty("targetName");
        LOG.debug("Target Name {}", new Object[]{this._targetName});
        super.doStart();
    }

    @Override
    public UserIdentity login(String string, Object object, ServletRequest servletRequest) {
        String string2 = (String)object;
        byte[] byArray = B64Code.decode((String)string2);
        GSSManager gSSManager = GSSManager.getInstance();
        try {
            Oid oid = new Oid("1.3.6.1.5.5.2");
            GSSName gSSName = gSSManager.createName(this._targetName, null);
            GSSCredential gSSCredential = gSSManager.createCredential(gSSName, Integer.MAX_VALUE, oid, 2);
            GSSContext gSSContext = gSSManager.createContext(gSSCredential);
            if (gSSContext == null) {
                LOG.debug("SpnegoUserRealm: failed to establish GSSContext", new Object[0]);
            } else {
                while (!gSSContext.isEstablished()) {
                    byArray = gSSContext.acceptSecContext(byArray, 0, byArray.length);
                }
                if (gSSContext.isEstablished()) {
                    String string3 = gSSContext.getSrcName().toString();
                    String string4 = string3.substring(string3.indexOf(64) + 1);
                    LOG.debug("SpnegoUserRealm: established a security context", new Object[0]);
                    LOG.debug("Client Principal is: " + gSSContext.getSrcName(), new Object[0]);
                    LOG.debug("Server Principal is: " + gSSContext.getTargName(), new Object[0]);
                    LOG.debug("Client Default Role: " + string4, new Object[0]);
                    SpnegoUserPrincipal spnegoUserPrincipal = new SpnegoUserPrincipal(string3, byArray);
                    Subject subject = new Subject();
                    subject.getPrincipals().add(spnegoUserPrincipal);
                    return this._identityService.newUserIdentity(subject, spnegoUserPrincipal, new String[]{string4});
                }
            }
        }
        catch (GSSException gSSException) {
            LOG.warn((Throwable)gSSException);
        }
        return null;
    }

    @Override
    public boolean validate(UserIdentity userIdentity) {
        return false;
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    @Override
    public void setIdentityService(IdentityService identityService) {
        this._identityService = identityService;
    }

    @Override
    public void logout(UserIdentity userIdentity) {
    }
}

