/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultAuthenticatorFactory;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.RoleInfo;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class SecurityHandler
extends HandlerWrapper
implements Authenticator.AuthConfiguration {
    private static final Logger LOG = Log.getLogger(SecurityHandler.class);
    private boolean _checkWelcomeFiles = false;
    private Authenticator _authenticator;
    private Authenticator.Factory _authenticatorFactory = new DefaultAuthenticatorFactory();
    private String _realmName;
    private String _authMethod;
    private final Map<String, String> _initParameters = new HashMap<String, String>();
    private LoginService _loginService;
    private IdentityService _identityService;
    private boolean _renewSession = true;
    public static final Principal __NO_USER = new Principal(){

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String toString() {
            return "No User";
        }
    };
    public static final Principal __NOBODY = new Principal(){

        @Override
        public String getName() {
            return "Nobody";
        }

        @Override
        public String toString() {
            return this.getName();
        }
    };

    protected SecurityHandler() {
        this.addBean(this._authenticatorFactory);
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this.updateBean(this._identityService, identityService);
        this._identityService = identityService;
    }

    @Override
    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this.updateBean(this._loginService, loginService);
        this._loginService = loginService;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this.updateBean(this._authenticator, authenticator);
        this._authenticator = authenticator;
        if (this._authenticator != null) {
            this._authMethod = this._authenticator.getAuthMethod();
        }
    }

    public Authenticator.Factory getAuthenticatorFactory() {
        return this._authenticatorFactory;
    }

    public void setAuthenticatorFactory(Authenticator.Factory factory) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this.updateBean(this._authenticatorFactory, factory);
        this._authenticatorFactory = factory;
    }

    @Override
    public String getRealmName() {
        return this._realmName;
    }

    public void setRealmName(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._realmName = string;
    }

    @Override
    public String getAuthMethod() {
        return this._authMethod;
    }

    public void setAuthMethod(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._authMethod = string;
    }

    public boolean isCheckWelcomeFiles() {
        return this._checkWelcomeFiles;
    }

    public void setCheckWelcomeFiles(boolean bl) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._checkWelcomeFiles = bl;
    }

    @Override
    public String getInitParameter(String string) {
        return this._initParameters.get(string);
    }

    @Override
    public Set<String> getInitParameterNames() {
        return this._initParameters.keySet();
    }

    public String setInitParameter(String string, String string2) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        return this._initParameters.put(string, string2);
    }

    protected LoginService findLoginService() {
        Collection collection = this.getServer().getBeans(LoginService.class);
        LoginService loginService = null;
        String string = this.getRealmName();
        if (string != null) {
            for (LoginService loginService2 : collection) {
                if (loginService2.getName() == null || !loginService2.getName().equals(string)) continue;
                loginService = loginService2;
                break;
            }
        } else if (collection.size() == 1) {
            loginService = (LoginService)collection.iterator().next();
        }
        return loginService;
    }

    protected IdentityService findIdentityService() {
        return (IdentityService)this.getServer().getBean(IdentityService.class);
    }

    protected void doStart() {
        Object object;
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context != null) {
            object = context.getInitParameterNames();
            while (object != null && object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (!string.startsWith("org.eclipse.jetty.security.") || this.getInitParameter(string) != null) continue;
                this.setInitParameter(string, context.getInitParameter(string));
            }
        }
        if (this._loginService == null) {
            this.setLoginService(this.findLoginService());
            if (this._loginService != null) {
                this.unmanage(this._loginService);
            }
        }
        if (this._identityService == null) {
            if (this._loginService != null) {
                this.setIdentityService(this._loginService.getIdentityService());
            }
            if (this._identityService == null) {
                this.setIdentityService(this.findIdentityService());
            }
            if (this._identityService == null) {
                if (this._realmName != null) {
                    this.setIdentityService(new DefaultIdentityService());
                    this.manage(this._identityService);
                }
            } else {
                this.unmanage(this._identityService);
            }
        }
        if (this._loginService != null) {
            if (this._loginService.getIdentityService() == null) {
                this._loginService.setIdentityService(this._identityService);
            } else if (this._loginService.getIdentityService() != this._identityService) {
                throw new IllegalStateException("LoginService has different IdentityService to " + this);
            }
        }
        object = this.getAuthenticatorFactory();
        if (this._authenticator == null && object != null && this._identityService != null) {
            this.setAuthenticator(object.getAuthenticator(this.getServer(), (ServletContext)ContextHandler.getCurrentContext(), this, this._identityService, this._loginService));
        }
        if (this._authenticator != null) {
            this._authenticator.setConfiguration(this);
        } else if (this._realmName != null) {
            LOG.warn("No Authenticator for " + this, new Object[0]);
            throw new IllegalStateException("No Authenticator");
        }
        super.doStart();
    }

    protected void doStop() {
        if (!this.isManaged(this._identityService)) {
            this.removeBean(this._identityService);
            this._identityService = null;
        }
        if (!this.isManaged(this._loginService)) {
            this.removeBean(this._loginService);
            this._loginService = null;
        }
        super.doStop();
    }

    protected boolean checkSecurity(Request request) {
        switch (request.getDispatcherType()) {
            case REQUEST: 
            case ASYNC: {
                return true;
            }
            case FORWARD: {
                if (this.isCheckWelcomeFiles() && request.getAttribute("org.eclipse.jetty.server.welcome") != null) {
                    request.removeAttribute("org.eclipse.jetty.server.welcome");
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isSessionRenewedOnAuthentication() {
        return this._renewSession;
    }

    public void setSessionRenewedOnAuthentication(boolean bl) {
        this._renewSession = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Response response = request.getResponse();
        Handler handler = this.getHandler();
        if (handler == null) {
            return;
        }
        Authenticator authenticator = this._authenticator;
        if (this.checkSecurity(request)) {
            RoleInfo roleInfo;
            if (authenticator != null) {
                authenticator.prepareRequest((ServletRequest)request);
            }
            if (!this.checkUserDataPermissions(string, request, response, roleInfo = this.prepareConstraintInfo(string, request))) {
                if (request.isHandled()) return;
                httpServletResponse.sendError(403);
                request.setHandled(true);
                return;
            }
            boolean bl = this.isAuthMandatory(request, response, roleInfo);
            if (bl && authenticator == null) {
                LOG.warn("No authenticator for: " + roleInfo, new Object[0]);
                if (request.isHandled()) return;
                httpServletResponse.sendError(403);
                request.setHandled(true);
                return;
            }
            Object object = null;
            try {
                Authentication authentication = request.getAuthentication();
                if (authentication == null || authentication == Authentication.NOT_CHECKED) {
                    Authentication authentication2 = authentication = authenticator == null ? Authentication.UNAUTHENTICATED : authenticator.validateRequest((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, bl);
                }
                if (authentication instanceof Authentication.Wrapped) {
                    httpServletRequest = ((Authentication.Wrapped)authentication).getHttpServletRequest();
                    httpServletResponse = ((Authentication.Wrapped)authentication).getHttpServletResponse();
                }
                if (authentication instanceof Authentication.ResponseSent) {
                    request.setHandled(true);
                    return;
                }
                if (authentication instanceof Authentication.User) {
                    boolean bl2;
                    Authentication.User user = (Authentication.User)authentication;
                    request.setAuthentication(authentication);
                    if (this._identityService != null) {
                        object = this._identityService.associate(user.getUserIdentity());
                    }
                    if (bl && !(bl2 = this.checkWebResourcePermissions(string, request, response, roleInfo, user.getUserIdentity()))) {
                        httpServletResponse.sendError(403, "!role");
                        request.setHandled(true);
                        if (this._identityService == null) return;
                        this._identityService.disassociate(object);
                        return;
                    }
                    handler.handle(string, request, httpServletRequest, httpServletResponse);
                    if (authenticator == null) return;
                    authenticator.secureResponse((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, bl, user);
                    return;
                }
                if (authentication instanceof Authentication.Deferred) {
                    DeferredAuthentication deferredAuthentication = (DeferredAuthentication)authentication;
                    request.setAuthentication(authentication);
                    try {
                        handler.handle(string, request, httpServletRequest, httpServletResponse);
                    }
                    finally {
                        object = deferredAuthentication.getPreviousAssociation();
                    }
                    if (authenticator == null) return;
                    Authentication authentication3 = request.getAuthentication();
                    if (authentication3 instanceof Authentication.User) {
                        Authentication.User user = (Authentication.User)authentication3;
                        authenticator.secureResponse((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, bl, user);
                        return;
                    }
                    authenticator.secureResponse((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, bl, null);
                    return;
                }
                request.setAuthentication(authentication);
                if (this._identityService != null) {
                    object = this._identityService.associate(null);
                }
                handler.handle(string, request, httpServletRequest, httpServletResponse);
                if (authenticator == null) return;
                authenticator.secureResponse((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, bl, null);
                return;
            }
            catch (ServerAuthException serverAuthException) {
                httpServletResponse.sendError(500, serverAuthException.getMessage());
                return;
            }
            finally {
                if (this._identityService != null) {
                    this._identityService.disassociate(object);
                }
            }
        }
        handler.handle(string, request, httpServletRequest, httpServletResponse);
    }

    public static SecurityHandler getCurrentSecurityHandler() {
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context == null) {
            return null;
        }
        return (SecurityHandler)context.getContextHandler().getChildHandlerByClass(SecurityHandler.class);
    }

    public void logout(Authentication.User user) {
        IdentityService identityService;
        LOG.debug("logout {}", new Object[]{user});
        LoginService loginService = this.getLoginService();
        if (loginService != null) {
            loginService.logout(user.getUserIdentity());
        }
        if ((identityService = this.getIdentityService()) != null) {
            Object var4_4 = null;
            identityService.disassociate(var4_4);
        }
    }

    protected abstract RoleInfo prepareConstraintInfo(String var1, Request var2);

    protected abstract boolean checkUserDataPermissions(String var1, Request var2, Response var3, RoleInfo var4);

    protected abstract boolean isAuthMandatory(Request var1, Response var2, Object var3);

    protected abstract boolean checkWebResourcePermissions(String var1, Request var2, Response var3, Object var4, UserIdentity var5);

    public class NotChecked
    implements Principal {
        @Override
        public String getName() {
            return null;
        }

        @Override
        public String toString() {
            return "NOT CHECKED";
        }

        public SecurityHandler getSecurityHandler() {
            return SecurityHandler.this;
        }
    }
}

