/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.PathWatcher;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Credential;

public class PropertyUserStore
extends AbstractLifeCycle
implements PathWatcher.Listener {
    private static final Logger LOG = Log.getLogger(PropertyUserStore.class);
    private Path _configPath;
    private Resource _configResource;
    private PathWatcher pathWatcher;
    private boolean hotReload = false;
    private IdentityService _identityService = new DefaultIdentityService();
    private boolean _firstLoad = true;
    private final List<String> _knownUsers = new ArrayList<String>();
    private final Map<String, UserIdentity> _knownUserIdentities = new HashMap<String, UserIdentity>();
    private List<UserListener> _listeners;

    @Deprecated
    public String getConfig() {
        return this._configPath.toString();
    }

    @Deprecated
    public void setConfig(String string) {
        this.setConfigPath(string);
    }

    public Path getConfigPath() {
        return this._configPath;
    }

    public void setConfigPath(String string) {
        this._configPath = string == null ? null : new File(string).toPath();
    }

    public void setConfigPath(File file) {
        this._configPath = file.toPath();
    }

    public void setConfigPath(Path path) {
        this._configPath = path;
    }

    public UserIdentity getUserIdentity(String string) {
        return this._knownUserIdentities.get(string);
    }

    public Resource getConfigResource() {
        if (this._configResource == null) {
            this._configResource = new PathResource(this._configPath);
        }
        return this._configResource;
    }

    public boolean isHotReload() {
        return this.hotReload;
    }

    public void setHotReload(boolean bl) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot set hot reload while user store is running");
        }
        this.hotReload = bl;
    }

    @Deprecated
    public void setRefreshInterval(int n) {
    }

    @Deprecated
    public int getRefreshInterval() {
        return this.hotReload ? 1 : 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((Object)((Object)this)).getClass().getName());
        stringBuilder.append("[");
        stringBuilder.append("users.count=").append(this._knownUsers.size());
        stringBuilder.append("identityService=").append(this._identityService);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUsers() {
        if (this._configPath == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading " + (Object)((Object)this) + " from " + this._configPath, new Object[0]);
        }
        Properties properties = new Properties();
        if (this.getConfigResource().exists()) {
            properties.load(this.getConfigResource().getInputStream());
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<Object, Object> object : properties.entrySet()) {
            String string = ((String)object.getKey()).trim();
            String string2 = ((String)object.getValue()).trim();
            String string3 = null;
            int n = string2.indexOf(44);
            if (n > 0) {
                string3 = string2.substring(n + 1).trim();
                string2 = string2.substring(0, n).trim();
            }
            if (string == null || string.length() <= 0 || string2 == null || string2.length() <= 0) continue;
            String[] stringArray = IdentityService.NO_ROLES;
            if (string3 != null && string3.length() > 0) {
                stringArray = StringUtil.csvSplit((String)string3);
            }
            hashSet.add(string);
            Credential credential = Credential.getCredential((String)string2);
            MappedLoginService.KnownUser knownUser = new MappedLoginService.KnownUser(string, credential);
            Subject subject = new Subject();
            subject.getPrincipals().add(knownUser);
            subject.getPrivateCredentials().add(credential);
            if (string3 != null) {
                for (String string4 : stringArray) {
                    subject.getPrincipals().add(new MappedLoginService.RolePrincipal(string4));
                }
            }
            subject.setReadOnly();
            this._knownUserIdentities.put(string, this._identityService.newUserIdentity(subject, knownUser, stringArray));
            this.notifyUpdate(string, credential, stringArray);
        }
        List<String> list = this._knownUsers;
        synchronized (list) {
            if (!this._firstLoad) {
                for (String string : this._knownUsers) {
                    if (hashSet.contains(string)) continue;
                    this._knownUserIdentities.remove(string);
                    this.notifyRemove(string);
                }
            }
            this._knownUsers.clear();
            this._knownUsers.addAll(hashSet);
        }
        this._firstLoad = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded " + (Object)((Object)this) + " from " + this._configPath, new Object[0]);
        }
    }

    protected void doStart() {
        super.doStart();
        this.loadUsers();
        if (this.isHotReload() && this._configPath != null) {
            this.pathWatcher = new PathWatcher();
            this.pathWatcher.watch(this._configPath);
            this.pathWatcher.addListener((EventListener)((Object)this));
            this.pathWatcher.setNotifyExistingOnStart(false);
            this.pathWatcher.start();
        }
    }

    public void onPathWatchEvent(PathWatcher.PathWatchEvent pathWatchEvent) {
        try {
            this.loadUsers();
        }
        catch (IOException iOException) {
            LOG.warn((Throwable)iOException);
        }
    }

    protected void doStop() {
        super.doStop();
        if (this.pathWatcher != null) {
            this.pathWatcher.stop();
        }
        this.pathWatcher = null;
    }

    private void notifyUpdate(String string, Credential credential, String[] stringArray) {
        if (this._listeners != null) {
            Iterator<UserListener> iterator = this._listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().update(string, credential, stringArray);
            }
        }
    }

    private void notifyRemove(String string) {
        if (this._listeners != null) {
            Iterator<UserListener> iterator = this._listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().remove(string);
            }
        }
    }

    public void registerUserListener(UserListener userListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<UserListener>();
        }
        this._listeners.add(userListener);
    }

    public static interface UserListener {
        public void update(String var1, Credential var2, String[] var3);

        public void remove(String var1);
    }
}

