/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

public abstract class MappedLoginService
extends AbstractLifeCycle
implements LoginService {
    private static final Logger LOG = Log.getLogger(MappedLoginService.class);
    protected IdentityService _identityService = new DefaultIdentityService();
    protected String _name;
    protected final ConcurrentMap<String, UserIdentity> _users = new ConcurrentHashMap<String, UserIdentity>();

    protected MappedLoginService() {
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public ConcurrentMap<String, UserIdentity> getUsers() {
        return this._users;
    }

    @Override
    public void setIdentityService(IdentityService identityService) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._identityService = identityService;
    }

    public void setName(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._name = string;
    }

    public void setUsers(Map<String, UserIdentity> map) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._users.clear();
        this._users.putAll(map);
    }

    protected void doStart() {
        this.loadUsers();
        super.doStart();
    }

    protected void doStop() {
        super.doStop();
    }

    @Override
    public void logout(UserIdentity userIdentity) {
        LOG.debug("logout {}", new Object[]{userIdentity});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }

    protected synchronized UserIdentity putUser(String string, Object object) {
        UserIdentity userIdentity;
        if (object instanceof UserIdentity) {
            userIdentity = (UserIdentity)object;
        } else {
            Credential credential = object instanceof Credential ? (Credential)object : Credential.getCredential((String)object.toString());
            KnownUser knownUser = new KnownUser(string, credential);
            Subject subject = new Subject();
            subject.getPrincipals().add(knownUser);
            subject.getPrivateCredentials().add(credential);
            subject.setReadOnly();
            userIdentity = this._identityService.newUserIdentity(subject, knownUser, IdentityService.NO_ROLES);
        }
        this._users.put(string, userIdentity);
        return userIdentity;
    }

    public synchronized UserIdentity putUser(String string, Credential credential, String[] userIdentity) {
        KnownUser knownUser = new KnownUser(string, credential);
        Subject subject = new Subject();
        subject.getPrincipals().add(knownUser);
        subject.getPrivateCredentials().add(credential);
        if (userIdentity != null) {
            for (UserIdentity userIdentity2 : userIdentity) {
                subject.getPrincipals().add(new RolePrincipal((String)userIdentity2));
            }
        }
        subject.setReadOnly();
        UserIdentity userIdentity3 = this._identityService.newUserIdentity(subject, knownUser, (String[])userIdentity);
        this._users.put(string, userIdentity3);
        return userIdentity3;
    }

    public synchronized UserIdentity putUser(KnownUser knownUser, String[] userIdentity) {
        Subject subject = new Subject();
        subject.getPrincipals().add(knownUser);
        subject.getPrivateCredentials().add(knownUser._credential);
        if (userIdentity != null) {
            for (UserIdentity userIdentity2 : userIdentity) {
                subject.getPrincipals().add(new RolePrincipal((String)userIdentity2));
            }
        }
        subject.setReadOnly();
        UserIdentity userIdentity3 = this._identityService.newUserIdentity(subject, knownUser, (String[])userIdentity);
        this._users.put(knownUser._name, userIdentity3);
        return userIdentity3;
    }

    public void removeUser(String string) {
        this._users.remove(string);
    }

    @Override
    public UserIdentity login(String string, Object object, ServletRequest servletRequest) {
        if (string == null) {
            return null;
        }
        UserIdentity userIdentity = (UserIdentity)this._users.get(string);
        if (userIdentity == null) {
            KnownUser knownUser = this.loadUserInfo(string);
            if (knownUser.authenticate(object)) {
                String[] stringArray = this.loadRoleInfo(knownUser);
                userIdentity = this.putUser(knownUser, stringArray);
                return userIdentity;
            }
        } else {
            UserPrincipal userPrincipal = (UserPrincipal)userIdentity.getUserPrincipal();
            if (userPrincipal.authenticate(object)) {
                return userIdentity;
            }
        }
        return null;
    }

    @Override
    public boolean validate(UserIdentity userIdentity) {
        if (this._users.containsKey(userIdentity.getUserPrincipal().getName())) {
            return true;
        }
        return this.loadUser(userIdentity.getUserPrincipal().getName()) != null;
    }

    protected abstract String[] loadRoleInfo(KnownUser var1);

    protected abstract KnownUser loadUserInfo(String var1);

    protected abstract UserIdentity loadUser(String var1);

    protected abstract void loadUsers();

    public static class KnownUser
    implements Serializable,
    UserPrincipal {
        private static final long serialVersionUID = -6226920753748399662L;
        private final String _name;
        private final Credential _credential;

        public KnownUser(String string, Credential credential) {
            this._name = string;
            this._credential = credential;
        }

        @Override
        public boolean authenticate(Object object) {
            return this._credential != null && this._credential.check(object);
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public boolean isAuthenticated() {
            return true;
        }

        @Override
        public String toString() {
            return this._name;
        }
    }

    public static class Anonymous
    implements Serializable,
    UserPrincipal {
        private static final long serialVersionUID = 1097640442553284845L;

        @Override
        public boolean isAuthenticated() {
            return false;
        }

        @Override
        public String getName() {
            return "Anonymous";
        }

        @Override
        public boolean authenticate(Object object) {
            return false;
        }
    }

    public static class RolePrincipal
    implements Serializable,
    Principal {
        private static final long serialVersionUID = 2998397924051854402L;
        private final String _roleName;

        public RolePrincipal(String string) {
            this._roleName = string;
        }

        @Override
        public String getName() {
            return this._roleName;
        }
    }

    public static interface UserPrincipal
    extends Serializable,
    Principal {
        public boolean authenticate(Object var1);

        public boolean isAuthenticated();
    }
}

